<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * UserManagedKeysConfig holds the resource address to Keys which are used
 * for signing certs and token that are used for communication within cluster.
 *
 * Generated from protobuf message <code>google.container.v1.UserManagedKeysConfig</code>
 */
class UserManagedKeysConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     *
     * Generated from protobuf field <code>string cluster_ca = 10 [(.google.api.resource_reference) = {</code>
     */
    protected $cluster_ca = '';
    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = {</code>
     */
    protected $etcd_api_ca = '';
    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = {</code>
     */
    protected $etcd_peer_ca = '';
    /**
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = {</code>
     */
    private $service_account_signing_keys;
    /**
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = {</code>
     */
    private $service_account_verification_keys;
    /**
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     *
     * Generated from protobuf field <code>string aggregation_ca = 15 [(.google.api.resource_reference) = {</code>
     */
    protected $aggregation_ca = '';
    /**
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     *
     * Generated from protobuf field <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = {</code>
     */
    protected $control_plane_disk_encryption_key = '';
    /**
     * Output only. All of the versions of the Cloud KMS cryptoKey that are used
     * by Confidential Hyperdisks on the control plane nodes.
     *
     * Generated from protobuf field <code>repeated string control_plane_disk_encryption_key_versions = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $control_plane_disk_encryption_key_versions;
    /**
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     *
     * Generated from protobuf field <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = {</code>
     */
    protected $gkeops_etcd_backup_encryption_key = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $cluster_ca
     *           The Certificate Authority Service caPool to use for the cluster CA in this
     *           cluster.
     *     @type string $etcd_api_ca
     *           Resource path of the Certificate Authority Service caPool to use for the
     *           etcd API CA in this cluster.
     *     @type string $etcd_peer_ca
     *           Resource path of the Certificate Authority Service caPool to use for the
     *           etcd peer CA in this cluster.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $service_account_signing_keys
     *           The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     *           issued by this cluster.
     *           Format:
     *           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $service_account_verification_keys
     *           The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     *           issued by this cluster.
     *           Format:
     *           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *     @type string $aggregation_ca
     *           The Certificate Authority Service caPool to use for the aggregation CA in
     *           this cluster.
     *     @type string $control_plane_disk_encryption_key
     *           The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     *           plane nodes.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $control_plane_disk_encryption_key_versions
     *           Output only. All of the versions of the Cloud KMS cryptoKey that are used
     *           by Confidential Hyperdisks on the control plane nodes.
     *     @type string $gkeops_etcd_backup_encryption_key
     *           Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     *           etcd backups.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     *
     * Generated from protobuf field <code>string cluster_ca = 10 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getClusterCa()
    {
        return $this->cluster_ca;
    }

    /**
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     *
     * Generated from protobuf field <code>string cluster_ca = 10 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setClusterCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_ca = $var;

        return $this;
    }

    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEtcdApiCa()
    {
        return $this->etcd_api_ca;
    }

    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEtcdApiCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->etcd_api_ca = $var;

        return $this;
    }

    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEtcdPeerCa()
    {
        return $this->etcd_peer_ca;
    }

    /**
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     *
     * Generated from protobuf field <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEtcdPeerCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->etcd_peer_ca = $var;

        return $this;
    }

    /**
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccountSigningKeys()
    {
        return $this->service_account_signing_keys;
    }

    /**
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccountSigningKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_account_signing_keys = $arr;

        return $this;
    }

    /**
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccountVerificationKeys()
    {
        return $this->service_account_verification_keys;
    }

    /**
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     *
     * Generated from protobuf field <code>repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccountVerificationKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_account_verification_keys = $arr;

        return $this;
    }

    /**
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     *
     * Generated from protobuf field <code>string aggregation_ca = 15 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAggregationCa()
    {
        return $this->aggregation_ca;
    }

    /**
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     *
     * Generated from protobuf field <code>string aggregation_ca = 15 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAggregationCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->aggregation_ca = $var;

        return $this;
    }

    /**
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     *
     * Generated from protobuf field <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getControlPlaneDiskEncryptionKey()
    {
        return $this->control_plane_disk_encryption_key;
    }

    /**
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     *
     * Generated from protobuf field <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setControlPlaneDiskEncryptionKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->control_plane_disk_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. All of the versions of the Cloud KMS cryptoKey that are used
     * by Confidential Hyperdisks on the control plane nodes.
     *
     * Generated from protobuf field <code>repeated string control_plane_disk_encryption_key_versions = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getControlPlaneDiskEncryptionKeyVersions()
    {
        return $this->control_plane_disk_encryption_key_versions;
    }

    /**
     * Output only. All of the versions of the Cloud KMS cryptoKey that are used
     * by Confidential Hyperdisks on the control plane nodes.
     *
     * Generated from protobuf field <code>repeated string control_plane_disk_encryption_key_versions = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setControlPlaneDiskEncryptionKeyVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->control_plane_disk_encryption_key_versions = $arr;

        return $this;
    }

    /**
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     *
     * Generated from protobuf field <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getGkeopsEtcdBackupEncryptionKey()
    {
        return $this->gkeops_etcd_backup_encryption_key;
    }

    /**
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     *
     * Generated from protobuf field <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setGkeopsEtcdBackupEncryptionKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->gkeops_etcd_backup_encryption_key = $var;

        return $this;
    }

}

