<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/channel/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Channel\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Channel\V1\ActivateEntitlementRequest;
use Google\Cloud\Channel\V1\CancelEntitlementRequest;
use Google\Cloud\Channel\V1\ChangeOfferRequest;
use Google\Cloud\Channel\V1\ChangeParametersRequest;
use Google\Cloud\Channel\V1\ChangeRenewalSettingsRequest;
use Google\Cloud\Channel\V1\ChannelPartnerLink;
use Google\Cloud\Channel\V1\ChannelPartnerRepricingConfig;
use Google\Cloud\Channel\V1\CheckCloudIdentityAccountsExistRequest;
use Google\Cloud\Channel\V1\CheckCloudIdentityAccountsExistResponse;
use Google\Cloud\Channel\V1\CreateChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\CreateChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\CreateCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\CreateCustomerRequest;
use Google\Cloud\Channel\V1\CreateEntitlementRequest;
use Google\Cloud\Channel\V1\Customer;
use Google\Cloud\Channel\V1\CustomerRepricingConfig;
use Google\Cloud\Channel\V1\DeleteChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\DeleteCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\DeleteCustomerRequest;
use Google\Cloud\Channel\V1\Entitlement;
use Google\Cloud\Channel\V1\GetChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\GetChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\GetCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\GetCustomerRequest;
use Google\Cloud\Channel\V1\GetEntitlementRequest;
use Google\Cloud\Channel\V1\ImportCustomerRequest;
use Google\Cloud\Channel\V1\ListChannelPartnerLinksRequest;
use Google\Cloud\Channel\V1\ListChannelPartnerRepricingConfigsRequest;
use Google\Cloud\Channel\V1\ListCustomerRepricingConfigsRequest;
use Google\Cloud\Channel\V1\ListCustomersRequest;
use Google\Cloud\Channel\V1\ListEntitlementChangesRequest;
use Google\Cloud\Channel\V1\ListEntitlementsRequest;
use Google\Cloud\Channel\V1\ListOffersRequest;
use Google\Cloud\Channel\V1\ListProductsRequest;
use Google\Cloud\Channel\V1\ListPurchasableOffersRequest;
use Google\Cloud\Channel\V1\ListPurchasableSkusRequest;
use Google\Cloud\Channel\V1\ListSkuGroupBillableSkusRequest;
use Google\Cloud\Channel\V1\ListSkuGroupsRequest;
use Google\Cloud\Channel\V1\ListSkusRequest;
use Google\Cloud\Channel\V1\ListSubscribersRequest;
use Google\Cloud\Channel\V1\ListTransferableOffersRequest;
use Google\Cloud\Channel\V1\ListTransferableSkusRequest;
use Google\Cloud\Channel\V1\LookupOfferRequest;
use Google\Cloud\Channel\V1\Offer;
use Google\Cloud\Channel\V1\OperationMetadata;
use Google\Cloud\Channel\V1\Parameter;
use Google\Cloud\Channel\V1\ProvisionCloudIdentityRequest;
use Google\Cloud\Channel\V1\QueryEligibleBillingAccountsRequest;
use Google\Cloud\Channel\V1\QueryEligibleBillingAccountsResponse;
use Google\Cloud\Channel\V1\RegisterSubscriberRequest;
use Google\Cloud\Channel\V1\RegisterSubscriberResponse;
use Google\Cloud\Channel\V1\StartPaidServiceRequest;
use Google\Cloud\Channel\V1\SuspendEntitlementRequest;
use Google\Cloud\Channel\V1\TransferEntitlementsRequest;
use Google\Cloud\Channel\V1\TransferEntitlementsResponse;
use Google\Cloud\Channel\V1\TransferEntitlementsToGoogleRequest;
use Google\Cloud\Channel\V1\UnregisterSubscriberRequest;
use Google\Cloud\Channel\V1\UnregisterSubscriberResponse;
use Google\Cloud\Channel\V1\UpdateChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\UpdateChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\UpdateCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\UpdateCustomerRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: CloudChannelService lets Google cloud resellers and distributors manage
 * their customers, channel partners, entitlements, and reports.
 *
 * Using this service:
 * 1. Resellers and distributors can manage a customer entity.
 * 2. Distributors can register an authorized reseller in their channel and
 * provide them with delegated admin access.
 * 3. Resellers and distributors can manage customer entitlements.
 *
 * CloudChannelService exposes the following resources:
 * - [Customer][google.cloud.channel.v1.Customer]s: An entity-usually an
 * enterprise-managed by a reseller or distributor.
 *
 * - [Entitlement][google.cloud.channel.v1.Entitlement]s: An entity that
 * provides a customer with the means to use a service. Entitlements are created
 * or updated as a result of a successful fulfillment.
 *
 * - [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s: An
 * entity that identifies links between distributors and their indirect
 * resellers in a channel.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> activateEntitlementAsync(ActivateEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> cancelEntitlementAsync(CancelEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> changeOfferAsync(ChangeOfferRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> changeParametersAsync(ChangeParametersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> changeRenewalSettingsAsync(ChangeRenewalSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistAsync(CheckCloudIdentityAccountsExistRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerLink> createChannelPartnerLinkAsync(CreateChannelPartnerLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerRepricingConfig> createChannelPartnerRepricingConfigAsync(CreateChannelPartnerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Customer> createCustomerAsync(CreateCustomerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomerRepricingConfig> createCustomerRepricingConfigAsync(CreateCustomerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEntitlementAsync(CreateEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteChannelPartnerRepricingConfigAsync(DeleteChannelPartnerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteCustomerAsync(DeleteCustomerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteCustomerRepricingConfigAsync(DeleteCustomerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerLink> getChannelPartnerLinkAsync(GetChannelPartnerLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerRepricingConfig> getChannelPartnerRepricingConfigAsync(GetChannelPartnerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Customer> getCustomerAsync(GetCustomerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomerRepricingConfig> getCustomerRepricingConfigAsync(GetCustomerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entitlement> getEntitlementAsync(GetEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Customer> importCustomerAsync(ImportCustomerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listChannelPartnerLinksAsync(ListChannelPartnerLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listChannelPartnerRepricingConfigsAsync(ListChannelPartnerRepricingConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomerRepricingConfigsAsync(ListCustomerRepricingConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomersAsync(ListCustomersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntitlementChangesAsync(ListEntitlementChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntitlementsAsync(ListEntitlementsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listOffersAsync(ListOffersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProductsAsync(ListProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPurchasableOffersAsync(ListPurchasableOffersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPurchasableSkusAsync(ListPurchasableSkusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSkuGroupBillableSkusAsync(ListSkuGroupBillableSkusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSkuGroupsAsync(ListSkuGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSkusAsync(ListSkusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSubscribersAsync(ListSubscribersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTransferableOffersAsync(ListTransferableOffersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTransferableSkusAsync(ListTransferableSkusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Offer> lookupOfferAsync(LookupOfferRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> provisionCloudIdentityAsync(ProvisionCloudIdentityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryEligibleBillingAccountsResponse> queryEligibleBillingAccountsAsync(QueryEligibleBillingAccountsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RegisterSubscriberResponse> registerSubscriberAsync(RegisterSubscriberRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> startPaidServiceAsync(StartPaidServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> suspendEntitlementAsync(SuspendEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> transferEntitlementsAsync(TransferEntitlementsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> transferEntitlementsToGoogleAsync(TransferEntitlementsToGoogleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UnregisterSubscriberResponse> unregisterSubscriberAsync(UnregisterSubscriberRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerLink> updateChannelPartnerLinkAsync(UpdateChannelPartnerLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ChannelPartnerRepricingConfig> updateChannelPartnerRepricingConfigAsync(UpdateChannelPartnerRepricingConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Customer> updateCustomerAsync(UpdateCustomerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomerRepricingConfig> updateCustomerRepricingConfigAsync(UpdateCustomerRepricingConfigRequest $request, array $optionalArgs = [])
 */
final class CloudChannelServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.channel.v1.CloudChannelService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'cloudchannel.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'cloudchannel.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/apps.order'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/cloud_channel_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/cloud_channel_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/cloud_channel_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/cloud_channel_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a account
     * resource.
     *
     * @param string $account
     *
     * @return string The formatted account resource.
     */
    public static function accountName(string $account): string
    {
        return self::getPathTemplate('account')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_partner_link resource.
     *
     * @param string $account
     * @param string $channelPartnerLink
     *
     * @return string The formatted channel_partner_link resource.
     */
    public static function channelPartnerLinkName(string $account, string $channelPartnerLink): string
    {
        return self::getPathTemplate('channelPartnerLink')->render([
            'account' => $account,
            'channel_partner_link' => $channelPartnerLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_partner_repricing_config resource.
     *
     * @param string $account
     * @param string $channelPartner
     * @param string $channelPartnerRepricingConfig
     *
     * @return string The formatted channel_partner_repricing_config resource.
     */
    public static function channelPartnerRepricingConfigName(
        string $account,
        string $channelPartner,
        string $channelPartnerRepricingConfig
    ): string {
        return self::getPathTemplate('channelPartnerRepricingConfig')->render([
            'account' => $account,
            'channel_partner' => $channelPartner,
            'channel_partner_repricing_config' => $channelPartnerRepricingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a customer
     * resource.
     *
     * @param string $account
     * @param string $customer
     *
     * @return string The formatted customer resource.
     */
    public static function customerName(string $account, string $customer): string
    {
        return self::getPathTemplate('customer')->render([
            'account' => $account,
            'customer' => $customer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * customer_repricing_config resource.
     *
     * @param string $account
     * @param string $customer
     * @param string $customerRepricingConfig
     *
     * @return string The formatted customer_repricing_config resource.
     */
    public static function customerRepricingConfigName(
        string $account,
        string $customer,
        string $customerRepricingConfig
    ): string {
        return self::getPathTemplate('customerRepricingConfig')->render([
            'account' => $account,
            'customer' => $customer,
            'customer_repricing_config' => $customerRepricingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entitlement
     * resource.
     *
     * @param string $account
     * @param string $customer
     * @param string $entitlement
     *
     * @return string The formatted entitlement resource.
     */
    public static function entitlementName(string $account, string $customer, string $entitlement): string
    {
        return self::getPathTemplate('entitlement')->render([
            'account' => $account,
            'customer' => $customer,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a offer
     * resource.
     *
     * @param string $account
     * @param string $offer
     *
     * @return string The formatted offer resource.
     */
    public static function offerName(string $account, string $offer): string
    {
        return self::getPathTemplate('offer')->render([
            'account' => $account,
            'offer' => $offer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a product
     * resource.
     *
     * @param string $product
     *
     * @return string The formatted product resource.
     */
    public static function productName(string $product): string
    {
        return self::getPathTemplate('product')->render([
            'product' => $product,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a sku_group
     * resource.
     *
     * @param string $account
     * @param string $skuGroup
     *
     * @return string The formatted sku_group resource.
     */
    public static function skuGroupName(string $account, string $skuGroup): string
    {
        return self::getPathTemplate('skuGroup')->render([
            'account' => $account,
            'sku_group' => $skuGroup,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - account: accounts/{account}
     * - channelPartnerLink: accounts/{account}/channelPartnerLinks/{channel_partner_link}
     * - channelPartnerRepricingConfig: accounts/{account}/channelPartnerLinks/{channel_partner}/channelPartnerRepricingConfigs/{channel_partner_repricing_config}
     * - customer: accounts/{account}/customers/{customer}
     * - customerRepricingConfig: accounts/{account}/customers/{customer}/customerRepricingConfigs/{customer_repricing_config}
     * - entitlement: accounts/{account}/customers/{customer}/entitlements/{entitlement}
     * - offer: accounts/{account}/offers/{offer}
     * - product: products/{product}
     * - skuGroup: accounts/{account}/skuGroups/{sku_group}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudchannel.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Channel\V1\CloudChannelServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new CloudChannelServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Activates a previously suspended entitlement. Entitlements suspended for
     * pending ToS acceptance can't be activated using this method.
     *
     * An entitlement activation is a long-running operation and it updates
     * the state of the customer entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
     * suspensions and entitlements that have accepted the TOS.
     * * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
     * state.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::activateEntitlementAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/activate_entitlement.php
     *
     * @param ActivateEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function activateEntitlement(ActivateEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ActivateEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Cancels a previously fulfilled entitlement.
     *
     * An entitlement cancellation is a long-running operation.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * FAILED_PRECONDITION: There are Google Cloud projects linked to the
     * Google Cloud entitlement's Cloud Billing subaccount.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
     * add-ons, or entitlements for Google Cloud's development platform.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The response will contain
     * google.protobuf.Empty on success. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::cancelEntitlementAsync()}
     * .
     *
     * @example samples/V1/CloudChannelServiceClient/cancel_entitlement.php
     *
     * @param CancelEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelEntitlement(CancelEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CancelEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Updates the Offer for an existing customer entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Offer or Entitlement resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::changeOfferAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/change_offer.php
     *
     * @param ChangeOfferRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function changeOffer(ChangeOfferRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ChangeOffer', $request, $callOptions)->wait();
    }

    /**
     * Change parameters of the entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * For example, the number of seats being changed is greater than the allowed
     * number of max seats, or decreasing seats for a commitment based plan.
     * * NOT_FOUND: Entitlement resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::changeParametersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/change_parameters.php
     *
     * @param ChangeParametersRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function changeParameters(ChangeParametersRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ChangeParameters', $request, $callOptions)->wait();
    }

    /**
     * Updates the renewal settings for an existing customer entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
     * commitment plan. Can't enable or disable renewals for non-commitment plans.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::changeRenewalSettingsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/change_renewal_settings.php
     *
     * @param ChangeRenewalSettingsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function changeRenewalSettings(
        ChangeRenewalSettingsRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ChangeRenewalSettings', $request, $callOptions)->wait();
    }

    /**
     * Confirms the existence of Cloud Identity accounts based on the domain and
     * if the Cloud Identity accounts are owned by the reseller.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * INVALID_VALUE: Invalid domain value in the request.
     *
     * Return value:
     * A list of
     * [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
     * resources for the domain (may be empty)
     *
     * Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
     * no
     * [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
     * resources match the domain.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::checkCloudIdentityAccountsExistAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/check_cloud_identity_accounts_exist.php
     *
     * @param CheckCloudIdentityAccountsExistRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckCloudIdentityAccountsExistResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkCloudIdentityAccountsExist(
        CheckCloudIdentityAccountsExistRequest $request,
        array $callOptions = []
    ): CheckCloudIdentityAccountsExistResponse {
        return $this->startApiCall('CheckCloudIdentityAccountsExist', $request, $callOptions)->wait();
    }

    /**
     * Initiates a channel partner link between a distributor and a reseller, or
     * between resellers in an n-tier reseller channel.
     * Invited partners need to follow the invite_link_uri provided in the
     * response to accept. After accepting the invitation, a link is set up
     * between the two parties.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
     * exists.
     * * NOT_FOUND: No Cloud Identity customer exists for provided domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
     * resource.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::createChannelPartnerLinkAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/create_channel_partner_link.php
     *
     * @param CreateChannelPartnerLinkRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannelPartnerLink(
        CreateChannelPartnerLinkRequest $request,
        array $callOptions = []
    ): ChannelPartnerLink {
        return $this->startApiCall('CreateChannelPartnerLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a ChannelPartnerRepricingConfig. Call this method to set
     * modifications for a specific ChannelPartner's bill. You can only create
     * configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. If needed, you can create a config for the current
     * month, with some restrictions.
     *
     * When creating a config for a future month, make sure there are no existing
     * configs for that
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * The following restrictions are for creating configs in the current month.
     *
     * * This functionality is reserved for recovering from an erroneous config,
     * and should not be used for regular business cases.
     * * The new config will not modify exports used with other configs.
     * Changes to the config may be immediate, but may take up to 24 hours.
     * * There is a limit of ten configs for any ChannelPartner or
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
     * for any
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     * * The contained
     * [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
     * value must be different from the value used in the current config for a
     * ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::createChannelPartnerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/create_channel_partner_repricing_config.php
     *
     * @param CreateChannelPartnerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannelPartnerRepricingConfig(
        CreateChannelPartnerRepricingConfigRequest $request,
        array $callOptions = []
    ): ChannelPartnerRepricingConfig {
        return $this->startApiCall('CreateChannelPartnerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
     * the reseller or distributor account.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The reseller account making the request is different from the
     * reseller account in the API request.
     * * You are not authorized to create a customer. See
     * https://support.google.com/channelservices/answer/9759265
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * Domain field value doesn't match the primary email domain.
     *
     * Return value:
     * The newly created [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * The async variant is {@see CloudChannelServiceClient::createCustomerAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/create_customer.php
     *
     * @param CreateCustomerRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Customer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomer(CreateCustomerRequest $request, array $callOptions = []): Customer
    {
        return $this->startApiCall('CreateCustomer', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomerRepricingConfig. Call this method to set modifications
     * for a specific customer's bill. You can only create configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. If needed, you can create a config for the current
     * month, with some restrictions.
     *
     * When creating a config for a future month, make sure there are no existing
     * configs for that
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * The following restrictions are for creating configs in the current month.
     *
     * * This functionality is reserved for recovering from an erroneous config,
     * and should not be used for regular business cases.
     * * The new config will not modify exports used with other configs.
     * Changes to the config may be immediate, but may take up to 24 hours.
     * * There is a limit of ten configs for any
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
     * for any
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     * * The contained
     * [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
     * value must be different from the value used in the current config for a
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::createCustomerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/create_customer_repricing_config.php
     *
     * @param CreateCustomerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomerRepricingConfig(
        CreateCustomerRepricingConfigRequest $request,
        array $callOptions = []
    ): CustomerRepricingConfig {
        return $this->startApiCall('CreateCustomerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates an entitlement for a customer.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller.
     * * The reseller is not authorized to transact on this Product. See
     * https://support.google.com/channelservices/answer/9759265
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * There is already a customer entitlement for a SKU from the same
     * product family.
     * * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
     * Google Channel support for further troubleshooting.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS:
     * * The SKU was already purchased for the customer.
     * * The customer's primary email already exists. Retry
     * after changing the customer's primary contact email.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The domain required for purchasing a SKU has not been verified.
     * * A pre-requisite SKU required to purchase an Add-On SKU is missing.
     * For example, Google Workspace Business Starter is required to purchase
     * Vault or Drive.
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::createEntitlementAsync()}
     * .
     *
     * @example samples/V1/CloudChannelServiceClient/create_entitlement.php
     *
     * @param CreateEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntitlement(CreateEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Deletes the given
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * permanently. You can only delete configs if their
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is set to a date after the current month.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * is active or in the past.
     * * NOT_FOUND: No
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * found for the name in the request.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::deleteChannelPartnerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/delete_channel_partner_repricing_config.php
     *
     * @param DeleteChannelPartnerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteChannelPartnerRepricingConfig(
        DeleteChannelPartnerRepricingConfigRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteChannelPartnerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The customer has existing entitlements.
     * * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
     * for the name in the request.
     *
     * The async variant is {@see CloudChannelServiceClient::deleteCustomerAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/delete_customer.php
     *
     * @param DeleteCustomerRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomer(DeleteCustomerRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteCustomer', $request, $callOptions)->wait();
    }

    /**
     * Deletes the given
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * permanently. You can only delete configs if their
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is set to a date after the current month.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * is active or in the past.
     * * NOT_FOUND: No
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * found for the name in the request.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::deleteCustomerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/delete_customer_repricing_config.php
     *
     * @param DeleteCustomerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomerRepricingConfig(
        DeleteCustomerRepricingConfigRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteCustomerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: ChannelPartnerLink resource not found because of an
     * invalid channel partner link name.
     *
     * Return value:
     * The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
     * resource.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::getChannelPartnerLinkAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/get_channel_partner_link.php
     *
     * @param GetChannelPartnerLinkRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannelPartnerLink(
        GetChannelPartnerLinkRequest $request,
        array $callOptions = []
    ): ChannelPartnerLink {
        return $this->startApiCall('GetChannelPartnerLink', $request, $callOptions)->wait();
    }

    /**
     * Gets information about how a Distributor modifies their bill before sending
     * it to a ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * was not found.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::getChannelPartnerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/get_channel_partner_repricing_config.php
     *
     * @param GetChannelPartnerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannelPartnerRepricingConfig(
        GetChannelPartnerRepricingConfigRequest $request,
        array $callOptions = []
    ): ChannelPartnerRepricingConfig {
        return $this->startApiCall('GetChannelPartnerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested [Customer][google.cloud.channel.v1.Customer]
     * resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
     * invalid name parameter.
     *
     * Return value:
     * The [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * The async variant is {@see CloudChannelServiceClient::getCustomerAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/get_customer.php
     *
     * @param GetCustomerRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Customer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomer(GetCustomerRequest $request, array $callOptions = []): Customer
    {
        return $this->startApiCall('GetCustomer', $request, $callOptions)->wait();
    }

    /**
     * Gets information about how a Reseller modifies their bill before sending
     * it to a Customer.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * was not found.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::getCustomerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/get_customer_repricing_config.php
     *
     * @param GetCustomerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomerRepricingConfig(
        GetCustomerRepricingConfigRequest $request,
        array $callOptions = []
    ): CustomerRepricingConfig {
        return $this->startApiCall('GetCustomerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
     * resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer entitlement was not found.
     *
     * Return value:
     * The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
     *
     * The async variant is {@see CloudChannelServiceClient::getEntitlementAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/get_entitlement.php
     *
     * @param GetEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entitlement
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntitlement(GetEntitlementRequest $request, array $callOptions = []): Entitlement
    {
        return $this->startApiCall('GetEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
     * Identity associated with the provided Cloud Identity ID or domain before a
     * TransferEntitlements call. If a linked Customer already exists and
     * overwrite_if_exists is true, it will update that Customer's data.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The reseller account making the request is different from the
     * reseller account in the API request.
     * * You are not authorized to import the customer. See
     * https://support.google.com/channelservices/answer/9759265
     * * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
     * * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
     * expired or invalid.
     * * ALREADY_EXISTS: A customer already exists and has conflicting critical
     * fields. Requires an overwrite.
     *
     * Return value:
     * The [Customer][google.cloud.channel.v1.Customer].
     *
     * The async variant is {@see CloudChannelServiceClient::importCustomerAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/import_customer.php
     *
     * @param ImportCustomerRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Customer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importCustomer(ImportCustomerRequest $request, array $callOptions = []): Customer
    {
        return $this->startApiCall('ImportCustomer', $request, $callOptions)->wait();
    }

    /**
     * List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
     * belonging to a distributor. You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * The list of the distributor account's
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listChannelPartnerLinksAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_channel_partner_links.php
     *
     * @param ListChannelPartnerLinksRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannelPartnerLinks(
        ListChannelPartnerLinksRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListChannelPartnerLinks', $request, $callOptions);
    }

    /**
     * Lists information about how a Reseller modifies their bill before sending
     * it to a ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resources. The data for each resource is displayed in the ascending order
     * of:
     *
     * * Channel Partner ID
     * * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
     *
     * If unsuccessful, returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listChannelPartnerRepricingConfigsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_channel_partner_repricing_configs.php
     *
     * @param ListChannelPartnerRepricingConfigsRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannelPartnerRepricingConfigs(
        ListChannelPartnerRepricingConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListChannelPartnerRepricingConfigs', $request, $callOptions);
    }

    /**
     * Lists information about how a Reseller modifies their bill before sending
     * it to a Customer.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resources. The data for each resource is displayed in the ascending order
     * of:
     *
     * * Customer ID
     * * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
     * * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
     *
     * If unsuccessful, returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listCustomerRepricingConfigsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_customer_repricing_configs.php
     *
     * @param ListCustomerRepricingConfigsRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomerRepricingConfigs(
        ListCustomerRepricingConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListCustomerRepricingConfigs', $request, $callOptions);
    }

    /**
     * List [Customer][google.cloud.channel.v1.Customer]s.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
     * there are no customers.
     *
     * The async variant is {@see CloudChannelServiceClient::listCustomersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_customers.php
     *
     * @param ListCustomersRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomers(ListCustomersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomers', $request, $callOptions);
    }

    /**
     * List entitlement history.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different.
     * * INVALID_ARGUMENT: Missing or invalid required fields in the request.
     * * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
     * invalid name parameter.
     * * INTERNAL: Any non-user error related to a technical issue in the backend.
     * In this case, contact CloudChannel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * In this case, contact Cloud Channel support.
     *
     * Return value:
     * List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listEntitlementChangesAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_entitlement_changes.php
     *
     * @param ListEntitlementChangesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntitlementChanges(
        ListEntitlementChangesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListEntitlementChanges', $request, $callOptions);
    }

    /**
     * Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
     * customer.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * A list of the customer's
     * [Entitlement][google.cloud.channel.v1.Entitlement]s.
     *
     * The async variant is {@see CloudChannelServiceClient::listEntitlementsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_entitlements.php
     *
     * @param ListEntitlementsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntitlements(ListEntitlementsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntitlements', $request, $callOptions);
    }

    /**
     * Lists the Offers the reseller can sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * The async variant is {@see CloudChannelServiceClient::listOffersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_offers.php
     *
     * @param ListOffersRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOffers(ListOffersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListOffers', $request, $callOptions);
    }

    /**
     * Lists the Products the reseller is authorized to sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * The async variant is {@see CloudChannelServiceClient::listProductsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_products.php
     *
     * @param ListProductsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProducts(ListProductsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProducts', $request, $callOptions);
    }

    /**
     * Lists the following:
     *
     * * Offers that you can purchase for a customer.
     * * Offers that you can change for an entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller
     * * The reseller is not authorized to transact on this Product. See
     * https://support.google.com/channelservices/answer/9759265
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listPurchasableOffersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_purchasable_offers.php
     *
     * @param ListPurchasableOffersRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPurchasableOffers(
        ListPurchasableOffersRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListPurchasableOffers', $request, $callOptions);
    }

    /**
     * Lists the following:
     *
     * * SKUs that you can purchase for a customer
     * * SKUs that you can upgrade or downgrade for an entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listPurchasableSkusAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_purchasable_skus.php
     *
     * @param ListPurchasableSkusRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPurchasableSkus(ListPurchasableSkusRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPurchasableSkus', $request, $callOptions);
    }

    /**
     * Lists the Billable SKUs in a given SKU group.
     *
     * Possible error codes:
     * PERMISSION_DENIED: If the account making the request and the account
     * being queried for are different, or the account doesn't exist.
     * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request.
     * INTERNAL: Any non-user error related to technical issue in the
     * backend. In this case, contact cloud channel support.
     *
     * Return Value:
     * If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
     * resources. The data for each resource is displayed in the ascending order
     * of:
     *
     * * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
     * * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
     *
     * If unsuccessful, returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listSkuGroupBillableSkusAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_sku_group_billable_skus.php
     *
     * @param ListSkuGroupBillableSkusRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSkuGroupBillableSkus(
        ListSkuGroupBillableSkusRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSkuGroupBillableSkus', $request, $callOptions);
    }

    /**
     * Lists the Rebilling supported SKU groups the account is authorized to
     * sell.
     * Reference: https://cloud.google.com/skus/sku-groups
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different, or the account doesn't exist.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
     * The data for each resource is displayed in the alphabetical order of SKU
     * group display name.
     * The data for each resource is displayed in the ascending order of
     * [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
     *
     * If unsuccessful, returns an error.
     *
     * The async variant is {@see CloudChannelServiceClient::listSkuGroupsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_sku_groups.php
     *
     * @param ListSkuGroupsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSkuGroups(ListSkuGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSkuGroups', $request, $callOptions);
    }

    /**
     * Lists the SKUs for a product the reseller is authorized to sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * The async variant is {@see CloudChannelServiceClient::listSkusAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_skus.php
     *
     * @param ListSkusRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSkus(ListSkusRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSkus', $request, $callOptions);
    }

    /**
     * Lists service accounts with subscriber privileges on the Pub/Sub topic
     * created for this Channel Services account or integrator.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The topic resource doesn't exist.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * A list of service email addresses.
     *
     * The async variant is {@see CloudChannelServiceClient::listSubscribersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_subscribers.php
     *
     * @param ListSubscribersRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubscribers(ListSubscribersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSubscribers', $request, $callOptions);
    }

    /**
     * List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
     * customer based on Cloud Identity ID or Customer Name in the request.
     *
     * Use this method when a reseller gets the entitlement information of an
     * unowned customer. The reseller should provide the customer's
     * Cloud Identity ID or Customer Name.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller and has no auth token.
     * * The customer provided incorrect reseller information when generating
     * auth token.
     * * The reseller account making the request is different
     * from the reseller account in the query.
     * * The reseller is not authorized to transact on this Product. See
     * https://support.google.com/channelservices/answer/9759265
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
     * the given customer and SKU.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listTransferableOffersAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_transferable_offers.php
     *
     * @param ListTransferableOffersRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTransferableOffers(
        ListTransferableOffersRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTransferableOffers', $request, $callOptions);
    }

    /**
     * List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
     * customer based on the Cloud Identity ID or Customer Name in the request.
     *
     * Use this method to list the entitlements information of an
     * unowned customer. You should provide the customer's
     * Cloud Identity ID or Customer Name.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller and has no auth token.
     * * The supplied auth token is invalid.
     * * The reseller account making the request is different
     * from the reseller account in the query.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * A list of the customer's
     * [TransferableSku][google.cloud.channel.v1.TransferableSku].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::listTransferableSkusAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/list_transferable_skus.php
     *
     * @param ListTransferableSkusRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTransferableSkus(
        ListTransferableSkusRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTransferableSkus', $request, $callOptions);
    }

    /**
     * Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement or offer was not found.
     *
     * Return value:
     * The [Offer][google.cloud.channel.v1.Offer] resource.
     *
     * The async variant is {@see CloudChannelServiceClient::lookupOfferAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/lookup_offer.php
     *
     * @param LookupOfferRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Offer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupOffer(LookupOfferRequest $request, array $callOptions = []): Offer
    {
        return $this->startApiCall('LookupOffer', $request, $callOptions)->wait();
    }

    /**
     * Creates a Cloud Identity for the given customer using the customer's
     * information, or the information provided here.
     *
     * Possible error codes:
     *
     * *  PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller.
     * * You are not authorized to provision cloud identity id. See
     * https://support.google.com/channelservices/answer/9759265
     * *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * *  NOT_FOUND: The customer was not found.
     * *  ALREADY_EXISTS: The customer's primary email already exists. Retry
     * after changing the customer's primary contact email.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata contains an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::provisionCloudIdentityAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/provision_cloud_identity.php
     *
     * @param ProvisionCloudIdentityRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Customer>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function provisionCloudIdentity(
        ProvisionCloudIdentityRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ProvisionCloudIdentity', $request, $callOptions)->wait();
    }

    /**
     * Lists the billing accounts that are eligible to purchase particular SKUs
     * for a given customer.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * Based on the provided list of SKUs, returns a list of SKU groups that must
     * be purchased using the same billing account and the billing accounts
     * eligible to purchase each SKU group.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::queryEligibleBillingAccountsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/query_eligible_billing_accounts.php
     *
     * @param QueryEligibleBillingAccountsRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryEligibleBillingAccountsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryEligibleBillingAccounts(
        QueryEligibleBillingAccountsRequest $request,
        array $callOptions = []
    ): QueryEligibleBillingAccountsResponse {
        return $this->startApiCall('QueryEligibleBillingAccounts', $request, $callOptions)->wait();
    }

    /**
     * Registers a service account with subscriber privileges on the Pub/Sub
     * topic for this Channel Services account or integrator. After you create a
     * subscriber, you get the events through
     * [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The topic name with the registered service email address.
     *
     * The async variant is {@see CloudChannelServiceClient::registerSubscriberAsync()}
     * .
     *
     * @example samples/V1/CloudChannelServiceClient/register_subscriber.php
     *
     * @param RegisterSubscriberRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RegisterSubscriberResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function registerSubscriber(
        RegisterSubscriberRequest $request,
        array $callOptions = []
    ): RegisterSubscriberResponse {
        return $this->startApiCall('RegisterSubscriber', $request, $callOptions)->wait();
    }

    /**
     * Starts paid service for a trial entitlement.
     *
     * Starts paid service for a trial entitlement immediately. This method is
     * only applicable if a plan is set up for a trial entitlement but has some
     * trial days remaining.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
     * entitlement on trial plans.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::startPaidServiceAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/start_paid_service.php
     *
     * @param StartPaidServiceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startPaidService(StartPaidServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartPaidService', $request, $callOptions)->wait();
    }

    /**
     * Suspends a previously fulfilled entitlement.
     *
     * An entitlement suspension is a long-running operation.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * NOT_ACTIVE: Entitlement is not active.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is {@see CloudChannelServiceClient::suspendEntitlementAsync()}
     * .
     *
     * @example samples/V1/CloudChannelServiceClient/suspend_entitlement.php
     *
     * @param SuspendEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suspendEntitlement(SuspendEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SuspendEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Transfers customer entitlements to new reseller.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller.
     * * The reseller is not authorized to transact on this Product. See
     * https://support.google.com/channelservices/answer/9759265
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS: The SKU was already transferred for the customer.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The SKU requires domain verification to transfer, but the domain is
     * not verified.
     * * An Add-On SKU (example, Vault or Drive) is missing the
     * pre-requisite SKU (example, G Suite Basic).
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * Specify all transferring entitlements.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::transferEntitlementsAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/transfer_entitlements.php
     *
     * @param TransferEntitlementsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<TransferEntitlementsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function transferEntitlements(
        TransferEntitlementsRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('TransferEntitlements', $request, $callOptions)->wait();
    }

    /**
     * Transfers customer entitlements from their current reseller to Google.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS: The SKU was already transferred for the customer.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The SKU requires domain verification to transfer, but the domain is
     * not verified.
     * * An Add-On SKU (example, Vault or Drive) is missing the
     * pre-requisite SKU (example, G Suite Basic).
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The response will contain
     * google.protobuf.Empty on success. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * The async variant is
     * {@see CloudChannelServiceClient::transferEntitlementsToGoogleAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/transfer_entitlements_to_google.php
     *
     * @param TransferEntitlementsToGoogleRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function transferEntitlementsToGoogle(
        TransferEntitlementsToGoogleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('TransferEntitlementsToGoogle', $request, $callOptions)->wait();
    }

    /**
     * Unregisters a service account with subscriber privileges on the Pub/Sub
     * topic created for this Channel Services account or integrator. If there are
     * no service accounts left with subscriber privileges, this deletes the
     * topic. You can call ListSubscribers to check for these accounts.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The topic resource doesn't exist.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The topic name that unregistered the service email address.
     * Returns a success response if the service email address wasn't registered
     * with the topic.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::unregisterSubscriberAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/unregister_subscriber.php
     *
     * @param UnregisterSubscriberRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UnregisterSubscriberResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function unregisterSubscriber(
        UnregisterSubscriberRequest $request,
        array $callOptions = []
    ): UnregisterSubscriberResponse {
        return $this->startApiCall('UnregisterSubscriber', $request, $callOptions)->wait();
    }

    /**
     * Updates a channel partner link. Distributors call this method to change a
     * link's status. For example, to suspend a partner link.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * Link state cannot change from invited to active or suspended.
     * * Cannot send reseller_cloud_identity_id, invite_url, or name in update
     * mask.
     * * NOT_FOUND: ChannelPartnerLink resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The updated
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::updateChannelPartnerLinkAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/update_channel_partner_link.php
     *
     * @param UpdateChannelPartnerLinkRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateChannelPartnerLink(
        UpdateChannelPartnerLinkRequest $request,
        array $callOptions = []
    ): ChannelPartnerLink {
        return $this->startApiCall('UpdateChannelPartnerLink', $request, $callOptions)->wait();
    }

    /**
     * Updates a ChannelPartnerRepricingConfig. Call this method to set
     * modifications for a specific ChannelPartner's bill. This method overwrites
     * the existing CustomerRepricingConfig.
     *
     * You can only update configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. To make changes to configs for the current month, use
     * [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
     * taking note of its restrictions. You cannot update the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * When updating a config in the future:
     *
     * * This config must already exist.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::updateChannelPartnerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/update_channel_partner_repricing_config.php
     *
     * @param UpdateChannelPartnerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelPartnerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateChannelPartnerRepricingConfig(
        UpdateChannelPartnerRepricingConfigRequest $request,
        array $callOptions = []
    ): ChannelPartnerRepricingConfig {
        return $this->startApiCall('UpdateChannelPartnerRepricingConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
     * for the reseller or distributor.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
     * for the name in the request.
     *
     * Return value:
     * The updated [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * The async variant is {@see CloudChannelServiceClient::updateCustomerAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/update_customer.php
     *
     * @param UpdateCustomerRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Customer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCustomer(UpdateCustomerRequest $request, array $callOptions = []): Customer
    {
        return $this->startApiCall('UpdateCustomer', $request, $callOptions)->wait();
    }

    /**
     * Updates a CustomerRepricingConfig. Call this method to set modifications
     * for a specific customer's bill. This method overwrites the existing
     * CustomerRepricingConfig.
     *
     * You can only update configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. To make changes to configs for the current month, use
     * [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
     * taking note of its restrictions. You cannot update the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * When updating a config in the future:
     *
     * * This config must already exist.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * The async variant is
     * {@see CloudChannelServiceClient::updateCustomerRepricingConfigAsync()} .
     *
     * @example samples/V1/CloudChannelServiceClient/update_customer_repricing_config.php
     *
     * @param UpdateCustomerRepricingConfigRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomerRepricingConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCustomerRepricingConfig(
        UpdateCustomerRepricingConfigRequest $request,
        array $callOptions = []
    ): CustomerRepricingConfig {
        return $this->startApiCall('UpdateCustomerRepricingConfig', $request, $callOptions)->wait();
    }
}
