<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/bigtable/admin/v2/bigtable_instance_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Bigtable\Admin\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\InsecureCredentialsWrapper;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Bigtable\Admin\V2\AppProfile;
use Google\Cloud\Bigtable\Admin\V2\Cluster;
use Google\Cloud\Bigtable\Admin\V2\CreateAppProfileRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateClusterRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateInstanceRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateLogicalViewRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateMaterializedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteAppProfileRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteClusterRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteInstanceRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteLogicalViewRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteMaterializedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\GetAppProfileRequest;
use Google\Cloud\Bigtable\Admin\V2\GetClusterRequest;
use Google\Cloud\Bigtable\Admin\V2\GetInstanceRequest;
use Google\Cloud\Bigtable\Admin\V2\GetLogicalViewRequest;
use Google\Cloud\Bigtable\Admin\V2\GetMaterializedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\Instance;
use Google\Cloud\Bigtable\Admin\V2\ListAppProfilesRequest;
use Google\Cloud\Bigtable\Admin\V2\ListClustersRequest;
use Google\Cloud\Bigtable\Admin\V2\ListClustersResponse;
use Google\Cloud\Bigtable\Admin\V2\ListHotTabletsRequest;
use Google\Cloud\Bigtable\Admin\V2\ListInstancesRequest;
use Google\Cloud\Bigtable\Admin\V2\ListInstancesResponse;
use Google\Cloud\Bigtable\Admin\V2\ListLogicalViewsRequest;
use Google\Cloud\Bigtable\Admin\V2\ListMaterializedViewsRequest;
use Google\Cloud\Bigtable\Admin\V2\LogicalView;
use Google\Cloud\Bigtable\Admin\V2\MaterializedView;
use Google\Cloud\Bigtable\Admin\V2\PartialUpdateClusterRequest;
use Google\Cloud\Bigtable\Admin\V2\PartialUpdateInstanceRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateAppProfileRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateLogicalViewRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateMaterializedViewRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use Grpc\ChannelCredentials;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for creating, configuring, and deleting Cloud Bigtable Instances and
 * Clusters. Provides access to the Instance and Cluster schemas only, not the
 * tables' metadata or data stored in those tables.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AppProfile> createAppProfileAsync(CreateAppProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createClusterAsync(CreateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createLogicalViewAsync(CreateLogicalViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMaterializedViewAsync(CreateMaterializedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAppProfileAsync(DeleteAppProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteClusterAsync(DeleteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteLogicalViewAsync(DeleteLogicalViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteMaterializedViewAsync(DeleteMaterializedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AppProfile> getAppProfileAsync(GetAppProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Cluster> getClusterAsync(GetClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<LogicalView> getLogicalViewAsync(GetLogicalViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MaterializedView> getMaterializedViewAsync(GetMaterializedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAppProfilesAsync(ListAppProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListClustersResponse> listClustersAsync(ListClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listHotTabletsAsync(ListHotTabletsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListInstancesResponse> listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLogicalViewsAsync(ListLogicalViewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMaterializedViewsAsync(ListMaterializedViewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> partialUpdateClusterAsync(PartialUpdateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> partialUpdateInstanceAsync(PartialUpdateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAppProfileAsync(UpdateAppProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateClusterAsync(Cluster $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> updateInstanceAsync(Instance $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateLogicalViewAsync(UpdateLogicalViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateMaterializedViewAsync(UpdateMaterializedViewRequest $request, array $optionalArgs = [])
 */
final class BigtableInstanceAdminClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.bigtable.admin.v2.BigtableInstanceAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'bigtableadmin.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'bigtableadmin.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigtable.admin',
        'https://www.googleapis.com/auth/bigtable.admin.cluster',
        'https://www.googleapis.com/auth/bigtable.admin.instance',
        'https://www.googleapis.com/auth/cloud-bigtable.admin',
        'https://www.googleapis.com/auth/cloud-bigtable.admin.cluster',
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/bigtable_instance_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/bigtable_instance_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/bigtable_instance_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/bigtable_instance_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app_profile
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $appProfile
     *
     * @return string The formatted app_profile resource.
     */
    public static function appProfileName(string $project, string $instance, string $appProfile): string
    {
        return self::getPathTemplate('appProfile')->render([
            'project' => $project,
            'instance' => $instance,
            'app_profile' => $appProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $instance, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'instance' => $instance,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a logical_view
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $logicalView
     *
     * @return string The formatted logical_view resource.
     */
    public static function logicalViewName(string $project, string $instance, string $logicalView): string
    {
        return self::getPathTemplate('logicalView')->render([
            'project' => $project,
            'instance' => $instance,
            'logical_view' => $logicalView,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * materialized_view resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $materializedView
     *
     * @return string The formatted materialized_view resource.
     */
    public static function materializedViewName(string $project, string $instance, string $materializedView): string
    {
        return self::getPathTemplate('materializedView')->render([
            'project' => $project,
            'instance' => $instance,
            'materialized_view' => $materializedView,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - appProfile: projects/{project}/instances/{instance}/appProfiles/{app_profile}
     * - cluster: projects/{project}/instances/{instance}/clusters/{cluster}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - instance: projects/{project}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - logicalView: projects/{project}/instances/{instance}/logicalViews/{logical_view}
     * - materializedView: projects/{project}/instances/{instance}/materializedViews/{materialized_view}
     * - project: projects/{project}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * Setting the "BIGTABLE_EMULATOR_HOST" environment variable will automatically set
     * the API Endpoint to the value specified in the variable, as well as ensure that
     * empty credentials are used in the transport layer.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigtableadmin.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Bigtable\Admin\V2\BigtableInstanceAdminClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new BigtableInstanceAdminClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $options = $this->setDefaultEmulatorConfig($options);
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an app profile within an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::createAppProfileAsync()}
     * .
     *
     * @example samples/V2/BigtableInstanceAdminClient/create_app_profile.php
     *
     * @param CreateAppProfileRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AppProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAppProfile(CreateAppProfileRequest $request, array $callOptions = []): AppProfile
    {
        return $this->startApiCall('CreateAppProfile', $request, $callOptions)->wait();
    }

    /**
     * Creates a cluster within an instance.
     *
     * Note that exactly one of Cluster.serve_nodes and
     * Cluster.cluster_config.cluster_autoscaling_config can be set. If
     * serve_nodes is set to non-zero, then the cluster is manually scaled. If
     * cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
     * enabled.
     *
     * The async variant is {@see BigtableInstanceAdminClient::createClusterAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/create_cluster.php
     *
     * @param CreateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Cluster>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCluster(CreateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCluster', $request, $callOptions)->wait();
    }

    /**
     * Create an instance within a project.
     *
     * Note that exactly one of Cluster.serve_nodes and
     * Cluster.cluster_config.cluster_autoscaling_config can be set. If
     * serve_nodes is set to non-zero, then the cluster is manually scaled. If
     * cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
     * enabled.
     *
     * The async variant is {@see BigtableInstanceAdminClient::createInstanceAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Instance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a logical view within an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::createLogicalViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/create_logical_view.php
     *
     * @param CreateLogicalViewRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<LogicalView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLogicalView(CreateLogicalViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateLogicalView', $request, $callOptions)->wait();
    }

    /**
     * Creates a materialized view within an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::createMaterializedViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/create_materialized_view.php
     *
     * @param CreateMaterializedViewRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MaterializedView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMaterializedView(CreateMaterializedViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMaterializedView', $request, $callOptions)->wait();
    }

    /**
     * Deletes an app profile from an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::deleteAppProfileAsync()}
     * .
     *
     * @example samples/V2/BigtableInstanceAdminClient/delete_app_profile.php
     *
     * @param DeleteAppProfileRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAppProfile(DeleteAppProfileRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAppProfile', $request, $callOptions)->wait();
    }

    /**
     * Deletes a cluster from an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::deleteClusterAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/delete_cluster.php
     *
     * @param DeleteClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCluster(DeleteClusterRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteCluster', $request, $callOptions)->wait();
    }

    /**
     * Delete an instance from a project.
     *
     * The async variant is {@see BigtableInstanceAdminClient::deleteInstanceAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes a logical view from an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::deleteLogicalViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/delete_logical_view.php
     *
     * @param DeleteLogicalViewRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteLogicalView(DeleteLogicalViewRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteLogicalView', $request, $callOptions)->wait();
    }

    /**
     * Deletes a materialized view from an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::deleteMaterializedViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/delete_materialized_view.php
     *
     * @param DeleteMaterializedViewRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMaterializedView(DeleteMaterializedViewRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMaterializedView', $request, $callOptions)->wait();
    }

    /**
     * Gets information about an app profile.
     *
     * The async variant is {@see BigtableInstanceAdminClient::getAppProfileAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_app_profile.php
     *
     * @param GetAppProfileRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AppProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAppProfile(GetAppProfileRequest $request, array $callOptions = []): AppProfile
    {
        return $this->startApiCall('GetAppProfile', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a cluster.
     *
     * The async variant is {@see BigtableInstanceAdminClient::getClusterAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_cluster.php
     *
     * @param GetClusterRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Cluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCluster(GetClusterRequest $request, array $callOptions = []): Cluster
    {
        return $this->startApiCall('GetCluster', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for an instance resource. Returns an empty
     * policy if an instance exists but does not have a policy set.
     *
     * The async variant is {@see BigtableInstanceAdminClient::getIamPolicyAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets information about an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::getInstanceAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a logical view.
     *
     * The async variant is {@see BigtableInstanceAdminClient::getLogicalViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_logical_view.php
     *
     * @param GetLogicalViewRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogicalView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLogicalView(GetLogicalViewRequest $request, array $callOptions = []): LogicalView
    {
        return $this->startApiCall('GetLogicalView', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a materialized view.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::getMaterializedViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/get_materialized_view.php
     *
     * @param GetMaterializedViewRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MaterializedView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMaterializedView(GetMaterializedViewRequest $request, array $callOptions = []): MaterializedView
    {
        return $this->startApiCall('GetMaterializedView', $request, $callOptions)->wait();
    }

    /**
     * Lists information about app profiles in an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::listAppProfilesAsync()}
     * .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_app_profiles.php
     *
     * @param ListAppProfilesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAppProfiles(ListAppProfilesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAppProfiles', $request, $callOptions);
    }

    /**
     * Lists information about clusters in an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::listClustersAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_clusters.php
     *
     * @param ListClustersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListClustersResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClusters(ListClustersRequest $request, array $callOptions = []): ListClustersResponse
    {
        return $this->startApiCall('ListClusters', $request, $callOptions)->wait();
    }

    /**
     * Lists hot tablets in a cluster, within the time range provided. Hot
     * tablets are ordered based on CPU usage.
     *
     * The async variant is {@see BigtableInstanceAdminClient::listHotTabletsAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_hot_tablets.php
     *
     * @param ListHotTabletsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHotTablets(ListHotTabletsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHotTablets', $request, $callOptions);
    }

    /**
     * Lists information about instances in a project.
     *
     * The async variant is {@see BigtableInstanceAdminClient::listInstancesAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListInstancesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): ListInstancesResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions)->wait();
    }

    /**
     * Lists information about logical views in an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::listLogicalViewsAsync()}
     * .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_logical_views.php
     *
     * @param ListLogicalViewsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLogicalViews(ListLogicalViewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLogicalViews', $request, $callOptions);
    }

    /**
     * Lists information about materialized views in an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::listMaterializedViewsAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/list_materialized_views.php
     *
     * @param ListMaterializedViewsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMaterializedViews(ListMaterializedViewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMaterializedViews', $request, $callOptions);
    }

    /**
     * Partially updates a cluster within a project. This method is the preferred
     * way to update a Cluster.
     *
     * To enable and update autoscaling, set
     * cluster_config.cluster_autoscaling_config. When autoscaling is enabled,
     * serve_nodes is treated as an OUTPUT_ONLY field, meaning that updates to it
     * are ignored. Note that an update cannot simultaneously set serve_nodes to
     * non-zero and cluster_config.cluster_autoscaling_config to non-empty, and
     * also specify both in the update_mask.
     *
     * To disable autoscaling, clear cluster_config.cluster_autoscaling_config,
     * and explicitly set a serve_node count via the update_mask.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::partialUpdateClusterAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/partial_update_cluster.php
     *
     * @param PartialUpdateClusterRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Cluster>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function partialUpdateCluster(PartialUpdateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PartialUpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Partially updates an instance within a project. This method can modify all
     * fields of an Instance and is the preferred way to update an Instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::partialUpdateInstanceAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/partial_update_instance.php
     *
     * @param PartialUpdateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Instance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function partialUpdateInstance(PartialUpdateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PartialUpdateInstance', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on an instance resource. Replaces any
     * existing policy.
     *
     * The async variant is {@see BigtableInstanceAdminClient::setIamPolicyAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that the caller has on the specified instance resource.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::testIamPermissionsAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates an app profile within an instance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::updateAppProfileAsync()}
     * .
     *
     * @example samples/V2/BigtableInstanceAdminClient/update_app_profile.php
     *
     * @param UpdateAppProfileRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AppProfile>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAppProfile(UpdateAppProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAppProfile', $request, $callOptions)->wait();
    }

    /**
     * Updates a cluster within an instance.
     *
     * Note that UpdateCluster does not support updating
     * cluster_config.cluster_autoscaling_config. In order to update it, you
     * must use PartialUpdateCluster.
     *
     * The async variant is {@see BigtableInstanceAdminClient::updateClusterAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/update_cluster.php
     *
     * @param Cluster $request     A request to house fields associated with the call.
     * @param array   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Cluster>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCluster(Cluster $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates an instance within a project. This method updates only the display
     * name and type for an Instance. To update other Instance properties, such as
     * labels, use PartialUpdateInstance.
     *
     * The async variant is {@see BigtableInstanceAdminClient::updateInstanceAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/update_instance.php
     *
     * @param Instance $request     A request to house fields associated with the call.
     * @param array    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstance(Instance $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('UpdateInstance', $request, $callOptions)->wait();
    }

    /**
     * Updates a logical view within an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::updateLogicalViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/update_logical_view.php
     *
     * @param UpdateLogicalViewRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<LogicalView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateLogicalView(UpdateLogicalViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateLogicalView', $request, $callOptions)->wait();
    }

    /**
     * Updates a materialized view within an instance.
     *
     * The async variant is
     * {@see BigtableInstanceAdminClient::updateMaterializedViewAsync()} .
     *
     * @example samples/V2/BigtableInstanceAdminClient/update_materialized_view.php
     *
     * @param UpdateMaterializedViewRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MaterializedView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMaterializedView(UpdateMaterializedViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateMaterializedView', $request, $callOptions)->wait();
    }

    /** Configure the gapic configuration to use a service emulator. */
    private function setDefaultEmulatorConfig(array $options): array
    {
        $emulatorHost = getenv('BIGTABLE_EMULATOR_HOST');
        if (empty($emulatorHost)) {
            return $options;
        }

        if ($scheme = parse_url($emulatorHost, PHP_URL_SCHEME)) {
            $search = $scheme . '://';
            $emulatorHost = str_replace($search, '', $emulatorHost);
        }

        $options['apiEndpoint'] ??= $emulatorHost;
        if (class_exists(ChannelCredentials::class)) {
            $options['transportConfig']['grpc']['stubOpts']['credentials'] ??= ChannelCredentials::createInsecure();
        }

        $options['credentials'] ??= new InsecureCredentialsWrapper();
        return $options;
    }
}
