<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/admin/v2/table.proto

namespace Google\Cloud\Bigtable\Admin\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A backup of a Cloud Bigtable table.
 *
 * Generated from protobuf message <code>google.bigtable.admin.v2.Backup</code>
 */
class Backup extends \Google\Protobuf\Internal\Message
{
    /**
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. Immutable. Name of the table from which this backup was created.
     * This needs to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     *
     * Generated from protobuf field <code>string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $source_table = '';
    /**
     * Output only. Name of the backup from which this backup was copied. If a
     * backup is not created by copying a backup, this field will be empty. Values
     * are of the form:
     * projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
     *
     * Generated from protobuf field <code>string source_backup = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $source_backup = '';
    /**
     * Required. The expiration time of the backup.
     * When creating a backup or updating its `expire_time`, the value must be
     * greater than the backup creation time by:
     * - At least 6 hours
     * - At most 90 days
     * Once the `expire_time` has passed, Cloud Bigtable will delete the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup]
     * request is received).  The row data in this backup will be no older than
     * this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $start_time = null;
    /**
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $end_time = null;
    /**
     * Output only. Size of the backup in bytes.
     *
     * Generated from protobuf field <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $size_bytes = 0;
    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The encryption information for the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $encryption_info = null;
    /**
     * Indicates the backup type of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.BackupType backup_type = 11;</code>
     */
    protected $backup_type = 0;
    /**
     * The time at which the hot backup will be converted to a standard backup.
     * Once the `hot_to_standard_time` has passed, Cloud Bigtable will convert the
     * hot backup to a standard backup. This value must be greater than the backup
     * creation time by:
     * - At least 24 hours
     * This field only applies for hot backups. When creating or updating a
     * standard backup, attempting to set this field will fail the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp hot_to_standard_time = 12;</code>
     */
    protected $hot_to_standard_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A globally unique identifier for the backup which cannot be
     *           changed. Values are of the form
     *           `projects/{project}/instances/{instance}/clusters/{cluster}/
     *              backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     *           The final segment of the name must be between 1 and 50 characters
     *           in length.
     *           The backup is stored in the cluster identified by the prefix of the backup
     *           name of the form
     *           `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *     @type string $source_table
     *           Required. Immutable. Name of the table from which this backup was created.
     *           This needs to be in the same instance as the backup. Values are of the form
     *           `projects/{project}/instances/{instance}/tables/{source_table}`.
     *     @type string $source_backup
     *           Output only. Name of the backup from which this backup was copied. If a
     *           backup is not created by copying a backup, this field will be empty. Values
     *           are of the form:
     *           projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Required. The expiration time of the backup.
     *           When creating a backup or updating its `expire_time`, the value must be
     *           greater than the backup creation time by:
     *           - At least 6 hours
     *           - At most 90 days
     *           Once the `expire_time` has passed, Cloud Bigtable will delete the backup.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. `start_time` is the time that the backup was started
     *           (i.e. approximately the time the
     *           [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup]
     *           request is received).  The row data in this backup will be no older than
     *           this timestamp.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Output only. `end_time` is the time that the backup was finished. The row
     *           data in the backup will be no newer than this timestamp.
     *     @type int|string $size_bytes
     *           Output only. Size of the backup in bytes.
     *     @type int $state
     *           Output only. The current state of the backup.
     *     @type \Google\Cloud\Bigtable\Admin\V2\EncryptionInfo $encryption_info
     *           Output only. The encryption information for the backup.
     *     @type int $backup_type
     *           Indicates the backup type of the backup.
     *     @type \Google\Protobuf\Timestamp $hot_to_standard_time
     *           The time at which the hot backup will be converted to a standard backup.
     *           Once the `hot_to_standard_time` has passed, Cloud Bigtable will convert the
     *           hot backup to a standard backup. This value must be greater than the backup
     *           creation time by:
     *           - At least 24 hours
     *           This field only applies for hot backups. When creating or updating a
     *           standard backup, attempting to set this field will fail the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\Admin\V2\Table::initOnce();
        parent::__construct($data);
    }

    /**
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. Name of the table from which this backup was created.
     * This needs to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     *
     * Generated from protobuf field <code>string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSourceTable()
    {
        return $this->source_table;
    }

    /**
     * Required. Immutable. Name of the table from which this backup was created.
     * This needs to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     *
     * Generated from protobuf field <code>string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_table = $var;

        return $this;
    }

    /**
     * Output only. Name of the backup from which this backup was copied. If a
     * backup is not created by copying a backup, this field will be empty. Values
     * are of the form:
     * projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
     *
     * Generated from protobuf field <code>string source_backup = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSourceBackup()
    {
        return $this->source_backup;
    }

    /**
     * Output only. Name of the backup from which this backup was copied. If a
     * backup is not created by copying a backup, this field will be empty. Values
     * are of the form:
     * projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
     *
     * Generated from protobuf field <code>string source_backup = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceBackup($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_backup = $var;

        return $this;
    }

    /**
     * Required. The expiration time of the backup.
     * When creating a backup or updating its `expire_time`, the value must be
     * greater than the backup creation time by:
     * - At least 6 hours
     * - At most 90 days
     * Once the `expire_time` has passed, Cloud Bigtable will delete the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Required. The expiration time of the backup.
     * When creating a backup or updating its `expire_time`, the value must be
     * greater than the backup creation time by:
     * - At least 6 hours
     * - At most 90 days
     * Once the `expire_time` has passed, Cloud Bigtable will delete the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup]
     * request is received).  The row data in this backup will be no older than
     * this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup]
     * request is received).  The row data in this backup will be no older than
     * this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * Output only. Size of the backup in bytes.
     *
     * Generated from protobuf field <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getSizeBytes()
    {
        return $this->size_bytes;
    }

    /**
     * Output only. Size of the backup in bytes.
     *
     * Generated from protobuf field <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->size_bytes = $var;

        return $this;
    }

    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Bigtable\Admin\V2\Backup\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The encryption information for the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Bigtable\Admin\V2\EncryptionInfo|null
     */
    public function getEncryptionInfo()
    {
        return $this->encryption_info;
    }

    public function hasEncryptionInfo()
    {
        return isset($this->encryption_info);
    }

    public function clearEncryptionInfo()
    {
        unset($this->encryption_info);
    }

    /**
     * Output only. The encryption information for the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Bigtable\Admin\V2\EncryptionInfo $var
     * @return $this
     */
    public function setEncryptionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\Admin\V2\EncryptionInfo::class);
        $this->encryption_info = $var;

        return $this;
    }

    /**
     * Indicates the backup type of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.BackupType backup_type = 11;</code>
     * @return int
     */
    public function getBackupType()
    {
        return $this->backup_type;
    }

    /**
     * Indicates the backup type of the backup.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.Backup.BackupType backup_type = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setBackupType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Bigtable\Admin\V2\Backup\BackupType::class);
        $this->backup_type = $var;

        return $this;
    }

    /**
     * The time at which the hot backup will be converted to a standard backup.
     * Once the `hot_to_standard_time` has passed, Cloud Bigtable will convert the
     * hot backup to a standard backup. This value must be greater than the backup
     * creation time by:
     * - At least 24 hours
     * This field only applies for hot backups. When creating or updating a
     * standard backup, attempting to set this field will fail the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp hot_to_standard_time = 12;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getHotToStandardTime()
    {
        return $this->hot_to_standard_time;
    }

    public function hasHotToStandardTime()
    {
        return isset($this->hot_to_standard_time);
    }

    public function clearHotToStandardTime()
    {
        unset($this->hot_to_standard_time);
    }

    /**
     * The time at which the hot backup will be converted to a standard backup.
     * Once the `hot_to_standard_time` has passed, Cloud Bigtable will convert the
     * hot backup to a standard backup. This value must be greater than the backup
     * creation time by:
     * - At least 24 hours
     * This field only applies for hot backups. When creating or updating a
     * standard backup, attempting to set this field will fail the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp hot_to_standard_time = 12;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setHotToStandardTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->hot_to_standard_time = $var;

        return $this;
    }

}

