<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/events/subscriptions/v1beta/subscription_resource.proto

namespace Google\Apps\Events\Subscriptions\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A subscription to receive events about a Google Workspace resource. To learn
 * more about subscriptions, see the [Google Workspace Events API
 * overview](https://developers.google.com/workspace/events).
 *
 * Generated from protobuf message <code>google.apps.events.subscriptions.v1beta.Subscription</code>
 */
class Subscription extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Resource name of the subscription.
     * Format: `subscriptions/{subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. System-assigned unique identifier for the subscription.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $uid = '';
    /**
     * Required. Immutable. The Google Workspace resource that's monitored for
     * events, formatted as the [full resource
     * name](https://google.aip.dev/122#full-resource-names). To learn about
     * target resources and the events that they support, see [Supported Google
     * Workspace
     * events](https://developers.google.com/workspace/events#supported-events).
     * A user can only authorize your app to create one subscription for a given
     * target resource. If your app tries to create another subscription with the
     * same user credentials, the request returns an `ALREADY_EXISTS` error.
     *
     * Generated from protobuf field <code>string target_resource = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $target_resource = '';
    /**
     * Required. Unordered list. Input for creating a subscription. Otherwise,
     * output only. One or more types of events to receive about the target
     * resource. Formatted according to the CloudEvents specification.
     * The supported event types depend on the target resource of your
     * subscription. For details, see [Supported Google Workspace
     * events](https://developers.google.com/workspace/events/guides#supported-events).
     * By default, you also receive events about the [lifecycle of your
     * subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
     * You don't need to specify lifecycle events for this field.
     * If you specify an event type that doesn't exist for the target resource,
     * the request returns an HTTP `400 Bad Request` status code.
     *
     * Generated from protobuf field <code>repeated string event_types = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = UNORDERED_LIST];</code>
     */
    private $event_types;
    /**
     * Optional. Options about what data to include in the event payload. Only
     * supported for Google Chat events.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.PayloadOptions payload_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $payload_options = null;
    /**
     * Required. Immutable. The endpoint where the subscription delivers events,
     * such as a Pub/Sub topic.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.NotificationEndpoint notification_endpoint = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $notification_endpoint = null;
    /**
     * Output only. The state of the subscription. Determines whether the
     * subscription can receive events and deliver them to the notification
     * endpoint.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The error that suspended the subscription.
     * To reactivate the subscription, resolve the error and call the
     * [`ReactivateSubscription`][google.apps.events.subscriptions.v1beta.SubscriptionsService.ReactivateSubscription]
     * method.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.ErrorType suspension_reason = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $suspension_reason = 0;
    /**
     * Output only. The user who authorized the creation of the subscription.
     * Format: `users/{user}`
     * For Google Workspace users, the `{user}` value is the
     * [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
     * field from the Directory API.
     *
     * Generated from protobuf field <code>string authority = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $authority = '';
    /**
     * Output only. The time when the subscription is created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last time that the subscription is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. If `true`, the subscription is in the process of being
     * updated.
     *
     * Generated from protobuf field <code>bool reconciling = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and might be sent on update requests to ensure the client has
     * an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    protected $subscription_options;
    protected $expiration;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Events\Subscriptions\V1beta\Subscription\DriveOptions $drive_options
     *           Optional. Features that are supported only for subscriptions on Drive
     *           resources.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Non-empty default. The timestamp in UTC when the subscription expires.
     *           Always displayed on output, regardless of what was used on input.
     *     @type \Google\Protobuf\Duration $ttl
     *           Input only. The time-to-live (TTL) or duration for the subscription. If
     *           unspecified or set to `0`, uses the maximum possible duration.
     *     @type string $name
     *           Identifier. Resource name of the subscription.
     *           Format: `subscriptions/{subscription}`
     *     @type string $uid
     *           Output only. System-assigned unique identifier for the subscription.
     *     @type string $target_resource
     *           Required. Immutable. The Google Workspace resource that's monitored for
     *           events, formatted as the [full resource
     *           name](https://google.aip.dev/122#full-resource-names). To learn about
     *           target resources and the events that they support, see [Supported Google
     *           Workspace
     *           events](https://developers.google.com/workspace/events#supported-events).
     *           A user can only authorize your app to create one subscription for a given
     *           target resource. If your app tries to create another subscription with the
     *           same user credentials, the request returns an `ALREADY_EXISTS` error.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $event_types
     *           Required. Unordered list. Input for creating a subscription. Otherwise,
     *           output only. One or more types of events to receive about the target
     *           resource. Formatted according to the CloudEvents specification.
     *           The supported event types depend on the target resource of your
     *           subscription. For details, see [Supported Google Workspace
     *           events](https://developers.google.com/workspace/events/guides#supported-events).
     *           By default, you also receive events about the [lifecycle of your
     *           subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
     *           You don't need to specify lifecycle events for this field.
     *           If you specify an event type that doesn't exist for the target resource,
     *           the request returns an HTTP `400 Bad Request` status code.
     *     @type \Google\Apps\Events\Subscriptions\V1beta\PayloadOptions $payload_options
     *           Optional. Options about what data to include in the event payload. Only
     *           supported for Google Chat events.
     *     @type \Google\Apps\Events\Subscriptions\V1beta\NotificationEndpoint $notification_endpoint
     *           Required. Immutable. The endpoint where the subscription delivers events,
     *           such as a Pub/Sub topic.
     *     @type int $state
     *           Output only. The state of the subscription. Determines whether the
     *           subscription can receive events and deliver them to the notification
     *           endpoint.
     *     @type int $suspension_reason
     *           Output only. The error that suspended the subscription.
     *           To reactivate the subscription, resolve the error and call the
     *           [`ReactivateSubscription`][google.apps.events.subscriptions.v1beta.SubscriptionsService.ReactivateSubscription]
     *           method.
     *     @type string $authority
     *           Output only. The user who authorized the creation of the subscription.
     *           Format: `users/{user}`
     *           For Google Workspace users, the `{user}` value is the
     *           [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
     *           field from the Directory API.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the subscription is created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last time that the subscription is updated.
     *     @type bool $reconciling
     *           Output only. If `true`, the subscription is in the process of being
     *           updated.
     *     @type string $etag
     *           Optional. This checksum is computed by the server based on the value of
     *           other fields, and might be sent on update requests to ensure the client has
     *           an up-to-date value before proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Events\Subscriptions\V1Beta\SubscriptionResource::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Features that are supported only for subscriptions on Drive
     * resources.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.DriveOptions drive_options = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Events\Subscriptions\V1beta\Subscription\DriveOptions|null
     */
    public function getDriveOptions()
    {
        return $this->readOneof(20);
    }

    public function hasDriveOptions()
    {
        return $this->hasOneof(20);
    }

    /**
     * Optional. Features that are supported only for subscriptions on Drive
     * resources.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.DriveOptions drive_options = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Events\Subscriptions\V1beta\Subscription\DriveOptions $var
     * @return $this
     */
    public function setDriveOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Events\Subscriptions\V1beta\Subscription\DriveOptions::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * Non-empty default. The timestamp in UTC when the subscription expires.
     * Always displayed on output, regardless of what was used on input.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = NON_EMPTY_DEFAULT];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->readOneof(13);
    }

    public function hasExpireTime()
    {
        return $this->hasOneof(13);
    }

    /**
     * Non-empty default. The timestamp in UTC when the subscription expires.
     * Always displayed on output, regardless of what was used on input.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = NON_EMPTY_DEFAULT];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Input only. The time-to-live (TTL) or duration for the subscription. If
     * unspecified or set to `0`, uses the maximum possible duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTtl()
    {
        return $this->readOneof(14);
    }

    public function hasTtl()
    {
        return $this->hasOneof(14);
    }

    /**
     * Input only. The time-to-live (TTL) or duration for the subscription. If
     * unspecified or set to `0`, uses the maximum possible duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Identifier. Resource name of the subscription.
     * Format: `subscriptions/{subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Resource name of the subscription.
     * Format: `subscriptions/{subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. System-assigned unique identifier for the subscription.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System-assigned unique identifier for the subscription.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Required. Immutable. The Google Workspace resource that's monitored for
     * events, formatted as the [full resource
     * name](https://google.aip.dev/122#full-resource-names). To learn about
     * target resources and the events that they support, see [Supported Google
     * Workspace
     * events](https://developers.google.com/workspace/events#supported-events).
     * A user can only authorize your app to create one subscription for a given
     * target resource. If your app tries to create another subscription with the
     * same user credentials, the request returns an `ALREADY_EXISTS` error.
     *
     * Generated from protobuf field <code>string target_resource = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTargetResource()
    {
        return $this->target_resource;
    }

    /**
     * Required. Immutable. The Google Workspace resource that's monitored for
     * events, formatted as the [full resource
     * name](https://google.aip.dev/122#full-resource-names). To learn about
     * target resources and the events that they support, see [Supported Google
     * Workspace
     * events](https://developers.google.com/workspace/events#supported-events).
     * A user can only authorize your app to create one subscription for a given
     * target resource. If your app tries to create another subscription with the
     * same user credentials, the request returns an `ALREADY_EXISTS` error.
     *
     * Generated from protobuf field <code>string target_resource = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource = $var;

        return $this;
    }

    /**
     * Required. Unordered list. Input for creating a subscription. Otherwise,
     * output only. One or more types of events to receive about the target
     * resource. Formatted according to the CloudEvents specification.
     * The supported event types depend on the target resource of your
     * subscription. For details, see [Supported Google Workspace
     * events](https://developers.google.com/workspace/events/guides#supported-events).
     * By default, you also receive events about the [lifecycle of your
     * subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
     * You don't need to specify lifecycle events for this field.
     * If you specify an event type that doesn't exist for the target resource,
     * the request returns an HTTP `400 Bad Request` status code.
     *
     * Generated from protobuf field <code>repeated string event_types = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = UNORDERED_LIST];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEventTypes()
    {
        return $this->event_types;
    }

    /**
     * Required. Unordered list. Input for creating a subscription. Otherwise,
     * output only. One or more types of events to receive about the target
     * resource. Formatted according to the CloudEvents specification.
     * The supported event types depend on the target resource of your
     * subscription. For details, see [Supported Google Workspace
     * events](https://developers.google.com/workspace/events/guides#supported-events).
     * By default, you also receive events about the [lifecycle of your
     * subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
     * You don't need to specify lifecycle events for this field.
     * If you specify an event type that doesn't exist for the target resource,
     * the request returns an HTTP `400 Bad Request` status code.
     *
     * Generated from protobuf field <code>repeated string event_types = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = UNORDERED_LIST];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEventTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->event_types = $arr;

        return $this;
    }

    /**
     * Optional. Options about what data to include in the event payload. Only
     * supported for Google Chat events.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.PayloadOptions payload_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Events\Subscriptions\V1beta\PayloadOptions|null
     */
    public function getPayloadOptions()
    {
        return $this->payload_options;
    }

    public function hasPayloadOptions()
    {
        return isset($this->payload_options);
    }

    public function clearPayloadOptions()
    {
        unset($this->payload_options);
    }

    /**
     * Optional. Options about what data to include in the event payload. Only
     * supported for Google Chat events.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.PayloadOptions payload_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Events\Subscriptions\V1beta\PayloadOptions $var
     * @return $this
     */
    public function setPayloadOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Events\Subscriptions\V1beta\PayloadOptions::class);
        $this->payload_options = $var;

        return $this;
    }

    /**
     * Required. Immutable. The endpoint where the subscription delivers events,
     * such as a Pub/Sub topic.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.NotificationEndpoint notification_endpoint = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Apps\Events\Subscriptions\V1beta\NotificationEndpoint|null
     */
    public function getNotificationEndpoint()
    {
        return $this->notification_endpoint;
    }

    public function hasNotificationEndpoint()
    {
        return isset($this->notification_endpoint);
    }

    public function clearNotificationEndpoint()
    {
        unset($this->notification_endpoint);
    }

    /**
     * Required. Immutable. The endpoint where the subscription delivers events,
     * such as a Pub/Sub topic.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.NotificationEndpoint notification_endpoint = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Apps\Events\Subscriptions\V1beta\NotificationEndpoint $var
     * @return $this
     */
    public function setNotificationEndpoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Events\Subscriptions\V1beta\NotificationEndpoint::class);
        $this->notification_endpoint = $var;

        return $this;
    }

    /**
     * Output only. The state of the subscription. Determines whether the
     * subscription can receive events and deliver them to the notification
     * endpoint.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the subscription. Determines whether the
     * subscription can receive events and deliver them to the notification
     * endpoint.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Events\Subscriptions\V1beta\Subscription\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The error that suspended the subscription.
     * To reactivate the subscription, resolve the error and call the
     * [`ReactivateSubscription`][google.apps.events.subscriptions.v1beta.SubscriptionsService.ReactivateSubscription]
     * method.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.ErrorType suspension_reason = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getSuspensionReason()
    {
        return $this->suspension_reason;
    }

    /**
     * Output only. The error that suspended the subscription.
     * To reactivate the subscription, resolve the error and call the
     * [`ReactivateSubscription`][google.apps.events.subscriptions.v1beta.SubscriptionsService.ReactivateSubscription]
     * method.
     *
     * Generated from protobuf field <code>.google.apps.events.subscriptions.v1beta.Subscription.ErrorType suspension_reason = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setSuspensionReason($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Events\Subscriptions\V1beta\Subscription\ErrorType::class);
        $this->suspension_reason = $var;

        return $this;
    }

    /**
     * Output only. The user who authorized the creation of the subscription.
     * Format: `users/{user}`
     * For Google Workspace users, the `{user}` value is the
     * [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
     * field from the Directory API.
     *
     * Generated from protobuf field <code>string authority = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAuthority()
    {
        return $this->authority;
    }

    /**
     * Output only. The user who authorized the creation of the subscription.
     * Format: `users/{user}`
     * For Google Workspace users, the `{user}` value is the
     * [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
     * field from the Directory API.
     *
     * Generated from protobuf field <code>string authority = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAuthority($var)
    {
        GPBUtil::checkString($var, True);
        $this->authority = $var;

        return $this;
    }

    /**
     * Output only. The time when the subscription is created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the subscription is created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last time that the subscription is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last time that the subscription is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. If `true`, the subscription is in the process of being
     * updated.
     *
     * Generated from protobuf field <code>bool reconciling = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. If `true`, the subscription is in the process of being
     * updated.
     *
     * Generated from protobuf field <code>bool reconciling = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and might be sent on update requests to ensure the client has
     * an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and might be sent on update requests to ensure the client has
     * an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubscriptionOptions()
    {
        return $this->whichOneof("subscription_options");
    }

    /**
     * @return string
     */
    public function getExpiration()
    {
        return $this->whichOneof("expiration");
    }

}

