<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/message.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information about a message that another message quotes.
 * When you create a message, you can quote messages within the same
 * thread, or quote a root message to create a new root message.
 * However, you can't quote a message reply from a different thread.
 * When you update a message, you can't add or replace the
 * `quotedMessageMetadata` field, but you can remove it.
 * For example usage, see [Quote another
 * message](https://developers.google.com/workspace/chat/create-messages#quote-a-message).
 *
 * Generated from protobuf message <code>google.chat.v1.QuotedMessageMetadata</code>
 */
class QuotedMessageMetadata extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Resource name of the message that is quoted.
     * Format: `spaces/{space}/messages/{message}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Required. The timestamp when the quoted message was created or when the
     * quoted message was last updated.
     * If the message was edited, use this field, `last_update_time`.
     * If the message was never edited, use `create_time`.
     * If `last_update_time` doesn't match the latest version of the quoted
     * message, the request fails.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $last_update_time = null;
    /**
     * Optional. Specifies the quote type. If not set, defaults to REPLY in the
     * message read/write path for backward compatibility.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata.QuoteType quote_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $quote_type = 0;
    /**
     * Output only. A snapshot of the quoted message's content.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageSnapshot quoted_message_snapshot = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $quoted_message_snapshot = null;
    /**
     * Output only. Metadata about the source space of the quoted message.
     * Populated only for FORWARD quote type.
     *
     * Generated from protobuf field <code>.google.chat.v1.ForwardedMetadata forwarded_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $forwarded_metadata = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Resource name of the message that is quoted.
     *           Format: `spaces/{space}/messages/{message}`
     *     @type \Google\Protobuf\Timestamp $last_update_time
     *           Required. The timestamp when the quoted message was created or when the
     *           quoted message was last updated.
     *           If the message was edited, use this field, `last_update_time`.
     *           If the message was never edited, use `create_time`.
     *           If `last_update_time` doesn't match the latest version of the quoted
     *           message, the request fails.
     *     @type int $quote_type
     *           Optional. Specifies the quote type. If not set, defaults to REPLY in the
     *           message read/write path for backward compatibility.
     *     @type \Google\Apps\Chat\V1\QuotedMessageSnapshot $quoted_message_snapshot
     *           Output only. A snapshot of the quoted message's content.
     *     @type \Google\Apps\Chat\V1\ForwardedMetadata $forwarded_metadata
     *           Output only. Metadata about the source space of the quoted message.
     *           Populated only for FORWARD quote type.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Resource name of the message that is quoted.
     * Format: `spaces/{space}/messages/{message}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Resource name of the message that is quoted.
     * Format: `spaces/{space}/messages/{message}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The timestamp when the quoted message was created or when the
     * quoted message was last updated.
     * If the message was edited, use this field, `last_update_time`.
     * If the message was never edited, use `create_time`.
     * If `last_update_time` doesn't match the latest version of the quoted
     * message, the request fails.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastUpdateTime()
    {
        return $this->last_update_time;
    }

    public function hasLastUpdateTime()
    {
        return isset($this->last_update_time);
    }

    public function clearLastUpdateTime()
    {
        unset($this->last_update_time);
    }

    /**
     * Required. The timestamp when the quoted message was created or when the
     * quoted message was last updated.
     * If the message was edited, use this field, `last_update_time`.
     * If the message was never edited, use `create_time`.
     * If `last_update_time` doesn't match the latest version of the quoted
     * message, the request fails.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_update_time = $var;

        return $this;
    }

    /**
     * Optional. Specifies the quote type. If not set, defaults to REPLY in the
     * message read/write path for backward compatibility.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata.QuoteType quote_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getQuoteType()
    {
        return $this->quote_type;
    }

    /**
     * Optional. Specifies the quote type. If not set, defaults to REPLY in the
     * message read/write path for backward compatibility.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata.QuoteType quote_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setQuoteType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\QuotedMessageMetadata\QuoteType::class);
        $this->quote_type = $var;

        return $this;
    }

    /**
     * Output only. A snapshot of the quoted message's content.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageSnapshot quoted_message_snapshot = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\QuotedMessageSnapshot|null
     */
    public function getQuotedMessageSnapshot()
    {
        return $this->quoted_message_snapshot;
    }

    public function hasQuotedMessageSnapshot()
    {
        return isset($this->quoted_message_snapshot);
    }

    public function clearQuotedMessageSnapshot()
    {
        unset($this->quoted_message_snapshot);
    }

    /**
     * Output only. A snapshot of the quoted message's content.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageSnapshot quoted_message_snapshot = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\QuotedMessageSnapshot $var
     * @return $this
     */
    public function setQuotedMessageSnapshot($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\QuotedMessageSnapshot::class);
        $this->quoted_message_snapshot = $var;

        return $this;
    }

    /**
     * Output only. Metadata about the source space of the quoted message.
     * Populated only for FORWARD quote type.
     *
     * Generated from protobuf field <code>.google.chat.v1.ForwardedMetadata forwarded_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\ForwardedMetadata|null
     */
    public function getForwardedMetadata()
    {
        return $this->forwarded_metadata;
    }

    public function hasForwardedMetadata()
    {
        return isset($this->forwarded_metadata);
    }

    public function clearForwardedMetadata()
    {
        unset($this->forwarded_metadata);
    }

    /**
     * Output only. Metadata about the source space of the quoted message.
     * Populated only for FORWARD quote type.
     *
     * Generated from protobuf field <code>.google.chat.v1.ForwardedMetadata forwarded_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\ForwardedMetadata $var
     * @return $this
     */
    public function setForwardedMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\ForwardedMetadata::class);
        $this->forwarded_metadata = $var;

        return $this;
    }

}

