<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apigeeregistry/v1/registry_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ApigeeRegistry\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Api\HttpBody;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ApigeeRegistry\V1\Api;
use Google\Cloud\ApigeeRegistry\V1\ApiDeployment;
use Google\Cloud\ApigeeRegistry\V1\ApiSpec;
use Google\Cloud\ApigeeRegistry\V1\ApiVersion;
use Google\Cloud\ApigeeRegistry\V1\Artifact;
use Google\Cloud\ApigeeRegistry\V1\CreateApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiDeploymentRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiSpecRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiSpecContentsRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\GetArtifactContentsRequest;
use Google\Cloud\ApigeeRegistry\V1\GetArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentRevisionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecRevisionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiVersionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApisRequest;
use Google\Cloud\ApigeeRegistry\V1\ListArtifactsRequest;
use Google\Cloud\ApigeeRegistry\V1\ReplaceArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\RollbackApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\RollbackApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\TagApiDeploymentRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\TagApiSpecRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiVersionRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The Registry service allows teams to manage descriptions of APIs.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Api> createApiAsync(CreateApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> createApiDeploymentAsync(CreateApiDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> createApiSpecAsync(CreateApiSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiVersion> createApiVersionAsync(CreateApiVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Artifact> createArtifactAsync(CreateArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiAsync(DeleteApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiDeploymentAsync(DeleteApiDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> deleteApiDeploymentRevisionAsync(DeleteApiDeploymentRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiSpecAsync(DeleteApiSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> deleteApiSpecRevisionAsync(DeleteApiSpecRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiVersionAsync(DeleteApiVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteArtifactAsync(DeleteArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Api> getApiAsync(GetApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> getApiDeploymentAsync(GetApiDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> getApiSpecAsync(GetApiSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> getApiSpecContentsAsync(GetApiSpecContentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiVersion> getApiVersionAsync(GetApiVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Artifact> getArtifactAsync(GetArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> getArtifactContentsAsync(GetArtifactContentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiDeploymentRevisionsAsync(ListApiDeploymentRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiDeploymentsAsync(ListApiDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiSpecRevisionsAsync(ListApiSpecRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiSpecsAsync(ListApiSpecsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiVersionsAsync(ListApiVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApisAsync(ListApisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listArtifactsAsync(ListArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Artifact> replaceArtifactAsync(ReplaceArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> rollbackApiDeploymentAsync(RollbackApiDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> rollbackApiSpecAsync(RollbackApiSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> tagApiDeploymentRevisionAsync(TagApiDeploymentRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> tagApiSpecRevisionAsync(TagApiSpecRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Api> updateApiAsync(UpdateApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiDeployment> updateApiDeploymentAsync(UpdateApiDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiSpec> updateApiSpecAsync(UpdateApiSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiVersion> updateApiVersionAsync(UpdateApiVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class RegistryClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.apigeeregistry.v1.Registry';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'apigeeregistry.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'apigeeregistry.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/registry_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/registry_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/registry_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/registry_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     *
     * @return string The formatted api resource.
     */
    public static function apiName(string $project, string $location, string $api): string
    {
        return self::getPathTemplate('api')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * api_deployment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $deployment
     *
     * @return string The formatted api_deployment resource.
     */
    public static function apiDeploymentName(string $project, string $location, string $api, string $deployment): string
    {
        return self::getPathTemplate('apiDeployment')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api_spec
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $spec
     *
     * @return string The formatted api_spec resource.
     */
    public static function apiSpecName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $spec
    ): string {
        return self::getPathTemplate('apiSpec')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'spec' => $spec,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api_version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     *
     * @return string The formatted api_version resource.
     */
    public static function apiVersionName(string $project, string $location, string $api, string $version): string
    {
        return self::getPathTemplate('apiVersion')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a artifact
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $artifact
     *
     * @return string The formatted artifact resource.
     */
    public static function artifactName(string $project, string $location, string $artifact): string
    {
        return self::getPathTemplate('artifact')->render([
            'project' => $project,
            'location' => $location,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $artifact
     *
     * @return string The formatted project_location_api_artifact resource.
     */
    public static function projectLocationApiArtifactName(
        string $project,
        string $location,
        string $api,
        string $artifact
    ): string {
        return self::getPathTemplate('projectLocationApiArtifact')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_deployment_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $deployment
     * @param string $artifact
     *
     * @return string The formatted project_location_api_deployment_artifact resource.
     */
    public static function projectLocationApiDeploymentArtifactName(
        string $project,
        string $location,
        string $api,
        string $deployment,
        string $artifact
    ): string {
        return self::getPathTemplate('projectLocationApiDeploymentArtifact')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'deployment' => $deployment,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_version_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $artifact
     *
     * @return string The formatted project_location_api_version_artifact resource.
     */
    public static function projectLocationApiVersionArtifactName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $artifact
    ): string {
        return self::getPathTemplate('projectLocationApiVersionArtifact')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_version_spec_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $spec
     * @param string $artifact
     *
     * @return string The formatted project_location_api_version_spec_artifact resource.
     */
    public static function projectLocationApiVersionSpecArtifactName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $spec,
        string $artifact
    ): string {
        return self::getPathTemplate('projectLocationApiVersionSpecArtifact')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'spec' => $spec,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $artifact
     *
     * @return string The formatted project_location_artifact resource.
     */
    public static function projectLocationArtifactName(string $project, string $location, string $artifact): string
    {
        return self::getPathTemplate('projectLocationArtifact')->render([
            'project' => $project,
            'location' => $location,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - api: projects/{project}/locations/{location}/apis/{api}
     * - apiDeployment: projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}
     * - apiSpec: projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}
     * - apiVersion: projects/{project}/locations/{location}/apis/{api}/versions/{version}
     * - artifact: projects/{project}/locations/{location}/artifacts/{artifact}
     * - location: projects/{project}/locations/{location}
     * - projectLocationApiArtifact: projects/{project}/locations/{location}/apis/{api}/artifacts/{artifact}
     * - projectLocationApiDeploymentArtifact: projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}/artifacts/{artifact}
     * - projectLocationApiVersionArtifact: projects/{project}/locations/{location}/apis/{api}/versions/{version}/artifacts/{artifact}
     * - projectLocationApiVersionSpecArtifact: projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}/artifacts/{artifact}
     * - projectLocationArtifact: projects/{project}/locations/{location}/artifacts/{artifact}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apigeeregistry.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ApigeeRegistry\V1\RegistryClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new RegistryClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a specified API.
     *
     * The async variant is {@see RegistryClient::createApiAsync()} .
     *
     * @example samples/V1/RegistryClient/create_api.php
     *
     * @param CreateApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApi(CreateApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('CreateApi', $request, $callOptions)->wait();
    }

    /**
     * Creates a specified deployment.
     *
     * The async variant is {@see RegistryClient::createApiDeploymentAsync()} .
     *
     * @example samples/V1/RegistryClient/create_api_deployment.php
     *
     * @param CreateApiDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApiDeployment(CreateApiDeploymentRequest $request, array $callOptions = []): ApiDeployment
    {
        return $this->startApiCall('CreateApiDeployment', $request, $callOptions)->wait();
    }

    /**
     * Creates a specified spec.
     *
     * The async variant is {@see RegistryClient::createApiSpecAsync()} .
     *
     * @example samples/V1/RegistryClient/create_api_spec.php
     *
     * @param CreateApiSpecRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApiSpec(CreateApiSpecRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('CreateApiSpec', $request, $callOptions)->wait();
    }

    /**
     * Creates a specified version.
     *
     * The async variant is {@see RegistryClient::createApiVersionAsync()} .
     *
     * @example samples/V1/RegistryClient/create_api_version.php
     *
     * @param CreateApiVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApiVersion(CreateApiVersionRequest $request, array $callOptions = []): ApiVersion
    {
        return $this->startApiCall('CreateApiVersion', $request, $callOptions)->wait();
    }

    /**
     * Creates a specified artifact.
     *
     * The async variant is {@see RegistryClient::createArtifactAsync()} .
     *
     * @example samples/V1/RegistryClient/create_artifact.php
     *
     * @param CreateArtifactRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createArtifact(CreateArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('CreateArtifact', $request, $callOptions)->wait();
    }

    /**
     * Removes a specified API and all of the resources that it
     * owns.
     *
     * The async variant is {@see RegistryClient::deleteApiAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api.php
     *
     * @param DeleteApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApi(DeleteApiRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApi', $request, $callOptions)->wait();
    }

    /**
     * Removes a specified deployment, all revisions, and all
     * child resources (e.g., artifacts).
     *
     * The async variant is {@see RegistryClient::deleteApiDeploymentAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api_deployment.php
     *
     * @param DeleteApiDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiDeployment(DeleteApiDeploymentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApiDeployment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a revision of a deployment.
     *
     * The async variant is {@see RegistryClient::deleteApiDeploymentRevisionAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api_deployment_revision.php
     *
     * @param DeleteApiDeploymentRevisionRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiDeploymentRevision(
        DeleteApiDeploymentRevisionRequest $request,
        array $callOptions = []
    ): ApiDeployment {
        return $this->startApiCall('DeleteApiDeploymentRevision', $request, $callOptions)->wait();
    }

    /**
     * Removes a specified spec, all revisions, and all child
     * resources (e.g., artifacts).
     *
     * The async variant is {@see RegistryClient::deleteApiSpecAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api_spec.php
     *
     * @param DeleteApiSpecRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiSpec(DeleteApiSpecRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApiSpec', $request, $callOptions)->wait();
    }

    /**
     * Deletes a revision of a spec.
     *
     * The async variant is {@see RegistryClient::deleteApiSpecRevisionAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api_spec_revision.php
     *
     * @param DeleteApiSpecRevisionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiSpecRevision(DeleteApiSpecRevisionRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('DeleteApiSpecRevision', $request, $callOptions)->wait();
    }

    /**
     * Removes a specified version and all of the resources that
     * it owns.
     *
     * The async variant is {@see RegistryClient::deleteApiVersionAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_api_version.php
     *
     * @param DeleteApiVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiVersion(DeleteApiVersionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApiVersion', $request, $callOptions)->wait();
    }

    /**
     * Removes a specified artifact.
     *
     * The async variant is {@see RegistryClient::deleteArtifactAsync()} .
     *
     * @example samples/V1/RegistryClient/delete_artifact.php
     *
     * @param DeleteArtifactRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteArtifact(DeleteArtifactRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteArtifact', $request, $callOptions)->wait();
    }

    /**
     * Returns a specified API.
     *
     * The async variant is {@see RegistryClient::getApiAsync()} .
     *
     * @example samples/V1/RegistryClient/get_api.php
     *
     * @param GetApiRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApi(GetApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('GetApi', $request, $callOptions)->wait();
    }

    /**
     * Returns a specified deployment.
     *
     * The async variant is {@see RegistryClient::getApiDeploymentAsync()} .
     *
     * @example samples/V1/RegistryClient/get_api_deployment.php
     *
     * @param GetApiDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApiDeployment(GetApiDeploymentRequest $request, array $callOptions = []): ApiDeployment
    {
        return $this->startApiCall('GetApiDeployment', $request, $callOptions)->wait();
    }

    /**
     * Returns a specified spec.
     *
     * The async variant is {@see RegistryClient::getApiSpecAsync()} .
     *
     * @example samples/V1/RegistryClient/get_api_spec.php
     *
     * @param GetApiSpecRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApiSpec(GetApiSpecRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('GetApiSpec', $request, $callOptions)->wait();
    }

    /**
     * Returns the contents of a specified spec.
     * If specs are stored with GZip compression, the default behavior
     * is to return the spec uncompressed (the mime_type response field
     * indicates the exact format returned).
     *
     * The async variant is {@see RegistryClient::getApiSpecContentsAsync()} .
     *
     * @example samples/V1/RegistryClient/get_api_spec_contents.php
     *
     * @param GetApiSpecContentsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApiSpecContents(GetApiSpecContentsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('GetApiSpecContents', $request, $callOptions)->wait();
    }

    /**
     * Returns a specified version.
     *
     * The async variant is {@see RegistryClient::getApiVersionAsync()} .
     *
     * @example samples/V1/RegistryClient/get_api_version.php
     *
     * @param GetApiVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApiVersion(GetApiVersionRequest $request, array $callOptions = []): ApiVersion
    {
        return $this->startApiCall('GetApiVersion', $request, $callOptions)->wait();
    }

    /**
     * Returns a specified artifact.
     *
     * The async variant is {@see RegistryClient::getArtifactAsync()} .
     *
     * @example samples/V1/RegistryClient/get_artifact.php
     *
     * @param GetArtifactRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getArtifact(GetArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('GetArtifact', $request, $callOptions)->wait();
    }

    /**
     * Returns the contents of a specified artifact.
     * If artifacts are stored with GZip compression, the default behavior
     * is to return the artifact uncompressed (the mime_type response field
     * indicates the exact format returned).
     *
     * The async variant is {@see RegistryClient::getArtifactContentsAsync()} .
     *
     * @example samples/V1/RegistryClient/get_artifact_contents.php
     *
     * @param GetArtifactContentsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getArtifactContents(GetArtifactContentsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('GetArtifactContents', $request, $callOptions)->wait();
    }

    /**
     * Lists all revisions of a deployment.
     * Revisions are returned in descending order of revision creation time.
     *
     * The async variant is {@see RegistryClient::listApiDeploymentRevisionsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_api_deployment_revisions.php
     *
     * @param ListApiDeploymentRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiDeploymentRevisions(
        ListApiDeploymentRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListApiDeploymentRevisions', $request, $callOptions);
    }

    /**
     * Returns matching deployments.
     *
     * The async variant is {@see RegistryClient::listApiDeploymentsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_api_deployments.php
     *
     * @param ListApiDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiDeployments(ListApiDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApiDeployments', $request, $callOptions);
    }

    /**
     * Lists all revisions of a spec.
     * Revisions are returned in descending order of revision creation time.
     *
     * The async variant is {@see RegistryClient::listApiSpecRevisionsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_api_spec_revisions.php
     *
     * @param ListApiSpecRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiSpecRevisions(
        ListApiSpecRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListApiSpecRevisions', $request, $callOptions);
    }

    /**
     * Returns matching specs.
     *
     * The async variant is {@see RegistryClient::listApiSpecsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_api_specs.php
     *
     * @param ListApiSpecsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiSpecs(ListApiSpecsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApiSpecs', $request, $callOptions);
    }

    /**
     * Returns matching versions.
     *
     * The async variant is {@see RegistryClient::listApiVersionsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_api_versions.php
     *
     * @param ListApiVersionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiVersions(ListApiVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApiVersions', $request, $callOptions);
    }

    /**
     * Returns matching APIs.
     *
     * The async variant is {@see RegistryClient::listApisAsync()} .
     *
     * @example samples/V1/RegistryClient/list_apis.php
     *
     * @param ListApisRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApis(ListApisRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApis', $request, $callOptions);
    }

    /**
     * Returns matching artifacts.
     *
     * The async variant is {@see RegistryClient::listArtifactsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_artifacts.php
     *
     * @param ListArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listArtifacts(ListArtifactsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListArtifacts', $request, $callOptions);
    }

    /**
     * Used to replace a specified artifact.
     *
     * The async variant is {@see RegistryClient::replaceArtifactAsync()} .
     *
     * @example samples/V1/RegistryClient/replace_artifact.php
     *
     * @param ReplaceArtifactRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function replaceArtifact(ReplaceArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('ReplaceArtifact', $request, $callOptions)->wait();
    }

    /**
     * Sets the current revision to a specified prior
     * revision. Note that this creates a new revision with a new revision ID.
     *
     * The async variant is {@see RegistryClient::rollbackApiDeploymentAsync()} .
     *
     * @example samples/V1/RegistryClient/rollback_api_deployment.php
     *
     * @param RollbackApiDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackApiDeployment(RollbackApiDeploymentRequest $request, array $callOptions = []): ApiDeployment
    {
        return $this->startApiCall('RollbackApiDeployment', $request, $callOptions)->wait();
    }

    /**
     * Sets the current revision to a specified prior revision.
     * Note that this creates a new revision with a new revision ID.
     *
     * The async variant is {@see RegistryClient::rollbackApiSpecAsync()} .
     *
     * @example samples/V1/RegistryClient/rollback_api_spec.php
     *
     * @param RollbackApiSpecRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackApiSpec(RollbackApiSpecRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('RollbackApiSpec', $request, $callOptions)->wait();
    }

    /**
     * Adds a tag to a specified revision of a
     * deployment.
     *
     * The async variant is {@see RegistryClient::tagApiDeploymentRevisionAsync()} .
     *
     * @example samples/V1/RegistryClient/tag_api_deployment_revision.php
     *
     * @param TagApiDeploymentRevisionRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function tagApiDeploymentRevision(
        TagApiDeploymentRevisionRequest $request,
        array $callOptions = []
    ): ApiDeployment {
        return $this->startApiCall('TagApiDeploymentRevision', $request, $callOptions)->wait();
    }

    /**
     * Adds a tag to a specified revision of a spec.
     *
     * The async variant is {@see RegistryClient::tagApiSpecRevisionAsync()} .
     *
     * @example samples/V1/RegistryClient/tag_api_spec_revision.php
     *
     * @param TagApiSpecRevisionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function tagApiSpecRevision(TagApiSpecRevisionRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('TagApiSpecRevision', $request, $callOptions)->wait();
    }

    /**
     * Used to modify a specified API.
     *
     * The async variant is {@see RegistryClient::updateApiAsync()} .
     *
     * @example samples/V1/RegistryClient/update_api.php
     *
     * @param UpdateApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApi(UpdateApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('UpdateApi', $request, $callOptions)->wait();
    }

    /**
     * Used to modify a specified deployment.
     *
     * The async variant is {@see RegistryClient::updateApiDeploymentAsync()} .
     *
     * @example samples/V1/RegistryClient/update_api_deployment.php
     *
     * @param UpdateApiDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApiDeployment(UpdateApiDeploymentRequest $request, array $callOptions = []): ApiDeployment
    {
        return $this->startApiCall('UpdateApiDeployment', $request, $callOptions)->wait();
    }

    /**
     * Used to modify a specified spec.
     *
     * The async variant is {@see RegistryClient::updateApiSpecAsync()} .
     *
     * @example samples/V1/RegistryClient/update_api_spec.php
     *
     * @param UpdateApiSpecRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApiSpec(UpdateApiSpecRequest $request, array $callOptions = []): ApiSpec
    {
        return $this->startApiCall('UpdateApiSpec', $request, $callOptions)->wait();
    }

    /**
     * Used to modify a specified version.
     *
     * The async variant is {@see RegistryClient::updateApiVersionAsync()} .
     *
     * @example samples/V1/RegistryClient/update_api_version.php
     *
     * @param UpdateApiVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApiVersion(UpdateApiVersionRequest $request, array $callOptions = []): ApiVersion
    {
        return $this->startApiCall('UpdateApiVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see RegistryClient::getLocationAsync()} .
     *
     * @example samples/V1/RegistryClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see RegistryClient::listLocationsAsync()} .
     *
     * @example samples/V1/RegistryClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see RegistryClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/RegistryClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see RegistryClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/RegistryClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see RegistryClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/RegistryClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
