<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/training_pipeline.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Assigns input data to the training, validation, and test sets so that the
 * distribution of values found in the categorical column (as specified by the
 * `key` field) is mirrored within each split. The fraction values determine
 * the relative sizes of the splits.
 * For example, if the specified column has three values, with 50% of the rows
 * having value "A", 25% value "B", and 25% value "C", and the split fractions
 * are specified as 80/10/10, then the training set will constitute 80% of the
 * training data, with about 50% of the training set rows having the value "A"
 * for the specified column, about 25% having the value "B", and about 25%
 * having the value "C".
 * Only the top 500 occurring values are used; any values not in the top
 * 500 values are randomly assigned to a split. If less than three rows contain
 * a specific value, those rows are randomly assigned.
 * Supported only for tabular Datasets.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.StratifiedSplit</code>
 */
class StratifiedSplit extends \Google\Protobuf\Internal\Message
{
    /**
     * The fraction of the input data that is to be used to train the Model.
     *
     * Generated from protobuf field <code>double training_fraction = 1;</code>
     */
    protected $training_fraction = 0.0;
    /**
     * The fraction of the input data that is to be used to validate the Model.
     *
     * Generated from protobuf field <code>double validation_fraction = 2;</code>
     */
    protected $validation_fraction = 0.0;
    /**
     * The fraction of the input data that is to be used to evaluate the Model.
     *
     * Generated from protobuf field <code>double test_fraction = 3;</code>
     */
    protected $test_fraction = 0.0;
    /**
     * Required. The key is a name of one of the Dataset's data columns.
     * The key provided must be for a categorical column.
     *
     * Generated from protobuf field <code>string key = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $key = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $training_fraction
     *           The fraction of the input data that is to be used to train the Model.
     *     @type float $validation_fraction
     *           The fraction of the input data that is to be used to validate the Model.
     *     @type float $test_fraction
     *           The fraction of the input data that is to be used to evaluate the Model.
     *     @type string $key
     *           Required. The key is a name of one of the Dataset's data columns.
     *           The key provided must be for a categorical column.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\TrainingPipeline::initOnce();
        parent::__construct($data);
    }

    /**
     * The fraction of the input data that is to be used to train the Model.
     *
     * Generated from protobuf field <code>double training_fraction = 1;</code>
     * @return float
     */
    public function getTrainingFraction()
    {
        return $this->training_fraction;
    }

    /**
     * The fraction of the input data that is to be used to train the Model.
     *
     * Generated from protobuf field <code>double training_fraction = 1;</code>
     * @param float $var
     * @return $this
     */
    public function setTrainingFraction($var)
    {
        GPBUtil::checkDouble($var);
        $this->training_fraction = $var;

        return $this;
    }

    /**
     * The fraction of the input data that is to be used to validate the Model.
     *
     * Generated from protobuf field <code>double validation_fraction = 2;</code>
     * @return float
     */
    public function getValidationFraction()
    {
        return $this->validation_fraction;
    }

    /**
     * The fraction of the input data that is to be used to validate the Model.
     *
     * Generated from protobuf field <code>double validation_fraction = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setValidationFraction($var)
    {
        GPBUtil::checkDouble($var);
        $this->validation_fraction = $var;

        return $this;
    }

    /**
     * The fraction of the input data that is to be used to evaluate the Model.
     *
     * Generated from protobuf field <code>double test_fraction = 3;</code>
     * @return float
     */
    public function getTestFraction()
    {
        return $this->test_fraction;
    }

    /**
     * The fraction of the input data that is to be used to evaluate the Model.
     *
     * Generated from protobuf field <code>double test_fraction = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setTestFraction($var)
    {
        GPBUtil::checkDouble($var);
        $this->test_fraction = $var;

        return $this;
    }

    /**
     * Required. The key is a name of one of the Dataset's data columns.
     * The key provided must be for a categorical column.
     *
     * Generated from protobuf field <code>string key = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Required. The key is a name of one of the Dataset's data columns.
     * The key provided must be for a categorical column.
     *
     * Generated from protobuf field <code>string key = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->key = $var;

        return $this;
    }

}

