<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/goal_enums.proto

namespace Google\Ads\AdManager\V1\UnitTypeEnum;

use UnexpectedValueException;

/**
 * Indicates the type of unit used for defining a reservation. The
 * [LineItem.cost_type][] can differ from the UnitType - an
 * ad can have an impression goal, but be billed by its click. Usually
 * CostType and UnitType will refer to the same unit.
 *
 * Protobuf type <code>google.ads.admanager.v1.UnitTypeEnum.UnitType</code>
 */
class UnitType
{
    /**
     * Default value. This value is unused.
     *
     * Generated from protobuf enum <code>UNIT_TYPE_UNSPECIFIED = 0;</code>
     */
    const UNIT_TYPE_UNSPECIFIED = 0;
    /**
     * The number of impressions served by creatives associated with the line
     * item.
     *
     * Generated from protobuf enum <code>IMPRESSIONS = 1;</code>
     */
    const IMPRESSIONS = 1;
    /**
     * The number of clicks reported by creatives associated with the line item.
     * The line item [type][google.ads.admanager.v1.LineItem.line_item_type]
     * must be one of:
     * * [LineItemTypeEnum.LineItemType.STANDARD][google.ads.admanager.v1.LineItemTypeEnum.LineItemType.STANDARD]
     * * [LineItemTypeEnum.LineItemType.BULK][google.ads.admanager.v1.LineItemTypeEnum.LineItemType.BULK]
     * * [LineItemTypeEnum.LineItemType.PRICE_PRIORITY][google.ads.admanager.v1.LineItemTypeEnum.LineItemType.PRICE_PRIORITY]
     *
     * Generated from protobuf enum <code>CLICKS = 2;</code>
     */
    const CLICKS = 2;
    /**
     * The number of click-through Cost-Per-Action (CPA) conversions from
     * creatives associated with the line item. This is only supported as
     * secondary goal and the [LineItem.cost_type][] must be
     * [CostTypeEnum.CostType.CPA][].
     *
     * Generated from protobuf enum <code>CLICK_THROUGH_CPA_CONVERSIONS = 3;</code>
     */
    const CLICK_THROUGH_CPA_CONVERSIONS = 3;
    /**
     * The number of view-through Cost-Per-Action (CPA) conversions from
     * creatives associated with the line item. This is only supported as
     * secondary goal and the [LineItem.cost_type][] must be
     * [CostTypeEnum.CostType.CPA}.
     *
     * Generated from protobuf enum <code>VIEW_THROUGH_CPA_CONVERSIONS = 4;</code>
     */
    const VIEW_THROUGH_CPA_CONVERSIONS = 4;
    /**
     * The number of total Cost-Per-Action (CPA) conversions from creatives
     * associated with the line item. This is only supported as secondary goal
     * and the [LineItem.cost_type} must be [CostTypeEnum.CostType.CPA}.
     *
     * Generated from protobuf enum <code>TOTAL_CPA_CONVERSIONS = 5;</code>
     */
    const TOTAL_CPA_CONVERSIONS = 5;
    /**
     * The number of viewable impressions reported by creatives associated with
     * the line item. The
     * [LineItem.line_item_type][google.ads.admanager.v1.LineItem.line_item_type]
     * must be
     * [LineItemTypeEnum.LineItemType.STANDARD][google.ads.admanager.v1.LineItemTypeEnum.LineItemType.STANDARD].
     *
     * Generated from protobuf enum <code>VIEWABLE_IMPRESSIONS = 6;</code>
     */
    const VIEWABLE_IMPRESSIONS = 6;
    /**
     * The number of in-target impressions reported by third party measurements.
     * The
     * [LineItem.line_item_type][google.ads.admanager.v1.LineItem.line_item_type]
     * must be
     * [LineItemTypeEnum.LineItemType.STANDARD][google.ads.admanager.v1.LineItemTypeEnum.LineItemType.STANDARD].
     *
     * Generated from protobuf enum <code>IN_TARGET_IMPRESSIONS = 7;</code>
     */
    const IN_TARGET_IMPRESSIONS = 7;

    private static $valueToName = [
        self::UNIT_TYPE_UNSPECIFIED => 'UNIT_TYPE_UNSPECIFIED',
        self::IMPRESSIONS => 'IMPRESSIONS',
        self::CLICKS => 'CLICKS',
        self::CLICK_THROUGH_CPA_CONVERSIONS => 'CLICK_THROUGH_CPA_CONVERSIONS',
        self::VIEW_THROUGH_CPA_CONVERSIONS => 'VIEW_THROUGH_CPA_CONVERSIONS',
        self::TOTAL_CPA_CONVERSIONS => 'TOTAL_CPA_CONVERSIONS',
        self::VIEWABLE_IMPRESSIONS => 'VIEWABLE_IMPRESSIONS',
        self::IN_TARGET_IMPRESSIONS => 'IN_TARGET_IMPRESSIONS',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


