<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/site_messages.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Site represents a domain owned or represented by a network. For a parent
 * network managing other networks as part of Multiple Customer Management
 * "Manage Inventory" model, it could be the child's domain.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.Site</code>
 */
class Site extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the `Site`.
     * Format: `networks/{network_code}/sites/{site_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The URL of the Site.
     *
     * Generated from protobuf field <code>optional string url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $url = null;
    /**
     * Optional. The network code of the child if the Site is being managed for an
     * MCM child network, or null if owned by this network.
     *
     * Generated from protobuf field <code>optional string child_network_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $child_network_code = null;
    /**
     * Output only. Status of the review performed on the Site by Google.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.SiteApprovalStatusEnum.SiteApprovalStatus approval_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $approval_status = null;
    /**
     * Output only. The latest Site approval status change time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp approval_status_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $approval_status_update_time = null;
    /**
     * Output only. Provides reasons for disapproving the Site. It is null when
     * the Site is not disapproved.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.DisapprovalReason disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $disapproval_reasons;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the `Site`.
     *           Format: `networks/{network_code}/sites/{site_id}`
     *     @type string $url
     *           Required. The URL of the Site.
     *     @type string $child_network_code
     *           Optional. The network code of the child if the Site is being managed for an
     *           MCM child network, or null if owned by this network.
     *     @type int $approval_status
     *           Output only. Status of the review performed on the Site by Google.
     *     @type \Google\Protobuf\Timestamp $approval_status_update_time
     *           Output only. The latest Site approval status change time.
     *     @type array<\Google\Ads\AdManager\V1\DisapprovalReason>|\Google\Protobuf\Internal\RepeatedField $disapproval_reasons
     *           Output only. Provides reasons for disapproving the Site. It is null when
     *           the Site is not disapproved.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\SiteMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the `Site`.
     * Format: `networks/{network_code}/sites/{site_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the `Site`.
     * Format: `networks/{network_code}/sites/{site_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The URL of the Site.
     *
     * Generated from protobuf field <code>optional string url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUrl()
    {
        return isset($this->url) ? $this->url : '';
    }

    public function hasUrl()
    {
        return isset($this->url);
    }

    public function clearUrl()
    {
        unset($this->url);
    }

    /**
     * Required. The URL of the Site.
     *
     * Generated from protobuf field <code>optional string url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->url = $var;

        return $this;
    }

    /**
     * Optional. The network code of the child if the Site is being managed for an
     * MCM child network, or null if owned by this network.
     *
     * Generated from protobuf field <code>optional string child_network_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getChildNetworkCode()
    {
        return isset($this->child_network_code) ? $this->child_network_code : '';
    }

    public function hasChildNetworkCode()
    {
        return isset($this->child_network_code);
    }

    public function clearChildNetworkCode()
    {
        unset($this->child_network_code);
    }

    /**
     * Optional. The network code of the child if the Site is being managed for an
     * MCM child network, or null if owned by this network.
     *
     * Generated from protobuf field <code>optional string child_network_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setChildNetworkCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->child_network_code = $var;

        return $this;
    }

    /**
     * Output only. Status of the review performed on the Site by Google.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.SiteApprovalStatusEnum.SiteApprovalStatus approval_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getApprovalStatus()
    {
        return isset($this->approval_status) ? $this->approval_status : 0;
    }

    public function hasApprovalStatus()
    {
        return isset($this->approval_status);
    }

    public function clearApprovalStatus()
    {
        unset($this->approval_status);
    }

    /**
     * Output only. Status of the review performed on the Site by Google.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.SiteApprovalStatusEnum.SiteApprovalStatus approval_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setApprovalStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\SiteApprovalStatusEnum\SiteApprovalStatus::class);
        $this->approval_status = $var;

        return $this;
    }

    /**
     * Output only. The latest Site approval status change time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp approval_status_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getApprovalStatusUpdateTime()
    {
        return $this->approval_status_update_time;
    }

    public function hasApprovalStatusUpdateTime()
    {
        return isset($this->approval_status_update_time);
    }

    public function clearApprovalStatusUpdateTime()
    {
        unset($this->approval_status_update_time);
    }

    /**
     * Output only. The latest Site approval status change time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp approval_status_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setApprovalStatusUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->approval_status_update_time = $var;

        return $this;
    }

    /**
     * Output only. Provides reasons for disapproving the Site. It is null when
     * the Site is not disapproved.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.DisapprovalReason disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisapprovalReasons()
    {
        return $this->disapproval_reasons;
    }

    /**
     * Output only. Provides reasons for disapproving the Site. It is null when
     * the Site is not disapproved.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.DisapprovalReason disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\AdManager\V1\DisapprovalReason>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisapprovalReasons($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\DisapprovalReason::class);
        $this->disapproval_reasons = $arr;

        return $this;
    }

}

