<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/recommender/v1/recommender_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Recommender\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Recommender\V1\GetInsightRequest;
use Google\Cloud\Recommender\V1\GetInsightTypeConfigRequest;
use Google\Cloud\Recommender\V1\GetRecommendationRequest;
use Google\Cloud\Recommender\V1\GetRecommenderConfigRequest;
use Google\Cloud\Recommender\V1\Insight;
use Google\Cloud\Recommender\V1\InsightTypeConfig;
use Google\Cloud\Recommender\V1\ListInsightsRequest;
use Google\Cloud\Recommender\V1\ListRecommendationsRequest;
use Google\Cloud\Recommender\V1\MarkInsightAcceptedRequest;
use Google\Cloud\Recommender\V1\MarkRecommendationClaimedRequest;
use Google\Cloud\Recommender\V1\MarkRecommendationFailedRequest;
use Google\Cloud\Recommender\V1\MarkRecommendationSucceededRequest;
use Google\Cloud\Recommender\V1\Recommendation;
use Google\Cloud\Recommender\V1\RecommenderConfig;
use Google\Cloud\Recommender\V1\UpdateInsightTypeConfigRequest;
use Google\Cloud\Recommender\V1\UpdateRecommenderConfigRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Provides insights and recommendations for cloud customers for various
 * categories like performance optimization, cost savings, reliability, feature
 * discovery, etc. Insights and recommendations are generated automatically
 * based on analysis of user resources, configuration and monitoring metrics.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface getInsightAsync(GetInsightRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInsightTypeConfigAsync(GetInsightTypeConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRecommendationAsync(GetRecommendationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRecommenderConfigAsync(GetRecommenderConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInsightsAsync(ListInsightsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRecommendationsAsync(ListRecommendationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface markInsightAcceptedAsync(MarkInsightAcceptedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface markRecommendationClaimedAsync(MarkRecommendationClaimedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface markRecommendationFailedAsync(MarkRecommendationFailedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface markRecommendationSucceededAsync(MarkRecommendationSucceededRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateInsightTypeConfigAsync(UpdateInsightTypeConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateRecommenderConfigAsync(UpdateRecommenderConfigRequest $request, array $optionalArgs = [])
 */
abstract class RecommenderBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.recommender.v1.Recommender';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'recommender.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/recommender_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/recommender_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/recommender_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/recommender_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_insight_type resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted billing_account_location_insight_type resource.
     */
    public static function billingAccountLocationInsightTypeName(string $billingAccount, string $location, string $insightType): string
    {
        return self::getPathTemplate('billingAccountLocationInsightType')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_insight_type_insight resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $insightType
     * @param string $insight
     *
     * @return string The formatted billing_account_location_insight_type_insight resource.
     */
    public static function billingAccountLocationInsightTypeInsightName(string $billingAccount, string $location, string $insightType, string $insight): string
    {
        return self::getPathTemplate('billingAccountLocationInsightTypeInsight')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'insight_type' => $insightType,
            'insight' => $insight,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_recommender resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted billing_account_location_recommender resource.
     */
    public static function billingAccountLocationRecommenderName(string $billingAccount, string $location, string $recommender): string
    {
        return self::getPathTemplate('billingAccountLocationRecommender')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_recommender_recommendation resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $recommender
     * @param string $recommendation
     *
     * @return string The formatted billing_account_location_recommender_recommendation resource.
     */
    public static function billingAccountLocationRecommenderRecommendationName(string $billingAccount, string $location, string $recommender, string $recommendation): string
    {
        return self::getPathTemplate('billingAccountLocationRecommenderRecommendation')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'recommender' => $recommender,
            'recommendation' => $recommendation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_insight_type resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted folder_location_insight_type resource.
     */
    public static function folderLocationInsightTypeName(string $folder, string $location, string $insightType): string
    {
        return self::getPathTemplate('folderLocationInsightType')->render([
            'folder' => $folder,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_insight_type_insight resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $insightType
     * @param string $insight
     *
     * @return string The formatted folder_location_insight_type_insight resource.
     */
    public static function folderLocationInsightTypeInsightName(string $folder, string $location, string $insightType, string $insight): string
    {
        return self::getPathTemplate('folderLocationInsightTypeInsight')->render([
            'folder' => $folder,
            'location' => $location,
            'insight_type' => $insightType,
            'insight' => $insight,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_recommender resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted folder_location_recommender resource.
     */
    public static function folderLocationRecommenderName(string $folder, string $location, string $recommender): string
    {
        return self::getPathTemplate('folderLocationRecommender')->render([
            'folder' => $folder,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_recommender_recommendation resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $recommender
     * @param string $recommendation
     *
     * @return string The formatted folder_location_recommender_recommendation resource.
     */
    public static function folderLocationRecommenderRecommendationName(string $folder, string $location, string $recommender, string $recommendation): string
    {
        return self::getPathTemplate('folderLocationRecommenderRecommendation')->render([
            'folder' => $folder,
            'location' => $location,
            'recommender' => $recommender,
            'recommendation' => $recommendation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a insight
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     * @param string $insight
     *
     * @return string The formatted insight resource.
     */
    public static function insightName(string $project, string $location, string $insightType, string $insight): string
    {
        return self::getPathTemplate('insight')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
            'insight' => $insight,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a insight_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted insight_type resource.
     */
    public static function insightTypeName(string $project, string $location, string $insightType): string
    {
        return self::getPathTemplate('insightType')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * insight_type_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted insight_type_config resource.
     */
    public static function insightTypeConfigName(string $project, string $location, string $insightType): string
    {
        return self::getPathTemplate('insightTypeConfig')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_insight_type resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted organization_location_insight_type resource.
     */
    public static function organizationLocationInsightTypeName(string $organization, string $location, string $insightType): string
    {
        return self::getPathTemplate('organizationLocationInsightType')->render([
            'organization' => $organization,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_insight_type_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted organization_location_insight_type_config resource.
     */
    public static function organizationLocationInsightTypeConfigName(string $organization, string $location, string $insightType): string
    {
        return self::getPathTemplate('organizationLocationInsightTypeConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_insight_type_insight resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $insightType
     * @param string $insight
     *
     * @return string The formatted organization_location_insight_type_insight resource.
     */
    public static function organizationLocationInsightTypeInsightName(string $organization, string $location, string $insightType, string $insight): string
    {
        return self::getPathTemplate('organizationLocationInsightTypeInsight')->render([
            'organization' => $organization,
            'location' => $location,
            'insight_type' => $insightType,
            'insight' => $insight,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_recommender resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted organization_location_recommender resource.
     */
    public static function organizationLocationRecommenderName(string $organization, string $location, string $recommender): string
    {
        return self::getPathTemplate('organizationLocationRecommender')->render([
            'organization' => $organization,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_recommender_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted organization_location_recommender_config resource.
     */
    public static function organizationLocationRecommenderConfigName(string $organization, string $location, string $recommender): string
    {
        return self::getPathTemplate('organizationLocationRecommenderConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_recommender_recommendation resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $recommender
     * @param string $recommendation
     *
     * @return string The formatted organization_location_recommender_recommendation resource.
     */
    public static function organizationLocationRecommenderRecommendationName(string $organization, string $location, string $recommender, string $recommendation): string
    {
        return self::getPathTemplate('organizationLocationRecommenderRecommendation')->render([
            'organization' => $organization,
            'location' => $location,
            'recommender' => $recommender,
            'recommendation' => $recommendation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_insight_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted project_location_insight_type resource.
     */
    public static function projectLocationInsightTypeName(string $project, string $location, string $insightType): string
    {
        return self::getPathTemplate('projectLocationInsightType')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_insight_type_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     *
     * @return string The formatted project_location_insight_type_config resource.
     */
    public static function projectLocationInsightTypeConfigName(string $project, string $location, string $insightType): string
    {
        return self::getPathTemplate('projectLocationInsightTypeConfig')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_insight_type_insight resource.
     *
     * @param string $project
     * @param string $location
     * @param string $insightType
     * @param string $insight
     *
     * @return string The formatted project_location_insight_type_insight resource.
     */
    public static function projectLocationInsightTypeInsightName(string $project, string $location, string $insightType, string $insight): string
    {
        return self::getPathTemplate('projectLocationInsightTypeInsight')->render([
            'project' => $project,
            'location' => $location,
            'insight_type' => $insightType,
            'insight' => $insight,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_recommender resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted project_location_recommender resource.
     */
    public static function projectLocationRecommenderName(string $project, string $location, string $recommender): string
    {
        return self::getPathTemplate('projectLocationRecommender')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_recommender_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted project_location_recommender_config resource.
     */
    public static function projectLocationRecommenderConfigName(string $project, string $location, string $recommender): string
    {
        return self::getPathTemplate('projectLocationRecommenderConfig')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_recommender_recommendation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     * @param string $recommendation
     *
     * @return string The formatted project_location_recommender_recommendation resource.
     */
    public static function projectLocationRecommenderRecommendationName(string $project, string $location, string $recommender, string $recommendation): string
    {
        return self::getPathTemplate('projectLocationRecommenderRecommendation')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
            'recommendation' => $recommendation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * recommendation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     * @param string $recommendation
     *
     * @return string The formatted recommendation resource.
     */
    public static function recommendationName(string $project, string $location, string $recommender, string $recommendation): string
    {
        return self::getPathTemplate('recommendation')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
            'recommendation' => $recommendation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a recommender
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted recommender resource.
     */
    public static function recommenderName(string $project, string $location, string $recommender): string
    {
        return self::getPathTemplate('recommender')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * recommender_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recommender
     *
     * @return string The formatted recommender_config resource.
     */
    public static function recommenderConfigName(string $project, string $location, string $recommender): string
    {
        return self::getPathTemplate('recommenderConfig')->render([
            'project' => $project,
            'location' => $location,
            'recommender' => $recommender,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - billingAccountLocationInsightType: billingAccounts/{billing_account}/locations/{location}/insightTypes/{insight_type}
     * - billingAccountLocationInsightTypeInsight: billingAccounts/{billing_account}/locations/{location}/insightTypes/{insight_type}/insights/{insight}
     * - billingAccountLocationRecommender: billingAccounts/{billing_account}/locations/{location}/recommenders/{recommender}
     * - billingAccountLocationRecommenderRecommendation: billingAccounts/{billing_account}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}
     * - folderLocationInsightType: folders/{folder}/locations/{location}/insightTypes/{insight_type}
     * - folderLocationInsightTypeInsight: folders/{folder}/locations/{location}/insightTypes/{insight_type}/insights/{insight}
     * - folderLocationRecommender: folders/{folder}/locations/{location}/recommenders/{recommender}
     * - folderLocationRecommenderRecommendation: folders/{folder}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}
     * - insight: projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}
     * - insightType: projects/{project}/locations/{location}/insightTypes/{insight_type}
     * - insightTypeConfig: projects/{project}/locations/{location}/insightTypes/{insight_type}/config
     * - organizationLocationInsightType: organizations/{organization}/locations/{location}/insightTypes/{insight_type}
     * - organizationLocationInsightTypeConfig: organizations/{organization}/locations/{location}/insightTypes/{insight_type}/config
     * - organizationLocationInsightTypeInsight: organizations/{organization}/locations/{location}/insightTypes/{insight_type}/insights/{insight}
     * - organizationLocationRecommender: organizations/{organization}/locations/{location}/recommenders/{recommender}
     * - organizationLocationRecommenderConfig: organizations/{organization}/locations/{location}/recommenders/{recommender}/config
     * - organizationLocationRecommenderRecommendation: organizations/{organization}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}
     * - projectLocationInsightType: projects/{project}/locations/{location}/insightTypes/{insight_type}
     * - projectLocationInsightTypeConfig: projects/{project}/locations/{location}/insightTypes/{insight_type}/config
     * - projectLocationInsightTypeInsight: projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}
     * - projectLocationRecommender: projects/{project}/locations/{location}/recommenders/{recommender}
     * - projectLocationRecommenderConfig: projects/{project}/locations/{location}/recommenders/{recommender}/config
     * - projectLocationRecommenderRecommendation: projects/{project}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}
     * - recommendation: projects/{project}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}
     * - recommender: projects/{project}/locations/{location}/recommenders/{recommender}
     * - recommenderConfig: projects/{project}/locations/{location}/recommenders/{recommender}/config
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'recommender.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Gets the requested insight. Requires the recommender.*.get IAM permission
     * for the specified insight type.
     *
     * The async variant is {@see self::getInsightAsync()} .
     *
     * @param GetInsightRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Insight
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInsight(GetInsightRequest $request, array $callOptions = []): Insight
    {
        return $this->startApiCall('GetInsight', $request, $callOptions)->wait();
    }

    /**
     * Gets the requested InsightTypeConfig. There is only one instance of the
     * config for each InsightType.
     *
     * The async variant is {@see self::getInsightTypeConfigAsync()} .
     *
     * @param GetInsightTypeConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InsightTypeConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInsightTypeConfig(GetInsightTypeConfigRequest $request, array $callOptions = []): InsightTypeConfig
    {
        return $this->startApiCall('GetInsightTypeConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the requested recommendation. Requires the recommender.*.get
     * IAM permission for the specified recommender.
     *
     * The async variant is {@see self::getRecommendationAsync()} .
     *
     * @param GetRecommendationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Recommendation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRecommendation(GetRecommendationRequest $request, array $callOptions = []): Recommendation
    {
        return $this->startApiCall('GetRecommendation', $request, $callOptions)->wait();
    }

    /**
     * Gets the requested Recommender Config. There is only one instance of the
     * config for each Recommender.
     *
     * The async variant is {@see self::getRecommenderConfigAsync()} .
     *
     * @param GetRecommenderConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RecommenderConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRecommenderConfig(GetRecommenderConfigRequest $request, array $callOptions = []): RecommenderConfig
    {
        return $this->startApiCall('GetRecommenderConfig', $request, $callOptions)->wait();
    }

    /**
     * Lists insights for the specified Cloud Resource. Requires the
     * recommender.*.list IAM permission for the specified insight type.
     *
     * The async variant is {@see self::listInsightsAsync()} .
     *
     * @param ListInsightsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInsights(ListInsightsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInsights', $request, $callOptions);
    }

    /**
     * Lists recommendations for the specified Cloud Resource. Requires the
     * recommender.*.list IAM permission for the specified recommender.
     *
     * The async variant is {@see self::listRecommendationsAsync()} .
     *
     * @param ListRecommendationsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRecommendations(ListRecommendationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRecommendations', $request, $callOptions);
    }

    /**
     * Marks the Insight State as Accepted. Users can use this method to
     * indicate to the Recommender API that they have applied some action based
     * on the insight. This stops the insight content from being updated.
     *
     * MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
     * the recommender.*.update IAM permission for the specified insight.
     *
     * The async variant is {@see self::markInsightAcceptedAsync()} .
     *
     * @param MarkInsightAcceptedRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Insight
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function markInsightAccepted(MarkInsightAcceptedRequest $request, array $callOptions = []): Insight
    {
        return $this->startApiCall('MarkInsightAccepted', $request, $callOptions)->wait();
    }

    /**
     * Marks the Recommendation State as Claimed. Users can use this method to
     * indicate to the Recommender API that they are starting to apply the
     * recommendation themselves. This stops the recommendation content from being
     * updated. Associated insights are frozen and placed in the ACCEPTED state.
     *
     * MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
     * SUCCEEDED, FAILED, or ACTIVE state.
     *
     * Requires the recommender.*.update IAM permission for the specified
     * recommender.
     *
     * The async variant is {@see self::markRecommendationClaimedAsync()} .
     *
     * @param MarkRecommendationClaimedRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Recommendation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function markRecommendationClaimed(MarkRecommendationClaimedRequest $request, array $callOptions = []): Recommendation
    {
        return $this->startApiCall('MarkRecommendationClaimed', $request, $callOptions)->wait();
    }

    /**
     * Marks the Recommendation State as Failed. Users can use this method to
     * indicate to the Recommender API that they have applied the recommendation
     * themselves, and the operation failed. This stops the recommendation content
     * from being updated. Associated insights are frozen and placed in the
     * ACCEPTED state.
     *
     * MarkRecommendationFailed can be applied to recommendations in ACTIVE,
     * CLAIMED, SUCCEEDED, or FAILED state.
     *
     * Requires the recommender.*.update IAM permission for the specified
     * recommender.
     *
     * The async variant is {@see self::markRecommendationFailedAsync()} .
     *
     * @param MarkRecommendationFailedRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Recommendation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function markRecommendationFailed(MarkRecommendationFailedRequest $request, array $callOptions = []): Recommendation
    {
        return $this->startApiCall('MarkRecommendationFailed', $request, $callOptions)->wait();
    }

    /**
     * Marks the Recommendation State as Succeeded. Users can use this method to
     * indicate to the Recommender API that they have applied the recommendation
     * themselves, and the operation was successful. This stops the recommendation
     * content from being updated. Associated insights are frozen and placed in
     * the ACCEPTED state.
     *
     * MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
     * CLAIMED, SUCCEEDED, or FAILED state.
     *
     * Requires the recommender.*.update IAM permission for the specified
     * recommender.
     *
     * The async variant is {@see self::markRecommendationSucceededAsync()} .
     *
     * @param MarkRecommendationSucceededRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Recommendation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function markRecommendationSucceeded(MarkRecommendationSucceededRequest $request, array $callOptions = []): Recommendation
    {
        return $this->startApiCall('MarkRecommendationSucceeded', $request, $callOptions)->wait();
    }

    /**
     * Updates an InsightTypeConfig change. This will create a new revision of the
     * config.
     *
     * The async variant is {@see self::updateInsightTypeConfigAsync()} .
     *
     * @param UpdateInsightTypeConfigRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InsightTypeConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInsightTypeConfig(UpdateInsightTypeConfigRequest $request, array $callOptions = []): InsightTypeConfig
    {
        return $this->startApiCall('UpdateInsightTypeConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates a Recommender Config. This will create a new revision of the
     * config.
     *
     * The async variant is {@see self::updateRecommenderConfigAsync()} .
     *
     * @param UpdateRecommenderConfigRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RecommenderConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRecommenderConfig(UpdateRecommenderConfigRequest $request, array $callOptions = []): RecommenderConfig
    {
        return $this->startApiCall('UpdateRecommenderConfig', $request, $callOptions)->wait();
    }
}
