<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/v2/participant.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\BidiStream;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\AnalyzeContentRequest;
use Google\Cloud\Dialogflow\V2\AnalyzeContentResponse;
use Google\Cloud\Dialogflow\V2\CreateParticipantRequest;
use Google\Cloud\Dialogflow\V2\GetParticipantRequest;
use Google\Cloud\Dialogflow\V2\ListParticipantsRequest;
use Google\Cloud\Dialogflow\V2\Participant;
use Google\Cloud\Dialogflow\V2\SuggestArticlesRequest;
use Google\Cloud\Dialogflow\V2\SuggestArticlesResponse;
use Google\Cloud\Dialogflow\V2\SuggestFaqAnswersRequest;
use Google\Cloud\Dialogflow\V2\SuggestFaqAnswersResponse;
use Google\Cloud\Dialogflow\V2\SuggestSmartRepliesRequest;
use Google\Cloud\Dialogflow\V2\SuggestSmartRepliesResponse;
use Google\Cloud\Dialogflow\V2\UpdateParticipantRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for managing [Participants][google.cloud.dialogflow.v2.Participant].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface analyzeContentAsync(AnalyzeContentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createParticipantAsync(CreateParticipantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getParticipantAsync(GetParticipantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listParticipantsAsync(ListParticipantsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface suggestArticlesAsync(SuggestArticlesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface suggestFaqAnswersAsync(SuggestFaqAnswersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface suggestSmartRepliesAsync(SuggestSmartRepliesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateParticipantAsync(UpdateParticipantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
abstract class ParticipantsBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dialogflow.v2.Participants';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/participants_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/participants_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/participants_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/participants_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName(string $project, string $session, string $context): string
    {
        return self::getPathTemplate('context')->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     */
    public static function conversationName(string $project, string $conversation): string
    {
        return self::getPathTemplate('conversation')->render([
            'project' => $project,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a message
     * resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $message
     *
     * @return string The formatted message resource.
     */
    public static function messageName(string $project, string $conversation, string $message): string
    {
        return self::getPathTemplate('message')->render([
            'project' => $project,
            'conversation' => $conversation,
            'message' => $message,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a participant
     * resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted participant resource.
     */
    public static function participantName(string $project, string $conversation, string $participant): string
    {
        return self::getPathTemplate('participant')->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation resource.
     *
     * @param string $project
     * @param string $conversation
     *
     * @return string The formatted project_conversation resource.
     */
    public static function projectConversationName(string $project, string $conversation): string
    {
        return self::getPathTemplate('projectConversation')->render([
            'project' => $project,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_message resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $message
     *
     * @return string The formatted project_conversation_message resource.
     */
    public static function projectConversationMessageName(string $project, string $conversation, string $message): string
    {
        return self::getPathTemplate('projectConversationMessage')->render([
            'project' => $project,
            'conversation' => $conversation,
            'message' => $message,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_participant resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_conversation_participant resource.
     */
    public static function projectConversationParticipantName(string $project, string $conversation, string $participant): string
    {
        return self::getPathTemplate('projectConversationParticipant')->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_environment_user_session resource.
     */
    public static function projectEnvironmentUserSessionName(string $project, string $environment, string $user, string $session): string
    {
        return self::getPathTemplate('projectEnvironmentUserSession')->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_environment_user_session_context resource.
     */
    public static function projectEnvironmentUserSessionContextName(string $project, string $environment, string $user, string $session, string $context): string
    {
        return self::getPathTemplate('projectEnvironmentUserSessionContext')->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session_entity_type resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_environment_user_session_entity_type resource.
     */
    public static function projectEnvironmentUserSessionEntityTypeName(string $project, string $environment, string $user, string $session, string $entityType): string
    {
        return self::getPathTemplate('projectEnvironmentUserSessionEntityType')->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     *
     * @return string The formatted project_location_conversation resource.
     */
    public static function projectLocationConversationName(string $project, string $location, string $conversation): string
    {
        return self::getPathTemplate('projectLocationConversation')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_message resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $message
     *
     * @return string The formatted project_location_conversation_message resource.
     */
    public static function projectLocationConversationMessageName(string $project, string $location, string $conversation, string $message): string
    {
        return self::getPathTemplate('projectLocationConversationMessage')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
            'message' => $message,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_participant resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_location_conversation_participant resource.
     */
    public static function projectLocationConversationParticipantName(string $project, string $location, string $conversation, string $participant): string
    {
        return self::getPathTemplate('projectLocationConversationParticipant')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_location_environment_user_session resource.
     */
    public static function projectLocationEnvironmentUserSessionName(string $project, string $location, string $environment, string $user, string $session): string
    {
        return self::getPathTemplate('projectLocationEnvironmentUserSession')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_environment_user_session_context resource.
     */
    public static function projectLocationEnvironmentUserSessionContextName(string $project, string $location, string $environment, string $user, string $session, string $context): string
    {
        return self::getPathTemplate('projectLocationEnvironmentUserSessionContext')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_environment_user_session_entity_type resource.
     */
    public static function projectLocationEnvironmentUserSessionEntityTypeName(string $project, string $location, string $environment, string $user, string $session, string $entityType): string
    {
        return self::getPathTemplate('projectLocationEnvironmentUserSessionEntityType')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     *
     * @return string The formatted project_location_session resource.
     */
    public static function projectLocationSessionName(string $project, string $location, string $session): string
    {
        return self::getPathTemplate('projectLocationSession')->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_session_context resource.
     */
    public static function projectLocationSessionContextName(string $project, string $location, string $session, string $context): string
    {
        return self::getPathTemplate('projectLocationSessionContext')->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_session_entity_type resource.
     */
    public static function projectLocationSessionEntityTypeName(string $project, string $location, string $session, string $entityType): string
    {
        return self::getPathTemplate('projectLocationSessionEntityType')->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted project_session resource.
     */
    public static function projectSessionName(string $project, string $session): string
    {
        return self::getPathTemplate('projectSession')->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session_context resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_session_context resource.
     */
    public static function projectSessionContextName(string $project, string $session, string $context): string
    {
        return self::getPathTemplate('projectSessionContext')->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session_entity_type resource.
     *
     * @param string $project
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_session_entity_type resource.
     */
    public static function projectSessionEntityTypeName(string $project, string $session, string $entityType): string
    {
        return self::getPathTemplate('projectSessionEntityType')->render([
            'project' => $project,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName(string $project, string $session): string
    {
        return self::getPathTemplate('session')->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * session_entity_type resource.
     *
     * @param string $project
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted session_entity_type resource.
     */
    public static function sessionEntityTypeName(string $project, string $session, string $entityType): string
    {
        return self::getPathTemplate('sessionEntityType')->render([
            'project' => $project,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - context: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - conversation: projects/{project}/conversations/{conversation}
     * - message: projects/{project}/conversations/{conversation}/messages/{message}
     * - participant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - projectConversation: projects/{project}/conversations/{conversation}
     * - projectConversationMessage: projects/{project}/conversations/{conversation}/messages/{message}
     * - projectConversationParticipant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - projectEnvironmentUserSession: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectEnvironmentUserSessionContext: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectEnvironmentUserSessionEntityType: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationConversation: projects/{project}/locations/{location}/conversations/{conversation}
     * - projectLocationConversationMessage: projects/{project}/locations/{location}/conversations/{conversation}/messages/{message}
     * - projectLocationConversationParticipant: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * - projectLocationEnvironmentUserSession: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectLocationEnvironmentUserSessionContext: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectLocationEnvironmentUserSessionEntityType: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationSession: projects/{project}/locations/{location}/agent/sessions/{session}
     * - projectLocationSessionContext: projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}
     * - projectLocationSessionEntityType: projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}
     * - projectSession: projects/{project}/agent/sessions/{session}
     * - projectSessionContext: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - projectSessionEntityType: projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}
     * - session: projects/{project}/agent/sessions/{session}
     * - sessionEntityType: projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds a text (chat, for example), or audio (phone recording, for example)
     * message from a participant into the conversation.
     *
     * Note: Always use agent versions for production traffic
     * sent to virtual agents. See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     *
     * The async variant is {@see self::analyzeContentAsync()} .
     *
     * @param AnalyzeContentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnalyzeContentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeContent(AnalyzeContentRequest $request, array $callOptions = []): AnalyzeContentResponse
    {
        return $this->startApiCall('AnalyzeContent', $request, $callOptions)->wait();
    }

    /**
     * Creates a new participant in a conversation.
     *
     * The async variant is {@see self::createParticipantAsync()} .
     *
     * @param CreateParticipantRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Participant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createParticipant(CreateParticipantRequest $request, array $callOptions = []): Participant
    {
        return $this->startApiCall('CreateParticipant', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a conversation participant.
     *
     * The async variant is {@see self::getParticipantAsync()} .
     *
     * @param GetParticipantRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Participant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getParticipant(GetParticipantRequest $request, array $callOptions = []): Participant
    {
        return $this->startApiCall('GetParticipant', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of all participants in the specified conversation.
     *
     * The async variant is {@see self::listParticipantsAsync()} .
     *
     * @param ListParticipantsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listParticipants(ListParticipantsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListParticipants', $request, $callOptions);
    }

    /**
     * Adds a text (chat, for example), or audio (phone recording, for example)
     * message from a participant into the conversation.
     * Note: This method is only available through the gRPC API (not REST).
     *
     * The top-level message sent to the client by the server is
     * `StreamingAnalyzeContentResponse`. Multiple response messages can be
     * returned in order. The first one or more messages contain the
     * `recognition_result` field. Each result represents a more complete
     * transcript of what the user said. The next message contains the
     * `reply_text` field and potentially the `reply_audio` field. The message can
     * also contain the `automated_agent_reply` field.
     *
     * Note: Always use agent versions for production traffic
     * sent to virtual agents. See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     *
     * @param array $callOptions {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return BidiStream
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function streamingAnalyzeContent(array $callOptions = []): BidiStream
    {
        return $this->startApiCall('StreamingAnalyzeContent', null, $callOptions);
    }

    /**
     * Gets suggested articles for a participant based on specific historical
     * messages.
     *
     * The async variant is {@see self::suggestArticlesAsync()} .
     *
     * @param SuggestArticlesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SuggestArticlesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suggestArticles(SuggestArticlesRequest $request, array $callOptions = []): SuggestArticlesResponse
    {
        return $this->startApiCall('SuggestArticles', $request, $callOptions)->wait();
    }

    /**
     * Gets suggested faq answers for a participant based on specific historical
     * messages.
     *
     * The async variant is {@see self::suggestFaqAnswersAsync()} .
     *
     * @param SuggestFaqAnswersRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SuggestFaqAnswersResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suggestFaqAnswers(SuggestFaqAnswersRequest $request, array $callOptions = []): SuggestFaqAnswersResponse
    {
        return $this->startApiCall('SuggestFaqAnswers', $request, $callOptions)->wait();
    }

    /**
     * Gets smart replies for a participant based on specific historical
     * messages.
     *
     * The async variant is {@see self::suggestSmartRepliesAsync()} .
     *
     * @param SuggestSmartRepliesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SuggestSmartRepliesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suggestSmartReplies(SuggestSmartRepliesRequest $request, array $callOptions = []): SuggestSmartRepliesResponse
    {
        return $this->startApiCall('SuggestSmartReplies', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified participant.
     *
     * The async variant is {@see self::updateParticipantAsync()} .
     *
     * @param UpdateParticipantRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Participant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateParticipant(UpdateParticipantRequest $request, array $callOptions = []): Participant
    {
        return $this->startApiCall('UpdateParticipant', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
