<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datastream/v1/datastream.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Datastream\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Datastream\V1\ConnectionProfile;
use Google\Cloud\Datastream\V1\CreateConnectionProfileRequest;
use Google\Cloud\Datastream\V1\CreatePrivateConnectionRequest;
use Google\Cloud\Datastream\V1\CreateRouteRequest;
use Google\Cloud\Datastream\V1\CreateStreamRequest;
use Google\Cloud\Datastream\V1\DeleteConnectionProfileRequest;
use Google\Cloud\Datastream\V1\DeletePrivateConnectionRequest;
use Google\Cloud\Datastream\V1\DeleteRouteRequest;
use Google\Cloud\Datastream\V1\DeleteStreamRequest;
use Google\Cloud\Datastream\V1\DiscoverConnectionProfileRequest;
use Google\Cloud\Datastream\V1\DiscoverConnectionProfileResponse;
use Google\Cloud\Datastream\V1\FetchStaticIpsRequest;
use Google\Cloud\Datastream\V1\FetchStaticIpsResponse;
use Google\Cloud\Datastream\V1\GetConnectionProfileRequest;
use Google\Cloud\Datastream\V1\GetPrivateConnectionRequest;
use Google\Cloud\Datastream\V1\GetRouteRequest;
use Google\Cloud\Datastream\V1\GetStreamObjectRequest;
use Google\Cloud\Datastream\V1\GetStreamRequest;
use Google\Cloud\Datastream\V1\ListConnectionProfilesRequest;
use Google\Cloud\Datastream\V1\ListConnectionProfilesResponse;
use Google\Cloud\Datastream\V1\ListPrivateConnectionsRequest;
use Google\Cloud\Datastream\V1\ListPrivateConnectionsResponse;
use Google\Cloud\Datastream\V1\ListRoutesRequest;
use Google\Cloud\Datastream\V1\ListRoutesResponse;
use Google\Cloud\Datastream\V1\ListStreamObjectsRequest;
use Google\Cloud\Datastream\V1\ListStreamObjectsResponse;
use Google\Cloud\Datastream\V1\ListStreamsRequest;
use Google\Cloud\Datastream\V1\ListStreamsResponse;
use Google\Cloud\Datastream\V1\LookupStreamObjectRequest;
use Google\Cloud\Datastream\V1\MysqlRdbms;
use Google\Cloud\Datastream\V1\OracleRdbms;
use Google\Cloud\Datastream\V1\PostgresqlRdbms;
use Google\Cloud\Datastream\V1\PrivateConnection;
use Google\Cloud\Datastream\V1\Route;
use Google\Cloud\Datastream\V1\SourceObjectIdentifier;
use Google\Cloud\Datastream\V1\StartBackfillJobRequest;
use Google\Cloud\Datastream\V1\StartBackfillJobResponse;
use Google\Cloud\Datastream\V1\StopBackfillJobRequest;
use Google\Cloud\Datastream\V1\StopBackfillJobResponse;
use Google\Cloud\Datastream\V1\Stream;
use Google\Cloud\Datastream\V1\StreamObject;
use Google\Cloud\Datastream\V1\UpdateConnectionProfileRequest;
use Google\Cloud\Datastream\V1\UpdateStreamRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Datastream service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $datastreamClient = new DatastreamClient();
 * try {
 *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
 *     $connectionProfileId = 'connection_profile_id';
 *     $connectionProfile = new ConnectionProfile();
 *     $operationResponse = $datastreamClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $datastreamClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'createConnectionProfile');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $datastreamClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class DatastreamGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.datastream.v1.Datastream';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'datastream.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $connectionProfileNameTemplate;

    private static $locationNameTemplate;

    private static $networksNameTemplate;

    private static $privateConnectionNameTemplate;

    private static $routeNameTemplate;

    private static $streamNameTemplate;

    private static $streamObjectNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/datastream_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/datastream_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/datastream_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/datastream_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getConnectionProfileNameTemplate()
    {
        if (self::$connectionProfileNameTemplate == null) {
            self::$connectionProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/connectionProfiles/{connection_profile}'
            );
        }

        return self::$connectionProfileNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworksNameTemplate()
    {
        if (self::$networksNameTemplate == null) {
            self::$networksNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networksNameTemplate;
    }

    private static function getPrivateConnectionNameTemplate()
    {
        if (self::$privateConnectionNameTemplate == null) {
            self::$privateConnectionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateConnections/{private_connection}'
            );
        }

        return self::$privateConnectionNameTemplate;
    }

    private static function getRouteNameTemplate()
    {
        if (self::$routeNameTemplate == null) {
            self::$routeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateConnections/{private_connection}/routes/{route}'
            );
        }

        return self::$routeNameTemplate;
    }

    private static function getStreamNameTemplate()
    {
        if (self::$streamNameTemplate == null) {
            self::$streamNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/streams/{stream}'
            );
        }

        return self::$streamNameTemplate;
    }

    private static function getStreamObjectNameTemplate()
    {
        if (self::$streamObjectNameTemplate == null) {
            self::$streamObjectNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/streams/{stream}/objects/{object}'
            );
        }

        return self::$streamObjectNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'connectionProfile' => self::getConnectionProfileNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'networks' => self::getNetworksNameTemplate(),
                'privateConnection' => self::getPrivateConnectionNameTemplate(),
                'route' => self::getRouteNameTemplate(),
                'stream' => self::getStreamNameTemplate(),
                'streamObject' => self::getStreamObjectNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * connection_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectionProfile
     *
     * @return string The formatted connection_profile resource.
     */
    public static function connectionProfileName(
        $project,
        $location,
        $connectionProfile
    ) {
        return self::getConnectionProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'connection_profile' => $connectionProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a networks
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted networks resource.
     */
    public static function networksName($project, $network)
    {
        return self::getNetworksNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName(
        $project,
        $location,
        $privateConnection
    ) {
        return self::getPrivateConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     * @param string $route
     *
     * @return string The formatted route resource.
     */
    public static function routeName(
        $project,
        $location,
        $privateConnection,
        $route
    ) {
        return self::getRouteNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
            'route' => $route,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a stream
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $stream
     *
     * @return string The formatted stream resource.
     */
    public static function streamName($project, $location, $stream)
    {
        return self::getStreamNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'stream' => $stream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * stream_object resource.
     *
     * @param string $project
     * @param string $location
     * @param string $stream
     * @param string $object
     *
     * @return string The formatted stream_object resource.
     */
    public static function streamObjectName(
        $project,
        $location,
        $stream,
        $object
    ) {
        return self::getStreamObjectNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'stream' => $stream,
            'object' => $object,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connectionProfile: projects/{project}/locations/{location}/connectionProfiles/{connection_profile}
     * - location: projects/{project}/locations/{location}
     * - networks: projects/{project}/global/networks/{network}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     * - route: projects/{project}/locations/{location}/privateConnections/{private_connection}/routes/{route}
     * - stream: projects/{project}/locations/{location}/streams/{stream}
     * - streamObject: projects/{project}/locations/{location}/streams/{stream}/objects/{object}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datastream.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Use this method to create a connection profile in a project and location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     $connectionProfileId = 'connection_profile_id';
     *     $connectionProfile = new ConnectionProfile();
     *     $operationResponse = $datastreamClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'createConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The parent that owns the collection of ConnectionProfiles.
     * @param string            $connectionProfileId Required. The connection profile identifier.
     * @param ConnectionProfile $connectionProfile   Required. The connection profile resource to create.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. Only validate the connection profile, but don't create any
     *           resources. The default is false.
     *     @type bool $force
     *           Optional. Create the connection profile without validating it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createConnectionProfile(
        $parent,
        $connectionProfileId,
        $connectionProfile,
        array $optionalArgs = []
    ) {
        $request = new CreateConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConnectionProfileId($connectionProfileId);
        $request->setConnectionProfile($connectionProfile);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateConnectionProfile',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to create a private connectivity configuration.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     $privateConnectionId = 'private_connection_id';
     *     $privateConnection = new PrivateConnection();
     *     $operationResponse = $datastreamClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'createPrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The parent that owns the collection of PrivateConnections.
     * @param string            $privateConnectionId Required. The private connectivity identifier.
     * @param PrivateConnection $privateConnection   Required. The Private Connectivity resource to create.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $force
     *           Optional. If set to true, will skip validations.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createPrivateConnection(
        $parent,
        $privateConnectionId,
        $privateConnection,
        array $optionalArgs = []
    ) {
        $request = new CreatePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPrivateConnectionId($privateConnectionId);
        $request->setPrivateConnection($privateConnection);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreatePrivateConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to create a route for a private connectivity configuration
     * in a project and location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $routeId = 'route_id';
     *     $route = new Route();
     *     $operationResponse = $datastreamClient->createRoute($formattedParent, $routeId, $route);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->createRoute($formattedParent, $routeId, $route);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'createRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of Routes.
     * @param string $routeId      Required. The Route identifier.
     * @param Route  $route        Required. The Route resource to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createRoute(
        $parent,
        $routeId,
        $route,
        array $optionalArgs = []
    ) {
        $request = new CreateRouteRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRouteId($routeId);
        $request->setRoute($route);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateRoute',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to create a stream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     $streamId = 'stream_id';
     *     $stream = new Stream();
     *     $operationResponse = $datastreamClient->createStream($formattedParent, $streamId, $stream);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->createStream($formattedParent, $streamId, $stream);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'createStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of streams.
     * @param string $streamId     Required. The stream identifier.
     * @param Stream $stream       Required. The stream resource to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. Only validate the stream, but don't create any resources.
     *           The default is false.
     *     @type bool $force
     *           Optional. Create the stream without validating it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createStream(
        $parent,
        $streamId,
        $stream,
        array $optionalArgs = []
    ) {
        $request = new CreateStreamRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setStreamId($streamId);
        $request->setStream($stream);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateStream',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to delete a connection profile.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->connectionProfileName('[PROJECT]', '[LOCATION]', '[CONNECTION_PROFILE]');
     *     $operationResponse = $datastreamClient->deleteConnectionProfile($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->deleteConnectionProfile($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'deleteConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the connection profile resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConnectionProfile($name, array $optionalArgs = [])
    {
        $request = new DeleteConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteConnectionProfile',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to delete a private connectivity configuration.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $operationResponse = $datastreamClient->deletePrivateConnection($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->deletePrivateConnection($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'deletePrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the private connectivity configuration to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $force
     *           Optional. If set to true, any child routes that belong to this
     *           PrivateConnection will also be deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePrivateConnection($name, array $optionalArgs = [])
    {
        $request = new DeletePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeletePrivateConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to delete a route.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->routeName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]', '[ROUTE]');
     *     $operationResponse = $datastreamClient->deleteRoute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->deleteRoute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'deleteRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Route resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteRoute($name, array $optionalArgs = [])
    {
        $request = new DeleteRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteRoute',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to delete a stream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->streamName('[PROJECT]', '[LOCATION]', '[STREAM]');
     *     $operationResponse = $datastreamClient->deleteStream($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->deleteStream($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'deleteStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the stream resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteStream($name, array $optionalArgs = [])
    {
        $request = new DeleteStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteStream',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to discover a connection profile.
     * The discover API call exposes the data objects and metadata belonging to
     * the profile. Typically, a request returns children data objects of a
     * parent data object that's optionally supplied in the request.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $datastreamClient->discoverConnectionProfile($formattedParent);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the connection profile type. Must be in
     *                             the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type ConnectionProfile $connectionProfile
     *           An ad-hoc connection profile configuration.
     *     @type string $connectionProfileName
     *           A reference to an existing connection profile.
     *     @type bool $fullHierarchy
     *           Whether to retrieve the full hierarchy of data objects (TRUE) or only the
     *           current level (FALSE).
     *     @type int $hierarchyDepth
     *           The number of hierarchy levels below the current level to be retrieved.
     *     @type OracleRdbms $oracleRdbms
     *           Oracle RDBMS to enrich with child data objects and metadata.
     *     @type MysqlRdbms $mysqlRdbms
     *           MySQL RDBMS to enrich with child data objects and metadata.
     *     @type PostgresqlRdbms $postgresqlRdbms
     *           PostgreSQL RDBMS to enrich with child data objects and metadata.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\DiscoverConnectionProfileResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function discoverConnectionProfile($parent, array $optionalArgs = [])
    {
        $request = new DiscoverConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['connectionProfile'])) {
            $request->setConnectionProfile($optionalArgs['connectionProfile']);
        }

        if (isset($optionalArgs['connectionProfileName'])) {
            $request->setConnectionProfileName(
                $optionalArgs['connectionProfileName']
            );
        }

        if (isset($optionalArgs['fullHierarchy'])) {
            $request->setFullHierarchy($optionalArgs['fullHierarchy']);
        }

        if (isset($optionalArgs['hierarchyDepth'])) {
            $request->setHierarchyDepth($optionalArgs['hierarchyDepth']);
        }

        if (isset($optionalArgs['oracleRdbms'])) {
            $request->setOracleRdbms($optionalArgs['oracleRdbms']);
        }

        if (isset($optionalArgs['mysqlRdbms'])) {
            $request->setMysqlRdbms($optionalArgs['mysqlRdbms']);
        }

        if (isset($optionalArgs['postgresqlRdbms'])) {
            $request->setPostgresqlRdbms($optionalArgs['postgresqlRdbms']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DiscoverConnectionProfile',
            DiscoverConnectionProfileResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * The FetchStaticIps API call exposes the static IP addresses used by
     * Datastream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->fetchStaticIps($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->fetchStaticIps($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name for the location for which static IPs should be
     *                             returned. Must be in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fetchStaticIps($name, array $optionalArgs = [])
    {
        $request = new FetchStaticIpsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'FetchStaticIps',
            $optionalArgs,
            FetchStaticIpsResponse::class,
            $request
        );
    }

    /**
     * Use this method to get details about a connection profile.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->connectionProfileName('[PROJECT]', '[LOCATION]', '[CONNECTION_PROFILE]');
     *     $response = $datastreamClient->getConnectionProfile($formattedName);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the connection profile resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\ConnectionProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getConnectionProfile($name, array $optionalArgs = [])
    {
        $request = new GetConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetConnectionProfile',
            ConnectionProfile::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to get details about a private connectivity configuration.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $response = $datastreamClient->getPrivateConnection($formattedName);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the  private connectivity configuration to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\PrivateConnection
     *
     * @throws ApiException if the remote call fails
     */
    public function getPrivateConnection($name, array $optionalArgs = [])
    {
        $request = new GetPrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPrivateConnection',
            PrivateConnection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to get details about a route.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->routeName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]', '[ROUTE]');
     *     $response = $datastreamClient->getRoute($formattedName);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Route resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\Route
     *
     * @throws ApiException if the remote call fails
     */
    public function getRoute($name, array $optionalArgs = [])
    {
        $request = new GetRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRoute',
            Route::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to get details about a stream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->streamName('[PROJECT]', '[LOCATION]', '[STREAM]');
     *     $response = $datastreamClient->getStream($formattedName);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the stream resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\Stream
     *
     * @throws ApiException if the remote call fails
     */
    public function getStream($name, array $optionalArgs = [])
    {
        $request = new GetStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetStream',
            Stream::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to get details about a stream object.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedName = $datastreamClient->streamObjectName('[PROJECT]', '[LOCATION]', '[STREAM]', '[OBJECT]');
     *     $response = $datastreamClient->getStreamObject($formattedName);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the stream object resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\StreamObject
     *
     * @throws ApiException if the remote call fails
     */
    public function getStreamObject($name, array $optionalArgs = [])
    {
        $request = new GetStreamObjectRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetStreamObject',
            StreamObject::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to list connection profiles created in a project and
     * location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listConnectionProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listConnectionProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of connection profiles.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter request.
     *     @type string $orderBy
     *           Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConnectionProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListConnectionProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListConnectionProfiles',
            $optionalArgs,
            ListConnectionProfilesResponse::class,
            $request
        );
    }

    /**
     * Use this method to list private connectivity configurations in a project
     * and location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of private connectivity
     *                             configurations.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter request.
     *     @type string $orderBy
     *           Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrivateConnections($parent, array $optionalArgs = [])
    {
        $request = new ListPrivateConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPrivateConnections',
            $optionalArgs,
            ListPrivateConnectionsResponse::class,
            $request
        );
    }

    /**
     * Use this method to list routes created for a private connectivity
     * configuration in a project and location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of Routess.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter request.
     *     @type string $orderBy
     *           Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRoutes',
            $optionalArgs,
            ListRoutesResponse::class,
            $request
        );
    }

    /**
     * Use this method to list the objects of a specific stream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->streamName('[PROJECT]', '[LOCATION]', '[STREAM]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listStreamObjects($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listStreamObjects($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent stream that owns the collection of objects.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listStreamObjects($parent, array $optionalArgs = [])
    {
        $request = new ListStreamObjectsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListStreamObjects',
            $optionalArgs,
            ListStreamObjectsResponse::class,
            $request
        );
    }

    /**
     * Use this method to list streams in a project and location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listStreams($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listStreams($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of streams.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter request.
     *     @type string $orderBy
     *           Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listStreams($parent, array $optionalArgs = [])
    {
        $request = new ListStreamsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListStreams',
            $optionalArgs,
            ListStreamsResponse::class,
            $request
        );
    }

    /**
     * Use this method to look up a stream object by its source object identifier.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedParent = $datastreamClient->streamName('[PROJECT]', '[LOCATION]', '[STREAM]');
     *     $sourceObjectIdentifier = new SourceObjectIdentifier();
     *     $response = $datastreamClient->lookupStreamObject($formattedParent, $sourceObjectIdentifier);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string                 $parent                 Required. The parent stream that owns the collection of objects.
     * @param SourceObjectIdentifier $sourceObjectIdentifier Required. The source object identifier which maps to the stream object.
     * @param array                  $optionalArgs           {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\StreamObject
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupStreamObject(
        $parent,
        $sourceObjectIdentifier,
        array $optionalArgs = []
    ) {
        $request = new LookupStreamObjectRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSourceObjectIdentifier($sourceObjectIdentifier);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'LookupStreamObject',
            StreamObject::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to start a backfill job for the specified stream object.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedObject = $datastreamClient->streamObjectName('[PROJECT]', '[LOCATION]', '[STREAM]', '[OBJECT]');
     *     $response = $datastreamClient->startBackfillJob($formattedObject);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $object       Required. The name of the stream object resource to start a backfill job
     *                             for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\StartBackfillJobResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startBackfillJob($object, array $optionalArgs = [])
    {
        $request = new StartBackfillJobRequest();
        $requestParamHeaders = [];
        $request->setObject($object);
        $requestParamHeaders['object'] = $object;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'StartBackfillJob',
            StartBackfillJobResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to stop a backfill job for the specified stream object.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $formattedObject = $datastreamClient->streamObjectName('[PROJECT]', '[LOCATION]', '[STREAM]', '[OBJECT]');
     *     $response = $datastreamClient->stopBackfillJob($formattedObject);
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param string $object       Required. The name of the stream object resource to stop the backfill job
     *                             for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Datastream\V1\StopBackfillJobResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function stopBackfillJob($object, array $optionalArgs = [])
    {
        $request = new StopBackfillJobRequest();
        $requestParamHeaders = [];
        $request->setObject($object);
        $requestParamHeaders['object'] = $object;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'StopBackfillJob',
            StopBackfillJobResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Use this method to update the parameters of a connection profile.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $connectionProfile = new ConnectionProfile();
     *     $operationResponse = $datastreamClient->updateConnectionProfile($connectionProfile);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->updateConnectionProfile($connectionProfile);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'updateConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param ConnectionProfile $connectionProfile Required. The connection profile to update.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           ConnectionProfile resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. Only validate the connection profile, but don't update any
     *           resources. The default is false.
     *     @type bool $force
     *           Optional. Update the connection profile without validating it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateConnectionProfile(
        $connectionProfile,
        array $optionalArgs = []
    ) {
        $request = new UpdateConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setConnectionProfile($connectionProfile);
        $requestParamHeaders[
            'connection_profile.name'
        ] = $connectionProfile->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateConnectionProfile',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Use this method to update the configuration of a stream.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $stream = new Stream();
     *     $operationResponse = $datastreamClient->updateStream($stream);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $datastreamClient->updateStream($stream);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $datastreamClient->resumeOperation($operationName, 'updateStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param Stream $stream       Required. The stream resource to update.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           stream resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. Only validate the stream with the changes, without actually
     *           updating it. The default is false.
     *     @type bool $force
     *           Optional. Update the stream without validating it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateStream($stream, array $optionalArgs = [])
    {
        $request = new UpdateStreamRequest();
        $requestParamHeaders = [];
        $request->setStream($stream);
        $requestParamHeaders['stream.name'] = $stream->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateStream',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     $response = $datastreamClient->getLocation();
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $datastreamClient = new DatastreamClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $datastreamClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $datastreamClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $datastreamClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
