<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/compute/v1/compute.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Compute\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Compute\V1\AbandonInstancesInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\AggregatedListInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ApplyUpdatesToInstancesInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\CreateInstancesInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeleteInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeleteInstancesInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeletePerInstanceConfigsInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\GetInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\InsertInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\InstanceGroupManager;
use Google\Cloud\Compute\V1\ListErrorsInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListManagedInstancesInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListPerInstanceConfigsInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\PatchInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\PatchPerInstanceConfigsInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\RecreateInstancesInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\ResizeInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\SetInstanceTemplateInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\SetTargetPoolsInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\UpdatePerInstanceConfigsInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\ZoneOperationsClient;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The InstanceGroupManagers API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface abandonInstancesAsync(AbandonInstancesInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface aggregatedListAsync(AggregatedListInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface applyUpdatesToInstancesAsync(ApplyUpdatesToInstancesInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstancesAsync(CreateInstancesInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAsync(DeleteInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstancesAsync(DeleteInstancesInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePerInstanceConfigsAsync(DeletePerInstanceConfigsInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAsync(GetInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface insertAsync(InsertInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAsync(ListInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listErrorsAsync(ListErrorsInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listManagedInstancesAsync(ListManagedInstancesInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPerInstanceConfigsAsync(ListPerInstanceConfigsInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface patchAsync(PatchInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface patchPerInstanceConfigsAsync(PatchPerInstanceConfigsInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface recreateInstancesAsync(RecreateInstancesInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resizeAsync(ResizeInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setInstanceTemplateAsync(SetInstanceTemplateInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setTargetPoolsAsync(SetTargetPoolsInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePerInstanceConfigsAsync(UpdatePerInstanceConfigsInstanceGroupManagerRequest $request, array $optionalArgs = [])
 */
abstract class InstanceGroupManagersBaseClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.compute.v1.InstanceGroupManagers';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'compute.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/instance_group_managers_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/instance_group_managers_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/instance_group_managers_rest_client_config.php',
                ],
            ],
            'operationsClientClass' => ZoneOperationsClient::class,
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements GapicClientTrait::getSupportedTransports. */
    private static function getSupportedTransports()
    {
        return [
            'rest',
        ];
    }

    /**
     * Return an ZoneOperationsClient object with the same endpoint as $this.
     *
     * @return ZoneOperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /** Return the default longrunning operation descriptor config. */
    private function getDefaultOperationDescriptor()
    {
        return [
            'additionalArgumentMethods' => [
                'getProject',
                'getZone',
            ],
            'getOperationMethod' => 'get',
            'cancelOperationMethod' => null,
            'deleteOperationMethod' => 'delete',
            'operationErrorCodeMethod' => 'getHttpErrorStatusCode',
            'operationErrorMessageMethod' => 'getHttpErrorMessage',
            'operationNameMethod' => 'getName',
            'operationStatusMethod' => 'getStatus',
            'operationStatusDoneValue' => \Google\Cloud\Compute\V1\Operation\Status::DONE,
        ];
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : $this->getDefaultOperationDescriptor();
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'compute.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is {@see self::abandonInstancesAsync()} .
     *
     * @param AbandonInstancesInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function abandonInstances(AbandonInstancesInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AbandonInstances', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the list of managed instance groups and groups them by zone.
     *
     * The async variant is {@see self::aggregatedListAsync()} .
     *
     * @param AggregatedListInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function aggregatedList(AggregatedListInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('AggregatedList', $request, $callOptions);
    }

    /**
     * Applies changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.
     *
     * The async variant is {@see self::applyUpdatesToInstancesAsync()} .
     *
     * @param ApplyUpdatesToInstancesInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function applyUpdatesToInstances(ApplyUpdatesToInstancesInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ApplyUpdatesToInstances', $request, $callOptions)->wait();
    }

    /**
     * Creates instances with per-instance configurations in this managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.
     *
     * The async variant is {@see self::createInstancesAsync()} .
     *
     * @param CreateInstancesInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstances(CreateInstancesInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstances', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read Deleting an instance group for more information.
     *
     * The async variant is {@see self::deleteAsync()} .
     *
     * @param DeleteInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function delete(DeleteInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Delete', $request, $callOptions)->wait();
    }

    /**
     * Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is {@see self::deleteInstancesAsync()} .
     *
     * @param DeleteInstancesInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstances(DeleteInstancesInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstances', $request, $callOptions)->wait();
    }

    /**
     * Deletes selected per-instance configurations for the managed instance group.
     *
     * The async variant is {@see self::deletePerInstanceConfigsAsync()} .
     *
     * @param DeletePerInstanceConfigsInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePerInstanceConfigs(DeletePerInstanceConfigsInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePerInstanceConfigs', $request, $callOptions)->wait();
    }

    /**
     * Returns all of the details about the specified managed instance group.
     *
     * The async variant is {@see self::getAsync()} .
     *
     * @param GetInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstanceGroupManager
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function get(GetInstanceGroupManagerRequest $request, array $callOptions = []): InstanceGroupManager
    {
        return $this->startApiCall('Get', $request, $callOptions)->wait();
    }

    /**
     * Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.
     *
     * The async variant is {@see self::insertAsync()} .
     *
     * @param InsertInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function insert(InsertInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Insert', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a list of managed instance groups that are contained within the specified project and zone.
     *
     * The async variant is {@see self::listAsync()} .
     *
     * @param ListInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function list(ListInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('List', $request, $callOptions);
    }

    /**
     * Lists all errors thrown by actions on instances for a given managed instance group. The filter and orderBy query parameters are not supported.
     *
     * The async variant is {@see self::listErrorsAsync()} .
     *
     * @param ListErrorsInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listErrors(ListErrorsInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListErrors', $request, $callOptions);
    }

    /**
     * Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only in the alpha and beta API and only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.
     *
     * The async variant is {@see self::listManagedInstancesAsync()} .
     *
     * @param ListManagedInstancesInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listManagedInstances(ListManagedInstancesInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListManagedInstances', $request, $callOptions);
    }

    /**
     * Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.
     *
     * The async variant is {@see self::listPerInstanceConfigsAsync()} .
     *
     * @param ListPerInstanceConfigsInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPerInstanceConfigs(ListPerInstanceConfigsInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPerInstanceConfigs', $request, $callOptions);
    }

    /**
     * Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
     *
     * The async variant is {@see self::patchAsync()} .
     *
     * @param PatchInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function patch(PatchInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Patch', $request, $callOptions)->wait();
    }

    /**
     * Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
     *
     * The async variant is {@see self::patchPerInstanceConfigsAsync()} .
     *
     * @param PatchPerInstanceConfigsInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function patchPerInstanceConfigs(PatchPerInstanceConfigsInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PatchPerInstanceConfigs', $request, $callOptions)->wait();
    }

    /**
     * Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is {@see self::recreateInstancesAsync()} .
     *
     * @param RecreateInstancesInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function recreateInstances(RecreateInstancesInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RecreateInstances', $request, $callOptions)->wait();
    }

    /**
     * Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including: + The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance. This list is subject to change. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
     *
     * The async variant is {@see self::resizeAsync()} .
     *
     * @param ResizeInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resize(ResizeInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Resize', $request, $callOptions)->wait();
    }

    /**
     * Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     *
     * The async variant is {@see self::setInstanceTemplateAsync()} .
     *
     * @param SetInstanceTemplateInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInstanceTemplate(SetInstanceTemplateInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInstanceTemplate', $request, $callOptions)->wait();
    }

    /**
     * Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.
     *
     * The async variant is {@see self::setTargetPoolsAsync()} .
     *
     * @param SetTargetPoolsInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setTargetPools(SetTargetPoolsInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetTargetPools', $request, $callOptions)->wait();
    }

    /**
     * Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
     *
     * The async variant is {@see self::updatePerInstanceConfigsAsync()} .
     *
     * @param UpdatePerInstanceConfigsInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePerInstanceConfigs(UpdatePerInstanceConfigsInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePerInstanceConfigs', $request, $callOptions)->wait();
    }
}
