<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/css/v1/css_product_inputs.proto

namespace Google\Shopping\Css\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This resource represents input data you submit for a CSS Product, not
 * the processed CSS Product that you see in CSS Center, in Shopping Ads, or
 * across Google surfaces.
 *
 * Generated from protobuf message <code>google.shopping.css.v1.CssProductInput</code>
 */
class CssProductInput extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the CSS Product input.
     * Format:
     * `accounts/{account}/cssProductInputs/{css_product_input}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The name of the processed CSS Product.
     * Format:
     * `accounts/{account}/cssProducts/{css_product}`
     * "
     *
     * Generated from protobuf field <code>string final_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $final_name = '';
    /**
     * Required. Your unique identifier for the CSS Product. This is the same for
     * the CSS Product input and processed CSS Product. We only allow ids with
     * alphanumerics, underscores and dashes. See the [products feed
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string raw_provided_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $raw_provided_id = '';
    /**
     * Required. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the CSS
     * Product.
     *
     * Generated from protobuf field <code>string content_language = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $content_language = '';
    /**
     * Required. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the CSS Product.
     * Feed Label is synonymous to "target country" and hence should always be a
     * valid region code. For example: 'DE' for Germany, 'FR' for France.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $feed_label = '';
    /**
     * DEPRECATED. Use expiration_date instead.
     * Represents the existing version (freshness) of the CSS Product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * This field must not be set to the future time.
     * If set, the update is prevented if a newer version of the item already
     * exists in our system (that is the last update time of the existing
     * CSS products is later than the freshness time set in the update). If
     * the update happens, the last update time is then set to this freshness
     * time.
     * If not set, the update will not be prevented and the last update time will
     * default to when this request was received by the CSS API.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp freshness_time = 6 [deprecated = true];</code>
     * @deprecated
     */
    protected $freshness_time = null;
    /**
     * A list of CSS Product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.Attributes attributes = 7;</code>
     */
    protected $attributes = null;
    /**
     * A list of custom (CSS-provided) attributes. It can also be used for
     * submitting any attribute of the feed specification in its generic
     * form (for example:
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 8;</code>
     */
    private $custom_attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name of the CSS Product input.
     *           Format:
     *           `accounts/{account}/cssProductInputs/{css_product_input}`
     *     @type string $final_name
     *           Output only. The name of the processed CSS Product.
     *           Format:
     *           `accounts/{account}/cssProducts/{css_product}`
     *           "
     *     @type string $raw_provided_id
     *           Required. Your unique identifier for the CSS Product. This is the same for
     *           the CSS Product input and processed CSS Product. We only allow ids with
     *           alphanumerics, underscores and dashes. See the [products feed
     *           specification](https://support.google.com/merchants/answer/188494#id) for
     *           details.
     *     @type string $content_language
     *           Required. The two-letter [ISO
     *           639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the CSS
     *           Product.
     *     @type string $feed_label
     *           Required. The [feed
     *           label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     *           for the CSS Product.
     *           Feed Label is synonymous to "target country" and hence should always be a
     *           valid region code. For example: 'DE' for Germany, 'FR' for France.
     *     @type \Google\Protobuf\Timestamp $freshness_time
     *           DEPRECATED. Use expiration_date instead.
     *           Represents the existing version (freshness) of the CSS Product, which
     *           can be used to preserve the right order when multiple updates are done at
     *           the same time.
     *           This field must not be set to the future time.
     *           If set, the update is prevented if a newer version of the item already
     *           exists in our system (that is the last update time of the existing
     *           CSS products is later than the freshness time set in the update). If
     *           the update happens, the last update time is then set to this freshness
     *           time.
     *           If not set, the update will not be prevented and the last update time will
     *           default to when this request was received by the CSS API.
     *           If the operation is prevented, the aborted exception will be
     *           thrown.
     *     @type \Google\Shopping\Css\V1\Attributes $attributes
     *           A list of CSS Product attributes.
     *     @type array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $custom_attributes
     *           A list of custom (CSS-provided) attributes. It can also be used for
     *           submitting any attribute of the feed specification in its generic
     *           form (for example:
     *           `{ "name": "size type", "value": "regular" }`).
     *           This is useful for submitting attributes not explicitly exposed by the
     *           API, such as additional attributes used for Buy on Google.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Css\V1\CssProductInputs::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the CSS Product input.
     * Format:
     * `accounts/{account}/cssProductInputs/{css_product_input}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the CSS Product input.
     * Format:
     * `accounts/{account}/cssProductInputs/{css_product_input}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The name of the processed CSS Product.
     * Format:
     * `accounts/{account}/cssProducts/{css_product}`
     * "
     *
     * Generated from protobuf field <code>string final_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getFinalName()
    {
        return $this->final_name;
    }

    /**
     * Output only. The name of the processed CSS Product.
     * Format:
     * `accounts/{account}/cssProducts/{css_product}`
     * "
     *
     * Generated from protobuf field <code>string final_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setFinalName($var)
    {
        GPBUtil::checkString($var, True);
        $this->final_name = $var;

        return $this;
    }

    /**
     * Required. Your unique identifier for the CSS Product. This is the same for
     * the CSS Product input and processed CSS Product. We only allow ids with
     * alphanumerics, underscores and dashes. See the [products feed
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string raw_provided_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRawProvidedId()
    {
        return $this->raw_provided_id;
    }

    /**
     * Required. Your unique identifier for the CSS Product. This is the same for
     * the CSS Product input and processed CSS Product. We only allow ids with
     * alphanumerics, underscores and dashes. See the [products feed
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string raw_provided_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRawProvidedId($var)
    {
        GPBUtil::checkString($var, True);
        $this->raw_provided_id = $var;

        return $this;
    }

    /**
     * Required. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the CSS
     * Product.
     *
     * Generated from protobuf field <code>string content_language = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getContentLanguage()
    {
        return $this->content_language;
    }

    /**
     * Required. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the CSS
     * Product.
     *
     * Generated from protobuf field <code>string content_language = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setContentLanguage($var)
    {
        GPBUtil::checkString($var, True);
        $this->content_language = $var;

        return $this;
    }

    /**
     * Required. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the CSS Product.
     * Feed Label is synonymous to "target country" and hence should always be a
     * valid region code. For example: 'DE' for Germany, 'FR' for France.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return $this->feed_label;
    }

    /**
     * Required. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the CSS Product.
     * Feed Label is synonymous to "target country" and hence should always be a
     * valid region code. For example: 'DE' for Germany, 'FR' for France.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * DEPRECATED. Use expiration_date instead.
     * Represents the existing version (freshness) of the CSS Product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * This field must not be set to the future time.
     * If set, the update is prevented if a newer version of the item already
     * exists in our system (that is the last update time of the existing
     * CSS products is later than the freshness time set in the update). If
     * the update happens, the last update time is then set to this freshness
     * time.
     * If not set, the update will not be prevented and the last update time will
     * default to when this request was received by the CSS API.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp freshness_time = 6 [deprecated = true];</code>
     * @return \Google\Protobuf\Timestamp|null
     * @deprecated
     */
    public function getFreshnessTime()
    {
        @trigger_error('freshness_time is deprecated.', E_USER_DEPRECATED);
        return $this->freshness_time;
    }

    public function hasFreshnessTime()
    {
        @trigger_error('freshness_time is deprecated.', E_USER_DEPRECATED);
        return isset($this->freshness_time);
    }

    public function clearFreshnessTime()
    {
        @trigger_error('freshness_time is deprecated.', E_USER_DEPRECATED);
        unset($this->freshness_time);
    }

    /**
     * DEPRECATED. Use expiration_date instead.
     * Represents the existing version (freshness) of the CSS Product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * This field must not be set to the future time.
     * If set, the update is prevented if a newer version of the item already
     * exists in our system (that is the last update time of the existing
     * CSS products is later than the freshness time set in the update). If
     * the update happens, the last update time is then set to this freshness
     * time.
     * If not set, the update will not be prevented and the last update time will
     * default to when this request was received by the CSS API.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp freshness_time = 6 [deprecated = true];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     * @deprecated
     */
    public function setFreshnessTime($var)
    {
        @trigger_error('freshness_time is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->freshness_time = $var;

        return $this;
    }

    /**
     * A list of CSS Product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.Attributes attributes = 7;</code>
     * @return \Google\Shopping\Css\V1\Attributes|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    public function hasAttributes()
    {
        return isset($this->attributes);
    }

    public function clearAttributes()
    {
        unset($this->attributes);
    }

    /**
     * A list of CSS Product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.Attributes attributes = 7;</code>
     * @param \Google\Shopping\Css\V1\Attributes $var
     * @return $this
     */
    public function setAttributes($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Css\V1\Attributes::class);
        $this->attributes = $var;

        return $this;
    }

    /**
     * A list of custom (CSS-provided) attributes. It can also be used for
     * submitting any attribute of the feed specification in its generic
     * form (for example:
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * A list of custom (CSS-provided) attributes. It can also be used for
     * submitting any attribute of the feed specification in its generic
     * form (for example:
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 8;</code>
     * @param array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Type\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

}

