<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/optimization/v1/fleet_routing.proto

namespace Google\Cloud\Optimization\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A vehicle's route can be decomposed, along the time axis, like this (we
 * assume there are n visits):
 * ```
 *   |            |            |          |       |  T[2], |        |      |
 *   | Transition |  Visit #0  |          |       |  V[2], |        |      |
 *   |     #0     |    aka     |   T[1]   |  V[1] |  ...   | V[n-1] | T[n] |
 *   |  aka T[0]  |    V[0]    |          |       | V[n-2],|        |      |
 *   |            |            |          |       | T[n-1] |        |      |
 *   ^            ^            ^          ^       ^        ^        ^      ^
 * vehicle    V[0].start   V[0].end     V[1].   V[1].    V[n].    V[n]. vehicle
 *  start     (arrival)   (departure)   start   end      start    end     end
 * ```
 * Note that we make a difference between:
 * * "punctual events", such as the vehicle start and end and each visit's start
 *   and end (aka arrival and departure). They happen at a given second.
 * * "time intervals", such as the visits themselves, and the transition between
 *   visits. Though time intervals can sometimes have zero duration, i.e. start
 *   and end at the same second, they often have a positive duration.
 * Invariants:
 * * If there are n visits, there are n+1 transitions.
 * * A visit is always surrounded by a transition before it (same index) and a
 *   transition after it (index + 1).
 * * The vehicle start is always followed by transition #0.
 * * The vehicle end is always preceded by transition #n.
 * Zooming in, here is what happens during a `Transition` and a `Visit`:
 * ```
 * ---+-------------------------------------+-----------------------------+-->
 *    |           TRANSITION[i]             |           VISIT[i]          |
 *    |                                     |                             |
 *    |  * TRAVEL: the vehicle moves from   |      PERFORM the visit:     |
 *    |    VISIT[i-1].departure_location to |                             |
 *    |    VISIT[i].arrival_location, which |  * Spend some time:         |
 *    |    takes a given travel duration    |    the "visit duration".    |
 *    |    and distance                     |                             |
 *    |                                     |  * Load or unload           |
 *    |  * BREAKS: the driver may have      |    some quantities from the |
 *    |    breaks (e.g. lunch break).       |    vehicle: the "demand".   |
 *    |                                     |                             |
 *    |  * WAIT: the driver/vehicle does    |                             |
 *    |    nothing. This can happen for     |                             |
 *    |    many reasons, for example when   |                             |
 *    |    the vehicle reaches the next     |                             |
 *    |    event's destination before the   |                             |
 *    |    start of its time window         |                             |
 *    |                                     |                             |
 *    |  * DELAY: *right before* the next   |                             |
 *    |    arrival. E.g. the vehicle and/or |                             |
 *    |    driver spends time unloading.    |                             |
 *    |                                     |                             |
 * ---+-------------------------------------+-----------------------------+-->
 *    ^                                     ^                             ^
 * V[i-1].end                           V[i].start                    V[i].end
 * ```
 * Lastly, here is how the TRAVEL, BREAKS, DELAY and WAIT can be arranged
 * during a transition.
 * * They don't overlap.
 * * The DELAY is unique and *must* be a contiguous period of time right
 *   before the next visit (or vehicle end). Thus, it suffice to know the
 *   delay duration to know its start and end time.
 * * The BREAKS are contiguous, non-overlapping periods of time. The
 *   response specifies the start time and duration of each break.
 * * TRAVEL and WAIT are "preemptable": they can be interrupted several times
 *   during this transition. Clients can assume that travel happens "as soon as
 *   possible" and that "wait" fills the remaining time.
 * A (complex) example:
 * ```
 *                                TRANSITION[i]
 * --++-----+-----------------------------------------------------------++-->
 *   ||     |       |           |       |           |         |         ||
 *   ||  T  |   B   |     T     |       |     B     |         |    D    ||
 *   ||  r  |   r   |     r     |   W   |     r     |    W    |    e    ||
 *   ||  a  |   e   |     a     |   a   |     e     |    a    |    l    ||
 *   ||  v  |   a   |     v     |   i   |     a     |    i    |    a    ||
 *   ||  e  |   k   |     e     |   t   |     k     |    t    |    y    ||
 *   ||  l  |       |     l     |       |           |         |         ||
 *   ||     |       |           |       |           |         |         ||
 * --++-----------------------------------------------------------------++-->
 * ```
 *
 * Generated from protobuf message <code>google.cloud.optimization.v1.ShipmentRoute</code>
 */
class ShipmentRoute extends \Google\Protobuf\Internal\Message
{
    /**
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     *
     * Generated from protobuf field <code>int32 vehicle_index = 1;</code>
     */
    protected $vehicle_index = 0;
    /**
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     *
     * Generated from protobuf field <code>string vehicle_label = 2;</code>
     */
    protected $vehicle_label = '';
    /**
     * Time at which the vehicle starts its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    protected $vehicle_start_time = null;
    /**
     * Time at which the vehicle finishes its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    protected $vehicle_end_time = null;
    /**
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    private $visits;
    /**
     * Ordered list of transitions for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    private $transitions;
    /**
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     * ```
     *   start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) > start_time(next_visit)
     * ```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     *
     * Generated from protobuf field <code>bool has_traffic_infeasibilities = 9;</code>
     */
    protected $has_traffic_infeasibilities = false;
    /**
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    protected $route_polyline = null;
    /**
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    private $breaks;
    /**
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are
     * summed over all
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits],
     * depending on the context.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    protected $metrics = null;
    /**
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     *
     * Generated from protobuf field <code>map<string, double> route_costs = 17;</code>
     */
    private $route_costs;
    /**
     * Total cost of the route. The sum of all costs in the cost map.
     *
     * Generated from protobuf field <code>double route_total_cost = 18;</code>
     */
    protected $route_total_cost = 0.0;
    /**
     * Deprecated: Use
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * instead. Vehicle loads upon arrival at its end location, for each type
     * specified in
     * [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];</code>
     * @deprecated
     */
    private $end_loads;
    /**
     * Deprecated: Use
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * instead. Ordered list of travel steps for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];</code>
     * @deprecated
     */
    private $travel_steps;
    /**
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit]
     * level.
     * This field is the extra detour time due to the shipments visited on the
     * route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     * @deprecated
     */
    protected $vehicle_detour = null;
    /**
     * Deprecated: Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];</code>
     * @deprecated
     */
    protected $delay_before_vehicle_end = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $vehicle_index
     *           Vehicle performing the route, identified by its index in the source
     *           `ShipmentModel`.
     *     @type string $vehicle_label
     *           Label of the vehicle performing this route, equal to
     *           `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     *     @type \Google\Protobuf\Timestamp $vehicle_start_time
     *           Time at which the vehicle starts its route.
     *     @type \Google\Protobuf\Timestamp $vehicle_end_time
     *           Time at which the vehicle finishes its route.
     *     @type array<\Google\Cloud\Optimization\V1\ShipmentRoute\Visit>|\Google\Protobuf\Internal\RepeatedField $visits
     *           Ordered sequence of visits representing a route.
     *           visits[i] is the i-th visit in the route.
     *           If this field is empty, the vehicle is considered as unused.
     *     @type array<\Google\Cloud\Optimization\V1\ShipmentRoute\Transition>|\Google\Protobuf\Internal\RepeatedField $transitions
     *           Ordered list of transitions for the route.
     *     @type bool $has_traffic_infeasibilities
     *           When
     *           [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     *           is set to true, this field indicates that inconsistencies in route timings
     *           are predicted using traffic-based travel duration estimates. There may be
     *           insufficient time to complete traffic-adjusted travel, delays, and breaks
     *           between visits, before the first visit, or after the last visit, while
     *           still satisfying the visit and vehicle time windows. For example,
     *           ```
     *             start_time(previous_visit) + duration(previous_visit) +
     *             travel_duration(previous_visit, next_visit) > start_time(next_visit)
     *           ```
     *           Arrival at next_visit will likely happen later than its current
     *           time window due the increased estimate of travel time
     *           `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     *           may be forced to overlap with a visit due to an increase in travel time
     *           estimates and visit or break time window restrictions.
     *     @type \Google\Cloud\Optimization\V1\ShipmentRoute\EncodedPolyline $route_polyline
     *           The encoded polyline representation of the route.
     *           This field is only populated if
     *           [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     *           is set to true.
     *     @type array<\Google\Cloud\Optimization\V1\ShipmentRoute\PBBreak>|\Google\Protobuf\Internal\RepeatedField $breaks
     *           Breaks scheduled for the vehicle performing this route.
     *           The `breaks` sequence represents time intervals, each starting at the
     *           corresponding `start_time` and lasting `duration` seconds.
     *     @type \Google\Cloud\Optimization\V1\AggregatedMetrics $metrics
     *           Duration, distance and load metrics for this route. The fields of
     *           [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are
     *           summed over all
     *           [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     *           or
     *           [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits],
     *           depending on the context.
     *     @type array|\Google\Protobuf\Internal\MapField $route_costs
     *           Cost of the route, broken down by cost-related request fields.
     *           The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     *           "model.shipments.pickups.cost", and the values are the total cost
     *           generated by the corresponding cost field, aggregated over the whole route.
     *           In other words, costs["model.shipments.pickups.cost"] is the sum of all
     *           pickup costs over the route. All costs defined in the model are reported in
     *           detail here with the exception of costs related to TransitionAttributes
     *           that are only reported in an aggregated way as of 2022/01.
     *     @type float $route_total_cost
     *           Total cost of the route. The sum of all costs in the cost map.
     *     @type array<\Google\Cloud\Optimization\V1\CapacityQuantity>|\Google\Protobuf\Internal\RepeatedField $end_loads
     *           Deprecated: Use
     *           [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     *           instead. Vehicle loads upon arrival at its end location, for each type
     *           specified in
     *           [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     *           `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     *           loads for quantity types unconstrained by intervals and that don't have any
     *           non-zero demand on the route.
     *     @type array<\Google\Cloud\Optimization\V1\ShipmentRoute\TravelStep>|\Google\Protobuf\Internal\RepeatedField $travel_steps
     *           Deprecated: Use
     *           [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     *           instead. Ordered list of travel steps for the route.
     *     @type \Google\Protobuf\Duration $vehicle_detour
     *           Deprecated: No longer used.
     *           This field will only be populated at the
     *           [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit]
     *           level.
     *           This field is the extra detour time due to the shipments visited on the
     *           route.
     *           It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     *           from the vehicle's start_location to its `end_location`.
     *     @type \Google\Cloud\Optimization\V1\ShipmentRoute\Delay $delay_before_vehicle_end
     *           Deprecated: Delay occurring before the vehicle end. See
     *           [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Optimization\V1\FleetRouting::initOnce();
        parent::__construct($data);
    }

    /**
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     *
     * Generated from protobuf field <code>int32 vehicle_index = 1;</code>
     * @return int
     */
    public function getVehicleIndex()
    {
        return $this->vehicle_index;
    }

    /**
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     *
     * Generated from protobuf field <code>int32 vehicle_index = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setVehicleIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->vehicle_index = $var;

        return $this;
    }

    /**
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     *
     * Generated from protobuf field <code>string vehicle_label = 2;</code>
     * @return string
     */
    public function getVehicleLabel()
    {
        return $this->vehicle_label;
    }

    /**
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     *
     * Generated from protobuf field <code>string vehicle_label = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setVehicleLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->vehicle_label = $var;

        return $this;
    }

    /**
     * Time at which the vehicle starts its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getVehicleStartTime()
    {
        return $this->vehicle_start_time;
    }

    public function hasVehicleStartTime()
    {
        return isset($this->vehicle_start_time);
    }

    public function clearVehicleStartTime()
    {
        unset($this->vehicle_start_time);
    }

    /**
     * Time at which the vehicle starts its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setVehicleStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->vehicle_start_time = $var;

        return $this;
    }

    /**
     * Time at which the vehicle finishes its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getVehicleEndTime()
    {
        return $this->vehicle_end_time;
    }

    public function hasVehicleEndTime()
    {
        return isset($this->vehicle_end_time);
    }

    public function clearVehicleEndTime()
    {
        unset($this->vehicle_end_time);
    }

    /**
     * Time at which the vehicle finishes its route.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setVehicleEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->vehicle_end_time = $var;

        return $this;
    }

    /**
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVisits()
    {
        return $this->visits;
    }

    /**
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     * @param array<\Google\Cloud\Optimization\V1\ShipmentRoute\Visit>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVisits($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Optimization\V1\ShipmentRoute\Visit::class);
        $this->visits = $arr;

        return $this;
    }

    /**
     * Ordered list of transitions for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTransitions()
    {
        return $this->transitions;
    }

    /**
     * Ordered list of transitions for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     * @param array<\Google\Cloud\Optimization\V1\ShipmentRoute\Transition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTransitions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Optimization\V1\ShipmentRoute\Transition::class);
        $this->transitions = $arr;

        return $this;
    }

    /**
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     * ```
     *   start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) > start_time(next_visit)
     * ```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     *
     * Generated from protobuf field <code>bool has_traffic_infeasibilities = 9;</code>
     * @return bool
     */
    public function getHasTrafficInfeasibilities()
    {
        return $this->has_traffic_infeasibilities;
    }

    /**
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     * ```
     *   start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) > start_time(next_visit)
     * ```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     *
     * Generated from protobuf field <code>bool has_traffic_infeasibilities = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setHasTrafficInfeasibilities($var)
    {
        GPBUtil::checkBool($var);
        $this->has_traffic_infeasibilities = $var;

        return $this;
    }

    /**
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     * @return \Google\Cloud\Optimization\V1\ShipmentRoute\EncodedPolyline|null
     */
    public function getRoutePolyline()
    {
        return $this->route_polyline;
    }

    public function hasRoutePolyline()
    {
        return isset($this->route_polyline);
    }

    public function clearRoutePolyline()
    {
        unset($this->route_polyline);
    }

    /**
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     * @param \Google\Cloud\Optimization\V1\ShipmentRoute\EncodedPolyline $var
     * @return $this
     */
    public function setRoutePolyline($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Optimization\V1\ShipmentRoute\EncodedPolyline::class);
        $this->route_polyline = $var;

        return $this;
    }

    /**
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBreaks()
    {
        return $this->breaks;
    }

    /**
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     * @param array<\Google\Cloud\Optimization\V1\ShipmentRoute\PBBreak>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBreaks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Optimization\V1\ShipmentRoute\PBBreak::class);
        $this->breaks = $arr;

        return $this;
    }

    /**
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are
     * summed over all
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits],
     * depending on the context.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     * @return \Google\Cloud\Optimization\V1\AggregatedMetrics|null
     */
    public function getMetrics()
    {
        return $this->metrics;
    }

    public function hasMetrics()
    {
        return isset($this->metrics);
    }

    public function clearMetrics()
    {
        unset($this->metrics);
    }

    /**
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are
     * summed over all
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits],
     * depending on the context.
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     * @param \Google\Cloud\Optimization\V1\AggregatedMetrics $var
     * @return $this
     */
    public function setMetrics($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Optimization\V1\AggregatedMetrics::class);
        $this->metrics = $var;

        return $this;
    }

    /**
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     *
     * Generated from protobuf field <code>map<string, double> route_costs = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getRouteCosts()
    {
        return $this->route_costs;
    }

    /**
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     *
     * Generated from protobuf field <code>map<string, double> route_costs = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setRouteCosts($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::DOUBLE);
        $this->route_costs = $arr;

        return $this;
    }

    /**
     * Total cost of the route. The sum of all costs in the cost map.
     *
     * Generated from protobuf field <code>double route_total_cost = 18;</code>
     * @return float
     */
    public function getRouteTotalCost()
    {
        return $this->route_total_cost;
    }

    /**
     * Total cost of the route. The sum of all costs in the cost map.
     *
     * Generated from protobuf field <code>double route_total_cost = 18;</code>
     * @param float $var
     * @return $this
     */
    public function setRouteTotalCost($var)
    {
        GPBUtil::checkDouble($var);
        $this->route_total_cost = $var;

        return $this;
    }

    /**
     * Deprecated: Use
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * instead. Vehicle loads upon arrival at its end location, for each type
     * specified in
     * [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getEndLoads()
    {
        @trigger_error('end_loads is deprecated.', E_USER_DEPRECATED);
        return $this->end_loads;
    }

    /**
     * Deprecated: Use
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * instead. Vehicle loads upon arrival at its end location, for each type
     * specified in
     * [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];</code>
     * @param array<\Google\Cloud\Optimization\V1\CapacityQuantity>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setEndLoads($var)
    {
        @trigger_error('end_loads is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Optimization\V1\CapacityQuantity::class);
        $this->end_loads = $arr;

        return $this;
    }

    /**
     * Deprecated: Use
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * instead. Ordered list of travel steps for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getTravelSteps()
    {
        @trigger_error('travel_steps is deprecated.', E_USER_DEPRECATED);
        return $this->travel_steps;
    }

    /**
     * Deprecated: Use
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
     * instead. Ordered list of travel steps for the route.
     *
     * Generated from protobuf field <code>repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];</code>
     * @param array<\Google\Cloud\Optimization\V1\ShipmentRoute\TravelStep>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setTravelSteps($var)
    {
        @trigger_error('travel_steps is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Optimization\V1\ShipmentRoute\TravelStep::class);
        $this->travel_steps = $arr;

        return $this;
    }

    /**
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit]
     * level.
     * This field is the extra detour time due to the shipments visited on the
     * route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     * @return \Google\Protobuf\Duration|null
     * @deprecated
     */
    public function getVehicleDetour()
    {
        @trigger_error('vehicle_detour is deprecated.', E_USER_DEPRECATED);
        return $this->vehicle_detour;
    }

    public function hasVehicleDetour()
    {
        @trigger_error('vehicle_detour is deprecated.', E_USER_DEPRECATED);
        return isset($this->vehicle_detour);
    }

    public function clearVehicleDetour()
    {
        @trigger_error('vehicle_detour is deprecated.', E_USER_DEPRECATED);
        unset($this->vehicle_detour);
    }

    /**
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit]
     * level.
     * This field is the extra detour time due to the shipments visited on the
     * route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     * @deprecated
     */
    public function setVehicleDetour($var)
    {
        @trigger_error('vehicle_detour is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->vehicle_detour = $var;

        return $this;
    }

    /**
     * Deprecated: Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];</code>
     * @return \Google\Cloud\Optimization\V1\ShipmentRoute\Delay|null
     * @deprecated
     */
    public function getDelayBeforeVehicleEnd()
    {
        @trigger_error('delay_before_vehicle_end is deprecated.', E_USER_DEPRECATED);
        return $this->delay_before_vehicle_end;
    }

    public function hasDelayBeforeVehicleEnd()
    {
        @trigger_error('delay_before_vehicle_end is deprecated.', E_USER_DEPRECATED);
        return isset($this->delay_before_vehicle_end);
    }

    public function clearDelayBeforeVehicleEnd()
    {
        @trigger_error('delay_before_vehicle_end is deprecated.', E_USER_DEPRECATED);
        unset($this->delay_before_vehicle_end);
    }

    /**
     * Deprecated: Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     *
     * Generated from protobuf field <code>.google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];</code>
     * @param \Google\Cloud\Optimization\V1\ShipmentRoute\Delay $var
     * @return $this
     * @deprecated
     */
    public function setDelayBeforeVehicleEnd($var)
    {
        @trigger_error('delay_before_vehicle_end is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Optimization\V1\ShipmentRoute\Delay::class);
        $this->delay_before_vehicle_end = $var;

        return $this;
    }

}

