<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/http_route.proto

namespace Google\Cloud\NetworkServices\V1\HttpRoute;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The Specification for allowing client side cross-origin requests.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.HttpRoute.CorsPolicy</code>
 */
class CorsPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     * An origin is allowed if it matches either an item in allow_origins or
     * an item in allow_origin_regexes.
     *
     * Generated from protobuf field <code>repeated string allow_origins = 1;</code>
     */
    private $allow_origins;
    /**
     * Specifies the regular expression patterns that match allowed origins. For
     * regular expression grammar, please see
     * https://github.com/google/re2/wiki/Syntax.
     *
     * Generated from protobuf field <code>repeated string allow_origin_regexes = 2;</code>
     */
    private $allow_origin_regexes;
    /**
     * Specifies the content for Access-Control-Allow-Methods header.
     *
     * Generated from protobuf field <code>repeated string allow_methods = 3;</code>
     */
    private $allow_methods;
    /**
     * Specifies the content for Access-Control-Allow-Headers header.
     *
     * Generated from protobuf field <code>repeated string allow_headers = 4;</code>
     */
    private $allow_headers;
    /**
     * Specifies the content for Access-Control-Expose-Headers header.
     *
     * Generated from protobuf field <code>repeated string expose_headers = 5;</code>
     */
    private $expose_headers;
    /**
     * Specifies how long result of a preflight request can be cached in
     * seconds. This translates to the Access-Control-Max-Age header.
     *
     * Generated from protobuf field <code>string max_age = 6;</code>
     */
    protected $max_age = '';
    /**
     * In response to a preflight request, setting this to true indicates that
     * the actual request can include user credentials. This translates to the
     * Access-Control-Allow-Credentials header.
     * Default value is false.
     *
     * Generated from protobuf field <code>bool allow_credentials = 7;</code>
     */
    protected $allow_credentials = false;
    /**
     * If true, the CORS policy is disabled. The default value is false, which
     * indicates that the CORS policy is in effect.
     *
     * Generated from protobuf field <code>bool disabled = 8;</code>
     */
    protected $disabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allow_origins
     *           Specifies the list of origins that will be allowed to do CORS requests.
     *           An origin is allowed if it matches either an item in allow_origins or
     *           an item in allow_origin_regexes.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allow_origin_regexes
     *           Specifies the regular expression patterns that match allowed origins. For
     *           regular expression grammar, please see
     *           https://github.com/google/re2/wiki/Syntax.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allow_methods
     *           Specifies the content for Access-Control-Allow-Methods header.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allow_headers
     *           Specifies the content for Access-Control-Allow-Headers header.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $expose_headers
     *           Specifies the content for Access-Control-Expose-Headers header.
     *     @type string $max_age
     *           Specifies how long result of a preflight request can be cached in
     *           seconds. This translates to the Access-Control-Max-Age header.
     *     @type bool $allow_credentials
     *           In response to a preflight request, setting this to true indicates that
     *           the actual request can include user credentials. This translates to the
     *           Access-Control-Allow-Credentials header.
     *           Default value is false.
     *     @type bool $disabled
     *           If true, the CORS policy is disabled. The default value is false, which
     *           indicates that the CORS policy is in effect.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\HttpRoute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     * An origin is allowed if it matches either an item in allow_origins or
     * an item in allow_origin_regexes.
     *
     * Generated from protobuf field <code>repeated string allow_origins = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowOrigins()
    {
        return $this->allow_origins;
    }

    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     * An origin is allowed if it matches either an item in allow_origins or
     * an item in allow_origin_regexes.
     *
     * Generated from protobuf field <code>repeated string allow_origins = 1;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowOrigins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allow_origins = $arr;

        return $this;
    }

    /**
     * Specifies the regular expression patterns that match allowed origins. For
     * regular expression grammar, please see
     * https://github.com/google/re2/wiki/Syntax.
     *
     * Generated from protobuf field <code>repeated string allow_origin_regexes = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowOriginRegexes()
    {
        return $this->allow_origin_regexes;
    }

    /**
     * Specifies the regular expression patterns that match allowed origins. For
     * regular expression grammar, please see
     * https://github.com/google/re2/wiki/Syntax.
     *
     * Generated from protobuf field <code>repeated string allow_origin_regexes = 2;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowOriginRegexes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allow_origin_regexes = $arr;

        return $this;
    }

    /**
     * Specifies the content for Access-Control-Allow-Methods header.
     *
     * Generated from protobuf field <code>repeated string allow_methods = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowMethods()
    {
        return $this->allow_methods;
    }

    /**
     * Specifies the content for Access-Control-Allow-Methods header.
     *
     * Generated from protobuf field <code>repeated string allow_methods = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowMethods($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allow_methods = $arr;

        return $this;
    }

    /**
     * Specifies the content for Access-Control-Allow-Headers header.
     *
     * Generated from protobuf field <code>repeated string allow_headers = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowHeaders()
    {
        return $this->allow_headers;
    }

    /**
     * Specifies the content for Access-Control-Allow-Headers header.
     *
     * Generated from protobuf field <code>repeated string allow_headers = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allow_headers = $arr;

        return $this;
    }

    /**
     * Specifies the content for Access-Control-Expose-Headers header.
     *
     * Generated from protobuf field <code>repeated string expose_headers = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExposeHeaders()
    {
        return $this->expose_headers;
    }

    /**
     * Specifies the content for Access-Control-Expose-Headers header.
     *
     * Generated from protobuf field <code>repeated string expose_headers = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExposeHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->expose_headers = $arr;

        return $this;
    }

    /**
     * Specifies how long result of a preflight request can be cached in
     * seconds. This translates to the Access-Control-Max-Age header.
     *
     * Generated from protobuf field <code>string max_age = 6;</code>
     * @return string
     */
    public function getMaxAge()
    {
        return $this->max_age;
    }

    /**
     * Specifies how long result of a preflight request can be cached in
     * seconds. This translates to the Access-Control-Max-Age header.
     *
     * Generated from protobuf field <code>string max_age = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setMaxAge($var)
    {
        GPBUtil::checkString($var, True);
        $this->max_age = $var;

        return $this;
    }

    /**
     * In response to a preflight request, setting this to true indicates that
     * the actual request can include user credentials. This translates to the
     * Access-Control-Allow-Credentials header.
     * Default value is false.
     *
     * Generated from protobuf field <code>bool allow_credentials = 7;</code>
     * @return bool
     */
    public function getAllowCredentials()
    {
        return $this->allow_credentials;
    }

    /**
     * In response to a preflight request, setting this to true indicates that
     * the actual request can include user credentials. This translates to the
     * Access-Control-Allow-Credentials header.
     * Default value is false.
     *
     * Generated from protobuf field <code>bool allow_credentials = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowCredentials($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_credentials = $var;

        return $this;
    }

    /**
     * If true, the CORS policy is disabled. The default value is false, which
     * indicates that the CORS policy is in effect.
     *
     * Generated from protobuf field <code>bool disabled = 8;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * If true, the CORS policy is disabled. The default value is false, which
     * indicates that the CORS policy is in effect.
     *
     * Generated from protobuf field <code>bool disabled = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

}


