<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/assuredworkloads/v1beta1/assuredworkloads.proto

namespace Google\Cloud\AssuredWorkloads\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to analyze a hypothetical move of a source project or project-based
 * workload to a target (destination) folder-based workload.
 *
 * Generated from protobuf message <code>google.cloud.assuredworkloads.v1beta1.AnalyzeWorkloadMoveRequest</code>
 */
class AnalyzeWorkloadMoveRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource ID of the folder-based destination workload. This workload is
     * where the source project will hypothetically be moved to. Specify the
     * workload's relative resource name, formatted as:
     * "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     * For example:
     * "organizations/123/locations/us-east1/workloads/assured-workload-2"
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target = '';
    protected $projectOrWorkloadResource;

    /**
     * @param string $project The source type is a project. Specify the project's relative resource
     *                        name, formatted as either a project number or a project ID:
     *                        "projects/{PROJECT_NUMBER}" or "projects/{PROJECT_ID}"
     *                        For example:
     *                        "projects/951040570662" when specifying a project number, or
     *                        "projects/my-project-123" when specifying a project ID.
     * @param string $target  Required. The resource ID of the folder-based destination workload. This workload is
     *                        where the source project will hypothetically be moved to. Specify the
     *                        workload's relative resource name, formatted as:
     *                        "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     *                        For example:
     *                        "organizations/123/locations/us-east1/workloads/assured-workload-2"
     *
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\AnalyzeWorkloadMoveRequest
     *
     * @experimental
     */
    public static function build(string $project, string $target): self
    {
        return (new self())
            ->setProject($project)
            ->setTarget($target);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $source
     *           The source type is a project-based workload. Specify the workloads's
     *           relative resource name, formatted as:
     *           "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     *           For example:
     *           "organizations/123/locations/us-east1/workloads/assured-workload-1"
     *     @type string $project
     *           The source type is a project. Specify the project's relative resource
     *           name, formatted as either a project number or a project ID:
     *           "projects/{PROJECT_NUMBER}" or "projects/{PROJECT_ID}"
     *           For example:
     *           "projects/951040570662" when specifying a project number, or
     *           "projects/my-project-123" when specifying a project ID.
     *     @type string $target
     *           Required. The resource ID of the folder-based destination workload. This workload is
     *           where the source project will hypothetically be moved to. Specify the
     *           workload's relative resource name, formatted as:
     *           "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     *           For example:
     *           "organizations/123/locations/us-east1/workloads/assured-workload-2"
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Assuredworkloads\V1Beta1\Assuredworkloads::initOnce();
        parent::__construct($data);
    }

    /**
     * The source type is a project-based workload. Specify the workloads's
     * relative resource name, formatted as:
     * "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     * For example:
     * "organizations/123/locations/us-east1/workloads/assured-workload-1"
     *
     * Generated from protobuf field <code>string source = 1;</code>
     * @return string
     */
    public function getSource()
    {
        return $this->readOneof(1);
    }

    public function hasSource()
    {
        return $this->hasOneof(1);
    }

    /**
     * The source type is a project-based workload. Specify the workloads's
     * relative resource name, formatted as:
     * "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     * For example:
     * "organizations/123/locations/us-east1/workloads/assured-workload-1"
     *
     * Generated from protobuf field <code>string source = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The source type is a project. Specify the project's relative resource
     * name, formatted as either a project number or a project ID:
     * "projects/{PROJECT_NUMBER}" or "projects/{PROJECT_ID}"
     * For example:
     * "projects/951040570662" when specifying a project number, or
     * "projects/my-project-123" when specifying a project ID.
     *
     * Generated from protobuf field <code>string project = 3;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->readOneof(3);
    }

    public function hasProject()
    {
        return $this->hasOneof(3);
    }

    /**
     * The source type is a project. Specify the project's relative resource
     * name, formatted as either a project number or a project ID:
     * "projects/{PROJECT_NUMBER}" or "projects/{PROJECT_ID}"
     * For example:
     * "projects/951040570662" when specifying a project number, or
     * "projects/my-project-123" when specifying a project ID.
     *
     * Generated from protobuf field <code>string project = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. The resource ID of the folder-based destination workload. This workload is
     * where the source project will hypothetically be moved to. Specify the
     * workload's relative resource name, formatted as:
     * "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     * For example:
     * "organizations/123/locations/us-east1/workloads/assured-workload-2"
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * Required. The resource ID of the folder-based destination workload. This workload is
     * where the source project will hypothetically be moved to. Specify the
     * workload's relative resource name, formatted as:
     * "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}"
     * For example:
     * "organizations/123/locations/us-east1/workloads/assured-workload-2"
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->target = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getProjectOrWorkloadResource()
    {
        return $this->whichOneof("projectOrWorkloadResource");
    }

}

