<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/storageinsights/v1/storageinsights.proto

namespace Google\Cloud\StorageInsights\V1\DatasetConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Provides a summary of the bucket level error statistics.
 *
 * Generated from protobuf message <code>google.cloud.storageinsights.v1.DatasetConfig.BucketErrors</code>
 */
class BucketErrors extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Count of successfully validated buckets.
     *
     * Generated from protobuf field <code>int64 validated_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validated_count = 0;
    /**
     * Optional. Count of buckets with permission denied errors.
     *
     * Generated from protobuf field <code>int64 permission_denied_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $permission_denied_count = 0;
    /**
     * Optional. Subset of bucket names that have permission denied.
     *
     * Generated from protobuf field <code>repeated string permission_denied_bucket_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $permission_denied_bucket_ids;
    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_management_hub_entitled_count = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $non_management_hub_entitled_count = 0;
    /**
     * Optional. Number of buckets that encountered internal errors during the
     * validation process. These buckets are automatically retried in subsequent
     * validation attempts.
     *
     * Generated from protobuf field <code>int64 internal_error_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $internal_error_count = 0;
    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_storage_intelligence_entitled_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $non_storage_intelligence_entitled_count = 0;
    /**
     * Optional. Subset of bucket names that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>repeated string non_storage_intelligence_entitled_bucket_ids = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $non_storage_intelligence_entitled_bucket_ids;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $validated_count
     *           Optional. Count of successfully validated buckets.
     *     @type int|string $permission_denied_count
     *           Optional. Count of buckets with permission denied errors.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $permission_denied_bucket_ids
     *           Optional. Subset of bucket names that have permission denied.
     *     @type int|string $non_management_hub_entitled_count
     *           Optional. Count of buckets that are not subscribed to Storage
     *           Intelligence.
     *     @type int|string $internal_error_count
     *           Optional. Number of buckets that encountered internal errors during the
     *           validation process. These buckets are automatically retried in subsequent
     *           validation attempts.
     *     @type int|string $non_storage_intelligence_entitled_count
     *           Optional. Count of buckets that are not subscribed to Storage
     *           Intelligence.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $non_storage_intelligence_entitled_bucket_ids
     *           Optional. Subset of bucket names that are not subscribed to Storage
     *           Intelligence.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Storageinsights\V1\Storageinsights::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Count of successfully validated buckets.
     *
     * Generated from protobuf field <code>int64 validated_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getValidatedCount()
    {
        return $this->validated_count;
    }

    /**
     * Optional. Count of successfully validated buckets.
     *
     * Generated from protobuf field <code>int64 validated_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setValidatedCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->validated_count = $var;

        return $this;
    }

    /**
     * Optional. Count of buckets with permission denied errors.
     *
     * Generated from protobuf field <code>int64 permission_denied_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getPermissionDeniedCount()
    {
        return $this->permission_denied_count;
    }

    /**
     * Optional. Count of buckets with permission denied errors.
     *
     * Generated from protobuf field <code>int64 permission_denied_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setPermissionDeniedCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->permission_denied_count = $var;

        return $this;
    }

    /**
     * Optional. Subset of bucket names that have permission denied.
     *
     * Generated from protobuf field <code>repeated string permission_denied_bucket_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPermissionDeniedBucketIds()
    {
        return $this->permission_denied_bucket_ids;
    }

    /**
     * Optional. Subset of bucket names that have permission denied.
     *
     * Generated from protobuf field <code>repeated string permission_denied_bucket_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPermissionDeniedBucketIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->permission_denied_bucket_ids = $arr;

        return $this;
    }

    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_management_hub_entitled_count = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     * @deprecated
     */
    public function getNonManagementHubEntitledCount()
    {
        if ($this->non_management_hub_entitled_count !== 0) {
            @trigger_error('non_management_hub_entitled_count is deprecated.', E_USER_DEPRECATED);
        }
        return $this->non_management_hub_entitled_count;
    }

    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_management_hub_entitled_count = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     * @deprecated
     */
    public function setNonManagementHubEntitledCount($var)
    {
        @trigger_error('non_management_hub_entitled_count is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkInt64($var);
        $this->non_management_hub_entitled_count = $var;

        return $this;
    }

    /**
     * Optional. Number of buckets that encountered internal errors during the
     * validation process. These buckets are automatically retried in subsequent
     * validation attempts.
     *
     * Generated from protobuf field <code>int64 internal_error_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getInternalErrorCount()
    {
        return $this->internal_error_count;
    }

    /**
     * Optional. Number of buckets that encountered internal errors during the
     * validation process. These buckets are automatically retried in subsequent
     * validation attempts.
     *
     * Generated from protobuf field <code>int64 internal_error_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setInternalErrorCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->internal_error_count = $var;

        return $this;
    }

    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_storage_intelligence_entitled_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getNonStorageIntelligenceEntitledCount()
    {
        return $this->non_storage_intelligence_entitled_count;
    }

    /**
     * Optional. Count of buckets that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>int64 non_storage_intelligence_entitled_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setNonStorageIntelligenceEntitledCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->non_storage_intelligence_entitled_count = $var;

        return $this;
    }

    /**
     * Optional. Subset of bucket names that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>repeated string non_storage_intelligence_entitled_bucket_ids = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNonStorageIntelligenceEntitledBucketIds()
    {
        return $this->non_storage_intelligence_entitled_bucket_ids;
    }

    /**
     * Optional. Subset of bucket names that are not subscribed to Storage
     * Intelligence.
     *
     * Generated from protobuf field <code>repeated string non_storage_intelligence_entitled_bucket_ids = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNonStorageIntelligenceEntitledBucketIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->non_storage_intelligence_entitled_bucket_ids = $arr;

        return $this;
    }

}


