<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1beta/regions.proto

namespace Google\Shopping\Merchant\Accounts\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a geographic region that you can use as a target with both the
 * `RegionalInventory` and `ShippingSettings` services. You can define regions
 * as collections of either postal codes or, in some countries, using predefined
 * geotargets. For more information, see [Set up regions
 * ](https://support.google.com/merchants/answer/7410946#zippy=%2Ccreate-a-new-region)
 * for more information.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1beta.Region</code>
 */
class Region extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the region.
     * Format: `accounts/{account}/regions/{region}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The display name of the region.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = null;
    /**
     * Optional. A list of postal codes that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.PostalCodeArea postal_code_area = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $postal_code_area = null;
    /**
     * Optional. A list of geotargets that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.GeoTargetArea geotarget_area = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $geotarget_area = null;
    /**
     * Output only. Indicates if the region is eligible for use in the Regional
     * Inventory configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue regional_inventory_eligible = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $regional_inventory_eligible = null;
    /**
     * Output only. Indicates if the region is eligible for use in the Shipping
     * Services configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue shipping_eligible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $shipping_eligible = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the region.
     *           Format: `accounts/{account}/regions/{region}`
     *     @type string $display_name
     *           Optional. The display name of the region.
     *     @type \Google\Shopping\Merchant\Accounts\V1beta\Region\PostalCodeArea $postal_code_area
     *           Optional. A list of postal codes that defines the region area.
     *     @type \Google\Shopping\Merchant\Accounts\V1beta\Region\GeoTargetArea $geotarget_area
     *           Optional. A list of geotargets that defines the region area.
     *     @type \Google\Protobuf\BoolValue $regional_inventory_eligible
     *           Output only. Indicates if the region is eligible for use in the Regional
     *           Inventory configuration.
     *     @type \Google\Protobuf\BoolValue $shipping_eligible
     *           Output only. Indicates if the region is eligible for use in the Shipping
     *           Services configuration.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1Beta\Regions::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the region.
     * Format: `accounts/{account}/regions/{region}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the region.
     * Format: `accounts/{account}/regions/{region}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The display name of the region.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return isset($this->display_name) ? $this->display_name : '';
    }

    public function hasDisplayName()
    {
        return isset($this->display_name);
    }

    public function clearDisplayName()
    {
        unset($this->display_name);
    }

    /**
     * Optional. The display name of the region.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. A list of postal codes that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.PostalCodeArea postal_code_area = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Accounts\V1beta\Region\PostalCodeArea|null
     */
    public function getPostalCodeArea()
    {
        return $this->postal_code_area;
    }

    public function hasPostalCodeArea()
    {
        return isset($this->postal_code_area);
    }

    public function clearPostalCodeArea()
    {
        unset($this->postal_code_area);
    }

    /**
     * Optional. A list of postal codes that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.PostalCodeArea postal_code_area = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Accounts\V1beta\Region\PostalCodeArea $var
     * @return $this
     */
    public function setPostalCodeArea($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1beta\Region\PostalCodeArea::class);
        $this->postal_code_area = $var;

        return $this;
    }

    /**
     * Optional. A list of geotargets that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.GeoTargetArea geotarget_area = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Accounts\V1beta\Region\GeoTargetArea|null
     */
    public function getGeotargetArea()
    {
        return $this->geotarget_area;
    }

    public function hasGeotargetArea()
    {
        return isset($this->geotarget_area);
    }

    public function clearGeotargetArea()
    {
        unset($this->geotarget_area);
    }

    /**
     * Optional. A list of geotargets that defines the region area.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.Region.GeoTargetArea geotarget_area = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Accounts\V1beta\Region\GeoTargetArea $var
     * @return $this
     */
    public function setGeotargetArea($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1beta\Region\GeoTargetArea::class);
        $this->geotarget_area = $var;

        return $this;
    }

    /**
     * Output only. Indicates if the region is eligible for use in the Regional
     * Inventory configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue regional_inventory_eligible = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getRegionalInventoryEligible()
    {
        return $this->regional_inventory_eligible;
    }

    public function hasRegionalInventoryEligible()
    {
        return isset($this->regional_inventory_eligible);
    }

    public function clearRegionalInventoryEligible()
    {
        unset($this->regional_inventory_eligible);
    }

    /**
     * Returns the unboxed value from <code>getRegionalInventoryEligible()</code>

     * Output only. Indicates if the region is eligible for use in the Regional
     * Inventory configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue regional_inventory_eligible = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool|null
     */
    public function getRegionalInventoryEligibleUnwrapped()
    {
        return $this->readWrapperValue("regional_inventory_eligible");
    }

    /**
     * Output only. Indicates if the region is eligible for use in the Regional
     * Inventory configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue regional_inventory_eligible = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setRegionalInventoryEligible($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->regional_inventory_eligible = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Output only. Indicates if the region is eligible for use in the Regional
     * Inventory configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue regional_inventory_eligible = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setRegionalInventoryEligibleUnwrapped($var)
    {
        $this->writeWrapperValue("regional_inventory_eligible", $var);
        return $this;}

    /**
     * Output only. Indicates if the region is eligible for use in the Shipping
     * Services configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue shipping_eligible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getShippingEligible()
    {
        return $this->shipping_eligible;
    }

    public function hasShippingEligible()
    {
        return isset($this->shipping_eligible);
    }

    public function clearShippingEligible()
    {
        unset($this->shipping_eligible);
    }

    /**
     * Returns the unboxed value from <code>getShippingEligible()</code>

     * Output only. Indicates if the region is eligible for use in the Shipping
     * Services configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue shipping_eligible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool|null
     */
    public function getShippingEligibleUnwrapped()
    {
        return $this->readWrapperValue("shipping_eligible");
    }

    /**
     * Output only. Indicates if the region is eligible for use in the Shipping
     * Services configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue shipping_eligible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setShippingEligible($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->shipping_eligible = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Output only. Indicates if the region is eligible for use in the Shipping
     * Services configuration.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue shipping_eligible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setShippingEligibleUnwrapped($var)
    {
        $this->writeWrapperValue("shipping_eligible", $var);
        return $this;}

}

