<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/serving_config.proto

namespace Google\Cloud\DiscoveryEngine\V1\ServingConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies the configurations needed for Media Discovery. Currently we
 * support:
 * * `demote_content_watched`: Threshold for watched content demotion.
 * Customers can specify if using watched content demotion or use viewed
 * detail page. Using the content watched demotion, customers need to specify
 * the watched minutes or percentage exceeds the threshold, the content will
 * be demoted in the recommendation result.
 * * `promote_fresh_content`: cutoff days for fresh content promotion.
 * Customers can specify if using content freshness promotion. If the content
 * was published within the cutoff days, the content will be promoted in the
 * recommendation result.
 * Can only be set if
 * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
 * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.ServingConfig.MediaConfig</code>
 */
class MediaConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     *
     * Generated from protobuf field <code>string demotion_event_type = 1;</code>
     */
    protected $demotion_event_type = '';
    /**
     * Optional. Specifies the number of days to look back for demoting watched
     * content. If set to zero or unset, defaults to the maximum of 365 days.
     *
     * Generated from protobuf field <code>int32 demote_content_watched_past_days = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $demote_content_watched_past_days = 0;
    /**
     * Specifies the content freshness used for recommendation result.
     * Contents will be demoted if contents were published for more than content
     * freshness cutoff days.
     *
     * Generated from protobuf field <code>int32 content_freshness_cutoff_days = 4;</code>
     */
    protected $content_freshness_cutoff_days = 0;
    protected $demote_content_watched;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $content_watched_percentage_threshold
     *           Specifies the content watched percentage threshold for demotion.
     *           Threshold value must be between [0, 1.0] inclusive.
     *     @type float $content_watched_seconds_threshold
     *           Specifies the content watched minutes threshold for demotion.
     *     @type string $demotion_event_type
     *           Specifies the event type used for demoting recommendation result.
     *           Currently supported values:
     *           * `view-item`: Item viewed.
     *           * `media-play`: Start/resume watching a video, playing a song, etc.
     *           * `media-complete`: Finished or stopped midway through a video, song,
     *           etc.
     *           If unset, watch history demotion will not be applied. Content freshness
     *           demotion will still be applied.
     *     @type int $demote_content_watched_past_days
     *           Optional. Specifies the number of days to look back for demoting watched
     *           content. If set to zero or unset, defaults to the maximum of 365 days.
     *     @type int $content_freshness_cutoff_days
     *           Specifies the content freshness used for recommendation result.
     *           Contents will be demoted if contents were published for more than content
     *           freshness cutoff days.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\ServingConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     *
     * Generated from protobuf field <code>float content_watched_percentage_threshold = 2;</code>
     * @return float
     */
    public function getContentWatchedPercentageThreshold()
    {
        return $this->readOneof(2);
    }

    public function hasContentWatchedPercentageThreshold()
    {
        return $this->hasOneof(2);
    }

    /**
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     *
     * Generated from protobuf field <code>float content_watched_percentage_threshold = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setContentWatchedPercentageThreshold($var)
    {
        GPBUtil::checkFloat($var);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Specifies the content watched minutes threshold for demotion.
     *
     * Generated from protobuf field <code>float content_watched_seconds_threshold = 5;</code>
     * @return float
     */
    public function getContentWatchedSecondsThreshold()
    {
        return $this->readOneof(5);
    }

    public function hasContentWatchedSecondsThreshold()
    {
        return $this->hasOneof(5);
    }

    /**
     * Specifies the content watched minutes threshold for demotion.
     *
     * Generated from protobuf field <code>float content_watched_seconds_threshold = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setContentWatchedSecondsThreshold($var)
    {
        GPBUtil::checkFloat($var);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     *
     * Generated from protobuf field <code>string demotion_event_type = 1;</code>
     * @return string
     */
    public function getDemotionEventType()
    {
        return $this->demotion_event_type;
    }

    /**
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     *
     * Generated from protobuf field <code>string demotion_event_type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDemotionEventType($var)
    {
        GPBUtil::checkString($var, True);
        $this->demotion_event_type = $var;

        return $this;
    }

    /**
     * Optional. Specifies the number of days to look back for demoting watched
     * content. If set to zero or unset, defaults to the maximum of 365 days.
     *
     * Generated from protobuf field <code>int32 demote_content_watched_past_days = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDemoteContentWatchedPastDays()
    {
        return $this->demote_content_watched_past_days;
    }

    /**
     * Optional. Specifies the number of days to look back for demoting watched
     * content. If set to zero or unset, defaults to the maximum of 365 days.
     *
     * Generated from protobuf field <code>int32 demote_content_watched_past_days = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDemoteContentWatchedPastDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->demote_content_watched_past_days = $var;

        return $this;
    }

    /**
     * Specifies the content freshness used for recommendation result.
     * Contents will be demoted if contents were published for more than content
     * freshness cutoff days.
     *
     * Generated from protobuf field <code>int32 content_freshness_cutoff_days = 4;</code>
     * @return int
     */
    public function getContentFreshnessCutoffDays()
    {
        return $this->content_freshness_cutoff_days;
    }

    /**
     * Specifies the content freshness used for recommendation result.
     * Contents will be demoted if contents were published for more than content
     * freshness cutoff days.
     *
     * Generated from protobuf field <code>int32 content_freshness_cutoff_days = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setContentFreshnessCutoffDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->content_freshness_cutoff_days = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDemoteContentWatched()
    {
        return $this->whichOneof("demote_content_watched");
    }

}


