<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/transaction.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This message is used to select the transaction in which a
 * [Read][google.spanner.v1.Spanner.Read] or
 * [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] call runs.
 * See [TransactionOptions][google.spanner.v1.TransactionOptions] for more information about transactions.
 *
 * Generated from protobuf message <code>google.spanner.v1.TransactionSelector</code>
 */
class TransactionSelector extends \Google\Protobuf\Internal\Message
{
    protected $selector;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions $single_use
     *           Execute the read or SQL query in a temporary transaction.
     *           This is the most efficient way to execute a transaction that
     *           consists of a single SQL query.
     *     @type string $id
     *           Execute the read or SQL query in a previously-started transaction.
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions $begin
     *           Begin a new transaction and execute this read or SQL query in
     *           it. The transaction ID of the new transaction is returned in
     *           [ResultSetMetadata.transaction][google.spanner.v1.ResultSetMetadata.transaction], which is a [Transaction][google.spanner.v1.Transaction].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Transaction::initOnce();
        parent::__construct($data);
    }

    /**
     * Execute the read or SQL query in a temporary transaction.
     * This is the most efficient way to execute a transaction that
     * consists of a single SQL query.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions single_use = 1;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions
     */
    public function getSingleUse()
    {
        return $this->readOneof(1);
    }

    public function hasSingleUse()
    {
        return $this->hasOneof(1);
    }

    /**
     * Execute the read or SQL query in a temporary transaction.
     * This is the most efficient way to execute a transaction that
     * consists of a single SQL query.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions single_use = 1;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions $var
     * @return $this
     */
    public function setSingleUse($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Execute the read or SQL query in a previously-started transaction.
     *
     * Generated from protobuf field <code>bytes id = 2;</code>
     * @return string
     */
    public function getId()
    {
        return $this->readOneof(2);
    }

    public function hasId()
    {
        return $this->hasOneof(2);
    }

    /**
     * Execute the read or SQL query in a previously-started transaction.
     *
     * Generated from protobuf field <code>bytes id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Begin a new transaction and execute this read or SQL query in
     * it. The transaction ID of the new transaction is returned in
     * [ResultSetMetadata.transaction][google.spanner.v1.ResultSetMetadata.transaction], which is a [Transaction][google.spanner.v1.Transaction].
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions begin = 3;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions
     */
    public function getBegin()
    {
        return $this->readOneof(3);
    }

    public function hasBegin()
    {
        return $this->hasOneof(3);
    }

    /**
     * Begin a new transaction and execute this read or SQL query in
     * it. The transaction ID of the new transaction is returned in
     * [ResultSetMetadata.transaction][google.spanner.v1.ResultSetMetadata.transaction], which is a [Transaction][google.spanner.v1.Transaction].
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions begin = 3;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions $var
     * @return $this
     */
    public function setBegin($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getSelector()
    {
        return $this->whichOneof("selector");
    }

}

