<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/prediction_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for Predict method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.PredictRequest</code>
 */
class PredictRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Full resource name of the format:
     * {name=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}
     * The id of the recommendation engine placement. This id is used to identify
     * the set of models that will be used to make the prediction.
     * We currently support three placements with the following IDs by default:
     * * `shopping_cart`: Predicts products frequently bought together with one or
     *   more  products in the same shopping session. Commonly displayed after
     *   `add-to-cart` events, on product detail pages, or on the shopping cart
     *   page.
     * * `home_page`: Predicts the next product that a user will most likely
     *   engage with or purchase based on the shopping or viewing history of the
     *   specified `userId` or `visitorId`. For example - Recommendations for you.
     * * `product_detail`: Predicts the next product that a user will most likely
     *   engage with or purchase. The prediction is based on the shopping or
     *   viewing history of the specified `userId` or `visitorId` and its
     *   relevance to a specified `CatalogItem`. Typically used on product detail
     *   pages. For example - More products like this.
     * * `recently_viewed_default`: Returns up to 75 products recently viewed by
     *   the specified `userId` or `visitorId`, most recent ones first. Returns
     *   nothing if neither of them has viewed any products yet. For example -
     *   Recently viewed.
     * The full list of available placements can be seen at
     * https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $placement = '';
    /**
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $user_event = null;
    /**
     * Maximum number of results to return per page. Set this property
     * to the number of prediction results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     */
    private $page_size = 0;
    /**
     * The previous PredictResponse.next_page_token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     */
    private $page_token = '';
    /**
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     * Examples:
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     * If your filter blocks all prediction results, nothing will be returned. If
     * you want generic (unfiltered) popular products to be returned instead, set
     * `strictFiltering` to false in `PredictRequest.params`.
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     */
    private $filter = '';
    /**
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     *
     * Generated from protobuf field <code>bool validate_only = 6;</code>
     */
    private $validate_only = false;
    /**
     * Additional domain specific parameters for the predictions.
     * Allowed values:
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of an product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 7;</code>
     */
    private $params;
    /**
     * The labels for the predict request.
     *  * Label keys can contain lowercase letters, digits and hyphens, must start
     *    with a letter, and must end with a letter or digit.
     *  * Non-zero label values can contain lowercase letters, digits and hyphens,
     *    must start with a letter, and must end with a letter or digit.
     *  * No more than 64 labels can be associated with a given request.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8;</code>
     */
    private $labels;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $placement
     *           Required. Full resource name of the format:
     *           {name=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}
     *           The id of the recommendation engine placement. This id is used to identify
     *           the set of models that will be used to make the prediction.
     *           We currently support three placements with the following IDs by default:
     *           * `shopping_cart`: Predicts products frequently bought together with one or
     *             more  products in the same shopping session. Commonly displayed after
     *             `add-to-cart` events, on product detail pages, or on the shopping cart
     *             page.
     *           * `home_page`: Predicts the next product that a user will most likely
     *             engage with or purchase based on the shopping or viewing history of the
     *             specified `userId` or `visitorId`. For example - Recommendations for you.
     *           * `product_detail`: Predicts the next product that a user will most likely
     *             engage with or purchase. The prediction is based on the shopping or
     *             viewing history of the specified `userId` or `visitorId` and its
     *             relevance to a specified `CatalogItem`. Typically used on product detail
     *             pages. For example - More products like this.
     *           * `recently_viewed_default`: Returns up to 75 products recently viewed by
     *             the specified `userId` or `visitorId`, most recent ones first. Returns
     *             nothing if neither of them has viewed any products yet. For example -
     *             Recently viewed.
     *           The full list of available placements can be seen at
     *           https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements
     *     @type \Google\Cloud\Retail\V2\UserEvent $user_event
     *           Required. Context about the user, what they are looking at and what action
     *           they took to trigger the predict request. Note that this user event detail
     *           won't be ingested to userEvent logs. Thus, a separate userEvent write
     *           request is required for event logging.
     *     @type int $page_size
     *           Maximum number of results to return per page. Set this property
     *           to the number of prediction results needed. If zero, the service will
     *           choose a reasonable default. The maximum allowed value is 100. Values
     *           above 100 will be coerced to 100.
     *     @type string $page_token
     *           The previous PredictResponse.next_page_token.
     *     @type string $filter
     *           Filter for restricting prediction results with a length limit of 5,000
     *           characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *            * Tag expressions. Restricts predictions to products that match all of the
     *              specified tags. Boolean operators `OR` and `NOT` are supported if the
     *              expression is enclosed in parentheses, and must be separated from the
     *              tag values by a space. `-"tagA"` is also supported and is equivalent to
     *              `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *              with a size limit of 1,000 characters.
     *            * filterOutOfStockItems. Restricts predictions to products that do not
     *            have a
     *              stockState value of OUT_OF_STOCK.
     *           Examples:
     *            * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *            * filterOutOfStockItems  tag=(-"promotional")
     *            * filterOutOfStockItems
     *           If your filter blocks all prediction results, nothing will be returned. If
     *           you want generic (unfiltered) popular products to be returned instead, set
     *           `strictFiltering` to false in `PredictRequest.params`.
     *     @type bool $validate_only
     *           Use validate only mode for this prediction query. If set to true, a
     *           dummy model will be used that returns arbitrary products.
     *           Note that the validate only mode should only be used for testing the API,
     *           or if the model is not ready.
     *     @type array|\Google\Protobuf\Internal\MapField $params
     *           Additional domain specific parameters for the predictions.
     *           Allowed values:
     *           * `returnProduct`: Boolean. If set to true, the associated product
     *              object will be returned in the `results.metadata` field in the
     *              prediction response.
     *           * `returnScore`: Boolean. If set to true, the prediction 'score'
     *              corresponding to each returned product will be set in the
     *              `results.metadata` field in the prediction response. The given
     *              'score' indicates the probability of an product being clicked/purchased
     *              given the user's context and history.
     *           * `strictFiltering`: Boolean. True by default. If set to false, the service
     *              will return generic (unfiltered) popular products instead of empty if
     *              your filter blocks all prediction results.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels for the predict request.
     *            * Label keys can contain lowercase letters, digits and hyphens, must start
     *              with a letter, and must end with a letter or digit.
     *            * Non-zero label values can contain lowercase letters, digits and hyphens,
     *              must start with a letter, and must end with a letter or digit.
     *            * No more than 64 labels can be associated with a given request.
     *           See https://goo.gl/xmQnxf for more information on and examples of labels.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\PredictionService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Full resource name of the format:
     * {name=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}
     * The id of the recommendation engine placement. This id is used to identify
     * the set of models that will be used to make the prediction.
     * We currently support three placements with the following IDs by default:
     * * `shopping_cart`: Predicts products frequently bought together with one or
     *   more  products in the same shopping session. Commonly displayed after
     *   `add-to-cart` events, on product detail pages, or on the shopping cart
     *   page.
     * * `home_page`: Predicts the next product that a user will most likely
     *   engage with or purchase based on the shopping or viewing history of the
     *   specified `userId` or `visitorId`. For example - Recommendations for you.
     * * `product_detail`: Predicts the next product that a user will most likely
     *   engage with or purchase. The prediction is based on the shopping or
     *   viewing history of the specified `userId` or `visitorId` and its
     *   relevance to a specified `CatalogItem`. Typically used on product detail
     *   pages. For example - More products like this.
     * * `recently_viewed_default`: Returns up to 75 products recently viewed by
     *   the specified `userId` or `visitorId`, most recent ones first. Returns
     *   nothing if neither of them has viewed any products yet. For example -
     *   Recently viewed.
     * The full list of available placements can be seen at
     * https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPlacement()
    {
        return $this->placement;
    }

    /**
     * Required. Full resource name of the format:
     * {name=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}
     * The id of the recommendation engine placement. This id is used to identify
     * the set of models that will be used to make the prediction.
     * We currently support three placements with the following IDs by default:
     * * `shopping_cart`: Predicts products frequently bought together with one or
     *   more  products in the same shopping session. Commonly displayed after
     *   `add-to-cart` events, on product detail pages, or on the shopping cart
     *   page.
     * * `home_page`: Predicts the next product that a user will most likely
     *   engage with or purchase based on the shopping or viewing history of the
     *   specified `userId` or `visitorId`. For example - Recommendations for you.
     * * `product_detail`: Predicts the next product that a user will most likely
     *   engage with or purchase. The prediction is based on the shopping or
     *   viewing history of the specified `userId` or `visitorId` and its
     *   relevance to a specified `CatalogItem`. Typically used on product detail
     *   pages. For example - More products like this.
     * * `recently_viewed_default`: Returns up to 75 products recently viewed by
     *   the specified `userId` or `visitorId`, most recent ones first. Returns
     *   nothing if neither of them has viewed any products yet. For example -
     *   Recently viewed.
     * The full list of available placements can be seen at
     * https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPlacement($var)
    {
        GPBUtil::checkString($var, True);
        $this->placement = $var;

        return $this;
    }

    /**
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Retail\V2\UserEvent
     */
    public function getUserEvent()
    {
        return isset($this->user_event) ? $this->user_event : null;
    }

    public function hasUserEvent()
    {
        return isset($this->user_event);
    }

    public function clearUserEvent()
    {
        unset($this->user_event);
    }

    /**
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Retail\V2\UserEvent $var
     * @return $this
     */
    public function setUserEvent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\UserEvent::class);
        $this->user_event = $var;

        return $this;
    }

    /**
     * Maximum number of results to return per page. Set this property
     * to the number of prediction results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Maximum number of results to return per page. Set this property
     * to the number of prediction results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The previous PredictResponse.next_page_token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The previous PredictResponse.next_page_token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     * Examples:
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     * If your filter blocks all prediction results, nothing will be returned. If
     * you want generic (unfiltered) popular products to be returned instead, set
     * `strictFiltering` to false in `PredictRequest.params`.
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     * Examples:
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     * If your filter blocks all prediction results, nothing will be returned. If
     * you want generic (unfiltered) popular products to be returned instead, set
     * `strictFiltering` to false in `PredictRequest.params`.
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     *
     * Generated from protobuf field <code>bool validate_only = 6;</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     *
     * Generated from protobuf field <code>bool validate_only = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * Additional domain specific parameters for the predictions.
     * Allowed values:
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of an product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Additional domain specific parameters for the predictions.
     * Allowed values:
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of an product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParams($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->params = $arr;

        return $this;
    }

    /**
     * The labels for the predict request.
     *  * Label keys can contain lowercase letters, digits and hyphens, must start
     *    with a letter, and must end with a letter or digit.
     *  * Non-zero label values can contain lowercase letters, digits and hyphens,
     *    must start with a letter, and must end with a letter or digit.
     *  * No more than 64 labels can be associated with a given request.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels for the predict request.
     *  * Label keys can contain lowercase letters, digits and hyphens, must start
     *    with a letter, and must end with a letter or digit.
     *  * Non-zero label values can contain lowercase letters, digits and hyphens,
     *    must start with a letter, and must end with a letter or digit.
     *  * No more than 64 labels can be associated with a given request.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

}

