<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Parameters that describe the nodes in a cluster.
 *
 * Generated from protobuf message <code>google.container.v1.NodeConfig</code>
 */
class NodeConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     */
    private $machine_type = '';
    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     */
    private $disk_size_gb = 0;
    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     */
    private $oauth_scopes;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     */
    private $service_account = '';
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * The following keys are reserved for Windows nodes:
     *  - "serial-port-logging-enable"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     */
    private $metadata;
    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     */
    private $image_type = '';
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     */
    private $labels;
    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     */
    private $local_ssd_count = 0;
    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     */
    private $tags;
    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     */
    private $preemptible = false;
    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    private $accelerators;
    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     */
    private $disk_type = '';
    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     */
    private $min_cpu_platform = '';
    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    private $workload_metadata_config = null;
    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    private $taints;
    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    private $sandbox_config = null;
    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     */
    private $node_group = '';
    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    private $reservation_affinity = null;
    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    private $shielded_instance_config = null;
    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     */
    private $boot_disk_kms_key = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $machine_type
     *           The name of a Google Compute Engine [machine
     *           type](https://cloud.google.com/compute/docs/machine-types)
     *           If unspecified, the default machine type is `e2-medium`.
     *     @type int $disk_size_gb
     *           Size of the disk attached to each node, specified in GB.
     *           The smallest allowed disk size is 10GB.
     *           If unspecified, the default disk size is 100GB.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $oauth_scopes
     *           The set of Google API scopes to be made available on all of the
     *           node VMs under the "default" service account.
     *           The following scopes are recommended, but not required, and by default are
     *           not included:
     *           * `https://www.googleapis.com/auth/compute` is required for mounting
     *           persistent storage on your nodes.
     *           * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     *           communicating with **gcr.io**
     *           (the [Google Container
     *           Registry](https://cloud.google.com/container-registry/)).
     *           If unspecified, no scopes are added, unless Cloud Logging or Cloud
     *           Monitoring are enabled, in which case their required scopes will be added.
     *     @type string $service_account
     *           The Google Cloud Platform Service Account to be used by the node VMs.
     *           Specify the email address of the Service Account; otherwise, if no Service
     *           Account is specified, the "default" service account is used.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           The metadata key/value pairs assigned to instances in the cluster.
     *           Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     *           in length. These are reflected as part of a URL in the metadata server.
     *           Additionally, to avoid ambiguity, keys must not conflict with any other
     *           metadata keys for the project or be one of the reserved keys:
     *            - "cluster-location"
     *            - "cluster-name"
     *            - "cluster-uid"
     *            - "configure-sh"
     *            - "containerd-configure-sh"
     *            - "enable-os-login"
     *            - "gci-ensure-gke-docker"
     *            - "gci-metrics-enabled"
     *            - "gci-update-strategy"
     *            - "instance-template"
     *            - "kube-env"
     *            - "startup-script"
     *            - "user-data"
     *            - "disable-address-manager"
     *            - "windows-startup-script-ps1"
     *            - "common-psm1"
     *            - "k8s-node-setup-psm1"
     *            - "install-ssh-psm1"
     *            - "user-profile-psm1"
     *           The following keys are reserved for Windows nodes:
     *            - "serial-port-logging-enable"
     *           Values are free-form strings, and only have meaning as interpreted by
     *           the image running in the instance. The only restriction placed on them is
     *           that each value's size must be less than or equal to 32 KB.
     *           The total size of all keys and values must be less than 512 KB.
     *     @type string $image_type
     *           The image type to use for this node. Note that for a given image type,
     *           the latest version of it will be used.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *           These will added in addition to any default label(s) that
     *           Kubernetes may apply to the node.
     *           In case of conflict in label keys, the applied set may differ depending on
     *           the Kubernetes version -- it's best to assume the behavior is undefined
     *           and conflicts should be avoided.
     *           For more information, including usage and the valid values, see:
     *           https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *     @type int $local_ssd_count
     *           The number of local SSD disks to be attached to the node.
     *           The limit for this value is dependent upon the maximum number of
     *           disks available on a machine per zone. See:
     *           https://cloud.google.com/compute/docs/disks/local-ssd
     *           for more information.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $tags
     *           The list of instance tags applied to all nodes. Tags are used to identify
     *           valid sources or targets for network firewalls and are specified by
     *           the client during cluster or node pool creation. Each tag within the list
     *           must comply with RFC1035.
     *     @type bool $preemptible
     *           Whether the nodes are created as preemptible VM instances. See:
     *           https://cloud.google.com/compute/docs/instances/preemptible for more
     *           information about preemptible VM instances.
     *     @type \Google\Cloud\Container\V1\AcceleratorConfig[]|\Google\Protobuf\Internal\RepeatedField $accelerators
     *           A list of hardware accelerators to be attached to each node.
     *           See https://cloud.google.com/compute/docs/gpus for more information about
     *           support for GPUs.
     *     @type string $disk_type
     *           Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     *           'pd-balanced')
     *           If unspecified, the default disk type is 'pd-standard'
     *     @type string $min_cpu_platform
     *           Minimum CPU platform to be used by this instance. The instance may be
     *           scheduled on the specified or newer CPU platform. Applicable values are the
     *           friendly names of CPU platforms, such as
     *           `minCpuPlatform: "Intel Haswell"` or
     *           `minCpuPlatform: "Intel Sandy Bridge"`. For more
     *           information, read [how to specify min CPU
     *           platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *     @type \Google\Cloud\Container\V1\WorkloadMetadataConfig $workload_metadata_config
     *           The workload metadata configuration for this node.
     *     @type \Google\Cloud\Container\V1\NodeTaint[]|\Google\Protobuf\Internal\RepeatedField $taints
     *           List of kubernetes taints to be applied to each node.
     *           For more information, including usage and the valid values, see:
     *           https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *     @type \Google\Cloud\Container\V1\SandboxConfig $sandbox_config
     *           Sandbox configuration for this node.
     *     @type string $node_group
     *           Setting this field will assign instances of this
     *           pool to run on the specified node group. This is useful for running
     *           workloads on [sole tenant
     *           nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *     @type \Google\Cloud\Container\V1\ReservationAffinity $reservation_affinity
     *           The optional reservation affinity. Setting this field will apply
     *           the specified [Zonal Compute
     *           Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     *           to this node pool.
     *     @type \Google\Cloud\Container\V1\ShieldedInstanceConfig $shielded_instance_config
     *           Shielded Instance options.
     *     @type string $boot_disk_kms_key
     *           The Customer Managed Encryption Key used to encrypt the boot disk attached
     *           to each node in the node pool. This should be of the form
     *           projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     *           For more information about protecting resources with Cloud KMS Keys please
     *           see:
     *           https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     * @return int
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOauthScopes()
    {
        return $this->oauth_scopes;
    }

    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOauthScopes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->oauth_scopes = $arr;

        return $this;
    }

    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * The following keys are reserved for Windows nodes:
     *  - "serial-port-logging-enable"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * The following keys are reserved for Windows nodes:
     *  - "serial-port-logging-enable"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     * @return string
     */
    public function getImageType()
    {
        return $this->image_type;
    }

    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setImageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_type = $var;

        return $this;
    }

    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     * @return int
     */
    public function getLocalSsdCount()
    {
        return $this->local_ssd_count;
    }

    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setLocalSsdCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->local_ssd_count = $var;

        return $this;
    }

    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     * @return bool
     */
    public function getPreemptible()
    {
        return $this->preemptible;
    }

    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setPreemptible($var)
    {
        GPBUtil::checkBool($var);
        $this->preemptible = $var;

        return $this;
    }

    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAccelerators()
    {
        return $this->accelerators;
    }

    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     * @param \Google\Cloud\Container\V1\AcceleratorConfig[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAccelerators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\AcceleratorConfig::class);
        $this->accelerators = $arr;

        return $this;
    }

    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     * @return string
     */
    public function getDiskType()
    {
        return $this->disk_type;
    }

    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskType($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_type = $var;

        return $this;
    }

    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     * @return string
     */
    public function getMinCpuPlatform()
    {
        return $this->min_cpu_platform;
    }

    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setMinCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->min_cpu_platform = $var;

        return $this;
    }

    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     * @return \Google\Cloud\Container\V1\WorkloadMetadataConfig
     */
    public function getWorkloadMetadataConfig()
    {
        return isset($this->workload_metadata_config) ? $this->workload_metadata_config : null;
    }

    public function hasWorkloadMetadataConfig()
    {
        return isset($this->workload_metadata_config);
    }

    public function clearWorkloadMetadataConfig()
    {
        unset($this->workload_metadata_config);
    }

    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     * @param \Google\Cloud\Container\V1\WorkloadMetadataConfig $var
     * @return $this
     */
    public function setWorkloadMetadataConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadMetadataConfig::class);
        $this->workload_metadata_config = $var;

        return $this;
    }

    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTaints()
    {
        return $this->taints;
    }

    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     * @param \Google\Cloud\Container\V1\NodeTaint[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTaints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\NodeTaint::class);
        $this->taints = $arr;

        return $this;
    }

    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     * @return \Google\Cloud\Container\V1\SandboxConfig
     */
    public function getSandboxConfig()
    {
        return isset($this->sandbox_config) ? $this->sandbox_config : null;
    }

    public function hasSandboxConfig()
    {
        return isset($this->sandbox_config);
    }

    public function clearSandboxConfig()
    {
        unset($this->sandbox_config);
    }

    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     * @param \Google\Cloud\Container\V1\SandboxConfig $var
     * @return $this
     */
    public function setSandboxConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\SandboxConfig::class);
        $this->sandbox_config = $var;

        return $this;
    }

    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     * @return string
     */
    public function getNodeGroup()
    {
        return $this->node_group;
    }

    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setNodeGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->node_group = $var;

        return $this;
    }

    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     * @return \Google\Cloud\Container\V1\ReservationAffinity
     */
    public function getReservationAffinity()
    {
        return isset($this->reservation_affinity) ? $this->reservation_affinity : null;
    }

    public function hasReservationAffinity()
    {
        return isset($this->reservation_affinity);
    }

    public function clearReservationAffinity()
    {
        unset($this->reservation_affinity);
    }

    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     * @param \Google\Cloud\Container\V1\ReservationAffinity $var
     * @return $this
     */
    public function setReservationAffinity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ReservationAffinity::class);
        $this->reservation_affinity = $var;

        return $this;
    }

    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     * @return \Google\Cloud\Container\V1\ShieldedInstanceConfig
     */
    public function getShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config) ? $this->shielded_instance_config : null;
    }

    public function hasShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config);
    }

    public function clearShieldedInstanceConfig()
    {
        unset($this->shielded_instance_config);
    }

    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     * @param \Google\Cloud\Container\V1\ShieldedInstanceConfig $var
     * @return $this
     */
    public function setShieldedInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ShieldedInstanceConfig::class);
        $this->shielded_instance_config = $var;

        return $this;
    }

    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     * @return string
     */
    public function getBootDiskKmsKey()
    {
        return $this->boot_disk_kms_key;
    }

    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setBootDiskKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->boot_disk_kms_key = $var;

        return $this;
    }

}

