<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Interconnect Attachment (VLAN) resource.
 * You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read  Creating VLAN Attachments. (== resource_for {$api_version}.interconnectAttachments ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.InterconnectAttachment</code>
 */
class InterconnectAttachment extends \Google\Protobuf\Internal\Message
{
    /**
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     */
    private $admin_enabled = false;
    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
     * - BPS_50M: 50 Mbit/s
     * - BPS_100M: 100 Mbit/s
     * - BPS_200M: 200 Mbit/s
     * - BPS_300M: 300 Mbit/s
     * - BPS_400M: 400 Mbit/s
     * - BPS_500M: 500 Mbit/s
     * - BPS_1G: 1 Gbit/s
     * - BPS_2G: 2 Gbit/s
     * - BPS_5G: 5 Gbit/s
     * - BPS_10G: 10 Gbit/s
     * - BPS_20G: 20 Gbit/s
     * - BPS_50G: 50 Gbit/s
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Bandwidth bandwidth = 181715121;</code>
     */
    private $bandwidth = 0;
    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     */
    private $candidate_subnets;
    /**
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string cloud_router_ip_address = 18957320;</code>
     */
    private $cloud_router_ip_address = '';
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string customer_router_ip_address = 64040305;</code>
     */
    private $customer_router_ip_address = '';
    /**
     * [Output Only] Dataplane version for this InterconnectAttachment.
     *
     * Generated from protobuf field <code>int32 dataplane_version = 34920075;</code>
     */
    private $dataplane_version = 0;
    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
     * - AVAILABILITY_DOMAIN_ANY
     * - AVAILABILITY_DOMAIN_1
     * - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.EdgeAvailabilityDomain edge_availability_domain = 71289510;</code>
     */
    private $edge_availability_domain = 0;
    /**
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     */
    private $google_reference_id = '';
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *
     * Generated from protobuf field <code>string interconnect = 224601230;</code>
     */
    private $interconnect = '';
    /**
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *
     * Generated from protobuf field <code>int32 mtu = 108462;</code>
     */
    private $mtu = 0;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
     * - OS_ACTIVE: The attachment has been turned up and is ready to use.
     * - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.OperationalStatus operational_status = 201070847;</code>
     */
    private $operational_status = 0;
    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>string pairing_key = 171260008;</code>
     */
    private $pairing_key = '';
    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>string partner_asn = 169730693;</code>
     */
    private $partner_asn = '';
    /**
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     */
    private $partner_metadata = null;
    /**
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     */
    private $private_interconnect_info = null;
    /**
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = '';
    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>string router = 148608841;</code>
     */
    private $router = '';
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
     * - ACTIVE: The attachment has been turned up and is ready to use.
     * - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
     * - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     * - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
     * - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.State state = 109757585;</code>
     */
    private $state = 0;
    /**
     * The type of interconnect attachment this is, which can take one of the following values:
     * - DEDICATED: an attachment to a Dedicated Interconnect.
     * - PARTNER: an attachment to a Partner Interconnect, created by the customer.
     * - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Type type = 3575610;</code>
     */
    private $type = 0;
    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
     *
     * Generated from protobuf field <code>int32 vlan_tag8021q = 119927836;</code>
     */
    private $vlan_tag8021q = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $admin_enabled
     *           Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     *     @type int $bandwidth
     *           Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
     *           - BPS_50M: 50 Mbit/s
     *           - BPS_100M: 100 Mbit/s
     *           - BPS_200M: 200 Mbit/s
     *           - BPS_300M: 300 Mbit/s
     *           - BPS_400M: 400 Mbit/s
     *           - BPS_500M: 500 Mbit/s
     *           - BPS_1G: 1 Gbit/s
     *           - BPS_2G: 2 Gbit/s
     *           - BPS_5G: 5 Gbit/s
     *           - BPS_10G: 10 Gbit/s
     *           - BPS_20G: 20 Gbit/s
     *           - BPS_50G: 50 Gbit/s
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $candidate_subnets
     *           Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     *     @type string $cloud_router_ip_address
     *           [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $customer_router_ip_address
     *           [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     *     @type int $dataplane_version
     *           [Output Only] Dataplane version for this InterconnectAttachment.
     *     @type string $description
     *           An optional description of this resource.
     *     @type int $edge_availability_domain
     *           Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
     *           - AVAILABILITY_DOMAIN_ANY
     *           - AVAILABILITY_DOMAIN_1
     *           - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *     @type string $google_reference_id
     *           [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $interconnect
     *           URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     *     @type int $mtu
     *           Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type int $operational_status
     *           [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
     *           - OS_ACTIVE: The attachment has been turned up and is ready to use.
     *           - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     *     @type string $pairing_key
     *           [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     *     @type string $partner_asn
     *           Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata $partner_metadata
     *           Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo $private_interconnect_info
     *           [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     *     @type string $region
     *           [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type string $router
     *           URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type int $state
     *           [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
     *           - ACTIVE: The attachment has been turned up and is ready to use.
     *           - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     *           - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
     *           - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     *           - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
     *           - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     *     @type int $type
     *           The type of interconnect attachment this is, which can take one of the following values:
     *           - DEDICATED: an attachment to a Dedicated Interconnect.
     *           - PARTNER: an attachment to a Partner Interconnect, created by the customer.
     *           - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     *     @type int $vlan_tag8021q
     *           The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     * @return bool
     */
    public function getAdminEnabled()
    {
        return $this->admin_enabled;
    }

    /**
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_enabled = $var;

        return $this;
    }

    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
     * - BPS_50M: 50 Mbit/s
     * - BPS_100M: 100 Mbit/s
     * - BPS_200M: 200 Mbit/s
     * - BPS_300M: 300 Mbit/s
     * - BPS_400M: 400 Mbit/s
     * - BPS_500M: 500 Mbit/s
     * - BPS_1G: 1 Gbit/s
     * - BPS_2G: 2 Gbit/s
     * - BPS_5G: 5 Gbit/s
     * - BPS_10G: 10 Gbit/s
     * - BPS_20G: 20 Gbit/s
     * - BPS_50G: 50 Gbit/s
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Bandwidth bandwidth = 181715121;</code>
     * @return int
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }

    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
     * - BPS_50M: 50 Mbit/s
     * - BPS_100M: 100 Mbit/s
     * - BPS_200M: 200 Mbit/s
     * - BPS_300M: 300 Mbit/s
     * - BPS_400M: 400 Mbit/s
     * - BPS_500M: 500 Mbit/s
     * - BPS_1G: 1 Gbit/s
     * - BPS_2G: 2 Gbit/s
     * - BPS_5G: 5 Gbit/s
     * - BPS_10G: 10 Gbit/s
     * - BPS_20G: 20 Gbit/s
     * - BPS_50G: 50 Gbit/s
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Bandwidth bandwidth = 181715121;</code>
     * @param int $var
     * @return $this
     */
    public function setBandwidth($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\InterconnectAttachment\Bandwidth::class);
        $this->bandwidth = $var;

        return $this;
    }

    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCandidateSubnets()
    {
        return $this->candidate_subnets;
    }

    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCandidateSubnets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->candidate_subnets = $arr;

        return $this;
    }

    /**
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string cloud_router_ip_address = 18957320;</code>
     * @return string
     */
    public function getCloudRouterIpAddress()
    {
        return $this->cloud_router_ip_address;
    }

    /**
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string cloud_router_ip_address = 18957320;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_router_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string customer_router_ip_address = 64040305;</code>
     * @return string
     */
    public function getCustomerRouterIpAddress()
    {
        return $this->customer_router_ip_address;
    }

    /**
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>string customer_router_ip_address = 64040305;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_router_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Dataplane version for this InterconnectAttachment.
     *
     * Generated from protobuf field <code>int32 dataplane_version = 34920075;</code>
     * @return int
     */
    public function getDataplaneVersion()
    {
        return $this->dataplane_version;
    }

    /**
     * [Output Only] Dataplane version for this InterconnectAttachment.
     *
     * Generated from protobuf field <code>int32 dataplane_version = 34920075;</code>
     * @param int $var
     * @return $this
     */
    public function setDataplaneVersion($var)
    {
        GPBUtil::checkInt32($var);
        $this->dataplane_version = $var;

        return $this;
    }

    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
     * - AVAILABILITY_DOMAIN_ANY
     * - AVAILABILITY_DOMAIN_1
     * - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.EdgeAvailabilityDomain edge_availability_domain = 71289510;</code>
     * @return int
     */
    public function getEdgeAvailabilityDomain()
    {
        return $this->edge_availability_domain;
    }

    /**
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
     * - AVAILABILITY_DOMAIN_ANY
     * - AVAILABILITY_DOMAIN_1
     * - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.EdgeAvailabilityDomain edge_availability_domain = 71289510;</code>
     * @param int $var
     * @return $this
     */
    public function setEdgeAvailabilityDomain($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\InterconnectAttachment\EdgeAvailabilityDomain::class);
        $this->edge_availability_domain = $var;

        return $this;
    }

    /**
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     * @return string
     */
    public function getGoogleReferenceId()
    {
        return $this->google_reference_id;
    }

    /**
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleReferenceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_reference_id = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *
     * Generated from protobuf field <code>string interconnect = 224601230;</code>
     * @return string
     */
    public function getInterconnect()
    {
        return $this->interconnect;
    }

    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *
     * Generated from protobuf field <code>string interconnect = 224601230;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnect($var)
    {
        GPBUtil::checkString($var, True);
        $this->interconnect = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *
     * Generated from protobuf field <code>int32 mtu = 108462;</code>
     * @return int
     */
    public function getMtu()
    {
        return $this->mtu;
    }

    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *
     * Generated from protobuf field <code>int32 mtu = 108462;</code>
     * @param int $var
     * @return $this
     */
    public function setMtu($var)
    {
        GPBUtil::checkInt32($var);
        $this->mtu = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
     * - OS_ACTIVE: The attachment has been turned up and is ready to use.
     * - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.OperationalStatus operational_status = 201070847;</code>
     * @return int
     */
    public function getOperationalStatus()
    {
        return $this->operational_status;
    }

    /**
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
     * - OS_ACTIVE: The attachment has been turned up and is ready to use.
     * - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.OperationalStatus operational_status = 201070847;</code>
     * @param int $var
     * @return $this
     */
    public function setOperationalStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\InterconnectAttachment\OperationalStatus::class);
        $this->operational_status = $var;

        return $this;
    }

    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>string pairing_key = 171260008;</code>
     * @return string
     */
    public function getPairingKey()
    {
        return $this->pairing_key;
    }

    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>string pairing_key = 171260008;</code>
     * @param string $var
     * @return $this
     */
    public function setPairingKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->pairing_key = $var;

        return $this;
    }

    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>string partner_asn = 169730693;</code>
     * @return string
     */
    public function getPartnerAsn()
    {
        return $this->partner_asn;
    }

    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>string partner_asn = 169730693;</code>
     * @param string $var
     * @return $this
     */
    public function setPartnerAsn($var)
    {
        GPBUtil::checkString($var, True);
        $this->partner_asn = $var;

        return $this;
    }

    /**
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata
     */
    public function getPartnerMetadata()
    {
        return isset($this->partner_metadata) ? $this->partner_metadata : null;
    }

    public function hasPartnerMetadata()
    {
        return isset($this->partner_metadata);
    }

    public function clearPartnerMetadata()
    {
        unset($this->partner_metadata);
    }

    /**
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata $var
     * @return $this
     */
    public function setPartnerMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata::class);
        $this->partner_metadata = $var;

        return $this;
    }

    /**
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo
     */
    public function getPrivateInterconnectInfo()
    {
        return isset($this->private_interconnect_info) ? $this->private_interconnect_info : null;
    }

    public function hasPrivateInterconnectInfo()
    {
        return isset($this->private_interconnect_info);
    }

    public function clearPrivateInterconnectInfo()
    {
        unset($this->private_interconnect_info);
    }

    /**
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo $var
     * @return $this
     */
    public function setPrivateInterconnectInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo::class);
        $this->private_interconnect_info = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>string router = 148608841;</code>
     * @return string
     */
    public function getRouter()
    {
        return $this->router;
    }

    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>string router = 148608841;</code>
     * @param string $var
     * @return $this
     */
    public function setRouter($var)
    {
        GPBUtil::checkString($var, True);
        $this->router = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
     * - ACTIVE: The attachment has been turned up and is ready to use.
     * - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
     * - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     * - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
     * - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.State state = 109757585;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
     * - ACTIVE: The attachment has been turned up and is ready to use.
     * - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
     * - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     * - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
     * - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.State state = 109757585;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\InterconnectAttachment\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The type of interconnect attachment this is, which can take one of the following values:
     * - DEDICATED: an attachment to a Dedicated Interconnect.
     * - PARTNER: an attachment to a Partner Interconnect, created by the customer.
     * - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Type type = 3575610;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of interconnect attachment this is, which can take one of the following values:
     * - DEDICATED: an attachment to a Dedicated Interconnect.
     * - PARTNER: an attachment to a Partner Interconnect, created by the customer.
     * - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InterconnectAttachment.Type type = 3575610;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\InterconnectAttachment\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
     *
     * Generated from protobuf field <code>int32 vlan_tag8021q = 119927836;</code>
     * @return int
     */
    public function getVlanTag8021Q()
    {
        return $this->vlan_tag8021q;
    }

    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
     *
     * Generated from protobuf field <code>int32 vlan_tag8021q = 119927836;</code>
     * @param int $var
     * @return $this
     */
    public function setVlanTag8021Q($var)
    {
        GPBUtil::checkInt32($var);
        $this->vlan_tag8021q = $var;

        return $this;
    }

}

