<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

namespace Google\Cloud\VmwareEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Private connection resource that provides connectivity for VMware Engine
 * private clouds.
 *
 * Generated from protobuf message <code>google.cloud.vmwareengine.v1.PrivateConnection</code>
 */
class PrivateConnection extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the private connection.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/privateConnections/my-connection`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. User-provided description for this private connection.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. State of the private connection.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Required. The relative resource name of Legacy VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}`, `{location}` will be same as specified in private
     * connection resource name and `{vmware_engine_network_id}` will be in the
     * form of `{location}`-default e.g.
     * projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $vmware_engine_network = '';
    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $vmware_engine_network_canonical = '';
    /**
     * Required. Private connection type.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.Type type = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $type = 0;
    /**
     * Output only. VPC network peering id between given network VPC and
     * VMwareEngineNetwork.
     *
     * Generated from protobuf field <code>string peering_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $peering_id = '';
    /**
     * Optional. Routing Mode.
     * Default value is set to GLOBAL.
     * For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
     * REGIONAL, for other types only GLOBAL is supported.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode routing_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $routing_mode = 0;
    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Required. Service network to create private connection.
     * Specify the name in the following form:
     * `projects/{project}/global/networks/{network_id}`
     * For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
     * VPC, e.g. projects/project-tp/global/networks/servicenetworking.
     * For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
     * e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
     * For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
     * projects/project-tp/global/networks/dell-tenant-vpc.
     * For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
     * any other producer VPC to which the VMware Engine Network needs to be
     * connected, e.g. projects/project/global/networks/vpc.
     *
     * Generated from protobuf field <code>string service_network = 16 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $service_network = '';
    /**
     * Output only. Peering state between service network and VMware Engine
     * network.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.PeeringState peering_state = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $peering_state = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the private connection.
     *           Resource names are schemeless URIs that follow the conventions in
     *           https://cloud.google.com/apis/design/resource_names.
     *           For example:
     *           `projects/my-project/locations/us-central1/privateConnections/my-connection`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Creation time of this resource.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last update time of this resource.
     *     @type string $description
     *           Optional. User-provided description for this private connection.
     *     @type int $state
     *           Output only. State of the private connection.
     *     @type string $vmware_engine_network
     *           Required. The relative resource name of Legacy VMware Engine network.
     *           Specify the name in the following form:
     *           `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *           where `{project}`, `{location}` will be same as specified in private
     *           connection resource name and `{vmware_engine_network_id}` will be in the
     *           form of `{location}`-default e.g.
     *           projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
     *     @type string $vmware_engine_network_canonical
     *           Output only. The canonical name of the VMware Engine network in the form:
     *           `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *     @type int $type
     *           Required. Private connection type.
     *     @type string $peering_id
     *           Output only. VPC network peering id between given network VPC and
     *           VMwareEngineNetwork.
     *     @type int $routing_mode
     *           Optional. Routing Mode.
     *           Default value is set to GLOBAL.
     *           For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
     *           REGIONAL, for other types only GLOBAL is supported.
     *     @type string $uid
     *           Output only. System-generated unique identifier for the resource.
     *     @type string $service_network
     *           Required. Service network to create private connection.
     *           Specify the name in the following form:
     *           `projects/{project}/global/networks/{network_id}`
     *           For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
     *           VPC, e.g. projects/project-tp/global/networks/servicenetworking.
     *           For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
     *           e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
     *           For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
     *           projects/project-tp/global/networks/dell-tenant-vpc.
     *           For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
     *           any other producer VPC to which the VMware Engine Network needs to be
     *           connected, e.g. projects/project/global/networks/vpc.
     *     @type int $peering_state
     *           Output only. Peering state between service network and VMware Engine
     *           network.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vmwareengine\V1\VmwareengineResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the private connection.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/privateConnections/my-connection`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the private connection.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/privateConnections/my-connection`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. User-provided description for this private connection.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. User-provided description for this private connection.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. State of the private connection.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the private connection.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\PrivateConnection\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Required. The relative resource name of Legacy VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}`, `{location}` will be same as specified in private
     * connection resource name and `{vmware_engine_network_id}` will be in the
     * form of `{location}`-default e.g.
     * projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVmwareEngineNetwork()
    {
        return $this->vmware_engine_network;
    }

    /**
     * Required. The relative resource name of Legacy VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}`, `{location}` will be same as specified in private
     * connection resource name and `{vmware_engine_network_id}` will be in the
     * form of `{location}`-default e.g.
     * projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVmwareEngineNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->vmware_engine_network = $var;

        return $this;
    }

    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVmwareEngineNetworkCanonical()
    {
        return $this->vmware_engine_network_canonical;
    }

    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVmwareEngineNetworkCanonical($var)
    {
        GPBUtil::checkString($var, True);
        $this->vmware_engine_network_canonical = $var;

        return $this;
    }

    /**
     * Required. Private connection type.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.Type type = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Required. Private connection type.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.Type type = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\PrivateConnection\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. VPC network peering id between given network VPC and
     * VMwareEngineNetwork.
     *
     * Generated from protobuf field <code>string peering_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPeeringId()
    {
        return $this->peering_id;
    }

    /**
     * Output only. VPC network peering id between given network VPC and
     * VMwareEngineNetwork.
     *
     * Generated from protobuf field <code>string peering_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPeeringId($var)
    {
        GPBUtil::checkString($var, True);
        $this->peering_id = $var;

        return $this;
    }

    /**
     * Optional. Routing Mode.
     * Default value is set to GLOBAL.
     * For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
     * REGIONAL, for other types only GLOBAL is supported.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode routing_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRoutingMode()
    {
        return $this->routing_mode;
    }

    /**
     * Optional. Routing Mode.
     * Default value is set to GLOBAL.
     * For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
     * REGIONAL, for other types only GLOBAL is supported.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode routing_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRoutingMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\PrivateConnection\RoutingMode::class);
        $this->routing_mode = $var;

        return $this;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Required. Service network to create private connection.
     * Specify the name in the following form:
     * `projects/{project}/global/networks/{network_id}`
     * For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
     * VPC, e.g. projects/project-tp/global/networks/servicenetworking.
     * For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
     * e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
     * For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
     * projects/project-tp/global/networks/dell-tenant-vpc.
     * For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
     * any other producer VPC to which the VMware Engine Network needs to be
     * connected, e.g. projects/project/global/networks/vpc.
     *
     * Generated from protobuf field <code>string service_network = 16 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceNetwork()
    {
        return $this->service_network;
    }

    /**
     * Required. Service network to create private connection.
     * Specify the name in the following form:
     * `projects/{project}/global/networks/{network_id}`
     * For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
     * VPC, e.g. projects/project-tp/global/networks/servicenetworking.
     * For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
     * e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
     * For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
     * projects/project-tp/global/networks/dell-tenant-vpc.
     * For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
     * any other producer VPC to which the VMware Engine Network needs to be
     * connected, e.g. projects/project/global/networks/vpc.
     *
     * Generated from protobuf field <code>string service_network = 16 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_network = $var;

        return $this;
    }

    /**
     * Output only. Peering state between service network and VMware Engine
     * network.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.PeeringState peering_state = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getPeeringState()
    {
        return $this->peering_state;
    }

    /**
     * Output only. Peering state between service network and VMware Engine
     * network.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.PrivateConnection.PeeringState peering_state = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setPeeringState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\PrivateConnection\PeeringState::class);
        $this->peering_state = $var;

        return $this;
    }

}

