<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/products/v1/products_common.proto

namespace Google\Shopping\Merchant\Products\V1\ProductAttributes;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Carrier-based shipping configuration. Allows for setting shipping speed or
 * shipping cost based on a carrier's provided info.
 *
 * Generated from protobuf message <code>google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping</code>
 */
class CarrierShipping extends \Google\Protobuf\Internal\Message
{
    /**
     * The [CLDR territory
     * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
     * of the country to which an item will ship.
     *
     * Generated from protobuf field <code>optional string country = 1;</code>
     */
    protected $country = null;
    /**
     * The geographic region to which a shipping rate applies.
     * See [region](https://support.google.com/merchants/answer/6324484) for
     * more information.
     *
     * Generated from protobuf field <code>optional string region = 2;</code>
     */
    protected $region = null;
    /**
     * The postal code range that the shipping rate applies to, represented by
     * a postal code (eg. `94043`), a postal code prefix followed by a *
     * wildcard (eg. `94*`), a range between two postal codes (eg.
     * `94043-98033`) or two postal code prefixes of equal length (eg.
     * `94*-98*`).
     *
     * Generated from protobuf field <code>optional string postal_code = 3;</code>
     */
    protected $postal_code = null;
    /**
     * The source location postal code from which this offer ships. Represented
     * only by a full-length postal code.
     *
     * Generated from protobuf field <code>optional string origin_postal_code = 4;</code>
     */
    protected $origin_postal_code = null;
    /**
     * Fixed shipping price, represented as a number with currency. Cannot be
     * set together with
     * [carrierPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price]
     * or its adjustments
     * ([carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment],
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment]).
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price flat_price = 5;</code>
     */
    protected $flat_price = null;
    /**
     * Selected carrier to calculate the shipping price from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Price will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate shipping price.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.ProductAttributes.CarrierPriceOption carrier_price = 6;</code>
     */
    protected $carrier_price = null;
    /**
     * A flat adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment].
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price carrier_price_flat_adjustment = 7;</code>
     */
    protected $carrier_price_flat_adjustment = null;
    /**
     * A percentual adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment].
     *
     * Generated from protobuf field <code>optional double carrier_price_percentage_adjustment = 8;</code>
     */
    protected $carrier_price_percentage_adjustment = null;
    /**
     * Minimum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time.
     * [minHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.min_handling_time]
     * can only be set if
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * is also set.
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 9;</code>
     */
    protected $min_handling_time = null;
    /**
     * Maximum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time. Both
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * and
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * are required if providing shipping speeds.
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 10;</code>
     */
    protected $max_handling_time = null;
    /**
     * Minimum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships.
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time]
     * can only be set if
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * is set. Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_min_transit_time = 11;</code>
     */
    protected $fixed_min_transit_time = null;
    /**
     * Maximum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships. Needs to be provided together with
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time].
     * Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_max_transit_time = 12;</code>
     */
    protected $fixed_max_transit_time = null;
    /**
     * Selected carrier to calculate the shipping speed from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Speed will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate delivery speed.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.CarrierTransitTimeOption carrier_transit_time = 13;</code>
     */
    protected $carrier_transit_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $country
     *           The [CLDR territory
     *           code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
     *           of the country to which an item will ship.
     *     @type string $region
     *           The geographic region to which a shipping rate applies.
     *           See [region](https://support.google.com/merchants/answer/6324484) for
     *           more information.
     *     @type string $postal_code
     *           The postal code range that the shipping rate applies to, represented by
     *           a postal code (eg. `94043`), a postal code prefix followed by a *
     *           wildcard (eg. `94*`), a range between two postal codes (eg.
     *           `94043-98033`) or two postal code prefixes of equal length (eg.
     *           `94*-98*`).
     *     @type string $origin_postal_code
     *           The source location postal code from which this offer ships. Represented
     *           only by a full-length postal code.
     *     @type \Google\Shopping\Type\Price $flat_price
     *           Fixed shipping price, represented as a number with currency. Cannot be
     *           set together with
     *           [carrierPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price]
     *           or its adjustments
     *           ([carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment],
     *           [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment]).
     *     @type int $carrier_price
     *           Selected carrier to calculate the shipping price from. Select a carrier
     *           from the [available carriers
     *           list](https://support.google.com/merchants/answer/15449142#Supported),
     *           for example `AUSTRALIA_POST_REGULAR`. Price will be calculated by this
     *           selected carrier, the location expressed in
     *           [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     *           along with the user location to determine the accurate shipping price.
     *           Carrier is represented by a carrier service name or a carrier service ID.
     *           Cannot be set together with
     *           [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price].
     *     @type \Google\Shopping\Type\Price $carrier_price_flat_adjustment
     *           A flat adjustment on the carrier price. Can be either positive or
     *           negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     *           be set together with
     *           [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     *           and
     *           [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment].
     *     @type float $carrier_price_percentage_adjustment
     *           A percentual adjustment on the carrier price. Can be either positive or
     *           negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     *           be set together with
     *           [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     *           and
     *           [carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment].
     *     @type int|string $min_handling_time
     *           Minimum handling time (inclusive) between when the order is received and
     *           shipped in business days. 0 means that the order is shipped on the same
     *           day as it is received if it happens before the cut-off time.
     *           [minHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.min_handling_time]
     *           can only be set if
     *           [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     *           is also set.
     *     @type int|string $max_handling_time
     *           Maximum handling time (inclusive) between when the order is received and
     *           shipped in business days. 0 means that the order is shipped on the same
     *           day as it is received if it happens before the cut-off time. Both
     *           [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     *           and
     *           [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     *           or
     *           [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     *           are required if providing shipping speeds.
     *     @type int|string $fixed_min_transit_time
     *           Minimum transit time (inclusive) between when the order has shipped and
     *           when it is delivered in business days. 0 means that the order is
     *           delivered on the same day as it ships.
     *           [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time]
     *           can only be set if
     *           [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     *           is set. Cannot be set if
     *           [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     *           is present.
     *     @type int|string $fixed_max_transit_time
     *           Maximum transit time (inclusive) between when the order has shipped and
     *           when it is delivered in business days. 0 means that the order is
     *           delivered on the same day as it ships. Needs to be provided together with
     *           [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time].
     *           Cannot be set if
     *           [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     *           is present.
     *     @type int $carrier_transit_time
     *           Selected carrier to calculate the shipping speed from. Select a carrier
     *           from the [available carriers
     *           list](https://support.google.com/merchants/answer/15449142#Supported),
     *           for example `AUSTRALIA_POST_REGULAR`. Speed will be calculated by this
     *           selected carrier, the location expressed in
     *           [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     *           along with the user location to determine the accurate delivery speed.
     *           Carrier is represented by a carrier service name or a carrier service ID.
     *           Cannot be set together with
     *           [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     *           or
     *           [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Products\V1\ProductsCommon::initOnce();
        parent::__construct($data);
    }

    /**
     * The [CLDR territory
     * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
     * of the country to which an item will ship.
     *
     * Generated from protobuf field <code>optional string country = 1;</code>
     * @return string
     */
    public function getCountry()
    {
        return isset($this->country) ? $this->country : '';
    }

    public function hasCountry()
    {
        return isset($this->country);
    }

    public function clearCountry()
    {
        unset($this->country);
    }

    /**
     * The [CLDR territory
     * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
     * of the country to which an item will ship.
     *
     * Generated from protobuf field <code>optional string country = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setCountry($var)
    {
        GPBUtil::checkString($var, True);
        $this->country = $var;

        return $this;
    }

    /**
     * The geographic region to which a shipping rate applies.
     * See [region](https://support.google.com/merchants/answer/6324484) for
     * more information.
     *
     * Generated from protobuf field <code>optional string region = 2;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * The geographic region to which a shipping rate applies.
     * See [region](https://support.google.com/merchants/answer/6324484) for
     * more information.
     *
     * Generated from protobuf field <code>optional string region = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * The postal code range that the shipping rate applies to, represented by
     * a postal code (eg. `94043`), a postal code prefix followed by a *
     * wildcard (eg. `94*`), a range between two postal codes (eg.
     * `94043-98033`) or two postal code prefixes of equal length (eg.
     * `94*-98*`).
     *
     * Generated from protobuf field <code>optional string postal_code = 3;</code>
     * @return string
     */
    public function getPostalCode()
    {
        return isset($this->postal_code) ? $this->postal_code : '';
    }

    public function hasPostalCode()
    {
        return isset($this->postal_code);
    }

    public function clearPostalCode()
    {
        unset($this->postal_code);
    }

    /**
     * The postal code range that the shipping rate applies to, represented by
     * a postal code (eg. `94043`), a postal code prefix followed by a *
     * wildcard (eg. `94*`), a range between two postal codes (eg.
     * `94043-98033`) or two postal code prefixes of equal length (eg.
     * `94*-98*`).
     *
     * Generated from protobuf field <code>optional string postal_code = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPostalCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->postal_code = $var;

        return $this;
    }

    /**
     * The source location postal code from which this offer ships. Represented
     * only by a full-length postal code.
     *
     * Generated from protobuf field <code>optional string origin_postal_code = 4;</code>
     * @return string
     */
    public function getOriginPostalCode()
    {
        return isset($this->origin_postal_code) ? $this->origin_postal_code : '';
    }

    public function hasOriginPostalCode()
    {
        return isset($this->origin_postal_code);
    }

    public function clearOriginPostalCode()
    {
        unset($this->origin_postal_code);
    }

    /**
     * The source location postal code from which this offer ships. Represented
     * only by a full-length postal code.
     *
     * Generated from protobuf field <code>optional string origin_postal_code = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setOriginPostalCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->origin_postal_code = $var;

        return $this;
    }

    /**
     * Fixed shipping price, represented as a number with currency. Cannot be
     * set together with
     * [carrierPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price]
     * or its adjustments
     * ([carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment],
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment]).
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price flat_price = 5;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getFlatPrice()
    {
        return $this->flat_price;
    }

    public function hasFlatPrice()
    {
        return isset($this->flat_price);
    }

    public function clearFlatPrice()
    {
        unset($this->flat_price);
    }

    /**
     * Fixed shipping price, represented as a number with currency. Cannot be
     * set together with
     * [carrierPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price]
     * or its adjustments
     * ([carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment],
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment]).
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price flat_price = 5;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setFlatPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->flat_price = $var;

        return $this;
    }

    /**
     * Selected carrier to calculate the shipping price from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Price will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate shipping price.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.ProductAttributes.CarrierPriceOption carrier_price = 6;</code>
     * @return int
     */
    public function getCarrierPrice()
    {
        return isset($this->carrier_price) ? $this->carrier_price : 0;
    }

    public function hasCarrierPrice()
    {
        return isset($this->carrier_price);
    }

    public function clearCarrierPrice()
    {
        unset($this->carrier_price);
    }

    /**
     * Selected carrier to calculate the shipping price from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Price will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate shipping price.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.ProductAttributes.CarrierPriceOption carrier_price = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setCarrierPrice($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\ProductAttributes\CarrierPriceOption::class);
        $this->carrier_price = $var;

        return $this;
    }

    /**
     * A flat adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment].
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price carrier_price_flat_adjustment = 7;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getCarrierPriceFlatAdjustment()
    {
        return $this->carrier_price_flat_adjustment;
    }

    public function hasCarrierPriceFlatAdjustment()
    {
        return isset($this->carrier_price_flat_adjustment);
    }

    public function clearCarrierPriceFlatAdjustment()
    {
        unset($this->carrier_price_flat_adjustment);
    }

    /**
     * A flat adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPricePercentageAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_percentage_adjustment].
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price carrier_price_flat_adjustment = 7;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setCarrierPriceFlatAdjustment($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->carrier_price_flat_adjustment = $var;

        return $this;
    }

    /**
     * A percentual adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment].
     *
     * Generated from protobuf field <code>optional double carrier_price_percentage_adjustment = 8;</code>
     * @return float
     */
    public function getCarrierPricePercentageAdjustment()
    {
        return isset($this->carrier_price_percentage_adjustment) ? $this->carrier_price_percentage_adjustment : 0.0;
    }

    public function hasCarrierPricePercentageAdjustment()
    {
        return isset($this->carrier_price_percentage_adjustment);
    }

    public function clearCarrierPricePercentageAdjustment()
    {
        unset($this->carrier_price_percentage_adjustment);
    }

    /**
     * A percentual adjustment on the carrier price. Can be either positive or
     * negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
     * be set together with
     * [flatPrice][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.flat_price]
     * and
     * [carrierPriceFlatAdjustment][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_price_flat_adjustment].
     *
     * Generated from protobuf field <code>optional double carrier_price_percentage_adjustment = 8;</code>
     * @param float $var
     * @return $this
     */
    public function setCarrierPricePercentageAdjustment($var)
    {
        GPBUtil::checkDouble($var);
        $this->carrier_price_percentage_adjustment = $var;

        return $this;
    }

    /**
     * Minimum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time.
     * [minHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.min_handling_time]
     * can only be set if
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * is also set.
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 9;</code>
     * @return int|string
     */
    public function getMinHandlingTime()
    {
        return isset($this->min_handling_time) ? $this->min_handling_time : 0;
    }

    public function hasMinHandlingTime()
    {
        return isset($this->min_handling_time);
    }

    public function clearMinHandlingTime()
    {
        unset($this->min_handling_time);
    }

    /**
     * Minimum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time.
     * [minHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.min_handling_time]
     * can only be set if
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * is also set.
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 9;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinHandlingTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->min_handling_time = $var;

        return $this;
    }

    /**
     * Maximum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time. Both
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * and
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * are required if providing shipping speeds.
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 10;</code>
     * @return int|string
     */
    public function getMaxHandlingTime()
    {
        return isset($this->max_handling_time) ? $this->max_handling_time : 0;
    }

    public function hasMaxHandlingTime()
    {
        return isset($this->max_handling_time);
    }

    public function clearMaxHandlingTime()
    {
        unset($this->max_handling_time);
    }

    /**
     * Maximum handling time (inclusive) between when the order is received and
     * shipped in business days. 0 means that the order is shipped on the same
     * day as it is received if it happens before the cut-off time. Both
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time]
     * and
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * are required if providing shipping speeds.
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 10;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxHandlingTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_handling_time = $var;

        return $this;
    }

    /**
     * Minimum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships.
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time]
     * can only be set if
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * is set. Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_min_transit_time = 11;</code>
     * @return int|string
     */
    public function getFixedMinTransitTime()
    {
        return isset($this->fixed_min_transit_time) ? $this->fixed_min_transit_time : 0;
    }

    public function hasFixedMinTransitTime()
    {
        return isset($this->fixed_min_transit_time);
    }

    public function clearFixedMinTransitTime()
    {
        unset($this->fixed_min_transit_time);
    }

    /**
     * Minimum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships.
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time]
     * can only be set if
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * is set. Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_min_transit_time = 11;</code>
     * @param int|string $var
     * @return $this
     */
    public function setFixedMinTransitTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->fixed_min_transit_time = $var;

        return $this;
    }

    /**
     * Maximum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships. Needs to be provided together with
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time].
     * Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_max_transit_time = 12;</code>
     * @return int|string
     */
    public function getFixedMaxTransitTime()
    {
        return isset($this->fixed_max_transit_time) ? $this->fixed_max_transit_time : 0;
    }

    public function hasFixedMaxTransitTime()
    {
        return isset($this->fixed_max_transit_time);
    }

    public function clearFixedMaxTransitTime()
    {
        unset($this->fixed_max_transit_time);
    }

    /**
     * Maximum transit time (inclusive) between when the order has shipped and
     * when it is delivered in business days. 0 means that the order is
     * delivered on the same day as it ships. Needs to be provided together with
     * [maxHandlingTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.max_handling_time].
     * Cannot be set if
     * [carrierTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.carrier_transit_time]
     * is present.
     *
     * Generated from protobuf field <code>optional int64 fixed_max_transit_time = 12;</code>
     * @param int|string $var
     * @return $this
     */
    public function setFixedMaxTransitTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->fixed_max_transit_time = $var;

        return $this;
    }

    /**
     * Selected carrier to calculate the shipping speed from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Speed will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate delivery speed.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.CarrierTransitTimeOption carrier_transit_time = 13;</code>
     * @return int
     */
    public function getCarrierTransitTime()
    {
        return isset($this->carrier_transit_time) ? $this->carrier_transit_time : 0;
    }

    public function hasCarrierTransitTime()
    {
        return isset($this->carrier_transit_time);
    }

    public function clearCarrierTransitTime()
    {
        unset($this->carrier_transit_time);
    }

    /**
     * Selected carrier to calculate the shipping speed from. Select a carrier
     * from the [available carriers
     * list](https://support.google.com/merchants/answer/15449142#Supported),
     * for example `AUSTRALIA_POST_REGULAR`. Speed will be calculated by this
     * selected carrier, the location expressed in
     * [originPostalCode][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.origin_postal_code],
     * along with the user location to determine the accurate delivery speed.
     * Carrier is represented by a carrier service name or a carrier service ID.
     * Cannot be set together with
     * [fixedMaxTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_max_transit_time]
     * or
     * [fixedMinTransitTime][google.shopping.merchant.products.v1.ProductAttributes.CarrierShipping.fixed_min_transit_time].
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.CarrierTransitTimeOption carrier_transit_time = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setCarrierTransitTime($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\CarrierTransitTimeOption::class);
        $this->carrier_transit_time = $var;

        return $this;
    }

}


