<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/shopping/merchant/accounts/v1/regions.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Shopping\Merchant\Accounts\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Shopping\Merchant\Accounts\V1\BatchCreateRegionsRequest;
use Google\Shopping\Merchant\Accounts\V1\BatchCreateRegionsResponse;
use Google\Shopping\Merchant\Accounts\V1\BatchDeleteRegionsRequest;
use Google\Shopping\Merchant\Accounts\V1\BatchUpdateRegionsRequest;
use Google\Shopping\Merchant\Accounts\V1\BatchUpdateRegionsResponse;
use Google\Shopping\Merchant\Accounts\V1\CreateRegionRequest;
use Google\Shopping\Merchant\Accounts\V1\DeleteRegionRequest;
use Google\Shopping\Merchant\Accounts\V1\GetRegionRequest;
use Google\Shopping\Merchant\Accounts\V1\ListRegionsRequest;
use Google\Shopping\Merchant\Accounts\V1\Region;
use Google\Shopping\Merchant\Accounts\V1\UpdateRegionRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Manages regions configuration.
 *
 * This API defines the following resource model:
 *
 * - [Region][google.shopping.merchant.accounts.v1.Region]
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<BatchCreateRegionsResponse> batchCreateRegionsAsync(BatchCreateRegionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> batchDeleteRegionsAsync(BatchDeleteRegionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BatchUpdateRegionsResponse> batchUpdateRegionsAsync(BatchUpdateRegionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Region> createRegionAsync(CreateRegionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteRegionAsync(DeleteRegionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Region> getRegionAsync(GetRegionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRegionsAsync(ListRegionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Region> updateRegionAsync(UpdateRegionRequest $request, array $optionalArgs = [])
 */
final class RegionsServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.shopping.merchant.accounts.v1.RegionsService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'merchantapi.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'merchantapi.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/content'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/regions_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/regions_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/regions_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/regions_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a account
     * resource.
     *
     * @param string $account
     *
     * @return string The formatted account resource.
     */
    public static function accountName(string $account): string
    {
        return self::getPathTemplate('account')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a region
     * resource.
     *
     * @param string $account
     * @param string $region
     *
     * @return string The formatted region resource.
     */
    public static function regionName(string $account, string $region): string
    {
        return self::getPathTemplate('region')->render([
            'account' => $account,
            'region' => $region,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - account: accounts/{account}
     * - region: accounts/{account}/regions/{region}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'merchantapi.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Shopping\Merchant\Accounts\V1\RegionsServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new RegionsServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates one or more regions in your Merchant Center account.
     * Executing this method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::batchCreateRegionsAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/batch_create_regions.php
     *
     * @param BatchCreateRegionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateRegionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateRegions(
        BatchCreateRegionsRequest $request,
        array $callOptions = []
    ): BatchCreateRegionsResponse {
        return $this->startApiCall('BatchCreateRegions', $request, $callOptions)->wait();
    }

    /**
     * Deletes multiple regions by name from your Merchant Center account.
     * Executing this method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::batchDeleteRegionsAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/batch_delete_regions.php
     *
     * @param BatchDeleteRegionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchDeleteRegions(BatchDeleteRegionsRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('BatchDeleteRegions', $request, $callOptions)->wait();
    }

    /**
     * Updates one or more regions in your Merchant Center account.
     * Executing this method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::batchUpdateRegionsAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/batch_update_regions.php
     *
     * @param BatchUpdateRegionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchUpdateRegionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchUpdateRegions(
        BatchUpdateRegionsRequest $request,
        array $callOptions = []
    ): BatchUpdateRegionsResponse {
        return $this->startApiCall('BatchUpdateRegions', $request, $callOptions)->wait();
    }

    /**
     * Creates a region definition in your Merchant Center account. Executing this
     * method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::createRegionAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/create_region.php
     *
     * @param CreateRegionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Region
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRegion(CreateRegionRequest $request, array $callOptions = []): Region
    {
        return $this->startApiCall('CreateRegion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a region definition from your Merchant Center account. Executing
     * this method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::deleteRegionAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/delete_region.php
     *
     * @param DeleteRegionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRegion(DeleteRegionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteRegion', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a region defined in your Merchant Center account.
     *
     * The async variant is {@see RegionsServiceClient::getRegionAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/get_region.php
     *
     * @param GetRegionRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Region
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRegion(GetRegionRequest $request, array $callOptions = []): Region
    {
        return $this->startApiCall('GetRegion', $request, $callOptions)->wait();
    }

    /**
     * Lists the regions in your Merchant Center account.
     *
     * The async variant is {@see RegionsServiceClient::listRegionsAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/list_regions.php
     *
     * @param ListRegionsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRegions(ListRegionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRegions', $request, $callOptions);
    }

    /**
     * Updates a region definition in your Merchant Center account.
     * Executing this method requires admin access.
     *
     * The async variant is {@see RegionsServiceClient::updateRegionAsync()} .
     *
     * @example samples/V1/RegionsServiceClient/update_region.php
     *
     * @param UpdateRegionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Region
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRegion(UpdateRegionRequest $request, array $callOptions = []): Region
    {
        return $this->startApiCall('UpdateRegion', $request, $callOptions)->wait();
    }
}
