<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/cloudsecuritycompliance/v1/audit.proto

namespace Google\Cloud\CloudSecurityCompliance\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for [ListFrameworkAudits][].
 *
 * Generated from protobuf message <code>google.cloud.cloudsecuritycompliance.v1.ListFrameworkAuditsRequest</code>
 */
class ListFrameworkAuditsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource where the framework audits are listed.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The maximum number of framework audits to return. The service
     * might return fewer audits than this value. If unspecified, a maximum of 10
     * framework audits are returned. The maximum value is 50; values above 50 are
     * limited to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. The `next_page_token` value that's returned from a previous list
     * request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Optional. The filters to apply to the framework audits.
     * Supported filters are `compliance_framework`, `compliance_state`,
     * `create_time,` and `framework_audit_name`. If the filter is invalid, an
     * invalid argument error is returned.
     * For syntax details, see [AIP-160][https://google.aip.dev/160].
     *
     * Generated from protobuf field <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter = '';

    /**
     * @param string $parent Required. The parent resource where the framework audits are listed.
     *
     *                       Supported formats are the following:
     *
     *                       * `organizations/{organization_id}/locations/{location}`
     *                       * `folders/{folder_id}/locations/{location}`
     *                       * `projects/{project_id}/locations/{location}`
     *                       Please see {@see AuditClient::organizationLocationName()} for help formatting this field.
     *
     * @return \Google\Cloud\CloudSecurityCompliance\V1\ListFrameworkAuditsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource where the framework audits are listed.
     *           Supported formats are the following:
     *           * `organizations/{organization_id}/locations/{location}`
     *           * `folders/{folder_id}/locations/{location}`
     *           * `projects/{project_id}/locations/{location}`
     *     @type int $page_size
     *           Optional. The maximum number of framework audits to return. The service
     *           might return fewer audits than this value. If unspecified, a maximum of 10
     *           framework audits are returned. The maximum value is 50; values above 50 are
     *           limited to 50.
     *     @type string $page_token
     *           Optional. The `next_page_token` value that's returned from a previous list
     *           request, if any.
     *     @type string $filter
     *           Optional. The filters to apply to the framework audits.
     *           Supported filters are `compliance_framework`, `compliance_state`,
     *           `create_time,` and `framework_audit_name`. If the filter is invalid, an
     *           invalid argument error is returned.
     *           For syntax details, see [AIP-160][https://google.aip.dev/160].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Cloudsecuritycompliance\V1\Audit::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource where the framework audits are listed.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where the framework audits are listed.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of framework audits to return. The service
     * might return fewer audits than this value. If unspecified, a maximum of 10
     * framework audits are returned. The maximum value is 50; values above 50 are
     * limited to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of framework audits to return. The service
     * might return fewer audits than this value. If unspecified, a maximum of 10
     * framework audits are returned. The maximum value is 50; values above 50 are
     * limited to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. The `next_page_token` value that's returned from a previous list
     * request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. The `next_page_token` value that's returned from a previous list
     * request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. The filters to apply to the framework audits.
     * Supported filters are `compliance_framework`, `compliance_state`,
     * `create_time,` and `framework_audit_name`. If the filter is invalid, an
     * invalid argument error is returned.
     * For syntax details, see [AIP-160][https://google.aip.dev/160].
     *
     * Generated from protobuf field <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional. The filters to apply to the framework audits.
     * Supported filters are `compliance_framework`, `compliance_state`,
     * `create_time,` and `framework_audit_name`. If the filter is invalid, an
     * invalid argument error is returned.
     * For syntax details, see [AIP-160][https://google.aip.dev/160].
     *
     * Generated from protobuf field <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

}

