<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/orgpolicy/v2/constraint.proto

namespace Google\Cloud\OrgPolicy\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A custom constraint defined by customers which can *only* be applied to the
 * given resource types and organization.
 * By creating a custom constraint, customers can apply policies of this
 * custom constraint. *Creating a custom constraint itself does NOT apply any
 * policy enforcement*.
 *
 * Generated from protobuf message <code>google.cloud.orgpolicy.v2.CustomConstraint</code>
 */
class CustomConstraint extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `<service name>/<type>` Example:
     *  * `compute.googleapis.com/Instance`.
     *
     * Generated from protobuf field <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $resource_types;
    /**
     * All the operations being applied for this constraint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
     */
    private $method_types;
    /**
     * A Common Expression Language (CEL) condition which is used in the
     * evaluation of the constraint. For example:
     * `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
     * `resource.management.auto_upgrade == true`
     * The max length of the condition is 1000 characters.
     *
     * Generated from protobuf field <code>string condition = 4;</code>
     */
    protected $condition = '';
    /**
     * Allow or deny type.
     *
     * Generated from protobuf field <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     */
    protected $action_type = 0;
    /**
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     */
    protected $display_name = '';
    /**
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     */
    protected $description = '';
    /**
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` methods were called.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. Name of the constraint. This is unique within the organization.
     *           Format of the name should be
     *           * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *           Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *           The max length is 70 characters and the minimum length is 1. Note that the
     *           prefix `organizations/{organization_id}/customConstraints/` is not counted.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $resource_types
     *           Immutable. The resource instance type on which this policy applies. Format
     *           will be of the form : `<service name>/<type>` Example:
     *            * `compute.googleapis.com/Instance`.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $method_types
     *           All the operations being applied for this constraint.
     *     @type string $condition
     *           A Common Expression Language (CEL) condition which is used in the
     *           evaluation of the constraint. For example:
     *           `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
     *           `resource.management.auto_upgrade == true`
     *           The max length of the condition is 1000 characters.
     *     @type int $action_type
     *           Allow or deny type.
     *     @type string $display_name
     *           One line display name for the UI.
     *           The max length of the display_name is 200 characters.
     *     @type string $description
     *           Detailed information about this custom policy constraint.
     *           The max length of the description is 2000 characters.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last time this custom constraint was updated. This
     *           represents the last time that the `CreateCustomConstraint` or
     *           `UpdateCustomConstraint` methods were called.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Orgpolicy\V2\Constraint::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `<service name>/<type>` Example:
     *  * `compute.googleapis.com/Instance`.
     *
     * Generated from protobuf field <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourceTypes()
    {
        return $this->resource_types;
    }

    /**
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `<service name>/<type>` Example:
     *  * `compute.googleapis.com/Instance`.
     *
     * Generated from protobuf field <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourceTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_types = $arr;

        return $this;
    }

    /**
     * All the operations being applied for this constraint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMethodTypes()
    {
        return $this->method_types;
    }

    /**
     * All the operations being applied for this constraint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMethodTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\OrgPolicy\V2\CustomConstraint\MethodType::class);
        $this->method_types = $arr;

        return $this;
    }

    /**
     * A Common Expression Language (CEL) condition which is used in the
     * evaluation of the constraint. For example:
     * `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
     * `resource.management.auto_upgrade == true`
     * The max length of the condition is 1000 characters.
     *
     * Generated from protobuf field <code>string condition = 4;</code>
     * @return string
     */
    public function getCondition()
    {
        return $this->condition;
    }

    /**
     * A Common Expression Language (CEL) condition which is used in the
     * evaluation of the constraint. For example:
     * `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
     * `resource.management.auto_upgrade == true`
     * The max length of the condition is 1000 characters.
     *
     * Generated from protobuf field <code>string condition = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkString($var, True);
        $this->condition = $var;

        return $this;
    }

    /**
     * Allow or deny type.
     *
     * Generated from protobuf field <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     * @return int
     */
    public function getActionType()
    {
        return $this->action_type;
    }

    /**
     * Allow or deny type.
     *
     * Generated from protobuf field <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setActionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OrgPolicy\V2\CustomConstraint\ActionType::class);
        $this->action_type = $var;

        return $this;
    }

    /**
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` methods were called.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` methods were called.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

}

