<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/locationfinder/v1/cloud_location.proto

namespace Google\Cloud\LocationFinder\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents resource cloud locations.
 *
 * Generated from protobuf message <code>google.cloud.locationfinder.v1.CloudLocation</code>
 */
class CloudLocation extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Name of the cloud location. Unique name of the cloud location
     * including project and location using the form:
     * `projects/{project_id}/locations/{location}/cloudLocations/{cloud_location}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The containing cloud location in the strict nesting hierarchy.
     * For example, the containing cloud location of a zone is a region.
     *
     * Generated from protobuf field <code>string containing_cloud_location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $containing_cloud_location = '';
    /**
     * Optional. The human-readable name of the cloud location. Example:
     * us-east-2, us-east1.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The provider of the cloud location. Values can be Google Cloud or
     * third-party providers, including AWS, Azure, or Oracle Cloud
     * Infrastructure.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudProvider cloud_provider = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cloud_provider = 0;
    /**
     * Optional. The two-letter ISO 3166-1 alpha-2 code of the cloud location.
     * Examples: US, JP, KR.
     *
     * Generated from protobuf field <code>string territory_code = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $territory_code = '';
    /**
     * Optional. The type of the cloud location.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudLocationType cloud_location_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cloud_location_type = 0;
    /**
     * Optional. The carbon free energy percentage of the cloud location. This
     * represents the average percentage of time customers' application will be
     * running on carbon-free energy. See
     * https://cloud.google.com/sustainability/region-carbon for more details.
     * There is a difference between default value 0 and unset value. 0 means the
     * carbon free energy percentage is 0%, while unset value means the carbon
     * footprint data is not available.
     *
     * Generated from protobuf field <code>optional float carbon_free_energy_percentage = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $carbon_free_energy_percentage = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Name of the cloud location. Unique name of the cloud location
     *           including project and location using the form:
     *           `projects/{project_id}/locations/{location}/cloudLocations/{cloud_location}`
     *     @type string $containing_cloud_location
     *           Output only. The containing cloud location in the strict nesting hierarchy.
     *           For example, the containing cloud location of a zone is a region.
     *     @type string $display_name
     *           Optional. The human-readable name of the cloud location. Example:
     *           us-east-2, us-east1.
     *     @type int $cloud_provider
     *           Optional. The provider of the cloud location. Values can be Google Cloud or
     *           third-party providers, including AWS, Azure, or Oracle Cloud
     *           Infrastructure.
     *     @type string $territory_code
     *           Optional. The two-letter ISO 3166-1 alpha-2 code of the cloud location.
     *           Examples: US, JP, KR.
     *     @type int $cloud_location_type
     *           Optional. The type of the cloud location.
     *     @type float $carbon_free_energy_percentage
     *           Optional. The carbon free energy percentage of the cloud location. This
     *           represents the average percentage of time customers' application will be
     *           running on carbon-free energy. See
     *           https://cloud.google.com/sustainability/region-carbon for more details.
     *           There is a difference between default value 0 and unset value. 0 means the
     *           carbon free energy percentage is 0%, while unset value means the carbon
     *           footprint data is not available.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Locationfinder\V1\CloudLocation::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Name of the cloud location. Unique name of the cloud location
     * including project and location using the form:
     * `projects/{project_id}/locations/{location}/cloudLocations/{cloud_location}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Name of the cloud location. Unique name of the cloud location
     * including project and location using the form:
     * `projects/{project_id}/locations/{location}/cloudLocations/{cloud_location}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The containing cloud location in the strict nesting hierarchy.
     * For example, the containing cloud location of a zone is a region.
     *
     * Generated from protobuf field <code>string containing_cloud_location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getContainingCloudLocation()
    {
        return $this->containing_cloud_location;
    }

    /**
     * Output only. The containing cloud location in the strict nesting hierarchy.
     * For example, the containing cloud location of a zone is a region.
     *
     * Generated from protobuf field <code>string containing_cloud_location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setContainingCloudLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->containing_cloud_location = $var;

        return $this;
    }

    /**
     * Optional. The human-readable name of the cloud location. Example:
     * us-east-2, us-east1.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The human-readable name of the cloud location. Example:
     * us-east-2, us-east1.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The provider of the cloud location. Values can be Google Cloud or
     * third-party providers, including AWS, Azure, or Oracle Cloud
     * Infrastructure.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudProvider cloud_provider = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCloudProvider()
    {
        return $this->cloud_provider;
    }

    /**
     * Optional. The provider of the cloud location. Values can be Google Cloud or
     * third-party providers, including AWS, Azure, or Oracle Cloud
     * Infrastructure.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudProvider cloud_provider = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCloudProvider($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\LocationFinder\V1\CloudLocation\CloudProvider::class);
        $this->cloud_provider = $var;

        return $this;
    }

    /**
     * Optional. The two-letter ISO 3166-1 alpha-2 code of the cloud location.
     * Examples: US, JP, KR.
     *
     * Generated from protobuf field <code>string territory_code = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTerritoryCode()
    {
        return $this->territory_code;
    }

    /**
     * Optional. The two-letter ISO 3166-1 alpha-2 code of the cloud location.
     * Examples: US, JP, KR.
     *
     * Generated from protobuf field <code>string territory_code = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTerritoryCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->territory_code = $var;

        return $this;
    }

    /**
     * Optional. The type of the cloud location.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudLocationType cloud_location_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCloudLocationType()
    {
        return $this->cloud_location_type;
    }

    /**
     * Optional. The type of the cloud location.
     *
     * Generated from protobuf field <code>.google.cloud.locationfinder.v1.CloudLocation.CloudLocationType cloud_location_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCloudLocationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\LocationFinder\V1\CloudLocation\CloudLocationType::class);
        $this->cloud_location_type = $var;

        return $this;
    }

    /**
     * Optional. The carbon free energy percentage of the cloud location. This
     * represents the average percentage of time customers' application will be
     * running on carbon-free energy. See
     * https://cloud.google.com/sustainability/region-carbon for more details.
     * There is a difference between default value 0 and unset value. 0 means the
     * carbon free energy percentage is 0%, while unset value means the carbon
     * footprint data is not available.
     *
     * Generated from protobuf field <code>optional float carbon_free_energy_percentage = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getCarbonFreeEnergyPercentage()
    {
        return isset($this->carbon_free_energy_percentage) ? $this->carbon_free_energy_percentage : 0.0;
    }

    public function hasCarbonFreeEnergyPercentage()
    {
        return isset($this->carbon_free_energy_percentage);
    }

    public function clearCarbonFreeEnergyPercentage()
    {
        unset($this->carbon_free_energy_percentage);
    }

    /**
     * Optional. The carbon free energy percentage of the cloud location. This
     * represents the average percentage of time customers' application will be
     * running on carbon-free energy. See
     * https://cloud.google.com/sustainability/region-carbon for more details.
     * There is a difference between default value 0 and unset value. 0 means the
     * carbon free energy percentage is 0%, while unset value means the carbon
     * footprint data is not available.
     *
     * Generated from protobuf field <code>optional float carbon_free_energy_percentage = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setCarbonFreeEnergyPercentage($var)
    {
        GPBUtil::checkFloat($var);
        $this->carbon_free_energy_percentage = $var;

        return $this;
    }

}

