<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/financialservices/v1/model.proto

namespace Google\Cloud\FinancialServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Model represents a trained model.
 *
 * Generated from protobuf message <code>google.cloud.financialservices.v1.Model</code>
 */
class Model extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the Model.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Output only. State of the model (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Model.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The EngineVersion used in training this model.  This is output
     * only, and is determined from the EngineConfig used.
     *
     * Generated from protobuf field <code>string engine_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $engine_version = '';
    /**
     * Required. The resource name of the EngineConfig the model training will be
     * based on. Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engineConfig}`
     *
     * Generated from protobuf field <code>string engine_config = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $engine_config = '';
    /**
     * Required. The resource name of the Primary Dataset used in this model
     * training. For information about how primary and auxiliary datasets are
     * used, refer to the engine version's documentation.  Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string primary_dataset = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $primary_dataset = '';
    /**
     * Required. End_time specifies the latest time from which labels are used and
     * from which data is used to generate features for training.  End_time should
     * be no later than the end of the date_range of the dataset.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $end_time = null;
    /**
     * Output only. The line of business (Retail/Commercial) this model is used
     * for. Determined by EngineConfig, cannot be set by user.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $line_of_business = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the Model.
     *           format:
     *           `/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp of creation of this resource.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp of the most recent update of this resource.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels
     *     @type int $state
     *           Output only. State of the model (creating, active, deleting, etc.)
     *     @type string $engine_version
     *           Output only. The EngineVersion used in training this model.  This is output
     *           only, and is determined from the EngineConfig used.
     *     @type string $engine_config
     *           Required. The resource name of the EngineConfig the model training will be
     *           based on. Format:
     *           `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engineConfig}`
     *     @type string $primary_dataset
     *           Required. The resource name of the Primary Dataset used in this model
     *           training. For information about how primary and auxiliary datasets are
     *           used, refer to the engine version's documentation.  Format:
     *           `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Required. End_time specifies the latest time from which labels are used and
     *           from which data is used to generate features for training.  End_time should
     *           be no later than the end of the date_range of the dataset.
     *     @type int $line_of_business
     *           Output only. The line of business (Retail/Commercial) this model is used
     *           for. Determined by EngineConfig, cannot be set by user.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Financialservices\V1\Model::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the Model.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the Model.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. State of the model (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Model.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the model (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Model.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\FinancialServices\V1\Model\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The EngineVersion used in training this model.  This is output
     * only, and is determined from the EngineConfig used.
     *
     * Generated from protobuf field <code>string engine_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEngineVersion()
    {
        return $this->engine_version;
    }

    /**
     * Output only. The EngineVersion used in training this model.  This is output
     * only, and is determined from the EngineConfig used.
     *
     * Generated from protobuf field <code>string engine_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEngineVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->engine_version = $var;

        return $this;
    }

    /**
     * Required. The resource name of the EngineConfig the model training will be
     * based on. Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engineConfig}`
     *
     * Generated from protobuf field <code>string engine_config = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEngineConfig()
    {
        return $this->engine_config;
    }

    /**
     * Required. The resource name of the EngineConfig the model training will be
     * based on. Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engineConfig}`
     *
     * Generated from protobuf field <code>string engine_config = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEngineConfig($var)
    {
        GPBUtil::checkString($var, True);
        $this->engine_config = $var;

        return $this;
    }

    /**
     * Required. The resource name of the Primary Dataset used in this model
     * training. For information about how primary and auxiliary datasets are
     * used, refer to the engine version's documentation.  Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string primary_dataset = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getPrimaryDataset()
    {
        return $this->primary_dataset;
    }

    /**
     * Required. The resource name of the Primary Dataset used in this model
     * training. For information about how primary and auxiliary datasets are
     * used, refer to the engine version's documentation.  Format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string primary_dataset = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setPrimaryDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->primary_dataset = $var;

        return $this;
    }

    /**
     * Required. End_time specifies the latest time from which labels are used and
     * from which data is used to generate features for training.  End_time should
     * be no later than the end of the date_range of the dataset.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Required. End_time specifies the latest time from which labels are used and
     * from which data is used to generate features for training.  End_time should
     * be no later than the end of the date_range of the dataset.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * Output only. The line of business (Retail/Commercial) this model is used
     * for. Determined by EngineConfig, cannot be set by user.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLineOfBusiness()
    {
        return $this->line_of_business;
    }

    /**
     * Output only. The line of business (Retail/Commercial) this model is used
     * for. Determined by EngineConfig, cannot be set by user.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLineOfBusiness($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\FinancialServices\V1\LineOfBusiness::class);
        $this->line_of_business = $var;

        return $this;
    }

}

