<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/financialservices/v1/instance.proto

namespace Google\Cloud\FinancialServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for adding/removing registered parties from BigQuery tables
 * specified by the customer.
 *
 * Generated from protobuf message <code>google.cloud.financialservices.v1.ImportRegisteredPartiesRequest</code>
 */
class ImportRegisteredPartiesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The full path to the Instance resource in this API.
     * format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Optional. List of BigQuery tables. Union of tables will be taken if there
     * is more than one table. VPC-SC restrictions apply. format:
     * `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
     * over the latter due to its simplicity and the reduced risk of errors
     * `party_tables` and `datasets` must not be provided at the
     * same time
     *
     * Generated from protobuf field <code>repeated string party_tables = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $party_tables;
    /**
     * Required. Mode of the request.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.ImportRegisteredPartiesRequest.UpdateMode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $mode = 0;
    /**
     * Optional. If the request will not register the parties, just determine what
     * would happen.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validate_only = false;
    /**
     * Required. LineOfBusiness for the specified registered parties.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $line_of_business = 0;

    /**
     * @param string   $name           Required. The full path to the Instance resource in this API.
     *                                 format: `projects/{project}/locations/{location}/instances/{instance}`
     *                                 Please see {@see AMLClient::instanceName()} for help formatting this field.
     * @param int      $mode           Required. Mode of the request.
     *                                 For allowed values, use constants defined on {@see \Google\Cloud\FinancialServices\V1\ImportRegisteredPartiesRequest\UpdateMode}
     * @param int      $lineOfBusiness Required. LineOfBusiness for the specified registered parties.
     *                                 For allowed values, use constants defined on {@see \Google\Cloud\FinancialServices\V1\LineOfBusiness}
     * @param string[] $partyTables    Optional. List of BigQuery tables. Union of tables will be taken if there
     *                                 is more than one table. VPC-SC restrictions apply. format:
     *                                 `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
     *                                 over the latter due to its simplicity and the reduced risk of errors
     *                                 `party_tables` and `datasets` must not be provided at the
     *                                 same time
     *
     * @return \Google\Cloud\FinancialServices\V1\ImportRegisteredPartiesRequest
     *
     * @experimental
     */
    public static function build(string $name, int $mode, int $lineOfBusiness, array $partyTables): self
    {
        return (new self())
            ->setName($name)
            ->setMode($mode)
            ->setLineOfBusiness($lineOfBusiness)
            ->setPartyTables($partyTables);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The full path to the Instance resource in this API.
     *           format: `projects/{project}/locations/{location}/instances/{instance}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $party_tables
     *           Optional. List of BigQuery tables. Union of tables will be taken if there
     *           is more than one table. VPC-SC restrictions apply. format:
     *           `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
     *           over the latter due to its simplicity and the reduced risk of errors
     *           `party_tables` and `datasets` must not be provided at the
     *           same time
     *     @type int $mode
     *           Required. Mode of the request.
     *     @type bool $validate_only
     *           Optional. If the request will not register the parties, just determine what
     *           would happen.
     *     @type int $line_of_business
     *           Required. LineOfBusiness for the specified registered parties.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Financialservices\V1\Instance::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The full path to the Instance resource in this API.
     * format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The full path to the Instance resource in this API.
     * format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. List of BigQuery tables. Union of tables will be taken if there
     * is more than one table. VPC-SC restrictions apply. format:
     * `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
     * over the latter due to its simplicity and the reduced risk of errors
     * `party_tables` and `datasets` must not be provided at the
     * same time
     *
     * Generated from protobuf field <code>repeated string party_tables = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPartyTables()
    {
        return $this->party_tables;
    }

    /**
     * Optional. List of BigQuery tables. Union of tables will be taken if there
     * is more than one table. VPC-SC restrictions apply. format:
     * `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
     * over the latter due to its simplicity and the reduced risk of errors
     * `party_tables` and `datasets` must not be provided at the
     * same time
     *
     * Generated from protobuf field <code>repeated string party_tables = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPartyTables($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->party_tables = $arr;

        return $this;
    }

    /**
     * Required. Mode of the request.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.ImportRegisteredPartiesRequest.UpdateMode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * Required. Mode of the request.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.ImportRegisteredPartiesRequest.UpdateMode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\FinancialServices\V1\ImportRegisteredPartiesRequest\UpdateMode::class);
        $this->mode = $var;

        return $this;
    }

    /**
     * Optional. If the request will not register the parties, just determine what
     * would happen.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. If the request will not register the parties, just determine what
     * would happen.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * Required. LineOfBusiness for the specified registered parties.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getLineOfBusiness()
    {
        return $this->line_of_business;
    }

    /**
     * Required. LineOfBusiness for the specified registered parties.
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.LineOfBusiness line_of_business = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setLineOfBusiness($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\FinancialServices\V1\LineOfBusiness::class);
        $this->line_of_business = $var;

        return $this;
    }

}

