<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/confidentialcomputing/v1/service.proto

namespace Google\Cloud\ConfidentialComputing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An SEV-SNP Attestation Report.
 * Contains the attestation report and the certificate bundle that the client
 * collects.
 *
 * Generated from protobuf message <code>google.cloud.confidentialcomputing.v1.SevSnpAttestation</code>
 */
class SevSnpAttestation extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The SEV-SNP Attestation Report
     * Format is in revision 1.55, §7.3 Attestation, Table 22. ATTESTATION_REPORT
     * Structure in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56860.pdf
     *
     * Generated from protobuf field <code>bytes report = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $report = '';
    /**
     * Optional. Certificate bundle defined in the GHCB protocol definition
     * Format is documented in GHCB revision 2.03, section 4.1.8.1 struct
     * cert_table in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56421.pdf
     *
     * Generated from protobuf field <code>bytes aux_blob = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $aux_blob = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $report
     *           Optional. The SEV-SNP Attestation Report
     *           Format is in revision 1.55, §7.3 Attestation, Table 22. ATTESTATION_REPORT
     *           Structure in this document:
     *           https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56860.pdf
     *     @type string $aux_blob
     *           Optional. Certificate bundle defined in the GHCB protocol definition
     *           Format is documented in GHCB revision 2.03, section 4.1.8.1 struct
     *           cert_table in this document:
     *           https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56421.pdf
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Confidentialcomputing\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The SEV-SNP Attestation Report
     * Format is in revision 1.55, §7.3 Attestation, Table 22. ATTESTATION_REPORT
     * Structure in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56860.pdf
     *
     * Generated from protobuf field <code>bytes report = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReport()
    {
        return $this->report;
    }

    /**
     * Optional. The SEV-SNP Attestation Report
     * Format is in revision 1.55, §7.3 Attestation, Table 22. ATTESTATION_REPORT
     * Structure in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56860.pdf
     *
     * Generated from protobuf field <code>bytes report = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReport($var)
    {
        GPBUtil::checkString($var, False);
        $this->report = $var;

        return $this;
    }

    /**
     * Optional. Certificate bundle defined in the GHCB protocol definition
     * Format is documented in GHCB revision 2.03, section 4.1.8.1 struct
     * cert_table in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56421.pdf
     *
     * Generated from protobuf field <code>bytes aux_blob = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAuxBlob()
    {
        return $this->aux_blob;
    }

    /**
     * Optional. Certificate bundle defined in the GHCB protocol definition
     * Format is documented in GHCB revision 2.03, section 4.1.8.1 struct
     * cert_table in this document:
     * https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56421.pdf
     *
     * Generated from protobuf field <code>bytes aux_blob = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAuxBlob($var)
    {
        GPBUtil::checkString($var, False);
        $this->aux_blob = $var;

        return $this;
    }

}

