<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies settings for an HTTP redirect.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.HttpRedirectAction</code>
 */
class HttpRedirectAction extends \Google\Protobuf\Internal\Message
{
    /**
     * The host that is used in the redirect response instead of the one that
     * was supplied in the request.
     * The value must be from 1 to 255
     * characters.
     *
     * Generated from protobuf field <code>optional string host_redirect = 107417747;</code>
     */
    protected $host_redirect = null;
    /**
     * If set to true, the URL scheme in the redirected request is
     * set to HTTPS.
     * If set to false, the URL scheme of the redirected request
     * remains the same as that of the request.
     * This must only be set for URL maps used inTargetHttpProxys. Setting this true forTargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool https_redirect = 170260656;</code>
     */
    protected $https_redirect = null;
    /**
     * The path that is used in the redirect response instead of the one
     * that was supplied in the request.
     * pathRedirect cannot be supplied together withprefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string path_redirect = 272342710;</code>
     */
    protected $path_redirect = null;
    /**
     * The prefix that replaces the prefixMatch specified in
     * the HttpRouteRuleMatch, retaining the remaining portion
     * of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together withpathRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string prefix_redirect = 446184169;</code>
     */
    protected $prefix_redirect = null;
    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     *    - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds
     *    to 301.
     *    - FOUND, which corresponds to 302.
     *    - SEE_OTHER which corresponds to 303.
     *    - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
     *    method is retained.
     *    - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
     *    method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string redirect_response_code = 436710408;</code>
     */
    protected $redirect_response_code = null;
    /**
     * If set to true, any accompanying query portion of the original
     * URL is
     * removed before redirecting the request. If set to false, the
     * query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool strip_query = 52284641;</code>
     */
    protected $strip_query = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_redirect
     *           The host that is used in the redirect response instead of the one that
     *           was supplied in the request.
     *           The value must be from 1 to 255
     *           characters.
     *     @type bool $https_redirect
     *           If set to true, the URL scheme in the redirected request is
     *           set to HTTPS.
     *           If set to false, the URL scheme of the redirected request
     *           remains the same as that of the request.
     *           This must only be set for URL maps used inTargetHttpProxys. Setting this true forTargetHttpsProxy is not permitted.
     *           The default is set to false.
     *     @type string $path_redirect
     *           The path that is used in the redirect response instead of the one
     *           that was supplied in the request.
     *           pathRedirect cannot be supplied together withprefixRedirect. Supply one alone or neither. If neither is
     *           supplied, the path of the original request is used for the redirect.
     *           The value must be from 1 to 1024 characters.
     *     @type string $prefix_redirect
     *           The prefix that replaces the prefixMatch specified in
     *           the HttpRouteRuleMatch, retaining the remaining portion
     *           of the URL before redirecting the request.
     *           prefixRedirect cannot be supplied together withpathRedirect. Supply one alone or neither. If neither is
     *           supplied, the path of the original request is used for the redirect.
     *           The value must be from 1 to 1024 characters.
     *     @type string $redirect_response_code
     *           The HTTP Status code to use for this RedirectAction.
     *           Supported values are:
     *              - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds
     *              to 301.
     *              - FOUND, which corresponds to 302.
     *              - SEE_OTHER which corresponds to 303.
     *              - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
     *              method is retained.
     *              - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
     *              method is retained.
     *           Check the RedirectResponseCode enum for the list of possible values.
     *     @type bool $strip_query
     *           If set to true, any accompanying query portion of the original
     *           URL is
     *           removed before redirecting the request. If set to false, the
     *           query portion of the original URL is retained.
     *           The default is set to false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * The host that is used in the redirect response instead of the one that
     * was supplied in the request.
     * The value must be from 1 to 255
     * characters.
     *
     * Generated from protobuf field <code>optional string host_redirect = 107417747;</code>
     * @return string
     */
    public function getHostRedirect()
    {
        return isset($this->host_redirect) ? $this->host_redirect : '';
    }

    public function hasHostRedirect()
    {
        return isset($this->host_redirect);
    }

    public function clearHostRedirect()
    {
        unset($this->host_redirect);
    }

    /**
     * The host that is used in the redirect response instead of the one that
     * was supplied in the request.
     * The value must be from 1 to 255
     * characters.
     *
     * Generated from protobuf field <code>optional string host_redirect = 107417747;</code>
     * @param string $var
     * @return $this
     */
    public function setHostRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_redirect = $var;

        return $this;
    }

    /**
     * If set to true, the URL scheme in the redirected request is
     * set to HTTPS.
     * If set to false, the URL scheme of the redirected request
     * remains the same as that of the request.
     * This must only be set for URL maps used inTargetHttpProxys. Setting this true forTargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool https_redirect = 170260656;</code>
     * @return bool
     */
    public function getHttpsRedirect()
    {
        return isset($this->https_redirect) ? $this->https_redirect : false;
    }

    public function hasHttpsRedirect()
    {
        return isset($this->https_redirect);
    }

    public function clearHttpsRedirect()
    {
        unset($this->https_redirect);
    }

    /**
     * If set to true, the URL scheme in the redirected request is
     * set to HTTPS.
     * If set to false, the URL scheme of the redirected request
     * remains the same as that of the request.
     * This must only be set for URL maps used inTargetHttpProxys. Setting this true forTargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool https_redirect = 170260656;</code>
     * @param bool $var
     * @return $this
     */
    public function setHttpsRedirect($var)
    {
        GPBUtil::checkBool($var);
        $this->https_redirect = $var;

        return $this;
    }

    /**
     * The path that is used in the redirect response instead of the one
     * that was supplied in the request.
     * pathRedirect cannot be supplied together withprefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string path_redirect = 272342710;</code>
     * @return string
     */
    public function getPathRedirect()
    {
        return isset($this->path_redirect) ? $this->path_redirect : '';
    }

    public function hasPathRedirect()
    {
        return isset($this->path_redirect);
    }

    public function clearPathRedirect()
    {
        unset($this->path_redirect);
    }

    /**
     * The path that is used in the redirect response instead of the one
     * that was supplied in the request.
     * pathRedirect cannot be supplied together withprefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string path_redirect = 272342710;</code>
     * @param string $var
     * @return $this
     */
    public function setPathRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->path_redirect = $var;

        return $this;
    }

    /**
     * The prefix that replaces the prefixMatch specified in
     * the HttpRouteRuleMatch, retaining the remaining portion
     * of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together withpathRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string prefix_redirect = 446184169;</code>
     * @return string
     */
    public function getPrefixRedirect()
    {
        return isset($this->prefix_redirect) ? $this->prefix_redirect : '';
    }

    public function hasPrefixRedirect()
    {
        return isset($this->prefix_redirect);
    }

    public function clearPrefixRedirect()
    {
        unset($this->prefix_redirect);
    }

    /**
     * The prefix that replaces the prefixMatch specified in
     * the HttpRouteRuleMatch, retaining the remaining portion
     * of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together withpathRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request is used for the redirect.
     * The value must be from 1 to 1024 characters.
     *
     * Generated from protobuf field <code>optional string prefix_redirect = 446184169;</code>
     * @param string $var
     * @return $this
     */
    public function setPrefixRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->prefix_redirect = $var;

        return $this;
    }

    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     *    - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds
     *    to 301.
     *    - FOUND, which corresponds to 302.
     *    - SEE_OTHER which corresponds to 303.
     *    - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
     *    method is retained.
     *    - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
     *    method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string redirect_response_code = 436710408;</code>
     * @return string
     */
    public function getRedirectResponseCode()
    {
        return isset($this->redirect_response_code) ? $this->redirect_response_code : '';
    }

    public function hasRedirectResponseCode()
    {
        return isset($this->redirect_response_code);
    }

    public function clearRedirectResponseCode()
    {
        unset($this->redirect_response_code);
    }

    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     *    - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds
     *    to 301.
     *    - FOUND, which corresponds to 302.
     *    - SEE_OTHER which corresponds to 303.
     *    - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
     *    method is retained.
     *    - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
     *    method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string redirect_response_code = 436710408;</code>
     * @param string $var
     * @return $this
     */
    public function setRedirectResponseCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->redirect_response_code = $var;

        return $this;
    }

    /**
     * If set to true, any accompanying query portion of the original
     * URL is
     * removed before redirecting the request. If set to false, the
     * query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool strip_query = 52284641;</code>
     * @return bool
     */
    public function getStripQuery()
    {
        return isset($this->strip_query) ? $this->strip_query : false;
    }

    public function hasStripQuery()
    {
        return isset($this->strip_query);
    }

    public function clearStripQuery()
    {
        unset($this->strip_query);
    }

    /**
     * If set to true, any accompanying query portion of the original
     * URL is
     * removed before redirecting the request. If set to false, the
     * query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>optional bool strip_query = 52284641;</code>
     * @param bool $var
     * @return $this
     */
    public function setStripQuery($var)
    {
        GPBUtil::checkBool($var);
        $this->strip_query = $var;

        return $this;
    }

}

