<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Connection Tracking configuration for this BackendService.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy</code>
 */
class BackendServiceConnectionTrackingPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies connection persistence when backends are unhealthy. The default
     * value is DEFAULT_FOR_PROTOCOL.
     * If set to DEFAULT_FOR_PROTOCOL, the existing connections
     * persist on unhealthy backends only for connection-oriented protocols
     * (TCP and SCTP) and only if the Tracking Mode isPER_CONNECTION (default tracking mode) or the Session
     * Affinity is configured for 5-tuple. They do not persist forUDP.
     * If set to NEVER_PERSIST, after a backend becomes unhealthy,
     * the existing connections on the unhealthy backend are never persisted on
     * the unhealthy backend. They are always diverted to newly selected healthy
     * backends (unless all backends are unhealthy).
     * If set to ALWAYS_PERSIST, existing connections always
     * persist on unhealthy backends regardless of protocol and session
     * affinity. It is generally not recommended to use this mode overriding the
     * default.
     * For more details, see [Connection Persistence for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence)
     * and [Connection Persistence for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     */
    protected $connection_persistence_on_unhealthy_backends = null;
    /**
     * Enable Strong Session Affinity for external passthrough Network Load
     * Balancers. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional bool enable_strong_affinity = 24539924;</code>
     */
    protected $enable_strong_affinity = null;
    /**
     * Specifies how long to keep a Connection Tracking entry while there is no
     * matching traffic (in seconds).
     * For internal passthrough Network Load Balancers:
     *    - The minimum (default) is 10 minutes and the maximum is 16 hours.
     *    - It can be set only if Connection Tracking is less than 5-tuple
     *    (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,CLIENT_IP or CLIENT_IP_PROTO, and Tracking
     *    Mode is PER_SESSION).
     * For external passthrough Network Load Balancers the default is 60
     * seconds. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional int32 idle_timeout_sec = 24977544;</code>
     */
    protected $idle_timeout_sec = null;
    /**
     * Specifies the key used for connection tracking. There are two
     * options:
     *    - PER_CONNECTION: This is the default mode. The Connection
     *    Tracking is performed as per the Connection Key (default Hash Method) for
     *    the specific protocol.
     *    - PER_SESSION: The Connection Tracking is performed as per
     *    the configured Session Affinity. It matches the configured Session
     *    Affinity.
     * For more details, see [Tracking Mode for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode)
     * and [Tracking Mode for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string tracking_mode = 127757867;</code>
     */
    protected $tracking_mode = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $connection_persistence_on_unhealthy_backends
     *           Specifies connection persistence when backends are unhealthy. The default
     *           value is DEFAULT_FOR_PROTOCOL.
     *           If set to DEFAULT_FOR_PROTOCOL, the existing connections
     *           persist on unhealthy backends only for connection-oriented protocols
     *           (TCP and SCTP) and only if the Tracking Mode isPER_CONNECTION (default tracking mode) or the Session
     *           Affinity is configured for 5-tuple. They do not persist forUDP.
     *           If set to NEVER_PERSIST, after a backend becomes unhealthy,
     *           the existing connections on the unhealthy backend are never persisted on
     *           the unhealthy backend. They are always diverted to newly selected healthy
     *           backends (unless all backends are unhealthy).
     *           If set to ALWAYS_PERSIST, existing connections always
     *           persist on unhealthy backends regardless of protocol and session
     *           affinity. It is generally not recommended to use this mode overriding the
     *           default.
     *           For more details, see [Connection Persistence for Network Load
     *           Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence)
     *           and [Connection Persistence for Internal TCP/UDP Load
     *           Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     *           Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     *     @type bool $enable_strong_affinity
     *           Enable Strong Session Affinity for external passthrough Network Load
     *           Balancers. This option is not available publicly.
     *     @type int $idle_timeout_sec
     *           Specifies how long to keep a Connection Tracking entry while there is no
     *           matching traffic (in seconds).
     *           For internal passthrough Network Load Balancers:
     *              - The minimum (default) is 10 minutes and the maximum is 16 hours.
     *              - It can be set only if Connection Tracking is less than 5-tuple
     *              (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,CLIENT_IP or CLIENT_IP_PROTO, and Tracking
     *              Mode is PER_SESSION).
     *           For external passthrough Network Load Balancers the default is 60
     *           seconds. This option is not available publicly.
     *     @type string $tracking_mode
     *           Specifies the key used for connection tracking. There are two
     *           options:
     *              - PER_CONNECTION: This is the default mode. The Connection
     *              Tracking is performed as per the Connection Key (default Hash Method) for
     *              the specific protocol.
     *              - PER_SESSION: The Connection Tracking is performed as per
     *              the configured Session Affinity. It matches the configured Session
     *              Affinity.
     *           For more details, see [Tracking Mode for Network Load
     *           Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode)
     *           and [Tracking Mode for Internal TCP/UDP Load
     *           Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     *           Check the TrackingMode enum for the list of possible values.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies connection persistence when backends are unhealthy. The default
     * value is DEFAULT_FOR_PROTOCOL.
     * If set to DEFAULT_FOR_PROTOCOL, the existing connections
     * persist on unhealthy backends only for connection-oriented protocols
     * (TCP and SCTP) and only if the Tracking Mode isPER_CONNECTION (default tracking mode) or the Session
     * Affinity is configured for 5-tuple. They do not persist forUDP.
     * If set to NEVER_PERSIST, after a backend becomes unhealthy,
     * the existing connections on the unhealthy backend are never persisted on
     * the unhealthy backend. They are always diverted to newly selected healthy
     * backends (unless all backends are unhealthy).
     * If set to ALWAYS_PERSIST, existing connections always
     * persist on unhealthy backends regardless of protocol and session
     * affinity. It is generally not recommended to use this mode overriding the
     * default.
     * For more details, see [Connection Persistence for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence)
     * and [Connection Persistence for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     * @return string
     */
    public function getConnectionPersistenceOnUnhealthyBackends()
    {
        return isset($this->connection_persistence_on_unhealthy_backends) ? $this->connection_persistence_on_unhealthy_backends : '';
    }

    public function hasConnectionPersistenceOnUnhealthyBackends()
    {
        return isset($this->connection_persistence_on_unhealthy_backends);
    }

    public function clearConnectionPersistenceOnUnhealthyBackends()
    {
        unset($this->connection_persistence_on_unhealthy_backends);
    }

    /**
     * Specifies connection persistence when backends are unhealthy. The default
     * value is DEFAULT_FOR_PROTOCOL.
     * If set to DEFAULT_FOR_PROTOCOL, the existing connections
     * persist on unhealthy backends only for connection-oriented protocols
     * (TCP and SCTP) and only if the Tracking Mode isPER_CONNECTION (default tracking mode) or the Session
     * Affinity is configured for 5-tuple. They do not persist forUDP.
     * If set to NEVER_PERSIST, after a backend becomes unhealthy,
     * the existing connections on the unhealthy backend are never persisted on
     * the unhealthy backend. They are always diverted to newly selected healthy
     * backends (unless all backends are unhealthy).
     * If set to ALWAYS_PERSIST, existing connections always
     * persist on unhealthy backends regardless of protocol and session
     * affinity. It is generally not recommended to use this mode overriding the
     * default.
     * For more details, see [Connection Persistence for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence)
     * and [Connection Persistence for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     * @param string $var
     * @return $this
     */
    public function setConnectionPersistenceOnUnhealthyBackends($var)
    {
        GPBUtil::checkString($var, True);
        $this->connection_persistence_on_unhealthy_backends = $var;

        return $this;
    }

    /**
     * Enable Strong Session Affinity for external passthrough Network Load
     * Balancers. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional bool enable_strong_affinity = 24539924;</code>
     * @return bool
     */
    public function getEnableStrongAffinity()
    {
        return isset($this->enable_strong_affinity) ? $this->enable_strong_affinity : false;
    }

    public function hasEnableStrongAffinity()
    {
        return isset($this->enable_strong_affinity);
    }

    public function clearEnableStrongAffinity()
    {
        unset($this->enable_strong_affinity);
    }

    /**
     * Enable Strong Session Affinity for external passthrough Network Load
     * Balancers. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional bool enable_strong_affinity = 24539924;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableStrongAffinity($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_strong_affinity = $var;

        return $this;
    }

    /**
     * Specifies how long to keep a Connection Tracking entry while there is no
     * matching traffic (in seconds).
     * For internal passthrough Network Load Balancers:
     *    - The minimum (default) is 10 minutes and the maximum is 16 hours.
     *    - It can be set only if Connection Tracking is less than 5-tuple
     *    (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,CLIENT_IP or CLIENT_IP_PROTO, and Tracking
     *    Mode is PER_SESSION).
     * For external passthrough Network Load Balancers the default is 60
     * seconds. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional int32 idle_timeout_sec = 24977544;</code>
     * @return int
     */
    public function getIdleTimeoutSec()
    {
        return isset($this->idle_timeout_sec) ? $this->idle_timeout_sec : 0;
    }

    public function hasIdleTimeoutSec()
    {
        return isset($this->idle_timeout_sec);
    }

    public function clearIdleTimeoutSec()
    {
        unset($this->idle_timeout_sec);
    }

    /**
     * Specifies how long to keep a Connection Tracking entry while there is no
     * matching traffic (in seconds).
     * For internal passthrough Network Load Balancers:
     *    - The minimum (default) is 10 minutes and the maximum is 16 hours.
     *    - It can be set only if Connection Tracking is less than 5-tuple
     *    (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,CLIENT_IP or CLIENT_IP_PROTO, and Tracking
     *    Mode is PER_SESSION).
     * For external passthrough Network Load Balancers the default is 60
     * seconds. This option is not available publicly.
     *
     * Generated from protobuf field <code>optional int32 idle_timeout_sec = 24977544;</code>
     * @param int $var
     * @return $this
     */
    public function setIdleTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->idle_timeout_sec = $var;

        return $this;
    }

    /**
     * Specifies the key used for connection tracking. There are two
     * options:
     *    - PER_CONNECTION: This is the default mode. The Connection
     *    Tracking is performed as per the Connection Key (default Hash Method) for
     *    the specific protocol.
     *    - PER_SESSION: The Connection Tracking is performed as per
     *    the configured Session Affinity. It matches the configured Session
     *    Affinity.
     * For more details, see [Tracking Mode for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode)
     * and [Tracking Mode for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string tracking_mode = 127757867;</code>
     * @return string
     */
    public function getTrackingMode()
    {
        return isset($this->tracking_mode) ? $this->tracking_mode : '';
    }

    public function hasTrackingMode()
    {
        return isset($this->tracking_mode);
    }

    public function clearTrackingMode()
    {
        unset($this->tracking_mode);
    }

    /**
     * Specifies the key used for connection tracking. There are two
     * options:
     *    - PER_CONNECTION: This is the default mode. The Connection
     *    Tracking is performed as per the Connection Key (default Hash Method) for
     *    the specific protocol.
     *    - PER_SESSION: The Connection Tracking is performed as per
     *    the configured Session Affinity. It matches the configured Session
     *    Affinity.
     * For more details, see [Tracking Mode for Network Load
     * Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode)
     * and [Tracking Mode for Internal TCP/UDP Load
     * Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string tracking_mode = 127757867;</code>
     * @param string $var
     * @return $this
     */
    public function setTrackingMode($var)
    {
        GPBUtil::checkString($var, True);
        $this->tracking_mode = $var;

        return $this;
    }

}

