<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1\BackendService;

use UnexpectedValueException;

/**
 * Specifies a preference for traffic sent from the proxy to the backend (or
 * from the client to the backend for proxyless gRPC).
 * The possible values are:
 *    - IPV4_ONLY: Only send IPv4 traffic to the backends of the
 *    backend service (Instance Group, Managed Instance Group, Network Endpoint
 *    Group), regardless of traffic from the client to the proxy. Only IPv4
 *    health checks are used to check the health of the backends. This is the
 *    default setting.
 *    - PREFER_IPV6: Prioritize the connection to the endpoint's
 *    IPv6 address over its IPv4 address (provided there is a healthy IPv6
 *    address).
 *    - IPV6_ONLY: Only send IPv6 traffic to the backends of the
 *    backend service (Instance Group, Managed Instance Group, Network Endpoint
 *    Group), regardless of traffic from the client to the proxy. Only IPv6
 *    health checks are used to check the health of the backends.
 * This field is applicable to either:
 *    -  Advanced global external Application Load Balancer (load balancing
 *    scheme EXTERNAL_MANAGED),
 *    -  Regional external Application Load
 *    Balancer,
 *    -  Internal proxy Network Load Balancer (load balancing
 *    scheme INTERNAL_MANAGED),
 *    -  Regional internal Application Load
 *    Balancer (load balancing scheme INTERNAL_MANAGED),
 *    -  Traffic
 *    Director with Envoy proxies and proxyless gRPC (load balancing scheme
 *    INTERNAL_SELF_MANAGED).
 *
 * Protobuf type <code>google.cloud.compute.v1.BackendService.IpAddressSelectionPolicy</code>
 */
class IpAddressSelectionPolicy
{
    /**
     * A value indicating that the enum field is not set.
     *
     * Generated from protobuf enum <code>UNDEFINED_IP_ADDRESS_SELECTION_POLICY = 0;</code>
     */
    const UNDEFINED_IP_ADDRESS_SELECTION_POLICY = 0;
    /**
     * Only send IPv4 traffic to the backends of the Backend Service
     * (Instance Group, Managed Instance Group, Network Endpoint Group)
     * regardless of traffic from the client to the proxy.
     * Only IPv4 health-checks are used to check the health of the backends.
     * This is the default setting.
     *
     * Generated from protobuf enum <code>IPV4_ONLY = 22373798;</code>
     */
    const IPV4_ONLY = 22373798;
    /**
     * Only send IPv6 traffic to the backends of the Backend Service
     * (Instance Group, Managed Instance Group, Network Endpoint Group)
     * regardless of traffic from the client to the proxy. Only IPv6
     * health-checks are used to check the health of the backends.
     *
     * Generated from protobuf enum <code>IPV6_ONLY = 79632100;</code>
     */
    const IPV6_ONLY = 79632100;
    /**
     * Unspecified IP address selection policy.
     *
     * Generated from protobuf enum <code>IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED = 36210144;</code>
     */
    const IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED = 36210144;
    /**
     * Prioritize the connection to the endpoints IPv6 address
     * over its IPv4 address (provided there is a healthy IPv6 address).
     *
     * Generated from protobuf enum <code>PREFER_IPV6 = 408601302;</code>
     */
    const PREFER_IPV6 = 408601302;

    private static $valueToName = [
        self::UNDEFINED_IP_ADDRESS_SELECTION_POLICY => 'UNDEFINED_IP_ADDRESS_SELECTION_POLICY',
        self::IPV4_ONLY => 'IPV4_ONLY',
        self::IPV6_ONLY => 'IPV6_ONLY',
        self::IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED => 'IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED',
        self::PREFER_IPV6 => 'PREFER_IPV6',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


