<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/artifactregistry/v1/export.proto

namespace Google\Cloud\ArtifactRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for exporting an artifact to a destination.
 *
 * Generated from protobuf message <code>google.devtools.artifactregistry.v1.ExportArtifactRequest</code>
 */
class ExportArtifactRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The repository of the artifact to export.
     * Format: projects/{project}/locations/{location}/repositories/{repository}
     *
     * Generated from protobuf field <code>string repository = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $repository = '';
    protected $source_artifact;
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $source_version
     *           The artifact version to export.
     *           Format:
     *           projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}
     *     @type string $source_tag
     *           The artifact tag to export.
     *           Format:projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}
     *     @type string $gcs_path
     *           The Cloud Storage path to export the artifact to. Should start with the
     *           bucket name, and optionally have a directory path. Examples:
     *           `dst_bucket`, `dst_bucket/sub_dir`.
     *           Existing objects with the same path will be overwritten.
     *     @type string $repository
     *           Required. The repository of the artifact to export.
     *           Format: projects/{project}/locations/{location}/repositories/{repository}
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Artifactregistry\V1\Export::initOnce();
        parent::__construct($data);
    }

    /**
     * The artifact version to export.
     * Format:
     * projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}
     *
     * Generated from protobuf field <code>string source_version = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceVersion()
    {
        return $this->readOneof(2);
    }

    public function hasSourceVersion()
    {
        return $this->hasOneof(2);
    }

    /**
     * The artifact version to export.
     * Format:
     * projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}
     *
     * Generated from protobuf field <code>string source_version = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The artifact tag to export.
     * Format:projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}
     *
     * Generated from protobuf field <code>string source_tag = 4 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceTag()
    {
        return $this->readOneof(4);
    }

    public function hasSourceTag()
    {
        return $this->hasOneof(4);
    }

    /**
     * The artifact tag to export.
     * Format:projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}
     *
     * Generated from protobuf field <code>string source_tag = 4 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The Cloud Storage path to export the artifact to. Should start with the
     * bucket name, and optionally have a directory path. Examples:
     * `dst_bucket`, `dst_bucket/sub_dir`.
     * Existing objects with the same path will be overwritten.
     *
     * Generated from protobuf field <code>string gcs_path = 3;</code>
     * @return string
     */
    public function getGcsPath()
    {
        return $this->readOneof(3);
    }

    public function hasGcsPath()
    {
        return $this->hasOneof(3);
    }

    /**
     * The Cloud Storage path to export the artifact to. Should start with the
     * bucket name, and optionally have a directory path. Examples:
     * `dst_bucket`, `dst_bucket/sub_dir`.
     * Existing objects with the same path will be overwritten.
     *
     * Generated from protobuf field <code>string gcs_path = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. The repository of the artifact to export.
     * Format: projects/{project}/locations/{location}/repositories/{repository}
     *
     * Generated from protobuf field <code>string repository = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getRepository()
    {
        return $this->repository;
    }

    /**
     * Required. The repository of the artifact to export.
     * Format: projects/{project}/locations/{location}/repositories/{repository}
     *
     * Generated from protobuf field <code>string repository = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRepository($var)
    {
        GPBUtil::checkString($var, True);
        $this->repository = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceArtifact()
    {
        return $this->whichOneof("source_artifact");
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

