<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1\OpenLink;

use UnexpectedValueException;

/**
 * What the client does when a link opened by an `OnClick` action is closed.
 * Implementation depends on client platform capabilities. For example, a web
 * browser might open a link in a pop-up window with an `OnClose` handler.
 * If both `OnOpen` and `OnClose` handlers are set, and the client platform
 * can't support both values, `OnClose` takes precedence.
 * [Google Workspace
 * add-ons](https://developers.google.com/workspace/add-ons):
 *
 * Protobuf type <code>google.apps.card.v1.OpenLink.OnClose</code>
 */
class OnClose
{
    /**
     * Default value. The card doesn't reload; nothing happens.
     *
     * Generated from protobuf enum <code>NOTHING = 0;</code>
     */
    const NOTHING = 0;
    /**
     * Reloads the card after the child window closes.
     * If used in conjunction with
     * [`OpenAs.OVERLAY`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#openas),
     * the child window acts as a modal dialog and the parent card is blocked
     * until the child window closes.
     *
     * Generated from protobuf enum <code>RELOAD = 1;</code>
     */
    const RELOAD = 1;

    private static $valueToName = [
        self::NOTHING => 'NOTHING',
        self::RELOAD => 'RELOAD',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


