<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/creative_template_messages.proto

namespace Google\Ads\AdManager\V1\CreativeTemplateVariable;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a list variable defined in a creative template. This is similar
 * to
 * [StringCreativeTemplateVariable][google.ads.admanager.v1.CreativeTemplateVariable.StringCreativeTemplateVariable],
 * except that there are possible choices to choose from.
 * Use [StringCreativeTemplateVariableValue][] to specify the value
 * for this variable when creating a [TemplateCreative][] from a
 * [CreativeTemplate][google.ads.admanager.v1.CreativeTemplate].
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable</code>
 */
class ListStringCreativeTemplateVariable extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Default value to be filled in when creating creatives from the
     * creative template.
     *
     * Generated from protobuf field <code>optional string default_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $default_value = null;
    /**
     * Optional. Sample value that is used when previewing the template in the
     * UI.
     *
     * Generated from protobuf field <code>optional string sample_value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $sample_value = null;
    /**
     * Optional. The selectable values that the user can choose from.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable.VariableChoice choices = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $choices;
    /**
     * Optional. `True` if a user can specify an 'other' value. For example, if
     * a variable called backgroundColor is defined as a list with values: red,
     * green, blue, this boolean can be set to allow a user to enter a value not
     * on the list such as purple.
     *
     * Generated from protobuf field <code>optional bool allow_other_choice = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allow_other_choice = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $default_value
     *           Optional. Default value to be filled in when creating creatives from the
     *           creative template.
     *     @type string $sample_value
     *           Optional. Sample value that is used when previewing the template in the
     *           UI.
     *     @type array<\Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable\VariableChoice>|\Google\Protobuf\Internal\RepeatedField $choices
     *           Optional. The selectable values that the user can choose from.
     *     @type bool $allow_other_choice
     *           Optional. `True` if a user can specify an 'other' value. For example, if
     *           a variable called backgroundColor is defined as a list with values: red,
     *           green, blue, this boolean can be set to allow a user to enter a value not
     *           on the list such as purple.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\CreativeTemplateMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Default value to be filled in when creating creatives from the
     * creative template.
     *
     * Generated from protobuf field <code>optional string default_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDefaultValue()
    {
        return isset($this->default_value) ? $this->default_value : '';
    }

    public function hasDefaultValue()
    {
        return isset($this->default_value);
    }

    public function clearDefaultValue()
    {
        unset($this->default_value);
    }

    /**
     * Optional. Default value to be filled in when creating creatives from the
     * creative template.
     *
     * Generated from protobuf field <code>optional string default_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDefaultValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->default_value = $var;

        return $this;
    }

    /**
     * Optional. Sample value that is used when previewing the template in the
     * UI.
     *
     * Generated from protobuf field <code>optional string sample_value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSampleValue()
    {
        return isset($this->sample_value) ? $this->sample_value : '';
    }

    public function hasSampleValue()
    {
        return isset($this->sample_value);
    }

    public function clearSampleValue()
    {
        unset($this->sample_value);
    }

    /**
     * Optional. Sample value that is used when previewing the template in the
     * UI.
     *
     * Generated from protobuf field <code>optional string sample_value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSampleValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->sample_value = $var;

        return $this;
    }

    /**
     * Optional. The selectable values that the user can choose from.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable.VariableChoice choices = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getChoices()
    {
        return $this->choices;
    }

    /**
     * Optional. The selectable values that the user can choose from.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable.VariableChoice choices = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable\VariableChoice>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setChoices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable\VariableChoice::class);
        $this->choices = $arr;

        return $this;
    }

    /**
     * Optional. `True` if a user can specify an 'other' value. For example, if
     * a variable called backgroundColor is defined as a list with values: red,
     * green, blue, this boolean can be set to allow a user to enter a value not
     * on the list such as purple.
     *
     * Generated from protobuf field <code>optional bool allow_other_choice = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAllowOtherChoice()
    {
        return isset($this->allow_other_choice) ? $this->allow_other_choice : false;
    }

    public function hasAllowOtherChoice()
    {
        return isset($this->allow_other_choice);
    }

    public function clearAllowOtherChoice()
    {
        unset($this->allow_other_choice);
    }

    /**
     * Optional. `True` if a user can specify an 'other' value. For example, if
     * a variable called backgroundColor is defined as a list with values: red,
     * green, blue, this boolean can be set to allow a user to enter a value not
     * on the list such as purple.
     *
     * Generated from protobuf field <code>optional bool allow_other_choice = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowOtherChoice($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_other_choice = $var;

        return $this;
    }

}


