<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Sets the scheduling options for an Instance. NextID: 13
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Scheduling</code>
 */
class Scheduling extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.
     * By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>bool automatic_restart = 82385915;</code>
     */
    private $automatic_restart = false;
    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>string location_hint = 82084049;</code>
     */
    private $location_hint = '';
    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>int32 min_node_cpus = 48796219;</code>
     */
    private $min_node_cpus = 0;
    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 193364515;</code>
     */
    private $node_affinities;
    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling.OnHostMaintenance on_host_maintenance = 64616796;</code>
     */
    private $on_host_maintenance = 0;
    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>bool preemptible = 55767713;</code>
     */
    private $preemptible = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $automatic_restart
     *           Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.
     *           By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *     @type string $location_hint
     *           An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *     @type int $min_node_cpus
     *           The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *     @type \Google\Cloud\Compute\V1\SchedulingNodeAffinity[]|\Google\Protobuf\Internal\RepeatedField $node_affinities
     *           A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *     @type int $on_host_maintenance
     *           Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
     *     @type bool $preemptible
     *           Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.
     * By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>bool automatic_restart = 82385915;</code>
     * @return bool
     */
    public function getAutomaticRestart()
    {
        return $this->automatic_restart;
    }

    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.
     * By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>bool automatic_restart = 82385915;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutomaticRestart($var)
    {
        GPBUtil::checkBool($var);
        $this->automatic_restart = $var;

        return $this;
    }

    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>string location_hint = 82084049;</code>
     * @return string
     */
    public function getLocationHint()
    {
        return $this->location_hint;
    }

    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>string location_hint = 82084049;</code>
     * @param string $var
     * @return $this
     */
    public function setLocationHint($var)
    {
        GPBUtil::checkString($var, True);
        $this->location_hint = $var;

        return $this;
    }

    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>int32 min_node_cpus = 48796219;</code>
     * @return int
     */
    public function getMinNodeCpus()
    {
        return $this->min_node_cpus;
    }

    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>int32 min_node_cpus = 48796219;</code>
     * @param int $var
     * @return $this
     */
    public function setMinNodeCpus($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_node_cpus = $var;

        return $this;
    }

    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 193364515;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNodeAffinities()
    {
        return $this->node_affinities;
    }

    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 193364515;</code>
     * @param \Google\Cloud\Compute\V1\SchedulingNodeAffinity[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNodeAffinities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\SchedulingNodeAffinity::class);
        $this->node_affinities = $arr;

        return $this;
    }

    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling.OnHostMaintenance on_host_maintenance = 64616796;</code>
     * @return int
     */
    public function getOnHostMaintenance()
    {
        return $this->on_host_maintenance;
    }

    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling.OnHostMaintenance on_host_maintenance = 64616796;</code>
     * @param int $var
     * @return $this
     */
    public function setOnHostMaintenance($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Scheduling\OnHostMaintenance::class);
        $this->on_host_maintenance = $var;

        return $this;
    }

    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>bool preemptible = 55767713;</code>
     * @return bool
     */
    public function getPreemptible()
    {
        return $this->preemptible;
    }

    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>bool preemptible = 55767713;</code>
     * @param bool $var
     * @return $this
     */
    public function setPreemptible($var)
    {
        GPBUtil::checkBool($var);
        $this->preemptible = $var;

        return $this;
    }

}

