<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1\DvrSession;

use UnexpectedValueException;

/**
 * State of the DVR session.
 *
 * Protobuf type <code>google.cloud.video.livestream.v1.DvrSession.State</code>
 */
class State
{
    /**
     * State is not specified.
     *
     * Generated from protobuf enum <code>STATE_UNSPECIFIED = 0;</code>
     */
    const STATE_UNSPECIFIED = 0;
    /**
     * The operation is pending to be picked up by the server.
     *
     * Generated from protobuf enum <code>PENDING = 1;</code>
     */
    const PENDING = 1;
    /**
     * The session is being updated.
     *
     * Generated from protobuf enum <code>UPDATING = 2;</code>
     */
    const UPDATING = 2;
    /**
     * The session is scheduled and waiting for the start time.
     *
     * Generated from protobuf enum <code>SCHEDULED = 3;</code>
     */
    const SCHEDULED = 3;
    /**
     * The session is currently in progress and the outputs are available in the
     * specified Cloud Storage bucket. For additional information, see the
     * `dvr_manifests.output_uri` field.
     *
     * Generated from protobuf enum <code>LIVE = 4;</code>
     */
    const LIVE = 4;
    /**
     * Outputs are available in the specified Cloud Storage bucket. For
     * additional information, see the `dvr_manifests.output_uri` field.
     *
     * Generated from protobuf enum <code>FINISHED = 5;</code>
     */
    const FINISHED = 5;
    /**
     * The operation has failed. For additional information, see the `error`
     * field.
     *
     * Generated from protobuf enum <code>FAILED = 6;</code>
     */
    const FAILED = 6;
    /**
     * The session is being deleted.
     *
     * Generated from protobuf enum <code>DELETING = 7;</code>
     */
    const DELETING = 7;
    /**
     * The session is being post processed.
     *
     * Generated from protobuf enum <code>POST_PROCESSING = 8;</code>
     */
    const POST_PROCESSING = 8;
    /**
     * The session is in cooldown. The cooldown period lasts for 60 seconds.
     * When the DVR session is updated by the user to have a new end time that
     * is likely already in the past, the DVR manifest will end as soon as
     * possible and the DVR session will move to this state. This is done to
     * prevent the players to receive a manifest update that removes a segment
     * that has already been played. After the cooldown period ends, a new
     * manifest is generated that honors the new end time.
     *
     * Generated from protobuf enum <code>COOLDOWN = 9;</code>
     */
    const COOLDOWN = 9;
    /**
     * The session is being stopped. The session will move to STOPPING state, if
     * the parent channel is updated.
     *
     * Generated from protobuf enum <code>STOPPING = 10;</code>
     */
    const STOPPING = 10;

    private static $valueToName = [
        self::STATE_UNSPECIFIED => 'STATE_UNSPECIFIED',
        self::PENDING => 'PENDING',
        self::UPDATING => 'UPDATING',
        self::SCHEDULED => 'SCHEDULED',
        self::LIVE => 'LIVE',
        self::FINISHED => 'FINISHED',
        self::FAILED => 'FAILED',
        self::DELETING => 'DELETING',
        self::POST_PROCESSING => 'POST_PROCESSING',
        self::COOLDOWN => 'COOLDOWN',
        self::STOPPING => 'STOPPING',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


