<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/locationfinder/v1/cloud_location.proto

namespace Google\Cloud\LocationFinder\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message for searching cloud locations from a given source location.
 *
 * Generated from protobuf message <code>google.cloud.locationfinder.v1.SearchCloudLocationsRequest</code>
 */
class SearchCloudLocationsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent, which owns this collection of cloud locations.
     * Format: projects/{project}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The source cloud location to search from.
     * Example search can be searching nearby cloud locations from the source
     * cloud location by latency.
     *
     * Generated from protobuf field <code>string source_cloud_location = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $source_cloud_location = '';
    /**
     * Optional. The maximum number of cloud locations to return. The service
     * might return fewer cloud locations than this value. If unspecified, server
     * will pick an appropriate default.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. A token identifying a page of results the server should return.
     * Provide Page token returned by a previous 'ListCloudLocations' call to
     * retrieve the next page of results. When paginating, all other parameters
     * provided to 'ListCloudLocations' must match the call that provided the page
     * token.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Optional. The query string in search query syntax. While filter is used to
     * filter the search results by attributes, query is used to specify the
     * search requirements.
     *
     * Generated from protobuf field <code>string query = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $query = '';

    /**
     * @param string $parent              Required. The parent, which owns this collection of cloud locations.
     *                                    Format: projects/{project}/locations/{location}
     *                                    Please see {@see CloudLocationFinderClient::locationName()} for help formatting this field.
     * @param string $sourceCloudLocation Required. The source cloud location to search from.
     *                                    Example search can be searching nearby cloud locations from the source
     *                                    cloud location by latency. Please see
     *                                    {@see CloudLocationFinderClient::cloudLocationName()} for help formatting this field.
     * @param string $query               Optional. The query string in search query syntax. While filter is used to
     *                                    filter the search results by attributes, query is used to specify the
     *                                    search requirements.
     *
     * @return \Google\Cloud\LocationFinder\V1\SearchCloudLocationsRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $sourceCloudLocation, string $query): self
    {
        return (new self())
            ->setParent($parent)
            ->setSourceCloudLocation($sourceCloudLocation)
            ->setQuery($query);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent, which owns this collection of cloud locations.
     *           Format: projects/{project}/locations/{location}
     *     @type string $source_cloud_location
     *           Required. The source cloud location to search from.
     *           Example search can be searching nearby cloud locations from the source
     *           cloud location by latency.
     *     @type int $page_size
     *           Optional. The maximum number of cloud locations to return. The service
     *           might return fewer cloud locations than this value. If unspecified, server
     *           will pick an appropriate default.
     *     @type string $page_token
     *           Optional. A token identifying a page of results the server should return.
     *           Provide Page token returned by a previous 'ListCloudLocations' call to
     *           retrieve the next page of results. When paginating, all other parameters
     *           provided to 'ListCloudLocations' must match the call that provided the page
     *           token.
     *     @type string $query
     *           Optional. The query string in search query syntax. While filter is used to
     *           filter the search results by attributes, query is used to specify the
     *           search requirements.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Locationfinder\V1\CloudLocation::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent, which owns this collection of cloud locations.
     * Format: projects/{project}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent, which owns this collection of cloud locations.
     * Format: projects/{project}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The source cloud location to search from.
     * Example search can be searching nearby cloud locations from the source
     * cloud location by latency.
     *
     * Generated from protobuf field <code>string source_cloud_location = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceCloudLocation()
    {
        return $this->source_cloud_location;
    }

    /**
     * Required. The source cloud location to search from.
     * Example search can be searching nearby cloud locations from the source
     * cloud location by latency.
     *
     * Generated from protobuf field <code>string source_cloud_location = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceCloudLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_cloud_location = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of cloud locations to return. The service
     * might return fewer cloud locations than this value. If unspecified, server
     * will pick an appropriate default.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of cloud locations to return. The service
     * might return fewer cloud locations than this value. If unspecified, server
     * will pick an appropriate default.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. A token identifying a page of results the server should return.
     * Provide Page token returned by a previous 'ListCloudLocations' call to
     * retrieve the next page of results. When paginating, all other parameters
     * provided to 'ListCloudLocations' must match the call that provided the page
     * token.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. A token identifying a page of results the server should return.
     * Provide Page token returned by a previous 'ListCloudLocations' call to
     * retrieve the next page of results. When paginating, all other parameters
     * provided to 'ListCloudLocations' must match the call that provided the page
     * token.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. The query string in search query syntax. While filter is used to
     * filter the search results by attributes, query is used to specify the
     * search requirements.
     *
     * Generated from protobuf field <code>string query = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Optional. The query string in search query syntax. While filter is used to
     * filter the search results by attributes, query is used to specify the
     * search requirements.
     *
     * Generated from protobuf field <code>string query = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

}

