<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/plugin_service.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * PluginInstanceAction represents an action which can be executed in the plugin
 * instance.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.PluginInstanceAction</code>
 */
class PluginInstanceAction extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. This should map to one of the [action
     * id][google.cloud.apihub.v1.PluginActionConfig.id] specified in
     * [actions_config][google.cloud.apihub.v1.Plugin.actions_config] in the
     * plugin.
     *
     * Generated from protobuf field <code>string action_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $action_id = '';
    /**
     * Output only. The current state of the plugin action in the plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Optional. The schedule for this plugin instance action. This can only be
     * set if the plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
     *
     * Generated from protobuf field <code>string schedule_cron_expression = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $schedule_cron_expression = '';
    /**
     * Optional. This configuration should be provided if the plugin action is
     * publishing data to API hub curate layer.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.CurationConfig curation_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $curation_config = null;
    /**
     * Optional. The time zone for the schedule cron expression. If not provided,
     * UTC will be used.
     *
     * Generated from protobuf field <code>string schedule_time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $schedule_time_zone = '';
    /**
     * Optional. The service account used to publish data. Note, the service
     * account will only be accepted for non GCP plugins like OPDK.
     *
     * Generated from protobuf field <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_account = '';
    /**
     * Output only. The configuration of resources created for a given plugin
     * instance action. Note these will be returned only in case of Non-GCP
     * plugins like OPDK.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.ResourceConfig resource_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $resource_config = null;
    protected $action_status;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ApiHub\V1\ExecutionStatus $hub_instance_action
     *           Optional. The execution information for the plugin instance action done
     *           corresponding to an API hub instance.
     *     @type string $action_id
     *           Required. This should map to one of the [action
     *           id][google.cloud.apihub.v1.PluginActionConfig.id] specified in
     *           [actions_config][google.cloud.apihub.v1.Plugin.actions_config] in the
     *           plugin.
     *     @type int $state
     *           Output only. The current state of the plugin action in the plugin instance.
     *     @type string $schedule_cron_expression
     *           Optional. The schedule for this plugin instance action. This can only be
     *           set if the plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
     *     @type \Google\Cloud\ApiHub\V1\CurationConfig $curation_config
     *           Optional. This configuration should be provided if the plugin action is
     *           publishing data to API hub curate layer.
     *     @type string $schedule_time_zone
     *           Optional. The time zone for the schedule cron expression. If not provided,
     *           UTC will be used.
     *     @type string $service_account
     *           Optional. The service account used to publish data. Note, the service
     *           account will only be accepted for non GCP plugins like OPDK.
     *     @type \Google\Cloud\ApiHub\V1\PluginInstanceAction\ResourceConfig $resource_config
     *           Output only. The configuration of resources created for a given plugin
     *           instance action. Note these will be returned only in case of Non-GCP
     *           plugins like OPDK.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\PluginService::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The execution information for the plugin instance action done
     * corresponding to an API hub instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.ExecutionStatus hub_instance_action = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\ExecutionStatus|null
     */
    public function getHubInstanceAction()
    {
        return $this->readOneof(6);
    }

    public function hasHubInstanceAction()
    {
        return $this->hasOneof(6);
    }

    /**
     * Optional. The execution information for the plugin instance action done
     * corresponding to an API hub instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.ExecutionStatus hub_instance_action = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\ExecutionStatus $var
     * @return $this
     */
    public function setHubInstanceAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\ExecutionStatus::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Required. This should map to one of the [action
     * id][google.cloud.apihub.v1.PluginActionConfig.id] specified in
     * [actions_config][google.cloud.apihub.v1.Plugin.actions_config] in the
     * plugin.
     *
     * Generated from protobuf field <code>string action_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getActionId()
    {
        return $this->action_id;
    }

    /**
     * Required. This should map to one of the [action
     * id][google.cloud.apihub.v1.PluginActionConfig.id] specified in
     * [actions_config][google.cloud.apihub.v1.Plugin.actions_config] in the
     * plugin.
     *
     * Generated from protobuf field <code>string action_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setActionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->action_id = $var;

        return $this;
    }

    /**
     * Output only. The current state of the plugin action in the plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the plugin action in the plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ApiHub\V1\PluginInstanceAction\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. The schedule for this plugin instance action. This can only be
     * set if the plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
     *
     * Generated from protobuf field <code>string schedule_cron_expression = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getScheduleCronExpression()
    {
        return $this->schedule_cron_expression;
    }

    /**
     * Optional. The schedule for this plugin instance action. This can only be
     * set if the plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
     *
     * Generated from protobuf field <code>string schedule_cron_expression = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setScheduleCronExpression($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule_cron_expression = $var;

        return $this;
    }

    /**
     * Optional. This configuration should be provided if the plugin action is
     * publishing data to API hub curate layer.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.CurationConfig curation_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\CurationConfig|null
     */
    public function getCurationConfig()
    {
        return $this->curation_config;
    }

    public function hasCurationConfig()
    {
        return isset($this->curation_config);
    }

    public function clearCurationConfig()
    {
        unset($this->curation_config);
    }

    /**
     * Optional. This configuration should be provided if the plugin action is
     * publishing data to API hub curate layer.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.CurationConfig curation_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\CurationConfig $var
     * @return $this
     */
    public function setCurationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\CurationConfig::class);
        $this->curation_config = $var;

        return $this;
    }

    /**
     * Optional. The time zone for the schedule cron expression. If not provided,
     * UTC will be used.
     *
     * Generated from protobuf field <code>string schedule_time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getScheduleTimeZone()
    {
        return $this->schedule_time_zone;
    }

    /**
     * Optional. The time zone for the schedule cron expression. If not provided,
     * UTC will be used.
     *
     * Generated from protobuf field <code>string schedule_time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setScheduleTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule_time_zone = $var;

        return $this;
    }

    /**
     * Optional. The service account used to publish data. Note, the service
     * account will only be accepted for non GCP plugins like OPDK.
     *
     * Generated from protobuf field <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Optional. The service account used to publish data. Note, the service
     * account will only be accepted for non GCP plugins like OPDK.
     *
     * Generated from protobuf field <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Output only. The configuration of resources created for a given plugin
     * instance action. Note these will be returned only in case of Non-GCP
     * plugins like OPDK.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.ResourceConfig resource_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\ApiHub\V1\PluginInstanceAction\ResourceConfig|null
     */
    public function getResourceConfig()
    {
        return $this->resource_config;
    }

    public function hasResourceConfig()
    {
        return isset($this->resource_config);
    }

    public function clearResourceConfig()
    {
        unset($this->resource_config);
    }

    /**
     * Output only. The configuration of resources created for a given plugin
     * instance action. Note these will be returned only in case of Non-GCP
     * plugins like OPDK.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstanceAction.ResourceConfig resource_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\ApiHub\V1\PluginInstanceAction\ResourceConfig $var
     * @return $this
     */
    public function setResourceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\PluginInstanceAction\ResourceConfig::class);
        $this->resource_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getActionStatus()
    {
        return $this->whichOneof("action_status");
    }

}

