<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/contactcenterinsights/v1/contact_center_insights.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ContactCenterInsights\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ContactCenterInsights\V1\Analysis;
use Google\Cloud\ContactCenterInsights\V1\BulkAnalyzeConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\BulkDeleteConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateIssueModelStatsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateIssueModelStatsResponse;
use Google\Cloud\ContactCenterInsights\V1\CalculateStatsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateStatsResponse;
use Google\Cloud\ContactCenterInsights\V1\Conversation;
use Google\Cloud\ContactCenterInsights\V1\CreateAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\CreatePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateViewRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\DeletePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteViewRequest;
use Google\Cloud\ContactCenterInsights\V1\DeployIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\ExportInsightsDataRequest;
use Google\Cloud\ContactCenterInsights\V1\GetAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\GetConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\GetIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\GetIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\GetPhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\GetSettingsRequest;
use Google\Cloud\ContactCenterInsights\V1\GetViewRequest;
use Google\Cloud\ContactCenterInsights\V1\IngestConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\Issue;
use Google\Cloud\ContactCenterInsights\V1\IssueModel;
use Google\Cloud\ContactCenterInsights\V1\ListAnalysesRequest;
use Google\Cloud\ContactCenterInsights\V1\ListConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\ListIssueModelsRequest;
use Google\Cloud\ContactCenterInsights\V1\ListIssueModelsResponse;
use Google\Cloud\ContactCenterInsights\V1\ListIssuesRequest;
use Google\Cloud\ContactCenterInsights\V1\ListIssuesResponse;
use Google\Cloud\ContactCenterInsights\V1\ListPhraseMatchersRequest;
use Google\Cloud\ContactCenterInsights\V1\ListViewsRequest;
use Google\Cloud\ContactCenterInsights\V1\PhraseMatcher;
use Google\Cloud\ContactCenterInsights\V1\Settings;
use Google\Cloud\ContactCenterInsights\V1\UndeployIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdatePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateSettingsRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateViewRequest;
use Google\Cloud\ContactCenterInsights\V1\UploadConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\View;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: An API that lets users analyze and explore their business conversation data.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface bulkAnalyzeConversationsAsync(BulkAnalyzeConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface bulkDeleteConversationsAsync(BulkDeleteConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface calculateIssueModelStatsAsync(CalculateIssueModelStatsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface calculateStatsAsync(CalculateStatsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAnalysisAsync(CreateAnalysisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConversationAsync(CreateConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createIssueModelAsync(CreateIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPhraseMatcherAsync(CreatePhraseMatcherRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createViewAsync(CreateViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAnalysisAsync(DeleteAnalysisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConversationAsync(DeleteConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteIssueAsync(DeleteIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteIssueModelAsync(DeleteIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePhraseMatcherAsync(DeletePhraseMatcherRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteViewAsync(DeleteViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deployIssueModelAsync(DeployIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportInsightsDataAsync(ExportInsightsDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAnalysisAsync(GetAnalysisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConversationAsync(GetConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIssueAsync(GetIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIssueModelAsync(GetIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPhraseMatcherAsync(GetPhraseMatcherRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSettingsAsync(GetSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getViewAsync(GetViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface ingestConversationsAsync(IngestConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAnalysesAsync(ListAnalysesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConversationsAsync(ListConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listIssueModelsAsync(ListIssueModelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listIssuesAsync(ListIssuesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPhraseMatchersAsync(ListPhraseMatchersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listViewsAsync(ListViewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeployIssueModelAsync(UndeployIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConversationAsync(UpdateConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateIssueAsync(UpdateIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateIssueModelAsync(UpdateIssueModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePhraseMatcherAsync(UpdatePhraseMatcherRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSettingsAsync(UpdateSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateViewAsync(UpdateViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface uploadConversationAsync(UploadConversationRequest $request, array $optionalArgs = [])
 */
final class ContactCenterInsightsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.contactcenterinsights.v1.ContactCenterInsights';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'contactcenterinsights.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'contactcenterinsights.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/contact_center_insights_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/contact_center_insights_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/contact_center_insights_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/contact_center_insights_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a analysis
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $analysis
     *
     * @return string The formatted analysis resource.
     */
    public static function analysisName(string $project, string $location, string $conversation, string $analysis): string
    {
        return self::getPathTemplate('analysis')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
            'analysis' => $analysis,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     */
    public static function conversationName(string $project, string $location, string $conversation): string
    {
        return self::getPathTemplate('conversation')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversation_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversationProfile
     *
     * @return string The formatted conversation_profile resource.
     */
    public static function conversationProfileName(string $project, string $location, string $conversationProfile): string
    {
        return self::getPathTemplate('conversationProfile')->render([
            'project' => $project,
            'location' => $location,
            'conversation_profile' => $conversationProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a issue
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $issueModel
     * @param string $issue
     *
     * @return string The formatted issue resource.
     */
    public static function issueName(string $project, string $location, string $issueModel, string $issue): string
    {
        return self::getPathTemplate('issue')->render([
            'project' => $project,
            'location' => $location,
            'issue_model' => $issueModel,
            'issue' => $issue,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a issue_model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $issueModel
     *
     * @return string The formatted issue_model resource.
     */
    public static function issueModelName(string $project, string $location, string $issueModel): string
    {
        return self::getPathTemplate('issueModel')->render([
            'project' => $project,
            'location' => $location,
            'issue_model' => $issueModel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a participant
     * resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted participant resource.
     */
    public static function participantName(string $project, string $conversation, string $participant): string
    {
        return self::getPathTemplate('participant')->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * phrase_matcher resource.
     *
     * @param string $project
     * @param string $location
     * @param string $phraseMatcher
     *
     * @return string The formatted phrase_matcher resource.
     */
    public static function phraseMatcherName(string $project, string $location, string $phraseMatcher): string
    {
        return self::getPathTemplate('phraseMatcher')->render([
            'project' => $project,
            'location' => $location,
            'phrase_matcher' => $phraseMatcher,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_participant resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_conversation_participant resource.
     */
    public static function projectConversationParticipantName(string $project, string $conversation, string $participant): string
    {
        return self::getPathTemplate('projectConversationParticipant')->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_participant resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_location_conversation_participant resource.
     */
    public static function projectLocationConversationParticipantName(string $project, string $location, string $conversation, string $participant): string
    {
        return self::getPathTemplate('projectLocationConversationParticipant')->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a recognizer
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recognizer
     *
     * @return string The formatted recognizer resource.
     */
    public static function recognizerName(string $project, string $location, string $recognizer): string
    {
        return self::getPathTemplate('recognizer')->render([
            'project' => $project,
            'location' => $location,
            'recognizer' => $recognizer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName(string $project, string $location): string
    {
        return self::getPathTemplate('settings')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a view
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $view
     *
     * @return string The formatted view resource.
     */
    public static function viewName(string $project, string $location, string $view): string
    {
        return self::getPathTemplate('view')->render([
            'project' => $project,
            'location' => $location,
            'view' => $view,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - analysis: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * - conversation: projects/{project}/locations/{location}/conversations/{conversation}
     * - conversationProfile: projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * - issue: projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * - issueModel: projects/{project}/locations/{location}/issueModels/{issue_model}
     * - location: projects/{project}/locations/{location}
     * - participant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - phraseMatcher: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * - projectConversationParticipant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - projectLocationConversationParticipant: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * - recognizer: projects/{project}/locations/{location}/recognizers/{recognizer}
     * - settings: projects/{project}/locations/{location}/settings
     * - view: projects/{project}/locations/{location}/views/{view}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'contactcenterinsights.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Analyzes multiple conversations in a single request.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::bulkAnalyzeConversationsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/bulk_analyze_conversations.php
     *
     * @param BulkAnalyzeConversationsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkAnalyzeConversations(BulkAnalyzeConversationsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkAnalyzeConversations', $request, $callOptions)->wait();
    }

    /**
     * Deletes multiple conversations in a single request.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::bulkDeleteConversationsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/bulk_delete_conversations.php
     *
     * @param BulkDeleteConversationsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkDeleteConversations(BulkDeleteConversationsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkDeleteConversations', $request, $callOptions)->wait();
    }

    /**
     * Gets an issue model's statistics.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::calculateIssueModelStatsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/calculate_issue_model_stats.php
     *
     * @param CalculateIssueModelStatsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CalculateIssueModelStatsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function calculateIssueModelStats(CalculateIssueModelStatsRequest $request, array $callOptions = []): CalculateIssueModelStatsResponse
    {
        return $this->startApiCall('CalculateIssueModelStats', $request, $callOptions)->wait();
    }

    /**
     * Gets conversation statistics.
     *
     * The async variant is {@see ContactCenterInsightsClient::calculateStatsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/calculate_stats.php
     *
     * @param CalculateStatsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CalculateStatsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function calculateStats(CalculateStatsRequest $request, array $callOptions = []): CalculateStatsResponse
    {
        return $this->startApiCall('CalculateStats', $request, $callOptions)->wait();
    }

    /**
     * Creates an analysis. The long running operation is done when the analysis
     * has completed.
     *
     * The async variant is {@see ContactCenterInsightsClient::createAnalysisAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/create_analysis.php
     *
     * @param CreateAnalysisRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAnalysis(CreateAnalysisRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAnalysis', $request, $callOptions)->wait();
    }

    /**
     * Creates a conversation.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::createConversationAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/create_conversation.php
     *
     * @param CreateConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConversation(CreateConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('CreateConversation', $request, $callOptions)->wait();
    }

    /**
     * Creates an issue model.
     *
     * The async variant is {@see ContactCenterInsightsClient::createIssueModelAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/create_issue_model.php
     *
     * @param CreateIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createIssueModel(CreateIssueModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Creates a phrase matcher.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::createPhraseMatcherAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/create_phrase_matcher.php
     *
     * @param CreatePhraseMatcherRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PhraseMatcher
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPhraseMatcher(CreatePhraseMatcherRequest $request, array $callOptions = []): PhraseMatcher
    {
        return $this->startApiCall('CreatePhraseMatcher', $request, $callOptions)->wait();
    }

    /**
     * Creates a view.
     *
     * The async variant is {@see ContactCenterInsightsClient::createViewAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/create_view.php
     *
     * @param CreateViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return View
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createView(CreateViewRequest $request, array $callOptions = []): View
    {
        return $this->startApiCall('CreateView', $request, $callOptions)->wait();
    }

    /**
     * Deletes an analysis.
     *
     * The async variant is {@see ContactCenterInsightsClient::deleteAnalysisAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_analysis.php
     *
     * @param DeleteAnalysisRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAnalysis(DeleteAnalysisRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAnalysis', $request, $callOptions)->wait();
    }

    /**
     * Deletes a conversation.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::deleteConversationAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_conversation.php
     *
     * @param DeleteConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConversation(DeleteConversationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConversation', $request, $callOptions)->wait();
    }

    /**
     * Deletes an issue.
     *
     * The async variant is {@see ContactCenterInsightsClient::deleteIssueAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_issue.php
     *
     * @param DeleteIssueRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIssue(DeleteIssueRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteIssue', $request, $callOptions)->wait();
    }

    /**
     * Deletes an issue model.
     *
     * The async variant is {@see ContactCenterInsightsClient::deleteIssueModelAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_issue_model.php
     *
     * @param DeleteIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIssueModel(DeleteIssueModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Deletes a phrase matcher.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::deletePhraseMatcherAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_phrase_matcher.php
     *
     * @param DeletePhraseMatcherRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePhraseMatcher(DeletePhraseMatcherRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeletePhraseMatcher', $request, $callOptions)->wait();
    }

    /**
     * Deletes a view.
     *
     * The async variant is {@see ContactCenterInsightsClient::deleteViewAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/delete_view.php
     *
     * @param DeleteViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteView(DeleteViewRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteView', $request, $callOptions)->wait();
    }

    /**
     * Deploys an issue model. Returns an error if a model is already deployed.
     * An issue model can only be used in analysis after it has been deployed.
     *
     * The async variant is {@see ContactCenterInsightsClient::deployIssueModelAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/deploy_issue_model.php
     *
     * @param DeployIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deployIssueModel(DeployIssueModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeployIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Export insights data to a destination defined in the request body.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::exportInsightsDataAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/export_insights_data.php
     *
     * @param ExportInsightsDataRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportInsightsData(ExportInsightsDataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportInsightsData', $request, $callOptions)->wait();
    }

    /**
     * Gets an analysis.
     *
     * The async variant is {@see ContactCenterInsightsClient::getAnalysisAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_analysis.php
     *
     * @param GetAnalysisRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Analysis
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAnalysis(GetAnalysisRequest $request, array $callOptions = []): Analysis
    {
        return $this->startApiCall('GetAnalysis', $request, $callOptions)->wait();
    }

    /**
     * Gets a conversation.
     *
     * The async variant is {@see ContactCenterInsightsClient::getConversationAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_conversation.php
     *
     * @param GetConversationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConversation(GetConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('GetConversation', $request, $callOptions)->wait();
    }

    /**
     * Gets an issue.
     *
     * The async variant is {@see ContactCenterInsightsClient::getIssueAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_issue.php
     *
     * @param GetIssueRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Issue
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIssue(GetIssueRequest $request, array $callOptions = []): Issue
    {
        return $this->startApiCall('GetIssue', $request, $callOptions)->wait();
    }

    /**
     * Gets an issue model.
     *
     * The async variant is {@see ContactCenterInsightsClient::getIssueModelAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_issue_model.php
     *
     * @param GetIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IssueModel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIssueModel(GetIssueModelRequest $request, array $callOptions = []): IssueModel
    {
        return $this->startApiCall('GetIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Gets a phrase matcher.
     *
     * The async variant is {@see ContactCenterInsightsClient::getPhraseMatcherAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_phrase_matcher.php
     *
     * @param GetPhraseMatcherRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PhraseMatcher
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPhraseMatcher(GetPhraseMatcherRequest $request, array $callOptions = []): PhraseMatcher
    {
        return $this->startApiCall('GetPhraseMatcher', $request, $callOptions)->wait();
    }

    /**
     * Gets project-level settings.
     *
     * The async variant is {@see ContactCenterInsightsClient::getSettingsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_settings.php
     *
     * @param GetSettingsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Settings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSettings(GetSettingsRequest $request, array $callOptions = []): Settings
    {
        return $this->startApiCall('GetSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets a view.
     *
     * The async variant is {@see ContactCenterInsightsClient::getViewAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/get_view.php
     *
     * @param GetViewRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return View
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getView(GetViewRequest $request, array $callOptions = []): View
    {
        return $this->startApiCall('GetView', $request, $callOptions)->wait();
    }

    /**
     * Imports conversations and processes them according to the user's
     * configuration.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::ingestConversationsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/ingest_conversations.php
     *
     * @param IngestConversationsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function ingestConversations(IngestConversationsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('IngestConversations', $request, $callOptions)->wait();
    }

    /**
     * Lists analyses.
     *
     * The async variant is {@see ContactCenterInsightsClient::listAnalysesAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_analyses.php
     *
     * @param ListAnalysesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAnalyses(ListAnalysesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAnalyses', $request, $callOptions);
    }

    /**
     * Lists conversations.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::listConversationsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_conversations.php
     *
     * @param ListConversationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConversations(ListConversationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversations', $request, $callOptions);
    }

    /**
     * Lists issue models.
     *
     * The async variant is {@see ContactCenterInsightsClient::listIssueModelsAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_issue_models.php
     *
     * @param ListIssueModelsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListIssueModelsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIssueModels(ListIssueModelsRequest $request, array $callOptions = []): ListIssueModelsResponse
    {
        return $this->startApiCall('ListIssueModels', $request, $callOptions)->wait();
    }

    /**
     * Lists issues.
     *
     * The async variant is {@see ContactCenterInsightsClient::listIssuesAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_issues.php
     *
     * @param ListIssuesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListIssuesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIssues(ListIssuesRequest $request, array $callOptions = []): ListIssuesResponse
    {
        return $this->startApiCall('ListIssues', $request, $callOptions)->wait();
    }

    /**
     * Lists phrase matchers.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::listPhraseMatchersAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_phrase_matchers.php
     *
     * @param ListPhraseMatchersRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPhraseMatchers(ListPhraseMatchersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPhraseMatchers', $request, $callOptions);
    }

    /**
     * Lists views.
     *
     * The async variant is {@see ContactCenterInsightsClient::listViewsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/list_views.php
     *
     * @param ListViewsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listViews(ListViewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListViews', $request, $callOptions);
    }

    /**
     * Undeploys an issue model.
     * An issue model can not be used in analysis after it has been undeployed.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::undeployIssueModelAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/undeploy_issue_model.php
     *
     * @param UndeployIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeployIssueModel(UndeployIssueModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeployIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Updates a conversation.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::updateConversationAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_conversation.php
     *
     * @param UpdateConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConversation(UpdateConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('UpdateConversation', $request, $callOptions)->wait();
    }

    /**
     * Updates an issue.
     *
     * The async variant is {@see ContactCenterInsightsClient::updateIssueAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_issue.php
     *
     * @param UpdateIssueRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Issue
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateIssue(UpdateIssueRequest $request, array $callOptions = []): Issue
    {
        return $this->startApiCall('UpdateIssue', $request, $callOptions)->wait();
    }

    /**
     * Updates an issue model.
     *
     * The async variant is {@see ContactCenterInsightsClient::updateIssueModelAsync()}
     * .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_issue_model.php
     *
     * @param UpdateIssueModelRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IssueModel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateIssueModel(UpdateIssueModelRequest $request, array $callOptions = []): IssueModel
    {
        return $this->startApiCall('UpdateIssueModel', $request, $callOptions)->wait();
    }

    /**
     * Updates a phrase matcher.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::updatePhraseMatcherAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_phrase_matcher.php
     *
     * @param UpdatePhraseMatcherRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PhraseMatcher
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePhraseMatcher(UpdatePhraseMatcherRequest $request, array $callOptions = []): PhraseMatcher
    {
        return $this->startApiCall('UpdatePhraseMatcher', $request, $callOptions)->wait();
    }

    /**
     * Updates project-level settings.
     *
     * The async variant is {@see ContactCenterInsightsClient::updateSettingsAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_settings.php
     *
     * @param UpdateSettingsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Settings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSettings(UpdateSettingsRequest $request, array $callOptions = []): Settings
    {
        return $this->startApiCall('UpdateSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a view.
     *
     * The async variant is {@see ContactCenterInsightsClient::updateViewAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/update_view.php
     *
     * @param UpdateViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return View
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateView(UpdateViewRequest $request, array $callOptions = []): View
    {
        return $this->startApiCall('UpdateView', $request, $callOptions)->wait();
    }

    /**
     * Create a longrunning conversation upload operation. This method differs
     * from CreateConversation by allowing audio transcription and optional DLP
     * redaction.
     *
     * The async variant is
     * {@see ContactCenterInsightsClient::uploadConversationAsync()} .
     *
     * @example samples/V1/ContactCenterInsightsClient/upload_conversation.php
     *
     * @param UploadConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function uploadConversation(UploadConversationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UploadConversation', $request, $callOptions)->wait();
    }
}
