<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/batch_prediction_job.proto

namespace Google\Cloud\AIPlatform\V1\BatchPredictionJob;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures the output of
 * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob]. See
 * [Model.supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats]
 * for supported output formats, and how predictions are expressed via any of
 * them.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig</code>
 */
class OutputConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     *
     * Generated from protobuf field <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $predictions_format = '';
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\GcsDestination $gcs_destination
     *           The Cloud Storage location of the directory where the output is
     *           to be written to. In the given directory a new directory is created.
     *           Its name is `prediction-<model-display-name>-<job-create-time>`,
     *           where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     *           Inside of it files `predictions_0001.<extension>`,
     *           `predictions_0002.<extension>`, ..., `predictions_N.<extension>`
     *           are created where `<extension>` depends on chosen
     *           [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format],
     *           and N may equal 0001 and depends on the total number of successfully
     *           predicted instances. If the Model has both
     *           [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     *           and
     *           [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     *           schemata defined then each such file contains predictions as per the
     *           [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format].
     *           If prediction for any instance failed (partially or completely), then
     *           an additional `errors_0001.<extension>`, `errors_0002.<extension>`,...,
     *           `errors_N.<extension>` files are created (N depends on total number
     *           of failed predictions). These files contain the failed instances,
     *           as per their schema, followed by an additional `error` field which as
     *           value has [google.rpc.Status][google.rpc.Status]
     *           containing only `code` and `message` fields.
     *     @type \Google\Cloud\AIPlatform\V1\BigQueryDestination $bigquery_destination
     *           The BigQuery project or dataset location where the output is to be
     *           written to. If project is provided, a new dataset is created with name
     *           `prediction_<model-display-name>_<job-create-time>`
     *           where <model-display-name> is made
     *           BigQuery-dataset-name compatible (for example, most special characters
     *           become underscores), and timestamp is in
     *           YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     *           two tables will be created, `predictions`, and `errors`.
     *           If the Model has both
     *           [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     *           and
     *           [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     *           schemata defined then the tables have columns as follows: The
     *           `predictions` table contains instances for which the prediction
     *           succeeded, it has columns as per a concatenation of the Model's
     *           instance and prediction schemata. The `errors` table contains rows for
     *           which the prediction has failed, it has instance columns, as per the
     *           instance schema, followed by a single "errors" column, which as values
     *           has [google.rpc.Status][google.rpc.Status]
     *           represented as a STRUCT, and containing only `code` and `message`.
     *     @type string $predictions_format
     *           Required. The format in which Vertex AI gives the predictions, must be
     *           one of the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     *           [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\BatchPredictionJob::initOnce();
        parent::__construct($data);
    }

    /**
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-<model-display-name>-<job-create-time>`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.<extension>`,
     * `predictions_0002.<extension>`, ..., `predictions_N.<extension>`
     * are created where `<extension>` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.<extension>`, `errors_0002.<extension>`,...,
     * `errors_N.<extension>` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination gcs_destination = 2;</code>
     * @return \Google\Cloud\AIPlatform\V1\GcsDestination|null
     */
    public function getGcsDestination()
    {
        return $this->readOneof(2);
    }

    public function hasGcsDestination()
    {
        return $this->hasOneof(2);
    }

    /**
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-<model-display-name>-<job-create-time>`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.<extension>`,
     * `predictions_0002.<extension>`, ..., `predictions_N.<extension>`
     * are created where `<extension>` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.<extension>`, `errors_0002.<extension>`,...,
     * `errors_N.<extension>` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination gcs_destination = 2;</code>
     * @param \Google\Cloud\AIPlatform\V1\GcsDestination $var
     * @return $this
     */
    public function setGcsDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GcsDestination::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_<model-display-name>_<job-create-time>`
     * where <model-display-name> is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQueryDestination bigquery_destination = 3;</code>
     * @return \Google\Cloud\AIPlatform\V1\BigQueryDestination|null
     */
    public function getBigqueryDestination()
    {
        return $this->readOneof(3);
    }

    public function hasBigqueryDestination()
    {
        return $this->hasOneof(3);
    }

    /**
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_<model-display-name>_<job-create-time>`
     * where <model-display-name> is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQueryDestination bigquery_destination = 3;</code>
     * @param \Google\Cloud\AIPlatform\V1\BigQueryDestination $var
     * @return $this
     */
    public function setBigqueryDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BigQueryDestination::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     *
     * Generated from protobuf field <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPredictionsFormat()
    {
        return $this->predictions_format;
    }

    /**
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     *
     * Generated from protobuf field <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPredictionsFormat($var)
    {
        GPBUtil::checkString($var, True);
        $this->predictions_format = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}


