<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securitycenter/v1/securitycenter_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecurityCenter\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\SecurityCenter\V1\BigQueryExport;
use Google\Cloud\SecurityCenter\V1\BulkMuteFindingsRequest;
use Google\Cloud\SecurityCenter\V1\CreateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\CreateFindingRequest;
use Google\Cloud\SecurityCenter\V1\CreateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\CreateSourceRequest;
use Google\Cloud\SecurityCenter\V1\DeleteBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\DeleteMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\EffectiveSecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\ExternalSystem;
use Google\Cloud\SecurityCenter\V1\Finding;
use Google\Cloud\SecurityCenter\V1\GetBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\GetEffectiveSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\GetSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetSourceRequest;
use Google\Cloud\SecurityCenter\V1\GroupAssetsRequest;
use Google\Cloud\SecurityCenter\V1\GroupFindingsRequest;
use Google\Cloud\SecurityCenter\V1\ListAssetsRequest;
use Google\Cloud\SecurityCenter\V1\ListBigQueryExportsRequest;
use Google\Cloud\SecurityCenter\V1\ListDescendantSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEffectiveSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListFindingsRequest;
use Google\Cloud\SecurityCenter\V1\ListMuteConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListNotificationConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListSourcesRequest;
use Google\Cloud\SecurityCenter\V1\MuteConfig;
use Google\Cloud\SecurityCenter\V1\NotificationConfig;
use Google\Cloud\SecurityCenter\V1\OrganizationSettings;
use Google\Cloud\SecurityCenter\V1\RunAssetDiscoveryRequest;
use Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\SecurityMarks;
use Google\Cloud\SecurityCenter\V1\SetFindingStateRequest;
use Google\Cloud\SecurityCenter\V1\SetMuteRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleResponse;
use Google\Cloud\SecurityCenter\V1\Source;
use Google\Cloud\SecurityCenter\V1\UpdateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\UpdateExternalSystemRequest;
use Google\Cloud\SecurityCenter\V1\UpdateFindingRequest;
use Google\Cloud\SecurityCenter\V1\UpdateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityMarksRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSourceRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: V1 APIs for Security Center service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\SecurityCenter\V1\SecurityCenterClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @method PromiseInterface bulkMuteFindingsAsync(BulkMuteFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBigQueryExportAsync(CreateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createFindingAsync(CreateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMuteConfigAsync(CreateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNotificationConfigAsync(CreateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSecurityHealthAnalyticsCustomModuleAsync(CreateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSourceAsync(CreateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBigQueryExportAsync(DeleteBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMuteConfigAsync(DeleteMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNotificationConfigAsync(DeleteNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSecurityHealthAnalyticsCustomModuleAsync(DeleteSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBigQueryExportAsync(GetBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveSecurityHealthAnalyticsCustomModuleAsync(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMuteConfigAsync(GetMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNotificationConfigAsync(GetNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getOrganizationSettingsAsync(GetOrganizationSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSecurityHealthAnalyticsCustomModuleAsync(GetSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSourceAsync(GetSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface groupAssetsAsync(GroupAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface groupFindingsAsync(GroupFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAssetsAsync(ListAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBigQueryExportsAsync(ListBigQueryExportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDescendantSecurityHealthAnalyticsCustomModulesAsync(ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEffectiveSecurityHealthAnalyticsCustomModulesAsync(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFindingsAsync(ListFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMuteConfigsAsync(ListMuteConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNotificationConfigsAsync(ListNotificationConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSecurityHealthAnalyticsCustomModulesAsync(ListSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSourcesAsync(ListSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface runAssetDiscoveryAsync(RunAssetDiscoveryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setFindingStateAsync(SetFindingStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMuteAsync(SetMuteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface simulateSecurityHealthAnalyticsCustomModuleAsync(SimulateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBigQueryExportAsync(UpdateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExternalSystemAsync(UpdateExternalSystemRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateFindingAsync(UpdateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMuteConfigAsync(UpdateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNotificationConfigAsync(UpdateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateOrganizationSettingsAsync(UpdateOrganizationSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSecurityHealthAnalyticsCustomModuleAsync(UpdateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSecurityMarksAsync(UpdateSecurityMarksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSourceAsync(UpdateSourceRequest $request, array $optionalArgs = [])
 */
final class SecurityCenterClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securitycenter.v1.SecurityCenter';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'securitycenter.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/security_center_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/security_center_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/security_center_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/security_center_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted big_query_export resource.
     */
    public static function bigQueryExportName(string $organization, string $export): string
    {
        return self::getPathTemplate('bigQueryExport')->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('dlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted effective_security_health_analytics_custom_module resource.
     */
    public static function effectiveSecurityHealthAnalyticsCustomModuleName(string $organization, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('effectiveSecurityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_system resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted external_system resource.
     */
    public static function externalSystemName(string $organization, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('externalSystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a finding
     * resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted finding resource.
     */
    public static function findingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('finding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_asset_securityMarks resource.
     *
     * @param string $folder
     * @param string $asset
     *
     * @return string The formatted folder_asset_securityMarks resource.
     */
    public static function folderAssetSecurityMarksName(string $folder, string $asset): string
    {
        return self::getPathTemplate('folderAssetSecurityMarks')->render([
            'folder' => $folder,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_custom_module resource.
     *
     * @param string $folder
     * @param string $customModule
     *
     * @return string The formatted folder_custom_module resource.
     */
    public static function folderCustomModuleName(string $folder, string $customModule): string
    {
        return self::getPathTemplate('folderCustomModule')->render([
            'folder' => $folder,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_effective_custom_module resource.
     *
     * @param string $folder
     * @param string $effectiveCustomModule
     *
     * @return string The formatted folder_effective_custom_module resource.
     */
    public static function folderEffectiveCustomModuleName(string $folder, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('folderEffectiveCustomModule')->render([
            'folder' => $folder,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_export resource.
     *
     * @param string $folder
     * @param string $export
     *
     * @return string The formatted folder_export resource.
     */
    public static function folderExportName(string $folder, string $export): string
    {
        return self::getPathTemplate('folderExport')->render([
            'folder' => $folder,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_mute_config resource.
     *
     * @param string $folder
     * @param string $muteConfig
     *
     * @return string The formatted folder_mute_config resource.
     */
    public static function folderMuteConfigName(string $folder, string $muteConfig): string
    {
        return self::getPathTemplate('folderMuteConfig')->render([
            'folder' => $folder,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_notification_config resource.
     *
     * @param string $folder
     * @param string $notificationConfig
     *
     * @return string The formatted folder_notification_config resource.
     */
    public static function folderNotificationConfigName(string $folder, string $notificationConfig): string
    {
        return self::getPathTemplate('folderNotificationConfig')->render([
            'folder' => $folder,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_securityHealthAnalyticsSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_securityHealthAnalyticsSettings resource.
     */
    public static function folderSecurityHealthAnalyticsSettingsName(string $folder): string
    {
        return self::getPathTemplate('folderSecurityHealthAnalyticsSettings')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source resource.
     *
     * @param string $folder
     * @param string $source
     *
     * @return string The formatted folder_source resource.
     */
    public static function folderSourceName(string $folder, string $source): string
    {
        return self::getPathTemplate('folderSource')->render([
            'folder' => $folder,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding resource.
     */
    public static function folderSourceFindingName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFinding')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_externalsystem resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted folder_source_finding_externalsystem resource.
     */
    public static function folderSourceFindingExternalsystemName(string $folder, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('folderSourceFindingExternalsystem')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_securityMarks resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding_securityMarks resource.
     */
    public static function folderSourceFindingSecurityMarksName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFindingSecurityMarks')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mute_config
     * resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted mute_config resource.
     */
    public static function muteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('muteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted notification_config resource.
     */
    public static function notificationConfigName(string $organization, string $notificationConfig): string
    {
        return self::getPathTemplate('notificationConfig')->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_asset_securityMarks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted organization_asset_securityMarks resource.
     */
    public static function organizationAssetSecurityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('organizationAssetSecurityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted organization_custom_module resource.
     */
    public static function organizationCustomModuleName(string $organization, string $customModule): string
    {
        return self::getPathTemplate('organizationCustomModule')->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_effective_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted organization_effective_custom_module resource.
     */
    public static function organizationEffectiveCustomModuleName(string $organization, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('organizationEffectiveCustomModule')->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted organization_export resource.
     */
    public static function organizationExportName(string $organization, string $export): string
    {
        return self::getPathTemplate('organizationExport')->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_mute_config resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted organization_mute_config resource.
     */
    public static function organizationMuteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('organizationMuteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted organization_notification_config resource.
     */
    public static function organizationNotificationConfigName(string $organization, string $notificationConfig): string
    {
        return self::getPathTemplate('organizationNotificationConfig')->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_securityHealthAnalyticsSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_securityHealthAnalyticsSettings resource.
     */
    public static function organizationSecurityHealthAnalyticsSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationSecurityHealthAnalyticsSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_settings resource.
     */
    public static function organizationSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted organization_source resource.
     */
    public static function organizationSourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('organizationSource')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding resource.
     */
    public static function organizationSourceFindingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('organizationSourceFinding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_externalsystem resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted organization_source_finding_externalsystem resource.
     */
    public static function organizationSourceFindingExternalsystemName(string $organization, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('organizationSourceFindingExternalsystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_securityMarks resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding_securityMarks resource.
     */
    public static function organizationSourceFindingSecurityMarksName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('organizationSourceFindingSecurityMarks')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_asset_securityMarks resource.
     *
     * @param string $project
     * @param string $asset
     *
     * @return string The formatted project_asset_securityMarks resource.
     */
    public static function projectAssetSecurityMarksName(string $project, string $asset): string
    {
        return self::getPathTemplate('projectAssetSecurityMarks')->render([
            'project' => $project,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_custom_module resource.
     *
     * @param string $project
     * @param string $customModule
     *
     * @return string The formatted project_custom_module resource.
     */
    public static function projectCustomModuleName(string $project, string $customModule): string
    {
        return self::getPathTemplate('projectCustomModule')->render([
            'project' => $project,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('projectDlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_effective_custom_module resource.
     *
     * @param string $project
     * @param string $effectiveCustomModule
     *
     * @return string The formatted project_effective_custom_module resource.
     */
    public static function projectEffectiveCustomModuleName(string $project, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('projectEffectiveCustomModule')->render([
            'project' => $project,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_export resource.
     *
     * @param string $project
     * @param string $export
     *
     * @return string The formatted project_export resource.
     */
    public static function projectExportName(string $project, string $export): string
    {
        return self::getPathTemplate('projectExport')->render([
            'project' => $project,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName(string $project, string $location, string $dlpJob): string
    {
        return self::getPathTemplate('projectLocationDlpJob')->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableProfile
     *
     * @return string The formatted project_location_table_profile resource.
     */
    public static function projectLocationTableProfileName(string $project, string $location, string $tableProfile): string
    {
        return self::getPathTemplate('projectLocationTableProfile')->render([
            'project' => $project,
            'location' => $location,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_mute_config resource.
     *
     * @param string $project
     * @param string $muteConfig
     *
     * @return string The formatted project_mute_config resource.
     */
    public static function projectMuteConfigName(string $project, string $muteConfig): string
    {
        return self::getPathTemplate('projectMuteConfig')->render([
            'project' => $project,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_notification_config resource.
     *
     * @param string $project
     * @param string $notificationConfig
     *
     * @return string The formatted project_notification_config resource.
     */
    public static function projectNotificationConfigName(string $project, string $notificationConfig): string
    {
        return self::getPathTemplate('projectNotificationConfig')->render([
            'project' => $project,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_securityHealthAnalyticsSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_securityHealthAnalyticsSettings resource.
     */
    public static function projectSecurityHealthAnalyticsSettingsName(string $project): string
    {
        return self::getPathTemplate('projectSecurityHealthAnalyticsSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source resource.
     *
     * @param string $project
     * @param string $source
     *
     * @return string The formatted project_source resource.
     */
    public static function projectSourceName(string $project, string $source): string
    {
        return self::getPathTemplate('projectSource')->render([
            'project' => $project,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding resource.
     */
    public static function projectSourceFindingName(string $project, string $source, string $finding): string
    {
        return self::getPathTemplate('projectSourceFinding')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_externalsystem resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted project_source_finding_externalsystem resource.
     */
    public static function projectSourceFindingExternalsystemName(string $project, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('projectSourceFindingExternalsystem')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_securityMarks resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding_securityMarks resource.
     */
    public static function projectSourceFindingSecurityMarksName(string $project, string $source, string $finding): string
    {
        return self::getPathTemplate('projectSourceFindingSecurityMarks')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_table_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted project_table_profile resource.
     */
    public static function projectTableProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('projectTableProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted security_health_analytics_custom_module resource.
     */
    public static function securityHealthAnalyticsCustomModuleName(string $organization, string $customModule): string
    {
        return self::getPathTemplate('securityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted security_health_analytics_settings resource.
     */
    public static function securityHealthAnalyticsSettingsName(string $organization): string
    {
        return self::getPathTemplate('securityHealthAnalyticsSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_marks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted security_marks resource.
     */
    public static function securityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('securityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('source')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('tableDataProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - bigQueryExport: organizations/{organization}/bigQueryExports/{export}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - effectiveSecurityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - externalSystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - finding: organizations/{organization}/sources/{source}/findings/{finding}
     * - folder: folders/{folder}
     * - folderAssetSecurityMarks: folders/{folder}/assets/{asset}/securityMarks
     * - folderCustomModule: folders/{folder}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - folderEffectiveCustomModule: folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - folderExport: folders/{folder}/bigQueryExports/{export}
     * - folderMuteConfig: folders/{folder}/muteConfigs/{mute_config}
     * - folderNotificationConfig: folders/{folder}/notificationConfigs/{notification_config}
     * - folderSecurityHealthAnalyticsSettings: folders/{folder}/securityHealthAnalyticsSettings
     * - folderSource: folders/{folder}/sources/{source}
     * - folderSourceFinding: folders/{folder}/sources/{source}/findings/{finding}
     * - folderSourceFindingExternalsystem: folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - folderSourceFindingSecurityMarks: folders/{folder}/sources/{source}/findings/{finding}/securityMarks
     * - muteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - notificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organization: organizations/{organization}
     * - organizationAssetSecurityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - organizationCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - organizationEffectiveCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - organizationExport: organizations/{organization}/bigQueryExports/{export}
     * - organizationMuteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - organizationNotificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organizationSecurityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - organizationSettings: organizations/{organization}/organizationSettings
     * - organizationSource: organizations/{organization}/sources/{source}
     * - organizationSourceFinding: organizations/{organization}/sources/{source}/findings/{finding}
     * - organizationSourceFindingExternalsystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - organizationSourceFindingSecurityMarks: organizations/{organization}/sources/{source}/findings/{finding}/securityMarks
     * - project: projects/{project}
     * - projectAssetSecurityMarks: projects/{project}/assets/{asset}/securityMarks
     * - projectCustomModule: projects/{project}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectEffectiveCustomModule: projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - projectExport: projects/{project}/bigQueryExports/{export}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationTableProfile: projects/{project}/locations/{location}/tableProfiles/{table_profile}
     * - projectMuteConfig: projects/{project}/muteConfigs/{mute_config}
     * - projectNotificationConfig: projects/{project}/notificationConfigs/{notification_config}
     * - projectSecurityHealthAnalyticsSettings: projects/{project}/securityHealthAnalyticsSettings
     * - projectSource: projects/{project}/sources/{source}
     * - projectSourceFinding: projects/{project}/sources/{source}/findings/{finding}
     * - projectSourceFindingExternalsystem: projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - projectSourceFindingSecurityMarks: projects/{project}/sources/{source}/findings/{finding}/securityMarks
     * - projectTableProfile: projects/{project}/tableProfiles/{table_profile}
     * - securityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - securityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - securityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - source: organizations/{organization}/sources/{source}
     * - tableDataProfile: projects/{project}/tableProfiles/{table_profile}
     * - topic: projects/{project}/topics/{topic}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securitycenter.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Kicks off an LRO to bulk mute findings for a parent based on a filter. The
     * parent can be either an organization, folder or project. The findings
     * matched by the filter will be muted after the LRO is done.
     *
     * The async variant is {@see SecurityCenterClient::bulkMuteFindingsAsync()} .
     *
     * @param BulkMuteFindingsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkMuteFindings(BulkMuteFindingsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkMuteFindings', $request, $callOptions)->wait();
    }

    /**
     * Creates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::createBigQueryExportAsync()} .
     *
     * @param CreateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBigQueryExport(CreateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('CreateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Creates a finding. The corresponding source must exist for finding creation
     * to succeed.
     *
     * The async variant is {@see SecurityCenterClient::createFindingAsync()} .
     *
     * @param CreateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFinding(CreateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('CreateFinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a mute config.
     *
     * The async variant is {@see SecurityCenterClient::createMuteConfigAsync()} .
     *
     * @param CreateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMuteConfig(CreateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('CreateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::createNotificationConfigAsync()} .
     *
     * @param CreateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNotificationConfig(CreateNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('CreateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
     * given CRM parent, and also creates inherited
     * SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
     * parent. These modules are enabled by default.
     *
     * The async variant is
     * {@see SecurityCenterClient::createSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @param CreateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSecurityHealthAnalyticsCustomModule(CreateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('CreateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Creates a source.
     *
     * The async variant is {@see SecurityCenterClient::createSourceAsync()} .
     *
     * @param CreateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSource(CreateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('CreateSource', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::deleteBigQueryExportAsync()} .
     *
     * @param DeleteBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBigQueryExport(DeleteBigQueryExportRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing mute config.
     *
     * The async variant is {@see SecurityCenterClient::deleteMuteConfigAsync()} .
     *
     * @param DeleteMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMuteConfig(DeleteMuteConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteNotificationConfigAsync()} .
     *
     * @param DeleteNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotificationConfig(DeleteNotificationConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
     * descendants in the CRM hierarchy. This method is only supported for
     * resident custom modules.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @param DeleteSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSecurityHealthAnalyticsCustomModule(DeleteSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::getBigQueryExportAsync()} .
     *
     * @param GetBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBigQueryExport(GetBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('GetBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterClient::getEffectiveSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @param GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EffectiveSecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveSecurityHealthAnalyticsCustomModule(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): EffectiveSecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('GetEffectiveSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a mute config.
     *
     * The async variant is {@see SecurityCenterClient::getMuteConfigAsync()} .
     *
     * @param GetMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMuteConfig(GetMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('GetMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a notification config.
     *
     * The async variant is {@see SecurityCenterClient::getNotificationConfigAsync()} .
     *
     * @param GetNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotificationConfig(GetNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('GetNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the settings for an organization.
     *
     * The async variant is {@see SecurityCenterClient::getOrganizationSettingsAsync()}
     * .
     *
     * @param GetOrganizationSettingsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrganizationSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOrganizationSettings(GetOrganizationSettingsRequest $request, array $callOptions = []): OrganizationSettings
    {
        return $this->startApiCall('GetOrganizationSettings', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a SecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterClient::getSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @param GetSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSecurityHealthAnalyticsCustomModule(GetSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('GetSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets a source.
     *
     * The async variant is {@see SecurityCenterClient::getSourceAsync()} .
     *
     * @param GetSourceRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSource(GetSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('GetSource', $request, $callOptions)->wait();
    }

    /**
     * Filters an organization's assets and  groups them by their specified
     * properties.
     *
     * The async variant is {@see SecurityCenterClient::groupAssetsAsync()} .
     *
     * @param GroupAssetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function groupAssets(GroupAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GroupAssets', $request, $callOptions);
    }

    /**
     * Filters an organization or source's findings and  groups them by their
     * specified properties.
     *
     * To group across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings,
     * /v1/folders/{folder_id}/sources/-/findings,
     * /v1/projects/{project_id}/sources/-/findings
     *
     * The async variant is {@see SecurityCenterClient::groupFindingsAsync()} .
     *
     * @param GroupFindingsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function groupFindings(GroupFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GroupFindings', $request, $callOptions);
    }

    /**
     * Lists an organization's assets.
     *
     * The async variant is {@see SecurityCenterClient::listAssetsAsync()} .
     *
     * @param ListAssetsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function listAssets(ListAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssets', $request, $callOptions);
    }

    /**
     * Lists BigQuery exports. Note that when requesting BigQuery exports at a
     * given level all exports under that level are also returned e.g. if
     * requesting BigQuery exports under a folder, then all BigQuery exports
     * immediately under the folder plus the ones created under the projects
     * within the folder are returned.
     *
     * The async variant is {@see SecurityCenterClient::listBigQueryExportsAsync()} .
     *
     * @param ListBigQueryExportsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBigQueryExports(ListBigQueryExportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBigQueryExports', $request, $callOptions);
    }

    /**
     * Returns a list of all resident SecurityHealthAnalyticsCustomModules under
     * the given CRM parent and all of the parent’s CRM descendants.
     *
     * The async variant is
     * {@see SecurityCenterClient::listDescendantSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @param ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDescendantSecurityHealthAnalyticsCustomModules(ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDescendantSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent, and inherited modules, inherited from CRM ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listEffectiveSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @param ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEffectiveSecurityHealthAnalyticsCustomModules(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEffectiveSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists an organization or source's findings.
     *
     * To list across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings
     *
     * The async variant is {@see SecurityCenterClient::listFindingsAsync()} .
     *
     * @param ListFindingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFindings(ListFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFindings', $request, $callOptions);
    }

    /**
     * Lists mute configs.
     *
     * The async variant is {@see SecurityCenterClient::listMuteConfigsAsync()} .
     *
     * @param ListMuteConfigsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMuteConfigs(ListMuteConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMuteConfigs', $request, $callOptions);
    }

    /**
     * Lists notification configs.
     *
     * The async variant is {@see SecurityCenterClient::listNotificationConfigsAsync()}
     * .
     *
     * @param ListNotificationConfigsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotificationConfigs(ListNotificationConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNotificationConfigs', $request, $callOptions);
    }

    /**
     * Returns a list of all SecurityHealthAnalyticsCustomModules for the given
     * parent. This includes resident modules defined at the scope of the parent,
     * and inherited modules, inherited from CRM ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listSecurityHealthAnalyticsCustomModulesAsync()} .
     *
     * @param ListSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSecurityHealthAnalyticsCustomModules(ListSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all sources belonging to an organization.
     *
     * The async variant is {@see SecurityCenterClient::listSourcesAsync()} .
     *
     * @param ListSourcesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSources(ListSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSources', $request, $callOptions);
    }

    /**
     * Runs asset discovery. The discovery is tracked with a long-running
     * operation.
     *
     * This API can only be called with limited frequency for an organization. If
     * it is called too frequently the caller will receive a TOO_MANY_REQUESTS
     * error.
     *
     * The async variant is {@see SecurityCenterClient::runAssetDiscoveryAsync()} .
     *
     * @param RunAssetDiscoveryRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function runAssetDiscovery(RunAssetDiscoveryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RunAssetDiscovery', $request, $callOptions)->wait();
    }

    /**
     * Updates the state of a finding.
     *
     * The async variant is {@see SecurityCenterClient::setFindingStateAsync()} .
     *
     * @param SetFindingStateRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setFindingState(SetFindingStateRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetFindingState', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the mute state of a finding.
     *
     * The async variant is {@see SecurityCenterClient::setMuteAsync()} .
     *
     * @param SetMuteRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMute(SetMuteRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetMute', $request, $callOptions)->wait();
    }

    /**
     * Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
     *
     * The async variant is
     * {@see SecurityCenterClient::simulateSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @param SimulateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SimulateSecurityHealthAnalyticsCustomModuleResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function simulateSecurityHealthAnalyticsCustomModule(SimulateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SimulateSecurityHealthAnalyticsCustomModuleResponse
    {
        return $this->startApiCall('SimulateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Returns the permissions that a caller has on the specified source.
     *
     * The async variant is {@see SecurityCenterClient::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::updateBigQueryExportAsync()} .
     *
     * @param UpdateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBigQueryExport(UpdateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('UpdateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Updates external system. This is for a given finding.
     *
     * The async variant is {@see SecurityCenterClient::updateExternalSystemAsync()} .
     *
     * @param UpdateExternalSystemRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalSystem
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalSystem(UpdateExternalSystemRequest $request, array $callOptions = []): ExternalSystem
    {
        return $this->startApiCall('UpdateExternalSystem', $request, $callOptions)->wait();
    }

    /**
     * Creates or updates a finding. The corresponding source must exist for a
     * finding creation to succeed.
     *
     * The async variant is {@see SecurityCenterClient::updateFindingAsync()} .
     *
     * @param UpdateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFinding(UpdateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('UpdateFinding', $request, $callOptions)->wait();
    }

    /**
     * Updates a mute config.
     *
     * The async variant is {@see SecurityCenterClient::updateMuteConfigAsync()} .
     *
     * @param UpdateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMuteConfig(UpdateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('UpdateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     *
     * Updates a notification config. The following update
     * fields are allowed: description, pubsub_topic, streaming_config.filter
     *
     * The async variant is
     * {@see SecurityCenterClient::updateNotificationConfigAsync()} .
     *
     * @param UpdateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNotificationConfig(UpdateNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('UpdateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates an organization's settings.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateOrganizationSettingsAsync()} .
     *
     * @param UpdateOrganizationSettingsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrganizationSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateOrganizationSettings(UpdateOrganizationSettingsRequest $request, array $callOptions = []): OrganizationSettings
    {
        return $this->startApiCall('UpdateOrganizationSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates the SecurityHealthAnalyticsCustomModule under the given name based
     * on the given update mask. Updating the enablement state is supported on
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name and custom
     * config of a module is supported on resident modules only.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @param UpdateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityHealthAnalyticsCustomModule(UpdateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('UpdateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Updates security marks.
     *
     * The async variant is {@see SecurityCenterClient::updateSecurityMarksAsync()} .
     *
     * @param UpdateSecurityMarksRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityMarks
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityMarks(UpdateSecurityMarksRequest $request, array $callOptions = []): SecurityMarks
    {
        return $this->startApiCall('UpdateSecurityMarks', $request, $callOptions)->wait();
    }

    /**
     * Updates a source.
     *
     * The async variant is {@see SecurityCenterClient::updateSourceAsync()} .
     *
     * @param UpdateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSource(UpdateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('UpdateSource', $request, $callOptions)->wait();
    }
}
