<?php
/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/analytics/admin/v1alpha/analytics_admin.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Analytics\Admin\V1alpha\Gapic;

use Google\Analytics\Admin\V1alpha\AccessBinding;
use Google\Analytics\Admin\V1alpha\AccessDateRange;
use Google\Analytics\Admin\V1alpha\AccessDimension;
use Google\Analytics\Admin\V1alpha\AccessFilterExpression;
use Google\Analytics\Admin\V1alpha\AccessMetric;
use Google\Analytics\Admin\V1alpha\AccessOrderBy;
use Google\Analytics\Admin\V1alpha\Account;
use Google\Analytics\Admin\V1alpha\AcknowledgeUserDataCollectionRequest;
use Google\Analytics\Admin\V1alpha\AcknowledgeUserDataCollectionResponse;
use Google\Analytics\Admin\V1alpha\AdSenseLink;
use Google\Analytics\Admin\V1alpha\ApproveDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\ApproveDisplayVideo360AdvertiserLinkProposalResponse;
use Google\Analytics\Admin\V1alpha\ArchiveAudienceRequest;
use Google\Analytics\Admin\V1alpha\ArchiveCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\ArchiveCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\AttributionSettings;
use Google\Analytics\Admin\V1alpha\Audience;
use Google\Analytics\Admin\V1alpha\BatchCreateAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchCreateAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BatchDeleteAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchGetAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchGetAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BatchUpdateAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchUpdateAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BigQueryLink;
use Google\Analytics\Admin\V1alpha\CancelDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\ChannelGroup;
use Google\Analytics\Admin\V1alpha\ConnectedSiteTag;
use Google\Analytics\Admin\V1alpha\ConversionEvent;
use Google\Analytics\Admin\V1alpha\CreateAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\CreateAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateAudienceRequest;
use Google\Analytics\Admin\V1alpha\CreateChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\CreateConnectedSiteTagRequest;
use Google\Analytics\Admin\V1alpha\CreateConnectedSiteTagResponse;
use Google\Analytics\Admin\V1alpha\CreateConversionEventRequest;
use Google\Analytics\Admin\V1alpha\CreateCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\CreateCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\CreateDataStreamRequest;
use Google\Analytics\Admin\V1alpha\CreateDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\CreateDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\CreateExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\CreateFirebaseLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\CreatePropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertyResponse;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\CreateSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyEventFilterRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyResponse;
use Google\Analytics\Admin\V1alpha\CustomDimension;
use Google\Analytics\Admin\V1alpha\CustomMetric;
use Google\Analytics\Admin\V1alpha\DataRedactionSettings;
use Google\Analytics\Admin\V1alpha\DataRetentionSettings;
use Google\Analytics\Admin\V1alpha\DataSharingSettings;
use Google\Analytics\Admin\V1alpha\DataStream;
use Google\Analytics\Admin\V1alpha\DeleteAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\DeleteAccountRequest;
use Google\Analytics\Admin\V1alpha\DeleteAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\DeleteConnectedSiteTagRequest;
use Google\Analytics\Admin\V1alpha\DeleteConversionEventRequest;
use Google\Analytics\Admin\V1alpha\DeleteDataStreamRequest;
use Google\Analytics\Admin\V1alpha\DeleteDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\DeleteDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\DeleteExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\DeleteFirebaseLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\DeletePropertyRequest;
use Google\Analytics\Admin\V1alpha\DeleteRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\DeleteSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteSubpropertyEventFilterRequest;
use Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLink;
use Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLinkProposal;
use Google\Analytics\Admin\V1alpha\EnhancedMeasurementSettings;
use Google\Analytics\Admin\V1alpha\EventCreateRule;
use Google\Analytics\Admin\V1alpha\ExpandedDataSet;
use Google\Analytics\Admin\V1alpha\FetchAutomatedGa4ConfigurationOptOutRequest;
use Google\Analytics\Admin\V1alpha\FetchAutomatedGa4ConfigurationOptOutResponse;
use Google\Analytics\Admin\V1alpha\FetchConnectedGa4PropertyRequest;
use Google\Analytics\Admin\V1alpha\FetchConnectedGa4PropertyResponse;
use Google\Analytics\Admin\V1alpha\FirebaseLink;
use Google\Analytics\Admin\V1alpha\GetAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\GetAccountRequest;
use Google\Analytics\Admin\V1alpha\GetAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\GetAttributionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetAudienceRequest;
use Google\Analytics\Admin\V1alpha\GetBigQueryLinkRequest;
use Google\Analytics\Admin\V1alpha\GetChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\GetConversionEventRequest;
use Google\Analytics\Admin\V1alpha\GetCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\GetCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\GetDataRedactionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataSharingSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataStreamRequest;
use Google\Analytics\Admin\V1alpha\GetDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\GetDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\GetEnhancedMeasurementSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\GetExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\GetGlobalSiteTagRequest;
use Google\Analytics\Admin\V1alpha\GetGoogleSignalsSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\GetPropertyRequest;
use Google\Analytics\Admin\V1alpha\GetRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\GetSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\GetSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\GlobalSiteTag;
use Google\Analytics\Admin\V1alpha\GoogleAdsLink;
use Google\Analytics\Admin\V1alpha\GoogleSignalsSettings;
use Google\Analytics\Admin\V1alpha\ListAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\ListAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\ListAccountSummariesRequest;
use Google\Analytics\Admin\V1alpha\ListAccountSummariesResponse;
use Google\Analytics\Admin\V1alpha\ListAccountsRequest;
use Google\Analytics\Admin\V1alpha\ListAccountsResponse;
use Google\Analytics\Admin\V1alpha\ListAdSenseLinksRequest;
use Google\Analytics\Admin\V1alpha\ListAdSenseLinksResponse;
use Google\Analytics\Admin\V1alpha\ListAudiencesRequest;
use Google\Analytics\Admin\V1alpha\ListAudiencesResponse;
use Google\Analytics\Admin\V1alpha\ListBigQueryLinksRequest;
use Google\Analytics\Admin\V1alpha\ListBigQueryLinksResponse;
use Google\Analytics\Admin\V1alpha\ListChannelGroupsRequest;
use Google\Analytics\Admin\V1alpha\ListChannelGroupsResponse;
use Google\Analytics\Admin\V1alpha\ListConnectedSiteTagsRequest;
use Google\Analytics\Admin\V1alpha\ListConnectedSiteTagsResponse;
use Google\Analytics\Admin\V1alpha\ListConversionEventsRequest;
use Google\Analytics\Admin\V1alpha\ListConversionEventsResponse;
use Google\Analytics\Admin\V1alpha\ListCustomDimensionsRequest;
use Google\Analytics\Admin\V1alpha\ListCustomDimensionsResponse;
use Google\Analytics\Admin\V1alpha\ListCustomMetricsRequest;
use Google\Analytics\Admin\V1alpha\ListCustomMetricsResponse;
use Google\Analytics\Admin\V1alpha\ListDataStreamsRequest;
use Google\Analytics\Admin\V1alpha\ListDataStreamsResponse;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinkProposalsRequest;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinkProposalsResponse;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinksRequest;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinksResponse;
use Google\Analytics\Admin\V1alpha\ListEventCreateRulesRequest;
use Google\Analytics\Admin\V1alpha\ListEventCreateRulesResponse;
use Google\Analytics\Admin\V1alpha\ListExpandedDataSetsRequest;
use Google\Analytics\Admin\V1alpha\ListExpandedDataSetsResponse;
use Google\Analytics\Admin\V1alpha\ListFirebaseLinksRequest;
use Google\Analytics\Admin\V1alpha\ListFirebaseLinksResponse;
use Google\Analytics\Admin\V1alpha\ListGoogleAdsLinksRequest;
use Google\Analytics\Admin\V1alpha\ListGoogleAdsLinksResponse;
use Google\Analytics\Admin\V1alpha\ListMeasurementProtocolSecretsRequest;
use Google\Analytics\Admin\V1alpha\ListMeasurementProtocolSecretsResponse;
use Google\Analytics\Admin\V1alpha\ListPropertiesRequest;
use Google\Analytics\Admin\V1alpha\ListPropertiesResponse;
use Google\Analytics\Admin\V1alpha\ListRollupPropertySourceLinksRequest;
use Google\Analytics\Admin\V1alpha\ListRollupPropertySourceLinksResponse;
use Google\Analytics\Admin\V1alpha\ListSKAdNetworkConversionValueSchemasRequest;
use Google\Analytics\Admin\V1alpha\ListSKAdNetworkConversionValueSchemasResponse;
use Google\Analytics\Admin\V1alpha\ListSearchAds360LinksRequest;
use Google\Analytics\Admin\V1alpha\ListSearchAds360LinksResponse;
use Google\Analytics\Admin\V1alpha\MeasurementProtocolSecret;
use Google\Analytics\Admin\V1alpha\Property;
use Google\Analytics\Admin\V1alpha\ProvisionAccountTicketRequest;
use Google\Analytics\Admin\V1alpha\ProvisionAccountTicketResponse;
use Google\Analytics\Admin\V1alpha\RollupPropertySourceLink;
use Google\Analytics\Admin\V1alpha\RunAccessReportRequest;
use Google\Analytics\Admin\V1alpha\RunAccessReportResponse;
use Google\Analytics\Admin\V1alpha\SKAdNetworkConversionValueSchema;
use Google\Analytics\Admin\V1alpha\SearchAds360Link;
use Google\Analytics\Admin\V1alpha\SearchChangeHistoryEventsRequest;
use Google\Analytics\Admin\V1alpha\SearchChangeHistoryEventsResponse;
use Google\Analytics\Admin\V1alpha\SetAutomatedGa4ConfigurationOptOutRequest;
use Google\Analytics\Admin\V1alpha\SetAutomatedGa4ConfigurationOptOutResponse;
use Google\Analytics\Admin\V1alpha\SubpropertyEventFilter;
use Google\Analytics\Admin\V1alpha\UpdateAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\UpdateAccountRequest;
use Google\Analytics\Admin\V1alpha\UpdateAttributionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateAudienceRequest;
use Google\Analytics\Admin\V1alpha\UpdateChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\UpdateConversionEventRequest;
use Google\Analytics\Admin\V1alpha\UpdateCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\UpdateCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataRedactionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataStreamRequest;
use Google\Analytics\Admin\V1alpha\UpdateDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\UpdateEnhancedMeasurementSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\UpdateExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\UpdateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\UpdateGoogleSignalsSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\UpdatePropertyRequest;
use Google\Analytics\Admin\V1alpha\UpdateSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\UpdateSearchAds360LinkRequest;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: Service Interface for the Analytics Admin API (GA4).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
 * try {
 *     $formattedProperty = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
 *     $acknowledgement = 'acknowledgement';
 *     $response = $analyticsAdminServiceClient->acknowledgeUserDataCollection($formattedProperty, $acknowledgement);
 * } finally {
 *     $analyticsAdminServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 */
class AnalyticsAdminServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.analytics.admin.v1alpha.AnalyticsAdminService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'analyticsadmin.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/analytics.edit',
        'https://www.googleapis.com/auth/analytics.manage.users',
        'https://www.googleapis.com/auth/analytics.manage.users.readonly',
        'https://www.googleapis.com/auth/analytics.readonly',
    ];

    private static $accessBindingNameTemplate;

    private static $accountNameTemplate;

    private static $accountAccessBindingNameTemplate;

    private static $adSenseLinkNameTemplate;

    private static $attributionSettingsNameTemplate;

    private static $audienceNameTemplate;

    private static $bigQueryLinkNameTemplate;

    private static $channelGroupNameTemplate;

    private static $conversionEventNameTemplate;

    private static $customDimensionNameTemplate;

    private static $customMetricNameTemplate;

    private static $dataRedactionSettingsNameTemplate;

    private static $dataRetentionSettingsNameTemplate;

    private static $dataSharingSettingsNameTemplate;

    private static $dataStreamNameTemplate;

    private static $displayVideo360AdvertiserLinkNameTemplate;

    private static $displayVideo360AdvertiserLinkProposalNameTemplate;

    private static $enhancedMeasurementSettingsNameTemplate;

    private static $eventCreateRuleNameTemplate;

    private static $expandedDataSetNameTemplate;

    private static $firebaseLinkNameTemplate;

    private static $globalSiteTagNameTemplate;

    private static $googleAdsLinkNameTemplate;

    private static $googleSignalsSettingsNameTemplate;

    private static $measurementProtocolSecretNameTemplate;

    private static $propertyNameTemplate;

    private static $propertyAccessBindingNameTemplate;

    private static $rollupPropertySourceLinkNameTemplate;

    private static $sKAdNetworkConversionValueSchemaNameTemplate;

    private static $searchAds360LinkNameTemplate;

    private static $subpropertyEventFilterNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/analytics_admin_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/analytics_admin_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/analytics_admin_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/analytics_admin_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAccessBindingNameTemplate()
    {
        if (self::$accessBindingNameTemplate == null) {
            self::$accessBindingNameTemplate = new PathTemplate('accounts/{account}/accessBindings/{access_binding}');
        }

        return self::$accessBindingNameTemplate;
    }

    private static function getAccountNameTemplate()
    {
        if (self::$accountNameTemplate == null) {
            self::$accountNameTemplate = new PathTemplate('accounts/{account}');
        }

        return self::$accountNameTemplate;
    }

    private static function getAccountAccessBindingNameTemplate()
    {
        if (self::$accountAccessBindingNameTemplate == null) {
            self::$accountAccessBindingNameTemplate = new PathTemplate('accounts/{account}/accessBindings/{access_binding}');
        }

        return self::$accountAccessBindingNameTemplate;
    }

    private static function getAdSenseLinkNameTemplate()
    {
        if (self::$adSenseLinkNameTemplate == null) {
            self::$adSenseLinkNameTemplate = new PathTemplate('properties/{property}/adSenseLinks/{adsense_link}');
        }

        return self::$adSenseLinkNameTemplate;
    }

    private static function getAttributionSettingsNameTemplate()
    {
        if (self::$attributionSettingsNameTemplate == null) {
            self::$attributionSettingsNameTemplate = new PathTemplate('properties/{property}/attributionSettings');
        }

        return self::$attributionSettingsNameTemplate;
    }

    private static function getAudienceNameTemplate()
    {
        if (self::$audienceNameTemplate == null) {
            self::$audienceNameTemplate = new PathTemplate('properties/{property}/audiences/{audience}');
        }

        return self::$audienceNameTemplate;
    }

    private static function getBigQueryLinkNameTemplate()
    {
        if (self::$bigQueryLinkNameTemplate == null) {
            self::$bigQueryLinkNameTemplate = new PathTemplate('properties/{property}/bigQueryLinks/{bigquery_link}');
        }

        return self::$bigQueryLinkNameTemplate;
    }

    private static function getChannelGroupNameTemplate()
    {
        if (self::$channelGroupNameTemplate == null) {
            self::$channelGroupNameTemplate = new PathTemplate('properties/{property}/channelGroups/{channel_group}');
        }

        return self::$channelGroupNameTemplate;
    }

    private static function getConversionEventNameTemplate()
    {
        if (self::$conversionEventNameTemplate == null) {
            self::$conversionEventNameTemplate = new PathTemplate('properties/{property}/conversionEvents/{conversion_event}');
        }

        return self::$conversionEventNameTemplate;
    }

    private static function getCustomDimensionNameTemplate()
    {
        if (self::$customDimensionNameTemplate == null) {
            self::$customDimensionNameTemplate = new PathTemplate('properties/{property}/customDimensions/{custom_dimension}');
        }

        return self::$customDimensionNameTemplate;
    }

    private static function getCustomMetricNameTemplate()
    {
        if (self::$customMetricNameTemplate == null) {
            self::$customMetricNameTemplate = new PathTemplate('properties/{property}/customMetrics/{custom_metric}');
        }

        return self::$customMetricNameTemplate;
    }

    private static function getDataRedactionSettingsNameTemplate()
    {
        if (self::$dataRedactionSettingsNameTemplate == null) {
            self::$dataRedactionSettingsNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/dataRedactionSettings');
        }

        return self::$dataRedactionSettingsNameTemplate;
    }

    private static function getDataRetentionSettingsNameTemplate()
    {
        if (self::$dataRetentionSettingsNameTemplate == null) {
            self::$dataRetentionSettingsNameTemplate = new PathTemplate('properties/{property}/dataRetentionSettings');
        }

        return self::$dataRetentionSettingsNameTemplate;
    }

    private static function getDataSharingSettingsNameTemplate()
    {
        if (self::$dataSharingSettingsNameTemplate == null) {
            self::$dataSharingSettingsNameTemplate = new PathTemplate('accounts/{account}/dataSharingSettings');
        }

        return self::$dataSharingSettingsNameTemplate;
    }

    private static function getDataStreamNameTemplate()
    {
        if (self::$dataStreamNameTemplate == null) {
            self::$dataStreamNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}');
        }

        return self::$dataStreamNameTemplate;
    }

    private static function getDisplayVideo360AdvertiserLinkNameTemplate()
    {
        if (self::$displayVideo360AdvertiserLinkNameTemplate == null) {
            self::$displayVideo360AdvertiserLinkNameTemplate = new PathTemplate('properties/{property}/displayVideo360AdvertiserLinks/{display_video_360_advertiser_link}');
        }

        return self::$displayVideo360AdvertiserLinkNameTemplate;
    }

    private static function getDisplayVideo360AdvertiserLinkProposalNameTemplate()
    {
        if (self::$displayVideo360AdvertiserLinkProposalNameTemplate == null) {
            self::$displayVideo360AdvertiserLinkProposalNameTemplate = new PathTemplate('properties/{property}/displayVideo360AdvertiserLinkProposals/{display_video_360_advertiser_link_proposal}');
        }

        return self::$displayVideo360AdvertiserLinkProposalNameTemplate;
    }

    private static function getEnhancedMeasurementSettingsNameTemplate()
    {
        if (self::$enhancedMeasurementSettingsNameTemplate == null) {
            self::$enhancedMeasurementSettingsNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings');
        }

        return self::$enhancedMeasurementSettingsNameTemplate;
    }

    private static function getEventCreateRuleNameTemplate()
    {
        if (self::$eventCreateRuleNameTemplate == null) {
            self::$eventCreateRuleNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/eventCreateRules/{event_create_rule}');
        }

        return self::$eventCreateRuleNameTemplate;
    }

    private static function getExpandedDataSetNameTemplate()
    {
        if (self::$expandedDataSetNameTemplate == null) {
            self::$expandedDataSetNameTemplate = new PathTemplate('properties/{property}/expandedDataSets/{expanded_data_set}');
        }

        return self::$expandedDataSetNameTemplate;
    }

    private static function getFirebaseLinkNameTemplate()
    {
        if (self::$firebaseLinkNameTemplate == null) {
            self::$firebaseLinkNameTemplate = new PathTemplate('properties/{property}/firebaseLinks/{firebase_link}');
        }

        return self::$firebaseLinkNameTemplate;
    }

    private static function getGlobalSiteTagNameTemplate()
    {
        if (self::$globalSiteTagNameTemplate == null) {
            self::$globalSiteTagNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/globalSiteTag');
        }

        return self::$globalSiteTagNameTemplate;
    }

    private static function getGoogleAdsLinkNameTemplate()
    {
        if (self::$googleAdsLinkNameTemplate == null) {
            self::$googleAdsLinkNameTemplate = new PathTemplate('properties/{property}/googleAdsLinks/{google_ads_link}');
        }

        return self::$googleAdsLinkNameTemplate;
    }

    private static function getGoogleSignalsSettingsNameTemplate()
    {
        if (self::$googleSignalsSettingsNameTemplate == null) {
            self::$googleSignalsSettingsNameTemplate = new PathTemplate('properties/{property}/googleSignalsSettings');
        }

        return self::$googleSignalsSettingsNameTemplate;
    }

    private static function getMeasurementProtocolSecretNameTemplate()
    {
        if (self::$measurementProtocolSecretNameTemplate == null) {
            self::$measurementProtocolSecretNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/measurementProtocolSecrets/{measurement_protocol_secret}');
        }

        return self::$measurementProtocolSecretNameTemplate;
    }

    private static function getPropertyNameTemplate()
    {
        if (self::$propertyNameTemplate == null) {
            self::$propertyNameTemplate = new PathTemplate('properties/{property}');
        }

        return self::$propertyNameTemplate;
    }

    private static function getPropertyAccessBindingNameTemplate()
    {
        if (self::$propertyAccessBindingNameTemplate == null) {
            self::$propertyAccessBindingNameTemplate = new PathTemplate('properties/{property}/accessBindings/{access_binding}');
        }

        return self::$propertyAccessBindingNameTemplate;
    }

    private static function getRollupPropertySourceLinkNameTemplate()
    {
        if (self::$rollupPropertySourceLinkNameTemplate == null) {
            self::$rollupPropertySourceLinkNameTemplate = new PathTemplate('properties/{property}/rollupPropertySourceLinks/{rollup_property_source_link}');
        }

        return self::$rollupPropertySourceLinkNameTemplate;
    }

    private static function getSKAdNetworkConversionValueSchemaNameTemplate()
    {
        if (self::$sKAdNetworkConversionValueSchemaNameTemplate == null) {
            self::$sKAdNetworkConversionValueSchemaNameTemplate = new PathTemplate('properties/{property}/dataStreams/{data_stream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}');
        }

        return self::$sKAdNetworkConversionValueSchemaNameTemplate;
    }

    private static function getSearchAds360LinkNameTemplate()
    {
        if (self::$searchAds360LinkNameTemplate == null) {
            self::$searchAds360LinkNameTemplate = new PathTemplate('properties/{property}/searchAds360Links/{search_ads_360_link}');
        }

        return self::$searchAds360LinkNameTemplate;
    }

    private static function getSubpropertyEventFilterNameTemplate()
    {
        if (self::$subpropertyEventFilterNameTemplate == null) {
            self::$subpropertyEventFilterNameTemplate = new PathTemplate('properties/{property}/subpropertyEventFilters/{sub_property_event_filter}');
        }

        return self::$subpropertyEventFilterNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'accessBinding' => self::getAccessBindingNameTemplate(),
                'account' => self::getAccountNameTemplate(),
                'accountAccessBinding' => self::getAccountAccessBindingNameTemplate(),
                'adSenseLink' => self::getAdSenseLinkNameTemplate(),
                'attributionSettings' => self::getAttributionSettingsNameTemplate(),
                'audience' => self::getAudienceNameTemplate(),
                'bigQueryLink' => self::getBigQueryLinkNameTemplate(),
                'channelGroup' => self::getChannelGroupNameTemplate(),
                'conversionEvent' => self::getConversionEventNameTemplate(),
                'customDimension' => self::getCustomDimensionNameTemplate(),
                'customMetric' => self::getCustomMetricNameTemplate(),
                'dataRedactionSettings' => self::getDataRedactionSettingsNameTemplate(),
                'dataRetentionSettings' => self::getDataRetentionSettingsNameTemplate(),
                'dataSharingSettings' => self::getDataSharingSettingsNameTemplate(),
                'dataStream' => self::getDataStreamNameTemplate(),
                'displayVideo360AdvertiserLink' => self::getDisplayVideo360AdvertiserLinkNameTemplate(),
                'displayVideo360AdvertiserLinkProposal' => self::getDisplayVideo360AdvertiserLinkProposalNameTemplate(),
                'enhancedMeasurementSettings' => self::getEnhancedMeasurementSettingsNameTemplate(),
                'eventCreateRule' => self::getEventCreateRuleNameTemplate(),
                'expandedDataSet' => self::getExpandedDataSetNameTemplate(),
                'firebaseLink' => self::getFirebaseLinkNameTemplate(),
                'globalSiteTag' => self::getGlobalSiteTagNameTemplate(),
                'googleAdsLink' => self::getGoogleAdsLinkNameTemplate(),
                'googleSignalsSettings' => self::getGoogleSignalsSettingsNameTemplate(),
                'measurementProtocolSecret' => self::getMeasurementProtocolSecretNameTemplate(),
                'property' => self::getPropertyNameTemplate(),
                'propertyAccessBinding' => self::getPropertyAccessBindingNameTemplate(),
                'rollupPropertySourceLink' => self::getRollupPropertySourceLinkNameTemplate(),
                'sKAdNetworkConversionValueSchema' => self::getSKAdNetworkConversionValueSchemaNameTemplate(),
                'searchAds360Link' => self::getSearchAds360LinkNameTemplate(),
                'subpropertyEventFilter' => self::getSubpropertyEventFilterNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * access_binding resource.
     *
     * @param string $account
     * @param string $accessBinding
     *
     * @return string The formatted access_binding resource.
     *
     * @experimental
     */
    public static function accessBindingName($account, $accessBinding)
    {
        return self::getAccessBindingNameTemplate()->render([
            'account' => $account,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a account
     * resource.
     *
     * @param string $account
     *
     * @return string The formatted account resource.
     *
     * @experimental
     */
    public static function accountName($account)
    {
        return self::getAccountNameTemplate()->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * account_access_binding resource.
     *
     * @param string $account
     * @param string $accessBinding
     *
     * @return string The formatted account_access_binding resource.
     *
     * @experimental
     */
    public static function accountAccessBindingName($account, $accessBinding)
    {
        return self::getAccountAccessBindingNameTemplate()->render([
            'account' => $account,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * ad_sense_link resource.
     *
     * @param string $property
     * @param string $adsenseLink
     *
     * @return string The formatted ad_sense_link resource.
     *
     * @experimental
     */
    public static function adSenseLinkName($property, $adsenseLink)
    {
        return self::getAdSenseLinkNameTemplate()->render([
            'property' => $property,
            'adsense_link' => $adsenseLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attribution_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted attribution_settings resource.
     *
     * @experimental
     */
    public static function attributionSettingsName($property)
    {
        return self::getAttributionSettingsNameTemplate()->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a audience
     * resource.
     *
     * @param string $property
     * @param string $audience
     *
     * @return string The formatted audience resource.
     *
     * @experimental
     */
    public static function audienceName($property, $audience)
    {
        return self::getAudienceNameTemplate()->render([
            'property' => $property,
            'audience' => $audience,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_link resource.
     *
     * @param string $property
     * @param string $bigqueryLink
     *
     * @return string The formatted big_query_link resource.
     *
     * @experimental
     */
    public static function bigQueryLinkName($property, $bigqueryLink)
    {
        return self::getBigQueryLinkNameTemplate()->render([
            'property' => $property,
            'bigquery_link' => $bigqueryLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_group resource.
     *
     * @param string $property
     * @param string $channelGroup
     *
     * @return string The formatted channel_group resource.
     *
     * @experimental
     */
    public static function channelGroupName($property, $channelGroup)
    {
        return self::getChannelGroupNameTemplate()->render([
            'property' => $property,
            'channel_group' => $channelGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversion_event resource.
     *
     * @param string $property
     * @param string $conversionEvent
     *
     * @return string The formatted conversion_event resource.
     *
     * @experimental
     */
    public static function conversionEventName($property, $conversionEvent)
    {
        return self::getConversionEventNameTemplate()->render([
            'property' => $property,
            'conversion_event' => $conversionEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_dimension resource.
     *
     * @param string $property
     * @param string $customDimension
     *
     * @return string The formatted custom_dimension resource.
     *
     * @experimental
     */
    public static function customDimensionName($property, $customDimension)
    {
        return self::getCustomDimensionNameTemplate()->render([
            'property' => $property,
            'custom_dimension' => $customDimension,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_metric resource.
     *
     * @param string $property
     * @param string $customMetric
     *
     * @return string The formatted custom_metric resource.
     *
     * @experimental
     */
    public static function customMetricName($property, $customMetric)
    {
        return self::getCustomMetricNameTemplate()->render([
            'property' => $property,
            'custom_metric' => $customMetric,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_redaction_settings resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted data_redaction_settings resource.
     *
     * @experimental
     */
    public static function dataRedactionSettingsName($property, $dataStream)
    {
        return self::getDataRedactionSettingsNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_retention_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted data_retention_settings resource.
     *
     * @experimental
     */
    public static function dataRetentionSettingsName($property)
    {
        return self::getDataRetentionSettingsNameTemplate()->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_sharing_settings resource.
     *
     * @param string $account
     *
     * @return string The formatted data_sharing_settings resource.
     *
     * @experimental
     */
    public static function dataSharingSettingsName($account)
    {
        return self::getDataSharingSettingsNameTemplate()->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_stream
     * resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted data_stream resource.
     *
     * @experimental
     */
    public static function dataStreamName($property, $dataStream)
    {
        return self::getDataStreamNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * display_video360_advertiser_link resource.
     *
     * @param string $property
     * @param string $displayVideo360AdvertiserLink
     *
     * @return string The formatted display_video360_advertiser_link resource.
     *
     * @experimental
     */
    public static function displayVideo360AdvertiserLinkName($property, $displayVideo360AdvertiserLink)
    {
        return self::getDisplayVideo360AdvertiserLinkNameTemplate()->render([
            'property' => $property,
            'display_video_360_advertiser_link' => $displayVideo360AdvertiserLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * display_video360_advertiser_link_proposal resource.
     *
     * @param string $property
     * @param string $displayVideo360AdvertiserLinkProposal
     *
     * @return string The formatted display_video360_advertiser_link_proposal resource.
     *
     * @experimental
     */
    public static function displayVideo360AdvertiserLinkProposalName($property, $displayVideo360AdvertiserLinkProposal)
    {
        return self::getDisplayVideo360AdvertiserLinkProposalNameTemplate()->render([
            'property' => $property,
            'display_video_360_advertiser_link_proposal' => $displayVideo360AdvertiserLinkProposal,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * enhanced_measurement_settings resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted enhanced_measurement_settings resource.
     *
     * @experimental
     */
    public static function enhancedMeasurementSettingsName($property, $dataStream)
    {
        return self::getEnhancedMeasurementSettingsNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_create_rule resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $eventCreateRule
     *
     * @return string The formatted event_create_rule resource.
     *
     * @experimental
     */
    public static function eventCreateRuleName($property, $dataStream, $eventCreateRule)
    {
        return self::getEventCreateRuleNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'event_create_rule' => $eventCreateRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * expanded_data_set resource.
     *
     * @param string $property
     * @param string $expandedDataSet
     *
     * @return string The formatted expanded_data_set resource.
     *
     * @experimental
     */
    public static function expandedDataSetName($property, $expandedDataSet)
    {
        return self::getExpandedDataSetNameTemplate()->render([
            'property' => $property,
            'expanded_data_set' => $expandedDataSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * firebase_link resource.
     *
     * @param string $property
     * @param string $firebaseLink
     *
     * @return string The formatted firebase_link resource.
     *
     * @experimental
     */
    public static function firebaseLinkName($property, $firebaseLink)
    {
        return self::getFirebaseLinkNameTemplate()->render([
            'property' => $property,
            'firebase_link' => $firebaseLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * global_site_tag resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted global_site_tag resource.
     *
     * @experimental
     */
    public static function globalSiteTagName($property, $dataStream)
    {
        return self::getGlobalSiteTagNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_ads_link resource.
     *
     * @param string $property
     * @param string $googleAdsLink
     *
     * @return string The formatted google_ads_link resource.
     *
     * @experimental
     */
    public static function googleAdsLinkName($property, $googleAdsLink)
    {
        return self::getGoogleAdsLinkNameTemplate()->render([
            'property' => $property,
            'google_ads_link' => $googleAdsLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_signals_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted google_signals_settings resource.
     *
     * @experimental
     */
    public static function googleSignalsSettingsName($property)
    {
        return self::getGoogleSignalsSettingsNameTemplate()->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * measurement_protocol_secret resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $measurementProtocolSecret
     *
     * @return string The formatted measurement_protocol_secret resource.
     *
     * @experimental
     */
    public static function measurementProtocolSecretName($property, $dataStream, $measurementProtocolSecret)
    {
        return self::getMeasurementProtocolSecretNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'measurement_protocol_secret' => $measurementProtocolSecret,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a property
     * resource.
     *
     * @param string $property
     *
     * @return string The formatted property resource.
     *
     * @experimental
     */
    public static function propertyName($property)
    {
        return self::getPropertyNameTemplate()->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * property_access_binding resource.
     *
     * @param string $property
     * @param string $accessBinding
     *
     * @return string The formatted property_access_binding resource.
     *
     * @experimental
     */
    public static function propertyAccessBindingName($property, $accessBinding)
    {
        return self::getPropertyAccessBindingNameTemplate()->render([
            'property' => $property,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * rollup_property_source_link resource.
     *
     * @param string $property
     * @param string $rollupPropertySourceLink
     *
     * @return string The formatted rollup_property_source_link resource.
     *
     * @experimental
     */
    public static function rollupPropertySourceLinkName($property, $rollupPropertySourceLink)
    {
        return self::getRollupPropertySourceLinkNameTemplate()->render([
            'property' => $property,
            'rollup_property_source_link' => $rollupPropertySourceLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * sk_ad_network_conversion_value_schema resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $skadnetworkConversionValueSchema
     *
     * @return string The formatted sk_ad_network_conversion_value_schema resource.
     *
     * @experimental
     */
    public static function sKAdNetworkConversionValueSchemaName($property, $dataStream, $skadnetworkConversionValueSchema)
    {
        return self::getSKAdNetworkConversionValueSchemaNameTemplate()->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'skadnetwork_conversion_value_schema' => $skadnetworkConversionValueSchema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * search_ads360_link resource.
     *
     * @param string $property
     * @param string $searchAds360Link
     *
     * @return string The formatted search_ads360_link resource.
     *
     * @experimental
     */
    public static function searchAds360LinkName($property, $searchAds360Link)
    {
        return self::getSearchAds360LinkNameTemplate()->render([
            'property' => $property,
            'search_ads_360_link' => $searchAds360Link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * subproperty_event_filter resource.
     *
     * @param string $property
     * @param string $subPropertyEventFilter
     *
     * @return string The formatted subproperty_event_filter resource.
     *
     * @experimental
     */
    public static function subpropertyEventFilterName($property, $subPropertyEventFilter)
    {
        return self::getSubpropertyEventFilterNameTemplate()->render([
            'property' => $property,
            'sub_property_event_filter' => $subPropertyEventFilter,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - accessBinding: accounts/{account}/accessBindings/{access_binding}
     * - account: accounts/{account}
     * - accountAccessBinding: accounts/{account}/accessBindings/{access_binding}
     * - adSenseLink: properties/{property}/adSenseLinks/{adsense_link}
     * - attributionSettings: properties/{property}/attributionSettings
     * - audience: properties/{property}/audiences/{audience}
     * - bigQueryLink: properties/{property}/bigQueryLinks/{bigquery_link}
     * - channelGroup: properties/{property}/channelGroups/{channel_group}
     * - conversionEvent: properties/{property}/conversionEvents/{conversion_event}
     * - customDimension: properties/{property}/customDimensions/{custom_dimension}
     * - customMetric: properties/{property}/customMetrics/{custom_metric}
     * - dataRedactionSettings: properties/{property}/dataStreams/{data_stream}/dataRedactionSettings
     * - dataRetentionSettings: properties/{property}/dataRetentionSettings
     * - dataSharingSettings: accounts/{account}/dataSharingSettings
     * - dataStream: properties/{property}/dataStreams/{data_stream}
     * - displayVideo360AdvertiserLink: properties/{property}/displayVideo360AdvertiserLinks/{display_video_360_advertiser_link}
     * - displayVideo360AdvertiserLinkProposal: properties/{property}/displayVideo360AdvertiserLinkProposals/{display_video_360_advertiser_link_proposal}
     * - enhancedMeasurementSettings: properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings
     * - eventCreateRule: properties/{property}/dataStreams/{data_stream}/eventCreateRules/{event_create_rule}
     * - expandedDataSet: properties/{property}/expandedDataSets/{expanded_data_set}
     * - firebaseLink: properties/{property}/firebaseLinks/{firebase_link}
     * - globalSiteTag: properties/{property}/dataStreams/{data_stream}/globalSiteTag
     * - googleAdsLink: properties/{property}/googleAdsLinks/{google_ads_link}
     * - googleSignalsSettings: properties/{property}/googleSignalsSettings
     * - measurementProtocolSecret: properties/{property}/dataStreams/{data_stream}/measurementProtocolSecrets/{measurement_protocol_secret}
     * - property: properties/{property}
     * - propertyAccessBinding: properties/{property}/accessBindings/{access_binding}
     * - rollupPropertySourceLink: properties/{property}/rollupPropertySourceLinks/{rollup_property_source_link}
     * - sKAdNetworkConversionValueSchema: properties/{property}/dataStreams/{data_stream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
     * - searchAds360Link: properties/{property}/searchAds360Links/{search_ads_360_link}
     * - subpropertyEventFilter: properties/{property}/subpropertyEventFilters/{sub_property_event_filter}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticsadmin.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Acknowledges the terms of user data collection for the specified property.
     *
     * This acknowledgement must be completed (either in the Google Analytics UI
     * or through this API) before MeasurementProtocolSecret resources may be
     * created.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedProperty = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $acknowledgement = 'acknowledgement';
     *     $response = $analyticsAdminServiceClient->acknowledgeUserDataCollection($formattedProperty, $acknowledgement);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $property        Required. The property for which to acknowledge user data collection.
     * @param string $acknowledgement Required. An acknowledgement that the caller of this method understands the
     *                                terms of user data collection.
     *
     *                                This field must contain the exact value:
     *                                "I acknowledge that I have the necessary privacy disclosures and rights
     *                                from my end users for the collection and processing of their data,
     *                                including the association of such data with the visitation information
     *                                Google Analytics collects from my site and/or app property."
     * @param array  $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AcknowledgeUserDataCollectionResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function acknowledgeUserDataCollection($property, $acknowledgement, array $optionalArgs = [])
    {
        $request = new AcknowledgeUserDataCollectionRequest();
        $requestParamHeaders = [];
        $request->setProperty($property);
        $request->setAcknowledgement($acknowledgement);
        $requestParamHeaders['property'] = $property;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('AcknowledgeUserDataCollection', AcknowledgeUserDataCollectionResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Approves a DisplayVideo360AdvertiserLinkProposal.
     * The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
     * DisplayVideo360AdvertiserLink will be created.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkProposalName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL]');
     *     $response = $analyticsAdminServiceClient->approveDisplayVideo360AdvertiserLinkProposal($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
     *                             Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ApproveDisplayVideo360AdvertiserLinkProposalResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function approveDisplayVideo360AdvertiserLinkProposal($name, array $optionalArgs = [])
    {
        $request = new ApproveDisplayVideo360AdvertiserLinkProposalRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ApproveDisplayVideo360AdvertiserLinkProposal', ApproveDisplayVideo360AdvertiserLinkProposalResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Archives an Audience on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $analyticsAdminServiceClient->archiveAudience($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example format: properties/1234/audiences/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function archiveAudience($name, array $optionalArgs = [])
    {
        $request = new ArchiveAudienceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ArchiveAudience', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Archives a CustomDimension on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->customDimensionName('[PROPERTY]', '[CUSTOM_DIMENSION]');
     *     $analyticsAdminServiceClient->archiveCustomDimension($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CustomDimension to archive.
     *                             Example format: properties/1234/customDimensions/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function archiveCustomDimension($name, array $optionalArgs = [])
    {
        $request = new ArchiveCustomDimensionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ArchiveCustomDimension', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Archives a CustomMetric on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->customMetricName('[PROPERTY]', '[CUSTOM_METRIC]');
     *     $analyticsAdminServiceClient->archiveCustomMetric($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CustomMetric to archive.
     *                             Example format: properties/1234/customMetrics/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function archiveCustomMetric($name, array $optionalArgs = [])
    {
        $request = new ArchiveCustomMetricRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ArchiveCustomMetric', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates information about multiple access bindings to an account or
     * property.
     *
     * This method is transactional. If any AccessBinding cannot be created, none
     * of the AccessBindings will be created.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $requests = [];
     *     $response = $analyticsAdminServiceClient->batchCreateAccessBindings($formattedParent, $requests);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                       $parent       Required. The account or property that owns the access bindings. The parent
     *                                                   field in the CreateAccessBindingRequest messages must either be empty or
     *                                                   match this field. Formats:
     *                                                   - accounts/{account}
     *                                                   - properties/{property}
     * @param CreateAccessBindingRequest[] $requests     Required. The requests specifying the access bindings to create.
     *                                                   A maximum of 1000 access bindings can be created in a batch.
     * @param array                        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\BatchCreateAccessBindingsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function batchCreateAccessBindings($parent, $requests, array $optionalArgs = [])
    {
        $request = new BatchCreateAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('BatchCreateAccessBindings', BatchCreateAccessBindingsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes information about multiple users' links to an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $requests = [];
     *     $analyticsAdminServiceClient->batchDeleteAccessBindings($formattedParent, $requests);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                       $parent       Required. The account or property that owns the access bindings. The parent
     *                                                   of all provided values for the 'names' field in DeleteAccessBindingRequest
     *                                                   messages must match this field. Formats:
     *                                                   - accounts/{account}
     *                                                   - properties/{property}
     * @param DeleteAccessBindingRequest[] $requests     Required. The requests specifying the access bindings to delete.
     *                                                   A maximum of 1000 access bindings can be deleted in a batch.
     * @param array                        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function batchDeleteAccessBindings($parent, $requests, array $optionalArgs = [])
    {
        $request = new BatchDeleteAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('BatchDeleteAccessBindings', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about multiple access bindings to an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $formattedNames = [
     *         $analyticsAdminServiceClient->accessBindingName('[ACCOUNT]', '[ACCESS_BINDING]'),
     *     ];
     *     $response = $analyticsAdminServiceClient->batchGetAccessBindings($formattedParent, $formattedNames);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The account or property that owns the access bindings. The parent
     *                               of all provided values for the 'names' field must match this field.
     *                               Formats:
     *                               - accounts/{account}
     *                               - properties/{property}
     * @param string[] $names        Required. The names of the access bindings to retrieve.
     *                               A maximum of 1000 access bindings can be retrieved in a batch.
     *                               Formats:
     *                               - accounts/{account}/accessBindings/{accessBinding}
     *                               - properties/{property}/accessBindings/{accessBinding}
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\BatchGetAccessBindingsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function batchGetAccessBindings($parent, $names, array $optionalArgs = [])
    {
        $request = new BatchGetAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNames($names);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('BatchGetAccessBindings', BatchGetAccessBindingsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates information about multiple access bindings to an account or
     * property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $requests = [];
     *     $response = $analyticsAdminServiceClient->batchUpdateAccessBindings($formattedParent, $requests);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                       $parent       Required. The account or property that owns the access bindings. The parent
     *                                                   of all provided AccessBinding in UpdateAccessBindingRequest messages must
     *                                                   match this field.
     *                                                   Formats:
     *                                                   - accounts/{account}
     *                                                   - properties/{property}
     * @param UpdateAccessBindingRequest[] $requests     Required. The requests specifying the access bindings to update.
     *                                                   A maximum of 1000 access bindings can be updated in a batch.
     * @param array                        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\BatchUpdateAccessBindingsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function batchUpdateAccessBindings($parent, $requests, array $optionalArgs = [])
    {
        $request = new BatchUpdateAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('BatchUpdateAccessBindings', BatchUpdateAccessBindingsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Cancels a DisplayVideo360AdvertiserLinkProposal.
     * Cancelling can mean either:
     * - Declining a proposal initiated from Display & Video 360
     * - Withdrawing a proposal initiated from Google Analytics
     * After being cancelled, a proposal will eventually be deleted automatically.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkProposalName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL]');
     *     $response = $analyticsAdminServiceClient->cancelDisplayVideo360AdvertiserLinkProposal($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
     *                             Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function cancelDisplayVideo360AdvertiserLinkProposal($name, array $optionalArgs = [])
    {
        $request = new CancelDisplayVideo360AdvertiserLinkProposalRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CancelDisplayVideo360AdvertiserLinkProposal', DisplayVideo360AdvertiserLinkProposal::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an access binding on an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $accessBinding = new AccessBinding();
     *     $response = $analyticsAdminServiceClient->createAccessBinding($formattedParent, $accessBinding);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. Formats:
     *                                     - accounts/{account}
     *                                     - properties/{property}
     * @param AccessBinding $accessBinding Required. The access binding to create.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AccessBinding
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createAccessBinding($parent, $accessBinding, array $optionalArgs = [])
    {
        $request = new CreateAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAccessBinding($accessBinding);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateAccessBinding', AccessBinding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an AdSenseLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $adsenseLink = new AdSenseLink();
     *     $response = $analyticsAdminServiceClient->createAdSenseLink($formattedParent, $adsenseLink);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The property for which to create an AdSense Link.
     *                                  Format: properties/{propertyId}
     *                                  Example: properties/1234
     * @param AdSenseLink $adsenseLink  Required. The AdSense Link to create
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AdSenseLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createAdSenseLink($parent, $adsenseLink, array $optionalArgs = [])
    {
        $request = new CreateAdSenseLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAdsenseLink($adsenseLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateAdSenseLink', AdSenseLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an Audience.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $audience = new Audience();
     *     $response = $analyticsAdminServiceClient->createAudience($formattedParent, $audience);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. Example format: properties/1234
     * @param Audience $audience     Required. The audience to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Audience
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createAudience($parent, $audience, array $optionalArgs = [])
    {
        $request = new CreateAudienceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAudience($audience);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateAudience', Audience::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a ChannelGroup.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $channelGroup = new ChannelGroup();
     *     $response = $analyticsAdminServiceClient->createChannelGroup($formattedParent, $channelGroup);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The property for which to create a ChannelGroup.
     *                                   Example format: properties/1234
     * @param ChannelGroup $channelGroup Required. The ChannelGroup to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ChannelGroup
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createChannelGroup($parent, $channelGroup, array $optionalArgs = [])
    {
        $request = new CreateChannelGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannelGroup($channelGroup);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateChannelGroup', ChannelGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a connected site tag for a Universal Analytics property. You can
     * create a maximum of 20 connected site tags per property.
     * Note: This API cannot be used on GA4 properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $connectedSiteTag = new ConnectedSiteTag();
     *     $response = $analyticsAdminServiceClient->createConnectedSiteTag($connectedSiteTag);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param ConnectedSiteTag $connectedSiteTag Required. The tag to add to the Universal Analytics property
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type string $property
     *           The Universal Analytics property to create connected site tags for.
     *           This API does not support GA4 properties.
     *           Format: properties/{universalAnalyticsPropertyId}
     *           Example: properties/1234
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CreateConnectedSiteTagResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createConnectedSiteTag($connectedSiteTag, array $optionalArgs = [])
    {
        $request = new CreateConnectedSiteTagRequest();
        $request->setConnectedSiteTag($connectedSiteTag);
        if (isset($optionalArgs['property'])) {
            $request->setProperty($optionalArgs['property']);
        }

        return $this->startCall('CreateConnectedSiteTag', CreateConnectedSiteTagResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a conversion event with the specified attributes.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $conversionEvent = new ConversionEvent();
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->createConversionEvent($conversionEvent, $formattedParent);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param ConversionEvent $conversionEvent Required. The conversion event to create.
     * @param string          $parent          Required. The resource name of the parent property where this conversion
     *                                         event will be created. Format: properties/123
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ConversionEvent
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createConversionEvent($conversionEvent, $parent, array $optionalArgs = [])
    {
        $request = new CreateConversionEventRequest();
        $requestParamHeaders = [];
        $request->setConversionEvent($conversionEvent);
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateConversionEvent', ConversionEvent::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a CustomDimension.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $customDimension = new CustomDimension();
     *     $response = $analyticsAdminServiceClient->createCustomDimension($formattedParent, $customDimension);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. Example format: properties/1234
     * @param CustomDimension $customDimension Required. The CustomDimension to create.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomDimension
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createCustomDimension($parent, $customDimension, array $optionalArgs = [])
    {
        $request = new CreateCustomDimensionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCustomDimension($customDimension);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateCustomDimension', CustomDimension::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a CustomMetric.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $customMetric = new CustomMetric();
     *     $response = $analyticsAdminServiceClient->createCustomMetric($formattedParent, $customMetric);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. Example format: properties/1234
     * @param CustomMetric $customMetric Required. The CustomMetric to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomMetric
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createCustomMetric($parent, $customMetric, array $optionalArgs = [])
    {
        $request = new CreateCustomMetricRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCustomMetric($customMetric);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateCustomMetric', CustomMetric::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a DataStream.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $dataStream = new DataStream();
     *     $response = $analyticsAdminServiceClient->createDataStream($formattedParent, $dataStream);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. Example format: properties/1234
     * @param DataStream $dataStream   Required. The DataStream to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataStream
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createDataStream($parent, $dataStream, array $optionalArgs = [])
    {
        $request = new CreateDataStreamRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataStream($dataStream);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateDataStream', DataStream::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a DisplayVideo360AdvertiserLink.
     * This can only be utilized by users who have proper authorization both on
     * the Google Analytics property and on the Display & Video 360 advertiser.
     * Users who do not have access to the Display & Video 360 advertiser should
     * instead seek to create a DisplayVideo360LinkProposal.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $displayVideo360AdvertiserLink = new DisplayVideo360AdvertiserLink();
     *     $response = $analyticsAdminServiceClient->createDisplayVideo360AdvertiserLink($formattedParent, $displayVideo360AdvertiserLink);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                        $parent                        Required. Example format: properties/1234
     * @param DisplayVideo360AdvertiserLink $displayVideo360AdvertiserLink Required. The DisplayVideo360AdvertiserLink to create.
     * @param array                         $optionalArgs                  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createDisplayVideo360AdvertiserLink($parent, $displayVideo360AdvertiserLink, array $optionalArgs = [])
    {
        $request = new CreateDisplayVideo360AdvertiserLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDisplayVideo360AdvertiserLink($displayVideo360AdvertiserLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateDisplayVideo360AdvertiserLink', DisplayVideo360AdvertiserLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a DisplayVideo360AdvertiserLinkProposal.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $displayVideo360AdvertiserLinkProposal = new DisplayVideo360AdvertiserLinkProposal();
     *     $response = $analyticsAdminServiceClient->createDisplayVideo360AdvertiserLinkProposal($formattedParent, $displayVideo360AdvertiserLinkProposal);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                                $parent                                Required. Example format: properties/1234
     * @param DisplayVideo360AdvertiserLinkProposal $displayVideo360AdvertiserLinkProposal Required. The DisplayVideo360AdvertiserLinkProposal to create.
     * @param array                                 $optionalArgs                          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createDisplayVideo360AdvertiserLinkProposal($parent, $displayVideo360AdvertiserLinkProposal, array $optionalArgs = [])
    {
        $request = new CreateDisplayVideo360AdvertiserLinkProposalRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDisplayVideo360AdvertiserLinkProposal($displayVideo360AdvertiserLinkProposal);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateDisplayVideo360AdvertiserLinkProposal', DisplayVideo360AdvertiserLinkProposal::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an EventCreateRule.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     $eventCreateRule = new EventCreateRule();
     *     $response = $analyticsAdminServiceClient->createEventCreateRule($formattedParent, $eventCreateRule);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. Example format: properties/123/dataStreams/456
     * @param EventCreateRule $eventCreateRule Required. The EventCreateRule to create.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\EventCreateRule
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createEventCreateRule($parent, $eventCreateRule, array $optionalArgs = [])
    {
        $request = new CreateEventCreateRuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEventCreateRule($eventCreateRule);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateEventCreateRule', EventCreateRule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a ExpandedDataSet.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $expandedDataSet = new ExpandedDataSet();
     *     $response = $analyticsAdminServiceClient->createExpandedDataSet($formattedParent, $expandedDataSet);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. Example format: properties/1234
     * @param ExpandedDataSet $expandedDataSet Required. The ExpandedDataSet to create.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ExpandedDataSet
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createExpandedDataSet($parent, $expandedDataSet, array $optionalArgs = [])
    {
        $request = new CreateExpandedDataSetRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setExpandedDataSet($expandedDataSet);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateExpandedDataSet', ExpandedDataSet::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a FirebaseLink.
     *
     * Properties can have at most one FirebaseLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $firebaseLink = new FirebaseLink();
     *     $response = $analyticsAdminServiceClient->createFirebaseLink($formattedParent, $firebaseLink);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. Format: properties/{property_id}
     *                                   Example: properties/1234
     * @param FirebaseLink $firebaseLink Required. The Firebase link to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\FirebaseLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createFirebaseLink($parent, $firebaseLink, array $optionalArgs = [])
    {
        $request = new CreateFirebaseLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFirebaseLink($firebaseLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateFirebaseLink', FirebaseLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a GoogleAdsLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $googleAdsLink = new GoogleAdsLink();
     *     $response = $analyticsAdminServiceClient->createGoogleAdsLink($formattedParent, $googleAdsLink);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. Example format: properties/1234
     * @param GoogleAdsLink $googleAdsLink Required. The GoogleAdsLink to create.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\GoogleAdsLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createGoogleAdsLink($parent, $googleAdsLink, array $optionalArgs = [])
    {
        $request = new CreateGoogleAdsLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGoogleAdsLink($googleAdsLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateGoogleAdsLink', GoogleAdsLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a measurement protocol secret.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     $measurementProtocolSecret = new MeasurementProtocolSecret();
     *     $response = $analyticsAdminServiceClient->createMeasurementProtocolSecret($formattedParent, $measurementProtocolSecret);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                    $parent                    Required. The parent resource where this secret will be created.
     *                                                             Format: properties/{property}/dataStreams/{dataStream}
     * @param MeasurementProtocolSecret $measurementProtocolSecret Required. The measurement protocol secret to create.
     * @param array                     $optionalArgs              {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\MeasurementProtocolSecret
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createMeasurementProtocolSecret($parent, $measurementProtocolSecret, array $optionalArgs = [])
    {
        $request = new CreateMeasurementProtocolSecretRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMeasurementProtocolSecret($measurementProtocolSecret);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateMeasurementProtocolSecret', MeasurementProtocolSecret::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an "GA4" property with the specified location and attributes.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $property = new Property();
     *     $response = $analyticsAdminServiceClient->createProperty($property);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param Property $property     Required. The property to create.
     *                               Note: the supplied property must specify its parent.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Property
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createProperty($property, array $optionalArgs = [])
    {
        $request = new CreatePropertyRequest();
        $request->setProperty($property);
        return $this->startCall('CreateProperty', Property::class, $optionalArgs, $request)->wait();
    }

    /**
     * Create a roll-up property and all roll-up property source links.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $rollupProperty = new Property();
     *     $response = $analyticsAdminServiceClient->createRollupProperty($rollupProperty);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param Property $rollupProperty Required. The roll-up property to create.
     * @param array    $optionalArgs   {
     *     Optional.
     *
     *     @type string[] $sourceProperties
     *           Optional. The resource names of properties that will be sources to the
     *           created roll-up property.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CreateRollupPropertyResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createRollupProperty($rollupProperty, array $optionalArgs = [])
    {
        $request = new CreateRollupPropertyRequest();
        $request->setRollupProperty($rollupProperty);
        if (isset($optionalArgs['sourceProperties'])) {
            $request->setSourceProperties($optionalArgs['sourceProperties']);
        }

        return $this->startCall('CreateRollupProperty', CreateRollupPropertyResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a roll-up property source link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $rollupPropertySourceLink = new RollupPropertySourceLink();
     *     $response = $analyticsAdminServiceClient->createRollupPropertySourceLink($formattedParent, $rollupPropertySourceLink);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                   $parent                   Required. Format: properties/{property_id}
     *                                                           Example: properties/1234
     * @param RollupPropertySourceLink $rollupPropertySourceLink Required. The roll-up property source link to create.
     * @param array                    $optionalArgs             {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\RollupPropertySourceLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createRollupPropertySourceLink($parent, $rollupPropertySourceLink, array $optionalArgs = [])
    {
        $request = new CreateRollupPropertySourceLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRollupPropertySourceLink($rollupPropertySourceLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateRollupPropertySourceLink', RollupPropertySourceLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a SKAdNetworkConversionValueSchema.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     $skadnetworkConversionValueSchema = new SKAdNetworkConversionValueSchema();
     *     $response = $analyticsAdminServiceClient->createSKAdNetworkConversionValueSchema($formattedParent, $skadnetworkConversionValueSchema);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                           $parent                           Required. The parent resource where this schema will be created.
     *                                                                           Format: properties/{property}/dataStreams/{dataStream}
     * @param SKAdNetworkConversionValueSchema $skadnetworkConversionValueSchema Required. SKAdNetwork conversion value schema to create.
     * @param array                            $optionalArgs                     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SKAdNetworkConversionValueSchema
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createSKAdNetworkConversionValueSchema($parent, $skadnetworkConversionValueSchema, array $optionalArgs = [])
    {
        $request = new CreateSKAdNetworkConversionValueSchemaRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSkadnetworkConversionValueSchema($skadnetworkConversionValueSchema);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSKAdNetworkConversionValueSchema', SKAdNetworkConversionValueSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a SearchAds360Link.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $searchAds360Link = new SearchAds360Link();
     *     $response = $analyticsAdminServiceClient->createSearchAds360Link($formattedParent, $searchAds360Link);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string           $parent           Required. Example format: properties/1234
     * @param SearchAds360Link $searchAds360Link Required. The SearchAds360Link to create.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SearchAds360Link
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createSearchAds360Link($parent, $searchAds360Link, array $optionalArgs = [])
    {
        $request = new CreateSearchAds360LinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSearchAds360Link($searchAds360Link);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSearchAds360Link', SearchAds360Link::class, $optionalArgs, $request)->wait();
    }

    /**
     * Create a subproperty and a subproperty event filter that applies to the
     * created subproperty.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $subproperty = new Property();
     *     $response = $analyticsAdminServiceClient->createSubproperty($formattedParent, $subproperty);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The ordinary property for which to create a subproperty.
     *                               Format: properties/property_id
     *                               Example: properties/123
     * @param Property $subproperty  Required. The subproperty to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type SubpropertyEventFilter $subpropertyEventFilter
     *           Optional. The subproperty event filter to create on an ordinary property.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CreateSubpropertyResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createSubproperty($parent, $subproperty, array $optionalArgs = [])
    {
        $request = new CreateSubpropertyRequest();
        $request->setParent($parent);
        $request->setSubproperty($subproperty);
        if (isset($optionalArgs['subpropertyEventFilter'])) {
            $request->setSubpropertyEventFilter($optionalArgs['subpropertyEventFilter']);
        }

        return $this->startCall('CreateSubproperty', CreateSubpropertyResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a subproperty Event Filter.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $subpropertyEventFilter = new SubpropertyEventFilter();
     *     $response = $analyticsAdminServiceClient->createSubpropertyEventFilter($formattedParent, $subpropertyEventFilter);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string                 $parent                 Required. The ordinary property for which to create a subproperty event
     *                                                       filter. Format: properties/property_id Example: properties/123
     * @param SubpropertyEventFilter $subpropertyEventFilter Required. The subproperty event filter to create.
     * @param array                  $optionalArgs           {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SubpropertyEventFilter
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createSubpropertyEventFilter($parent, $subpropertyEventFilter, array $optionalArgs = [])
    {
        $request = new CreateSubpropertyEventFilterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSubpropertyEventFilter($subpropertyEventFilter);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSubpropertyEventFilter', SubpropertyEventFilter::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an access binding on an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->accessBindingName('[ACCOUNT]', '[ACCESS_BINDING]');
     *     $analyticsAdminServiceClient->deleteAccessBinding($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Formats:
     *                             - accounts/{account}/accessBindings/{accessBinding}
     *                             - properties/{property}/accessBindings/{accessBinding}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteAccessBinding($name, array $optionalArgs = [])
    {
        $request = new DeleteAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteAccessBinding', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Marks target Account as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted accounts.
     * However, they can be restored using the Trash Can UI.
     *
     * If the accounts are not restored before the expiration time, the account
     * and all child resources (eg: Properties, GoogleAdsLinks, Streams,
     * AccessBindings) will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $analyticsAdminServiceClient->deleteAccount($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Account to soft-delete.
     *                             Format: accounts/{account}
     *                             Example: "accounts/100"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteAccount($name, array $optionalArgs = [])
    {
        $request = new DeleteAccountRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteAccount', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an AdSenseLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->adSenseLinkName('[PROPERTY]', '[ADSENSE_LINK]');
     *     $analyticsAdminServiceClient->deleteAdSenseLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Unique identifier for the AdSense Link to be deleted.
     *                             Format: properties/{propertyId}/adSenseLinks/{linkId}
     *                             Example: properties/1234/adSenseLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteAdSenseLink($name, array $optionalArgs = [])
    {
        $request = new DeleteAdSenseLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteAdSenseLink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a ChannelGroup on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->channelGroupName('[PROPERTY]', '[CHANNEL_GROUP]');
     *     $analyticsAdminServiceClient->deleteChannelGroup($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The ChannelGroup to delete.
     *                             Example format: properties/1234/channelGroups/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteChannelGroup($name, array $optionalArgs = [])
    {
        $request = new DeleteChannelGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteChannelGroup', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a connected site tag for a Universal Analytics property.
     * Note: this has no effect on GA4 properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $analyticsAdminServiceClient->deleteConnectedSiteTag();
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $property
     *           The Universal Analytics property to delete connected site tags for.
     *           This API does not support GA4 properties.
     *           Format: properties/{universalAnalyticsPropertyId}
     *           Example: properties/1234
     *     @type string $tagId
     *           Tag ID to forward events to. Also known as the Measurement ID, or the
     *           "G-ID"  (For example: G-12345).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteConnectedSiteTag(array $optionalArgs = [])
    {
        $request = new DeleteConnectedSiteTagRequest();
        if (isset($optionalArgs['property'])) {
            $request->setProperty($optionalArgs['property']);
        }

        if (isset($optionalArgs['tagId'])) {
            $request->setTagId($optionalArgs['tagId']);
        }

        return $this->startCall('DeleteConnectedSiteTag', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a conversion event in a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->conversionEventName('[PROPERTY]', '[CONVERSION_EVENT]');
     *     $analyticsAdminServiceClient->deleteConversionEvent($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the conversion event to delete.
     *                             Format: properties/{property}/conversionEvents/{conversion_event}
     *                             Example: "properties/123/conversionEvents/456"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteConversionEvent($name, array $optionalArgs = [])
    {
        $request = new DeleteConversionEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteConversionEvent', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a DataStream on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     $analyticsAdminServiceClient->deleteDataStream($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DataStream to delete.
     *                             Example format: properties/1234/dataStreams/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteDataStream($name, array $optionalArgs = [])
    {
        $request = new DeleteDataStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteDataStream', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a DisplayVideo360AdvertiserLink on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK]');
     *     $analyticsAdminServiceClient->deleteDisplayVideo360AdvertiserLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLink to delete.
     *                             Example format: properties/1234/displayVideo360AdvertiserLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteDisplayVideo360AdvertiserLink($name, array $optionalArgs = [])
    {
        $request = new DeleteDisplayVideo360AdvertiserLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteDisplayVideo360AdvertiserLink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
     * This can only be used on cancelled proposals.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkProposalName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL]');
     *     $analyticsAdminServiceClient->deleteDisplayVideo360AdvertiserLinkProposal($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
     *                             Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteDisplayVideo360AdvertiserLinkProposal($name, array $optionalArgs = [])
    {
        $request = new DeleteDisplayVideo360AdvertiserLinkProposalRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteDisplayVideo360AdvertiserLinkProposal', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an EventCreateRule.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->eventCreateRuleName('[PROPERTY]', '[DATA_STREAM]', '[EVENT_CREATE_RULE]');
     *     $analyticsAdminServiceClient->deleteEventCreateRule($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example format:
     *                             properties/123/dataStreams/456/eventCreateRules/789
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteEventCreateRule($name, array $optionalArgs = [])
    {
        $request = new DeleteEventCreateRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEventCreateRule', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a ExpandedDataSet on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->expandedDataSetName('[PROPERTY]', '[EXPANDED_DATA_SET]');
     *     $analyticsAdminServiceClient->deleteExpandedDataSet($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example format: properties/1234/expandedDataSets/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteExpandedDataSet($name, array $optionalArgs = [])
    {
        $request = new DeleteExpandedDataSetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteExpandedDataSet', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a FirebaseLink on a property
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->firebaseLinkName('[PROPERTY]', '[FIREBASE_LINK]');
     *     $analyticsAdminServiceClient->deleteFirebaseLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
     *                             Example: properties/1234/firebaseLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteFirebaseLink($name, array $optionalArgs = [])
    {
        $request = new DeleteFirebaseLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteFirebaseLink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a GoogleAdsLink on a property
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->googleAdsLinkName('[PROPERTY]', '[GOOGLE_ADS_LINK]');
     *     $analyticsAdminServiceClient->deleteGoogleAdsLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example format: properties/1234/googleAdsLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteGoogleAdsLink($name, array $optionalArgs = [])
    {
        $request = new DeleteGoogleAdsLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteGoogleAdsLink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes target MeasurementProtocolSecret.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->measurementProtocolSecretName('[PROPERTY]', '[DATA_STREAM]', '[MEASUREMENT_PROTOCOL_SECRET]');
     *     $analyticsAdminServiceClient->deleteMeasurementProtocolSecret($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the MeasurementProtocolSecret to delete.
     *                             Format:
     *                             properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteMeasurementProtocolSecret($name, array $optionalArgs = [])
    {
        $request = new DeleteMeasurementProtocolSecretRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteMeasurementProtocolSecret', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Marks target Property as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted properties.
     * However, they can be restored using the Trash Can UI.
     *
     * If the properties are not restored before the expiration time, the Property
     * and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
     * will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found, or is not a GA4 Property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->deleteProperty($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Property to soft-delete.
     *                             Format: properties/{property_id}
     *                             Example: "properties/1000"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Property
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteProperty($name, array $optionalArgs = [])
    {
        $request = new DeletePropertyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteProperty', Property::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a roll-up property source link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->rollupPropertySourceLinkName('[PROPERTY]', '[ROLLUP_PROPERTY_SOURCE_LINK]');
     *     $analyticsAdminServiceClient->deleteRollupPropertySourceLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Format:
     *                             properties/{property_id}/rollupPropertySourceLinks/{rollup_property_source_link_id}
     *                             Example: properties/1234/rollupPropertySourceLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteRollupPropertySourceLink($name, array $optionalArgs = [])
    {
        $request = new DeleteRollupPropertySourceLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteRollupPropertySourceLink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes target SKAdNetworkConversionValueSchema.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->sKAdNetworkConversionValueSchemaName('[PROPERTY]', '[DATA_STREAM]', '[SKADNETWORK_CONVERSION_VALUE_SCHEMA]');
     *     $analyticsAdminServiceClient->deleteSKAdNetworkConversionValueSchema($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SKAdNetworkConversionValueSchema to delete.
     *                             Format:
     *                             properties/{property}/dataStreams/{dataStream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteSKAdNetworkConversionValueSchema($name, array $optionalArgs = [])
    {
        $request = new DeleteSKAdNetworkConversionValueSchemaRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSKAdNetworkConversionValueSchema', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a SearchAds360Link on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->searchAds360LinkName('[PROPERTY]', '[SEARCH_ADS_360_LINK]');
     *     $analyticsAdminServiceClient->deleteSearchAds360Link($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SearchAds360Link to delete.
     *                             Example format: properties/1234/SearchAds360Links/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteSearchAds360Link($name, array $optionalArgs = [])
    {
        $request = new DeleteSearchAds360LinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSearchAds360Link', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a subproperty event filter.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->subpropertyEventFilterName('[PROPERTY]', '[SUB_PROPERTY_EVENT_FILTER]');
     *     $analyticsAdminServiceClient->deleteSubpropertyEventFilter($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the subproperty event filter to delete.
     *                             Format:
     *                             properties/property_id/subpropertyEventFilters/subproperty_event_filter
     *                             Example: properties/123/subpropertyEventFilters/456
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteSubpropertyEventFilter($name, array $optionalArgs = [])
    {
        $request = new DeleteSubpropertyEventFilterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSubpropertyEventFilter', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Fetches the opt out status for the automated GA4 setup process for a UA
     * property.
     * Note: this has no effect on GA4 property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $property = 'property';
     *     $response = $analyticsAdminServiceClient->fetchAutomatedGa4ConfigurationOptOut($property);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $property     Required. The UA property to get the opt out status. Note this request uses
     *                             the internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
     *                             Format: properties/{internalWebPropertyId}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\FetchAutomatedGa4ConfigurationOptOutResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchAutomatedGa4ConfigurationOptOut($property, array $optionalArgs = [])
    {
        $request = new FetchAutomatedGa4ConfigurationOptOutRequest();
        $request->setProperty($property);
        return $this->startCall('FetchAutomatedGa4ConfigurationOptOut', FetchAutomatedGa4ConfigurationOptOutResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Given a specified UA property, looks up the GA4 property connected to it.
     * Note: this cannot be used with GA4 properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedProperty = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->fetchConnectedGa4Property($formattedProperty);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $property     Required. The UA property for which to look up the connected GA4 property.
     *                             Note this request uses the
     *                             internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
     *                             Format: properties/{internal_web_property_id}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\FetchConnectedGa4PropertyResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchConnectedGa4Property($property, array $optionalArgs = [])
    {
        $request = new FetchConnectedGa4PropertyRequest();
        $request->setProperty($property);
        return $this->startCall('FetchConnectedGa4Property', FetchConnectedGa4PropertyResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about an access binding.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->accessBindingName('[ACCOUNT]', '[ACCESS_BINDING]');
     *     $response = $analyticsAdminServiceClient->getAccessBinding($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the access binding to retrieve.
     *                             Formats:
     *                             - accounts/{account}/accessBindings/{accessBinding}
     *                             - properties/{property}/accessBindings/{accessBinding}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AccessBinding
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAccessBinding($name, array $optionalArgs = [])
    {
        $request = new GetAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAccessBinding', AccessBinding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single Account.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     $response = $analyticsAdminServiceClient->getAccount($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the account to lookup.
     *                             Format: accounts/{account}
     *                             Example: "accounts/100"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Account
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAccount($name, array $optionalArgs = [])
    {
        $request = new GetAccountRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAccount', Account::class, $optionalArgs, $request)->wait();
    }

    /**
     * Looks up a single AdSenseLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->adSenseLinkName('[PROPERTY]', '[ADSENSE_LINK]');
     *     $response = $analyticsAdminServiceClient->getAdSenseLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Unique identifier for the AdSense Link requested.
     *                             Format: properties/{propertyId}/adSenseLinks/{linkId}
     *                             Example: properties/1234/adSenseLinks/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AdSenseLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAdSenseLink($name, array $optionalArgs = [])
    {
        $request = new GetAdSenseLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAdSenseLink', AdSenseLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a AttributionSettings singleton.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->attributionSettingsName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->getAttributionSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the attribution settings to retrieve.
     *                             Format: properties/{property}/attributionSettings
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AttributionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAttributionSettings($name, array $optionalArgs = [])
    {
        $request = new GetAttributionSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAttributionSettings', AttributionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single Audience.
     * Audiences created before 2020 may not be supported.
     * Default audiences will not show filter definitions.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->audienceName('[PROPERTY]', '[AUDIENCE]');
     *     $response = $analyticsAdminServiceClient->getAudience($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Audience to get.
     *                             Example format: properties/1234/audiences/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Audience
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAudience($name, array $optionalArgs = [])
    {
        $request = new GetAudienceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAudience', Audience::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single BigQuery Link.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->bigQueryLinkName('[PROPERTY]', '[BIGQUERY_LINK]');
     *     $response = $analyticsAdminServiceClient->getBigQueryLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the BigQuery link to lookup.
     *                             Format: properties/{property_id}/bigQueryLinks/{bigquery_link_id}
     *                             Example: properties/123/bigQueryLinks/456
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\BigQueryLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getBigQueryLink($name, array $optionalArgs = [])
    {
        $request = new GetBigQueryLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBigQueryLink', BigQueryLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single ChannelGroup.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->channelGroupName('[PROPERTY]', '[CHANNEL_GROUP]');
     *     $response = $analyticsAdminServiceClient->getChannelGroup($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The ChannelGroup to get.
     *                             Example format: properties/1234/channelGroups/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ChannelGroup
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getChannelGroup($name, array $optionalArgs = [])
    {
        $request = new GetChannelGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetChannelGroup', ChannelGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieve a single conversion event.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->conversionEventName('[PROPERTY]', '[CONVERSION_EVENT]');
     *     $response = $analyticsAdminServiceClient->getConversionEvent($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the conversion event to retrieve.
     *                             Format: properties/{property}/conversionEvents/{conversion_event}
     *                             Example: "properties/123/conversionEvents/456"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ConversionEvent
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getConversionEvent($name, array $optionalArgs = [])
    {
        $request = new GetConversionEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetConversionEvent', ConversionEvent::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single CustomDimension.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->customDimensionName('[PROPERTY]', '[CUSTOM_DIMENSION]');
     *     $response = $analyticsAdminServiceClient->getCustomDimension($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CustomDimension to get.
     *                             Example format: properties/1234/customDimensions/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomDimension
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getCustomDimension($name, array $optionalArgs = [])
    {
        $request = new GetCustomDimensionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCustomDimension', CustomDimension::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single CustomMetric.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->customMetricName('[PROPERTY]', '[CUSTOM_METRIC]');
     *     $response = $analyticsAdminServiceClient->getCustomMetric($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CustomMetric to get.
     *                             Example format: properties/1234/customMetrics/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomMetric
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getCustomMetric($name, array $optionalArgs = [])
    {
        $request = new GetCustomMetricRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCustomMetric', CustomMetric::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single DataRedactionSettings.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->dataRedactionSettingsName('[PROPERTY]', '[DATA_STREAM]');
     *     $response = $analyticsAdminServiceClient->getDataRedactionSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the settings to lookup.
     *                             Format:
     *                             properties/{property}/dataStreams/{data_stream}/dataRedactionSettings
     *                             Example: "properties/1000/dataStreams/2000/dataRedactionSettings"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataRedactionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDataRedactionSettings($name, array $optionalArgs = [])
    {
        $request = new GetDataRedactionSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataRedactionSettings', DataRedactionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the singleton data retention settings for this property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->dataRetentionSettingsName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->getDataRetentionSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the settings to lookup.
     *                             Format:
     *                             properties/{property}/dataRetentionSettings
     *                             Example: "properties/1000/dataRetentionSettings"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataRetentionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDataRetentionSettings($name, array $optionalArgs = [])
    {
        $request = new GetDataRetentionSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataRetentionSettings', DataRetentionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get data sharing settings on an account.
     * Data sharing settings are singletons.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->dataSharingSettingsName('[ACCOUNT]');
     *     $response = $analyticsAdminServiceClient->getDataSharingSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the settings to lookup.
     *                             Format: accounts/{account}/dataSharingSettings
     *                             Example: "accounts/1000/dataSharingSettings"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataSharingSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDataSharingSettings($name, array $optionalArgs = [])
    {
        $request = new GetDataSharingSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataSharingSettings', DataSharingSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single DataStream.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     $response = $analyticsAdminServiceClient->getDataStream($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DataStream to get.
     *                             Example format: properties/1234/dataStreams/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataStream
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDataStream($name, array $optionalArgs = [])
    {
        $request = new GetDataStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataStream', DataStream::class, $optionalArgs, $request)->wait();
    }

    /**
     * Look up a single DisplayVideo360AdvertiserLink
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK]');
     *     $response = $analyticsAdminServiceClient->getDisplayVideo360AdvertiserLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLink to get.
     *                             Example format: properties/1234/displayVideo360AdvertiserLink/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDisplayVideo360AdvertiserLink($name, array $optionalArgs = [])
    {
        $request = new GetDisplayVideo360AdvertiserLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDisplayVideo360AdvertiserLink', DisplayVideo360AdvertiserLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single DisplayVideo360AdvertiserLinkProposal.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->displayVideo360AdvertiserLinkProposalName('[PROPERTY]', '[DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL]');
     *     $response = $analyticsAdminServiceClient->getDisplayVideo360AdvertiserLinkProposal($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
     *                             Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getDisplayVideo360AdvertiserLinkProposal($name, array $optionalArgs = [])
    {
        $request = new GetDisplayVideo360AdvertiserLinkProposalRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDisplayVideo360AdvertiserLinkProposal', DisplayVideo360AdvertiserLinkProposal::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the enhanced measurement settings for this data stream.
     * Note that the stream must enable enhanced measurement for these settings to
     * take effect.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->enhancedMeasurementSettingsName('[PROPERTY]', '[DATA_STREAM]');
     *     $response = $analyticsAdminServiceClient->getEnhancedMeasurementSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the settings to lookup.
     *                             Format:
     *                             properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings
     *                             Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\EnhancedMeasurementSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getEnhancedMeasurementSettings($name, array $optionalArgs = [])
    {
        $request = new GetEnhancedMeasurementSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEnhancedMeasurementSettings', EnhancedMeasurementSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single EventCreateRule.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->eventCreateRuleName('[PROPERTY]', '[DATA_STREAM]', '[EVENT_CREATE_RULE]');
     *     $response = $analyticsAdminServiceClient->getEventCreateRule($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the EventCreateRule to get.
     *                             Example format: properties/123/dataStreams/456/eventCreateRules/789
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\EventCreateRule
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getEventCreateRule($name, array $optionalArgs = [])
    {
        $request = new GetEventCreateRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEventCreateRule', EventCreateRule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single ExpandedDataSet.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->expandedDataSetName('[PROPERTY]', '[EXPANDED_DATA_SET]');
     *     $response = $analyticsAdminServiceClient->getExpandedDataSet($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the ExpandedDataSet to get.
     *                             Example format: properties/1234/expandedDataSets/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ExpandedDataSet
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getExpandedDataSet($name, array $optionalArgs = [])
    {
        $request = new GetExpandedDataSetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetExpandedDataSet', ExpandedDataSet::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the Site Tag for the specified web stream.
     * Site Tags are immutable singletons.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->globalSiteTagName('[PROPERTY]', '[DATA_STREAM]');
     *     $response = $analyticsAdminServiceClient->getGlobalSiteTag($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the site tag to lookup.
     *                             Note that site tags are singletons and do not have unique IDs.
     *                             Format: properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
     *                             Example: "properties/123/dataStreams/456/globalSiteTag"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\GlobalSiteTag
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getGlobalSiteTag($name, array $optionalArgs = [])
    {
        $request = new GetGlobalSiteTagRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetGlobalSiteTag', GlobalSiteTag::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for Google Signals settings for a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->googleSignalsSettingsName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->getGoogleSignalsSettings($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the google signals settings to retrieve.
     *                             Format: properties/{property}/googleSignalsSettings
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\GoogleSignalsSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getGoogleSignalsSettings($name, array $optionalArgs = [])
    {
        $request = new GetGoogleSignalsSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetGoogleSignalsSettings', GoogleSignalsSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single "GA4" MeasurementProtocolSecret.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->measurementProtocolSecretName('[PROPERTY]', '[DATA_STREAM]', '[MEASUREMENT_PROTOCOL_SECRET]');
     *     $response = $analyticsAdminServiceClient->getMeasurementProtocolSecret($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the measurement protocol secret to lookup.
     *                             Format:
     *                             properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\MeasurementProtocolSecret
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getMeasurementProtocolSecret($name, array $optionalArgs = [])
    {
        $request = new GetMeasurementProtocolSecretRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetMeasurementProtocolSecret', MeasurementProtocolSecret::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single "GA4" Property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     $response = $analyticsAdminServiceClient->getProperty($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the property to lookup.
     *                             Format: properties/{property_id}
     *                             Example: "properties/1000"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Property
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getProperty($name, array $optionalArgs = [])
    {
        $request = new GetPropertyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetProperty', Property::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lookup for a single roll-up property source Link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->rollupPropertySourceLinkName('[PROPERTY]', '[ROLLUP_PROPERTY_SOURCE_LINK]');
     *     $response = $analyticsAdminServiceClient->getRollupPropertySourceLink($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the roll-up property source link to lookup.
     *                             Format:
     *                             properties/{property_id}/rollupPropertySourceLinks/{rollup_property_source_link_id}
     *                             Example: properties/123/rollupPropertySourceLinks/456
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\RollupPropertySourceLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getRollupPropertySourceLink($name, array $optionalArgs = [])
    {
        $request = new GetRollupPropertySourceLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetRollupPropertySourceLink', RollupPropertySourceLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Looks up a single SKAdNetworkConversionValueSchema.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->sKAdNetworkConversionValueSchemaName('[PROPERTY]', '[DATA_STREAM]', '[SKADNETWORK_CONVERSION_VALUE_SCHEMA]');
     *     $response = $analyticsAdminServiceClient->getSKAdNetworkConversionValueSchema($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of SKAdNetwork conversion value schema to look
     *                             up. Format:
     *                             properties/{property}/dataStreams/{dataStream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SKAdNetworkConversionValueSchema
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getSKAdNetworkConversionValueSchema($name, array $optionalArgs = [])
    {
        $request = new GetSKAdNetworkConversionValueSchemaRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSKAdNetworkConversionValueSchema', SKAdNetworkConversionValueSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Look up a single SearchAds360Link
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedName = $analyticsAdminServiceClient->searchAds360LinkName('[PROPERTY]', '[SEARCH_ADS_360_LINK]');
     *     $response = $analyticsAdminServiceClient->getSearchAds360Link($formattedName);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SearchAds360Link to get.
     *                             Example format: properties/1234/SearchAds360Link/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SearchAds360Link
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getSearchAds360Link($name, array $optionalArgs = [])
    {
        $request = new GetSearchAds360LinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSearchAds360Link', SearchAds360Link::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists all access bindings on an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccessBindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccessBindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Formats:
     *                             - accounts/{account}
     *                             - properties/{property}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAccessBindings($parent, array $optionalArgs = [])
    {
        $request = new ListAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAccessBindings', $optionalArgs, ListAccessBindingsResponse::class, $request);
    }

    /**
     * Returns summaries of all accounts accessible by the caller.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccountSummaries();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccountSummaries();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAccountSummaries(array $optionalArgs = [])
    {
        $request = new ListAccountSummariesRequest();
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        return $this->getPagedListResponse('ListAccountSummaries', $optionalArgs, ListAccountSummariesResponse::class, $request);
    }

    /**
     * Returns all accounts accessible by the caller.
     *
     * Note that these accounts might not currently have GA4 properties.
     * Soft-deleted (ie: "trashed") accounts are excluded by default.
     * Returns an empty list if no relevant accounts are found.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccounts();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAccounts();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type bool $showDeleted
     *           Whether to include soft-deleted (ie: "trashed") Accounts in the
     *           results. Accounts can be inspected to determine whether they are deleted or
     *           not.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAccounts(array $optionalArgs = [])
    {
        $request = new ListAccountsRequest();
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['showDeleted'])) {
            $request->setShowDeleted($optionalArgs['showDeleted']);
        }

        return $this->getPagedListResponse('ListAccounts', $optionalArgs, ListAccountsResponse::class, $request);
    }

    /**
     * Lists AdSenseLinks on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAdSenseLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAdSenseLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the parent property.
     *                             Format: properties/{propertyId}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAdSenseLinks($parent, array $optionalArgs = [])
    {
        $request = new ListAdSenseLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAdSenseLinks', $optionalArgs, ListAdSenseLinksResponse::class, $request);
    }

    /**
     * Lists Audiences on a property.
     * Audiences created before 2020 may not be supported.
     * Default audiences will not show filter definitions.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAudiences($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listAudiences($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAudiences($parent, array $optionalArgs = [])
    {
        $request = new ListAudiencesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAudiences', $optionalArgs, ListAudiencesResponse::class, $request);
    }

    /**
     * Lists BigQuery Links on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listBigQueryLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listBigQueryLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the property to list BigQuery links under.
     *                             Format: properties/{property_id}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listBigQueryLinks($parent, array $optionalArgs = [])
    {
        $request = new ListBigQueryLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListBigQueryLinks', $optionalArgs, ListBigQueryLinksResponse::class, $request);
    }

    /**
     * Lists ChannelGroups on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listChannelGroups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listChannelGroups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The property for which to list ChannelGroups.
     *                             Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listChannelGroups($parent, array $optionalArgs = [])
    {
        $request = new ListChannelGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListChannelGroups', $optionalArgs, ListChannelGroupsResponse::class, $request);
    }

    /**
     * Lists the connected site tags for a Universal Analytics property. A maximum
     * of 20 connected site tags will be returned. Note: this has no effect on GA4
     * property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $response = $analyticsAdminServiceClient->listConnectedSiteTags();
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $property
     *           The Universal Analytics property to fetch connected site tags for.
     *           This does not work on GA4 properties. A maximum of 20 connected site tags
     *           will be returned.
     *           Example Format: `properties/1234`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ListConnectedSiteTagsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listConnectedSiteTags(array $optionalArgs = [])
    {
        $request = new ListConnectedSiteTagsRequest();
        if (isset($optionalArgs['property'])) {
            $request->setProperty($optionalArgs['property']);
        }

        return $this->startCall('ListConnectedSiteTags', ListConnectedSiteTagsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns a list of conversion events in the specified parent property.
     *
     * Returns an empty list if no conversion events are found.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listConversionEvents($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listConversionEvents($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent property.
     *                             Example: 'properties/123'
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listConversionEvents($parent, array $optionalArgs = [])
    {
        $request = new ListConversionEventsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListConversionEvents', $optionalArgs, ListConversionEventsResponse::class, $request);
    }

    /**
     * Lists CustomDimensions on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listCustomDimensions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listCustomDimensions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listCustomDimensions($parent, array $optionalArgs = [])
    {
        $request = new ListCustomDimensionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCustomDimensions', $optionalArgs, ListCustomDimensionsResponse::class, $request);
    }

    /**
     * Lists CustomMetrics on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listCustomMetrics($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listCustomMetrics($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listCustomMetrics($parent, array $optionalArgs = [])
    {
        $request = new ListCustomMetricsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCustomMetrics', $optionalArgs, ListCustomMetricsResponse::class, $request);
    }

    /**
     * Lists DataStreams on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDataStreams($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDataStreams($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listDataStreams($parent, array $optionalArgs = [])
    {
        $request = new ListDataStreamsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDataStreams', $optionalArgs, ListDataStreamsResponse::class, $request);
    }

    /**
     * Lists DisplayVideo360AdvertiserLinkProposals on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDisplayVideo360AdvertiserLinkProposals($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDisplayVideo360AdvertiserLinkProposals($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listDisplayVideo360AdvertiserLinkProposals($parent, array $optionalArgs = [])
    {
        $request = new ListDisplayVideo360AdvertiserLinkProposalsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDisplayVideo360AdvertiserLinkProposals', $optionalArgs, ListDisplayVideo360AdvertiserLinkProposalsResponse::class, $request);
    }

    /**
     * Lists all DisplayVideo360AdvertiserLinks on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDisplayVideo360AdvertiserLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listDisplayVideo360AdvertiserLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listDisplayVideo360AdvertiserLinks($parent, array $optionalArgs = [])
    {
        $request = new ListDisplayVideo360AdvertiserLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDisplayVideo360AdvertiserLinks', $optionalArgs, ListDisplayVideo360AdvertiserLinksResponse::class, $request);
    }

    /**
     * Lists EventCreateRules on a web data stream.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listEventCreateRules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listEventCreateRules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/123/dataStreams/456
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listEventCreateRules($parent, array $optionalArgs = [])
    {
        $request = new ListEventCreateRulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEventCreateRules', $optionalArgs, ListEventCreateRulesResponse::class, $request);
    }

    /**
     * Lists ExpandedDataSets on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listExpandedDataSets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listExpandedDataSets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listExpandedDataSets($parent, array $optionalArgs = [])
    {
        $request = new ListExpandedDataSetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListExpandedDataSets', $optionalArgs, ListExpandedDataSetsResponse::class, $request);
    }

    /**
     * Lists FirebaseLinks on a property.
     * Properties can have at most one FirebaseLink.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listFirebaseLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listFirebaseLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Format: properties/{property_id}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listFirebaseLinks($parent, array $optionalArgs = [])
    {
        $request = new ListFirebaseLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListFirebaseLinks', $optionalArgs, ListFirebaseLinksResponse::class, $request);
    }

    /**
     * Lists GoogleAdsLinks on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listGoogleAdsLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listGoogleAdsLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listGoogleAdsLinks($parent, array $optionalArgs = [])
    {
        $request = new ListGoogleAdsLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListGoogleAdsLinks', $optionalArgs, ListGoogleAdsLinksResponse::class, $request);
    }

    /**
     * Returns child MeasurementProtocolSecrets under the specified parent
     * Property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listMeasurementProtocolSecrets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listMeasurementProtocolSecrets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent stream.
     *                             Format:
     *                             properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listMeasurementProtocolSecrets($parent, array $optionalArgs = [])
    {
        $request = new ListMeasurementProtocolSecretsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListMeasurementProtocolSecrets', $optionalArgs, ListMeasurementProtocolSecretsResponse::class, $request);
    }

    /**
     * Returns child Properties under the specified parent Account.
     *
     * Only "GA4" properties will be returned.
     * Properties will be excluded if the caller does not have access.
     * Soft-deleted (ie: "trashed") properties are excluded by default.
     * Returns an empty list if no relevant properties are found.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $filter = 'filter';
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listProperties($filter);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listProperties($filter);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $filter       Required. An expression for filtering the results of the request.
     *                             Fields eligible for filtering are:
     *                             `parent:`(The resource name of the parent account/property) or
     *                             `ancestor:`(The resource name of the parent account) or
     *                             `firebase_project:`(The id or number of the linked firebase project).
     *                             Some examples of filters:
     *
     *                             ```
     *                             | Filter                      | Description                               |
     *                             |-----------------------------|-------------------------------------------|
     *                             | parent:accounts/123         | The account with account id: 123.       |
     *                             | parent:properties/123       | The property with property id: 123.       |
     *                             | ancestor:accounts/123       | The account with account id: 123.         |
     *                             | firebase_project:project-id | The firebase project with id: project-id. |
     *                             | firebase_project:123        | The firebase project with number: 123.    |
     *                             ```
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type bool $showDeleted
     *           Whether to include soft-deleted (ie: "trashed") Properties in the
     *           results. Properties can be inspected to determine whether they are deleted
     *           or not.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listProperties($filter, array $optionalArgs = [])
    {
        $request = new ListPropertiesRequest();
        $request->setFilter($filter);
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['showDeleted'])) {
            $request->setShowDeleted($optionalArgs['showDeleted']);
        }

        return $this->getPagedListResponse('ListProperties', $optionalArgs, ListPropertiesResponse::class, $request);
    }

    /**
     * Lists roll-up property source Links on a property.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listRollupPropertySourceLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listRollupPropertySourceLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the roll-up property to list roll-up property source
     *                             links under. Format: properties/{property_id} Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listRollupPropertySourceLinks($parent, array $optionalArgs = [])
    {
        $request = new ListRollupPropertySourceLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListRollupPropertySourceLinks', $optionalArgs, ListRollupPropertySourceLinksResponse::class, $request);
    }

    /**
     * Lists SKAdNetworkConversionValueSchema on a stream.
     * Properties can have at most one SKAdNetworkConversionValueSchema.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->dataStreamName('[PROPERTY]', '[DATA_STREAM]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listSKAdNetworkConversionValueSchemas($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listSKAdNetworkConversionValueSchemas($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The DataStream resource to list schemas for.
     *                             Format:
     *                             properties/{property_id}/dataStreams/{dataStream}
     *                             Example: properties/1234/dataStreams/5678
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listSKAdNetworkConversionValueSchemas($parent, array $optionalArgs = [])
    {
        $request = new ListSKAdNetworkConversionValueSchemasRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSKAdNetworkConversionValueSchemas', $optionalArgs, ListSKAdNetworkConversionValueSchemasResponse::class, $request);
    }

    /**
     * Lists all SearchAds360Links on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedParent = $analyticsAdminServiceClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->listSearchAds360Links($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->listSearchAds360Links($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example format: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listSearchAds360Links($parent, array $optionalArgs = [])
    {
        $request = new ListSearchAds360LinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSearchAds360Links', $optionalArgs, ListSearchAds360LinksResponse::class, $request);
    }

    /**
     * Requests a ticket for creating an account.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $response = $analyticsAdminServiceClient->provisionAccountTicket();
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type Account $account
     *           The account to create.
     *     @type string $redirectUri
     *           Redirect URI where the user will be sent after accepting Terms of Service.
     *           Must be configured in Cloud Console as a Redirect URI.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ProvisionAccountTicketResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function provisionAccountTicket(array $optionalArgs = [])
    {
        $request = new ProvisionAccountTicketRequest();
        if (isset($optionalArgs['account'])) {
            $request->setAccount($optionalArgs['account']);
        }

        if (isset($optionalArgs['redirectUri'])) {
            $request->setRedirectUri($optionalArgs['redirectUri']);
        }

        return $this->startCall('ProvisionAccountTicket', ProvisionAccountTicketResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns a customized report of data access records. The report provides
     * records of each time a user reads Google Analytics reporting data. Access
     * records are retained for up to 2 years.
     *
     * Data Access Reports can be requested for a property. The property must be
     * in Google Analytics 360. This method is only available to Administrators.
     *
     * These data access records include GA4 UI Reporting, GA4 UI Explorations,
     * GA4 Data API, and other products like Firebase & Admob that can retrieve
     * data from Google Analytics through a linkage. These records don't include
     * property configuration changes like adding a stream or changing a
     * property's time zone. For configuration change history, see
     * [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $response = $analyticsAdminServiceClient->runAccessReport();
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $entity
     *           The Data Access Report supports requesting at the property level or account
     *           level. If requested at the account level, Data Access Reports include all
     *           access for all properties under that account.
     *
     *           To request at the property level, entity should be for example
     *           'properties/123' if "123" is your GA4 property ID. To request at the
     *           account level, entity should be for example 'accounts/1234' if "1234" is
     *           your GA4 Account ID.
     *     @type AccessDimension[] $dimensions
     *           The dimensions requested and displayed in the response. Requests are
     *           allowed up to 9 dimensions.
     *     @type AccessMetric[] $metrics
     *           The metrics requested and displayed in the response. Requests are allowed
     *           up to 10 metrics.
     *     @type AccessDateRange[] $dateRanges
     *           Date ranges of access records to read. If multiple date ranges are
     *           requested, each response row will contain a zero based date range index. If
     *           two date ranges overlap, the access records for the overlapping days is
     *           included in the response rows for both date ranges. Requests are allowed up
     *           to 2 date ranges.
     *     @type AccessFilterExpression $dimensionFilter
     *           Dimension filters let you restrict report response to specific
     *           dimension values which match the filter. For example, filtering on access
     *           records of a single user. To learn more, see [Fundamentals of Dimension
     *           Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     *           for examples. Metrics cannot be used in this filter.
     *     @type AccessFilterExpression $metricFilter
     *           Metric filters allow you to restrict report response to specific metric
     *           values which match the filter. Metric filters are applied after aggregating
     *           the report's rows, similar to SQL having-clause. Dimensions cannot be used
     *           in this filter.
     *     @type int $offset
     *           The row count of the start row. The first row is counted as row 0. If
     *           offset is unspecified, it is treated as 0. If offset is zero, then this
     *           method will return the first page of results with `limit` entries.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type int $limit
     *           The number of rows to return. If unspecified, 10,000 rows are returned. The
     *           API returns a maximum of 100,000 rows per request, no matter how many you
     *           ask for. `limit` must be positive.
     *
     *           The API may return fewer rows than the requested `limit`, if there aren't
     *           as many remaining rows as the `limit`. For instance, there are fewer than
     *           300 possible values for the dimension `country`, so when reporting on only
     *           `country`, you can't get more than 300 rows, even if you set `limit` to a
     *           higher value.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type string $timeZone
     *           This request's time zone if specified. If unspecified, the property's time
     *           zone is used. The request's time zone is used to interpret the start & end
     *           dates of the report.
     *
     *           Formatted as strings from the IANA Time Zone database
     *           (https://www.iana.org/time-zones); for example "America/New_York" or
     *           "Asia/Tokyo".
     *     @type AccessOrderBy[] $orderBys
     *           Specifies how rows are ordered in the response.
     *     @type bool $returnEntityQuota
     *           Toggles whether to return the current state of this Analytics Property's
     *           quota. Quota is returned in [AccessQuota](#AccessQuota). For account-level
     *           requests, this field must be false.
     *     @type bool $includeAllUsers
     *           Optional. Determines whether to include users who have never made an API
     *           call in the response. If true, all users with access to the specified
     *           property or account are included in the response, regardless of whether
     *           they have made an API call or not. If false, only the users who have made
     *           an API call will be included.
     *     @type bool $expandGroups
     *           Optional. Decides whether to return the users within user groups. This
     *           field works only when include_all_users is set to true. If true, it will
     *           return all users with access to the specified property or account.
     *           If false, only the users with direct access will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\RunAccessReportResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function runAccessReport(array $optionalArgs = [])
    {
        $request = new RunAccessReportRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['entity'])) {
            $request->setEntity($optionalArgs['entity']);
            $requestParamHeaders['entity'] = $optionalArgs['entity'];
        }

        if (isset($optionalArgs['dimensions'])) {
            $request->setDimensions($optionalArgs['dimensions']);
        }

        if (isset($optionalArgs['metrics'])) {
            $request->setMetrics($optionalArgs['metrics']);
        }

        if (isset($optionalArgs['dateRanges'])) {
            $request->setDateRanges($optionalArgs['dateRanges']);
        }

        if (isset($optionalArgs['dimensionFilter'])) {
            $request->setDimensionFilter($optionalArgs['dimensionFilter']);
        }

        if (isset($optionalArgs['metricFilter'])) {
            $request->setMetricFilter($optionalArgs['metricFilter']);
        }

        if (isset($optionalArgs['offset'])) {
            $request->setOffset($optionalArgs['offset']);
        }

        if (isset($optionalArgs['limit'])) {
            $request->setLimit($optionalArgs['limit']);
        }

        if (isset($optionalArgs['timeZone'])) {
            $request->setTimeZone($optionalArgs['timeZone']);
        }

        if (isset($optionalArgs['orderBys'])) {
            $request->setOrderBys($optionalArgs['orderBys']);
        }

        if (isset($optionalArgs['returnEntityQuota'])) {
            $request->setReturnEntityQuota($optionalArgs['returnEntityQuota']);
        }

        if (isset($optionalArgs['includeAllUsers'])) {
            $request->setIncludeAllUsers($optionalArgs['includeAllUsers']);
        }

        if (isset($optionalArgs['expandGroups'])) {
            $request->setExpandGroups($optionalArgs['expandGroups']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('RunAccessReport', RunAccessReportResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Searches through all changes to an account or its children given the
     * specified set of filters.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $formattedAccount = $analyticsAdminServiceClient->accountName('[ACCOUNT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsAdminServiceClient->searchChangeHistoryEvents($formattedAccount);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsAdminServiceClient->searchChangeHistoryEvents($formattedAccount);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $account      Required. The account resource for which to return change history
     *                             resources.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $property
     *           Optional. Resource name for a child property. If set, only return changes
     *           made to this property or its child resources.
     *     @type int[] $resourceType
     *           Optional. If set, only return changes if they are for a resource that
     *           matches at least one of these types.
     *           For allowed values, use constants defined on {@see \Google\Analytics\Admin\V1alpha\ChangeHistoryResourceType}
     *     @type int[] $action
     *           Optional. If set, only return changes that match one or more of these types
     *           of actions.
     *           For allowed values, use constants defined on {@see \Google\Analytics\Admin\V1alpha\ActionType}
     *     @type string[] $actorEmail
     *           Optional. If set, only return changes if they are made by a user in this
     *           list.
     *     @type Timestamp $earliestChangeTime
     *           Optional. If set, only return changes made after this time (inclusive).
     *     @type Timestamp $latestChangeTime
     *           Optional. If set, only return changes made before this time (inclusive).
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function searchChangeHistoryEvents($account, array $optionalArgs = [])
    {
        $request = new SearchChangeHistoryEventsRequest();
        $requestParamHeaders = [];
        $request->setAccount($account);
        $requestParamHeaders['account'] = $account;
        if (isset($optionalArgs['property'])) {
            $request->setProperty($optionalArgs['property']);
        }

        if (isset($optionalArgs['resourceType'])) {
            $request->setResourceType($optionalArgs['resourceType']);
        }

        if (isset($optionalArgs['action'])) {
            $request->setAction($optionalArgs['action']);
        }

        if (isset($optionalArgs['actorEmail'])) {
            $request->setActorEmail($optionalArgs['actorEmail']);
        }

        if (isset($optionalArgs['earliestChangeTime'])) {
            $request->setEarliestChangeTime($optionalArgs['earliestChangeTime']);
        }

        if (isset($optionalArgs['latestChangeTime'])) {
            $request->setLatestChangeTime($optionalArgs['latestChangeTime']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('SearchChangeHistoryEvents', $optionalArgs, SearchChangeHistoryEventsResponse::class, $request);
    }

    /**
     * Sets the opt out status for the automated GA4 setup process for a UA
     * property.
     * Note: this has no effect on GA4 property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $property = 'property';
     *     $response = $analyticsAdminServiceClient->setAutomatedGa4ConfigurationOptOut($property);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $property     Required. The UA property to set the opt out status. Note this request uses
     *                             the internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
     *                             Format: properties/{internalWebPropertyId}
     *                             Example: properties/1234
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $optOut
     *           The status to set.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SetAutomatedGa4ConfigurationOptOutResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function setAutomatedGa4ConfigurationOptOut($property, array $optionalArgs = [])
    {
        $request = new SetAutomatedGa4ConfigurationOptOutRequest();
        $request->setProperty($property);
        if (isset($optionalArgs['optOut'])) {
            $request->setOptOut($optionalArgs['optOut']);
        }

        return $this->startCall('SetAutomatedGa4ConfigurationOptOut', SetAutomatedGa4ConfigurationOptOutResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an access binding on an account or property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $accessBinding = new AccessBinding();
     *     $response = $analyticsAdminServiceClient->updateAccessBinding($accessBinding);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param AccessBinding $accessBinding Required. The access binding to update.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AccessBinding
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateAccessBinding($accessBinding, array $optionalArgs = [])
    {
        $request = new UpdateAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setAccessBinding($accessBinding);
        $requestParamHeaders['access_binding.name'] = $accessBinding->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAccessBinding', AccessBinding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an account.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $account = new Account();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateAccount($account, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param Account   $account      Required. The account to update.
     *                                The account's `name` field is used to identify the account.
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Field names must be in snake
     *                                case (for example, "field_to_update"). Omitted fields will not be updated.
     *                                To replace the entire entity, use one path with the string "*" to match all
     *                                fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Account
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateAccount($account, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAccountRequest();
        $requestParamHeaders = [];
        $request->setAccount($account);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['account.name'] = $account->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAccount', Account::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates attribution settings on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $attributionSettings = new AttributionSettings();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateAttributionSettings($attributionSettings, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param AttributionSettings $attributionSettings Required. The attribution settings to update.
     *                                                 The `name` field is used to identify the settings to be updated.
     * @param FieldMask           $updateMask          Required. The list of fields to be updated. Field names must be in snake
     *                                                 case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                                 replace the entire entity, use one path with the string "*" to match all
     *                                                 fields.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\AttributionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateAttributionSettings($attributionSettings, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAttributionSettingsRequest();
        $requestParamHeaders = [];
        $request->setAttributionSettings($attributionSettings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['attribution_settings.name'] = $attributionSettings->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAttributionSettings', AttributionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an Audience on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $audience = new Audience();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateAudience($audience, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param Audience  $audience     Required. The audience to update.
     *                                The audience's `name` field is used to identify the audience to be updated.
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Field names must be in snake
     *                                case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                replace the entire entity, use one path with the string "*" to match all
     *                                fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Audience
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateAudience($audience, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAudienceRequest();
        $requestParamHeaders = [];
        $request->setAudience($audience);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['audience.name'] = $audience->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAudience', Audience::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a ChannelGroup.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $channelGroup = new ChannelGroup();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateChannelGroup($channelGroup, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param ChannelGroup $channelGroup Required. The ChannelGroup to update.
     *                                   The resource's `name` field is used to identify the ChannelGroup to be
     *                                   updated.
     * @param FieldMask    $updateMask   Required. The list of fields to be updated. Field names must be in snake
     *                                   case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                   replace the entire entity, use one path with the string "*" to match all
     *                                   fields.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ChannelGroup
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateChannelGroup($channelGroup, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateChannelGroupRequest();
        $requestParamHeaders = [];
        $request->setChannelGroup($channelGroup);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['channel_group.name'] = $channelGroup->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateChannelGroup', ChannelGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a conversion event with the specified attributes.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $conversionEvent = new ConversionEvent();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateConversionEvent($conversionEvent, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param ConversionEvent $conversionEvent Required. The conversion event to update.
     *                                         The `name` field is used to identify the settings to be updated.
     * @param FieldMask       $updateMask      Required. The list of fields to be updated. Field names must be in snake
     *                                         case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                         replace the entire entity, use one path with the string "*" to match all
     *                                         fields.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ConversionEvent
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateConversionEvent($conversionEvent, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateConversionEventRequest();
        $requestParamHeaders = [];
        $request->setConversionEvent($conversionEvent);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['conversion_event.name'] = $conversionEvent->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateConversionEvent', ConversionEvent::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a CustomDimension on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateCustomDimension($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Omitted fields will not be
     *                                updated. To replace the entire entity, use one path with the string "*" to
     *                                match all fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type CustomDimension $customDimension
     *           The CustomDimension to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomDimension
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateCustomDimension($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateCustomDimensionRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['customDimension'])) {
            $request->setCustomDimension($optionalArgs['customDimension']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCustomDimension', CustomDimension::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a CustomMetric on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateCustomMetric($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Omitted fields will not be
     *                                updated. To replace the entire entity, use one path with the string "*" to
     *                                match all fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type CustomMetric $customMetric
     *           The CustomMetric to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\CustomMetric
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateCustomMetric($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateCustomMetricRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['customMetric'])) {
            $request->setCustomMetric($optionalArgs['customMetric']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCustomMetric', CustomMetric::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a DataRedactionSettings on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $dataRedactionSettings = new DataRedactionSettings();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateDataRedactionSettings($dataRedactionSettings, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param DataRedactionSettings $dataRedactionSettings Required. The settings to update.
     *                                                     The `name` field is used to identify the settings to be updated.
     * @param FieldMask             $updateMask            Required. The list of fields to be updated. Field names must be in snake
     *                                                     case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                                     replace the entire entity, use one path with the string "*" to match all
     *                                                     fields.
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataRedactionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateDataRedactionSettings($dataRedactionSettings, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateDataRedactionSettingsRequest();
        $requestParamHeaders = [];
        $request->setDataRedactionSettings($dataRedactionSettings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['data_redaction_settings.name'] = $dataRedactionSettings->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateDataRedactionSettings', DataRedactionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the singleton data retention settings for this property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $dataRetentionSettings = new DataRetentionSettings();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateDataRetentionSettings($dataRetentionSettings, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param DataRetentionSettings $dataRetentionSettings Required. The settings to update.
     *                                                     The `name` field is used to identify the settings to be updated.
     * @param FieldMask             $updateMask            Required. The list of fields to be updated. Field names must be in snake
     *                                                     case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                                     replace the entire entity, use one path with the string "*" to match all
     *                                                     fields.
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataRetentionSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateDataRetentionSettings($dataRetentionSettings, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateDataRetentionSettingsRequest();
        $requestParamHeaders = [];
        $request->setDataRetentionSettings($dataRetentionSettings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['data_retention_settings.name'] = $dataRetentionSettings->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateDataRetentionSettings', DataRetentionSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a DataStream on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateDataStream($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Omitted fields will not be
     *                                updated. To replace the entire entity, use one path with the string "*" to
     *                                match all fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type DataStream $dataStream
     *           The DataStream to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DataStream
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateDataStream($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateDataStreamRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['dataStream'])) {
            $request->setDataStream($optionalArgs['dataStream']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateDataStream', DataStream::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a DisplayVideo360AdvertiserLink on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateDisplayVideo360AdvertiserLink($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Omitted fields will not be
     *                                updated. To replace the entire entity, use one path with the string "*" to
     *                                match all fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type DisplayVideo360AdvertiserLink $displayVideo360AdvertiserLink
     *           The DisplayVideo360AdvertiserLink to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateDisplayVideo360AdvertiserLink($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateDisplayVideo360AdvertiserLinkRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['displayVideo360AdvertiserLink'])) {
            $request->setDisplayVideo360AdvertiserLink($optionalArgs['displayVideo360AdvertiserLink']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateDisplayVideo360AdvertiserLink', DisplayVideo360AdvertiserLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the enhanced measurement settings for this data stream.
     * Note that the stream must enable enhanced measurement for these settings to
     * take effect.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $enhancedMeasurementSettings = new EnhancedMeasurementSettings();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateEnhancedMeasurementSettings($enhancedMeasurementSettings, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param EnhancedMeasurementSettings $enhancedMeasurementSettings Required. The settings to update.
     *                                                                 The `name` field is used to identify the settings to be updated.
     * @param FieldMask                   $updateMask                  Required. The list of fields to be updated. Field names must be in snake
     *                                                                 case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                                                 replace the entire entity, use one path with the string "*" to match all
     *                                                                 fields.
     * @param array                       $optionalArgs                {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\EnhancedMeasurementSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateEnhancedMeasurementSettings($enhancedMeasurementSettings, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateEnhancedMeasurementSettingsRequest();
        $requestParamHeaders = [];
        $request->setEnhancedMeasurementSettings($enhancedMeasurementSettings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['enhanced_measurement_settings.name'] = $enhancedMeasurementSettings->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEnhancedMeasurementSettings', EnhancedMeasurementSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an EventCreateRule.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $eventCreateRule = new EventCreateRule();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateEventCreateRule($eventCreateRule, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param EventCreateRule $eventCreateRule Required. The EventCreateRule to update.
     *                                         The resource's `name` field is used to identify the EventCreateRule to be
     *                                         updated.
     * @param FieldMask       $updateMask      Required. The list of fields to be updated. Field names must be in snake
     *                                         case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                         replace the entire entity, use one path with the string "*" to match all
     *                                         fields.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\EventCreateRule
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateEventCreateRule($eventCreateRule, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateEventCreateRuleRequest();
        $requestParamHeaders = [];
        $request->setEventCreateRule($eventCreateRule);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['event_create_rule.name'] = $eventCreateRule->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEventCreateRule', EventCreateRule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a ExpandedDataSet on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $expandedDataSet = new ExpandedDataSet();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateExpandedDataSet($expandedDataSet, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param ExpandedDataSet $expandedDataSet Required. The ExpandedDataSet to update.
     *                                         The resource's `name` field is used to identify the ExpandedDataSet to be
     *                                         updated.
     * @param FieldMask       $updateMask      Required. The list of fields to be updated. Field names must be in snake
     *                                         case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                         replace the entire entity, use one path with the string "*" to match all
     *                                         fields.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\ExpandedDataSet
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateExpandedDataSet($expandedDataSet, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateExpandedDataSetRequest();
        $requestParamHeaders = [];
        $request->setExpandedDataSet($expandedDataSet);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['expanded_data_set.name'] = $expandedDataSet->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateExpandedDataSet', ExpandedDataSet::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a GoogleAdsLink on a property
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateGoogleAdsLink($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Field names must be in snake
     *                                case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                replace the entire entity, use one path with the string "*" to match all
     *                                fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type GoogleAdsLink $googleAdsLink
     *           The GoogleAdsLink to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\GoogleAdsLink
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateGoogleAdsLink($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateGoogleAdsLinkRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['googleAdsLink'])) {
            $request->setGoogleAdsLink($optionalArgs['googleAdsLink']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateGoogleAdsLink', GoogleAdsLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates Google Signals settings for a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $googleSignalsSettings = new GoogleSignalsSettings();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateGoogleSignalsSettings($googleSignalsSettings, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param GoogleSignalsSettings $googleSignalsSettings Required. The settings to update.
     *                                                     The `name` field is used to identify the settings to be updated.
     * @param FieldMask             $updateMask            Required. The list of fields to be updated. Field names must be in snake
     *                                                     case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                                     replace the entire entity, use one path with the string "*" to match all
     *                                                     fields.
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\GoogleSignalsSettings
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateGoogleSignalsSettings($googleSignalsSettings, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateGoogleSignalsSettingsRequest();
        $requestParamHeaders = [];
        $request->setGoogleSignalsSettings($googleSignalsSettings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['google_signals_settings.name'] = $googleSignalsSettings->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateGoogleSignalsSettings', GoogleSignalsSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a measurement protocol secret.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $measurementProtocolSecret = new MeasurementProtocolSecret();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateMeasurementProtocolSecret($measurementProtocolSecret, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param MeasurementProtocolSecret $measurementProtocolSecret Required. The measurement protocol secret to update.
     * @param FieldMask                 $updateMask                Required. The list of fields to be updated. Omitted fields will not be
     *                                                             updated.
     * @param array                     $optionalArgs              {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\MeasurementProtocolSecret
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateMeasurementProtocolSecret($measurementProtocolSecret, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateMeasurementProtocolSecretRequest();
        $requestParamHeaders = [];
        $request->setMeasurementProtocolSecret($measurementProtocolSecret);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['measurement_protocol_secret.name'] = $measurementProtocolSecret->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateMeasurementProtocolSecret', MeasurementProtocolSecret::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $property = new Property();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateProperty($property, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param Property  $property     Required. The property to update.
     *                                The property's `name` field is used to identify the property to be
     *                                updated.
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Field names must be in snake
     *                                case (e.g., "field_to_update"). Omitted fields will not be updated. To
     *                                replace the entire entity, use one path with the string "*" to match all
     *                                fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\Property
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateProperty($property, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdatePropertyRequest();
        $requestParamHeaders = [];
        $request->setProperty($property);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['property.name'] = $property->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateProperty', Property::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a SKAdNetworkConversionValueSchema.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $skadnetworkConversionValueSchema = new SKAdNetworkConversionValueSchema();
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateSKAdNetworkConversionValueSchema($skadnetworkConversionValueSchema, $updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param SKAdNetworkConversionValueSchema $skadnetworkConversionValueSchema Required. SKAdNetwork conversion value schema to update.
     * @param FieldMask                        $updateMask                       Required. The list of fields to be updated. Omitted fields will not be
     *                                                                           updated.
     * @param array                            $optionalArgs                     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SKAdNetworkConversionValueSchema
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateSKAdNetworkConversionValueSchema($skadnetworkConversionValueSchema, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateSKAdNetworkConversionValueSchemaRequest();
        $requestParamHeaders = [];
        $request->setSkadnetworkConversionValueSchema($skadnetworkConversionValueSchema);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['skadnetwork_conversion_value_schema.name'] = $skadnetworkConversionValueSchema->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSKAdNetworkConversionValueSchema', SKAdNetworkConversionValueSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a SearchAds360Link on a property.
     *
     * Sample code:
     * ```
     * $analyticsAdminServiceClient = new AnalyticsAdminServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $response = $analyticsAdminServiceClient->updateSearchAds360Link($updateMask);
     * } finally {
     *     $analyticsAdminServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. The list of fields to be updated. Omitted fields will not be
     *                                updated. To replace the entire entity, use one path with the string "*" to
     *                                match all fields.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type SearchAds360Link $searchAds360Link
     *           The SearchAds360Link to update
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Admin\V1alpha\SearchAds360Link
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateSearchAds360Link($updateMask, array $optionalArgs = [])
    {
        $request = new UpdateSearchAds360LinkRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        if (isset($optionalArgs['searchAds360Link'])) {
            $request->setSearchAds360Link($optionalArgs['searchAds360Link']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSearchAds360Link', SearchAds360Link::class, $optionalArgs, $request)->wait();
    }
}
