<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/model_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchImportEvaluatedAnnotationsRequest;
use Google\Cloud\AIPlatform\V1\BatchImportEvaluatedAnnotationsResponse;
use Google\Cloud\AIPlatform\V1\BatchImportModelEvaluationSlicesRequest;
use Google\Cloud\AIPlatform\V1\BatchImportModelEvaluationSlicesResponse;
use Google\Cloud\AIPlatform\V1\CopyModelRequest;
use Google\Cloud\AIPlatform\V1\DeleteModelRequest;
use Google\Cloud\AIPlatform\V1\DeleteModelVersionRequest;
use Google\Cloud\AIPlatform\V1\EncryptionSpec;
use Google\Cloud\AIPlatform\V1\EvaluatedAnnotation;
use Google\Cloud\AIPlatform\V1\Examples;
use Google\Cloud\AIPlatform\V1\ExportModelRequest;
use Google\Cloud\AIPlatform\V1\ExportModelRequest\OutputConfig;
use Google\Cloud\AIPlatform\V1\GetModelEvaluationRequest;
use Google\Cloud\AIPlatform\V1\GetModelEvaluationSliceRequest;
use Google\Cloud\AIPlatform\V1\GetModelRequest;
use Google\Cloud\AIPlatform\V1\ImportModelEvaluationRequest;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationSlicesRequest;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationSlicesResponse;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationsRequest;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationsResponse;
use Google\Cloud\AIPlatform\V1\ListModelVersionsRequest;
use Google\Cloud\AIPlatform\V1\ListModelVersionsResponse;
use Google\Cloud\AIPlatform\V1\ListModelsRequest;
use Google\Cloud\AIPlatform\V1\ListModelsResponse;
use Google\Cloud\AIPlatform\V1\MergeVersionAliasesRequest;
use Google\Cloud\AIPlatform\V1\Model;
use Google\Cloud\AIPlatform\V1\ModelEvaluation;
use Google\Cloud\AIPlatform\V1\ModelEvaluationSlice;
use Google\Cloud\AIPlatform\V1\UpdateExplanationDatasetRequest;
use Google\Cloud\AIPlatform\V1\UpdateModelRequest;
use Google\Cloud\AIPlatform\V1\UploadModelRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: A service for managing Vertex AI's machine learning Models.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $modelServiceClient = new ModelServiceClient();
 * try {
 *     $formattedParent = $modelServiceClient->modelEvaluationSliceName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]', '[SLICE]');
 *     $evaluatedAnnotations = [];
 *     $response = $modelServiceClient->batchImportEvaluatedAnnotations($formattedParent, $evaluatedAnnotations);
 * } finally {
 *     $modelServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\AIPlatform\V1\Client\ModelServiceClient} to use the new surface.
 */
class ModelServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.ModelService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $endpointNameTemplate;

    private static $locationNameTemplate;

    private static $modelNameTemplate;

    private static $modelEvaluationNameTemplate;

    private static $modelEvaluationSliceNameTemplate;

    private static $pipelineJobNameTemplate;

    private static $projectLocationEndpointNameTemplate;

    private static $projectLocationPublisherModelNameTemplate;

    private static $trainingPipelineNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/model_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/model_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/model_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/model_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEndpointNameTemplate()
    {
        if (self::$endpointNameTemplate == null) {
            self::$endpointNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/endpoints/{endpoint}'
            );
        }

        return self::$endpointNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getModelNameTemplate()
    {
        if (self::$modelNameTemplate == null) {
            self::$modelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/models/{model}'
            );
        }

        return self::$modelNameTemplate;
    }

    private static function getModelEvaluationNameTemplate()
    {
        if (self::$modelEvaluationNameTemplate == null) {
            self::$modelEvaluationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}'
            );
        }

        return self::$modelEvaluationNameTemplate;
    }

    private static function getModelEvaluationSliceNameTemplate()
    {
        if (self::$modelEvaluationSliceNameTemplate == null) {
            self::$modelEvaluationSliceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}'
            );
        }

        return self::$modelEvaluationSliceNameTemplate;
    }

    private static function getPipelineJobNameTemplate()
    {
        if (self::$pipelineJobNameTemplate == null) {
            self::$pipelineJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}'
            );
        }

        return self::$pipelineJobNameTemplate;
    }

    private static function getProjectLocationEndpointNameTemplate()
    {
        if (self::$projectLocationEndpointNameTemplate == null) {
            self::$projectLocationEndpointNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/endpoints/{endpoint}'
            );
        }

        return self::$projectLocationEndpointNameTemplate;
    }

    private static function getProjectLocationPublisherModelNameTemplate()
    {
        if (self::$projectLocationPublisherModelNameTemplate == null) {
            self::$projectLocationPublisherModelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/publishers/{publisher}/models/{model}'
            );
        }

        return self::$projectLocationPublisherModelNameTemplate;
    }

    private static function getTrainingPipelineNameTemplate()
    {
        if (self::$trainingPipelineNameTemplate == null) {
            self::$trainingPipelineNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}'
            );
        }

        return self::$trainingPipelineNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'endpoint' => self::getEndpointNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'model' => self::getModelNameTemplate(),
                'modelEvaluation' => self::getModelEvaluationNameTemplate(),
                'modelEvaluationSlice' => self::getModelEvaluationSliceNameTemplate(),
                'pipelineJob' => self::getPipelineJobNameTemplate(),
                'projectLocationEndpoint' => self::getProjectLocationEndpointNameTemplate(),
                'projectLocationPublisherModel' => self::getProjectLocationPublisherModelNameTemplate(),
                'trainingPipeline' => self::getTrainingPipelineNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a endpoint
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted endpoint resource.
     */
    public static function endpointName($project, $location, $endpoint)
    {
        return self::getEndpointNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     *
     * @return string The formatted model resource.
     */
    public static function modelName($project, $location, $model)
    {
        return self::getModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_evaluation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     * @param string $evaluation
     *
     * @return string The formatted model_evaluation resource.
     */
    public static function modelEvaluationName(
        $project,
        $location,
        $model,
        $evaluation
    ) {
        return self::getModelEvaluationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_evaluation_slice resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     * @param string $evaluation
     * @param string $slice
     *
     * @return string The formatted model_evaluation_slice resource.
     */
    public static function modelEvaluationSliceName(
        $project,
        $location,
        $model,
        $evaluation,
        $slice
    ) {
        return self::getModelEvaluationSliceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
            'evaluation' => $evaluation,
            'slice' => $slice,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pipeline_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pipelineJob
     *
     * @return string The formatted pipeline_job resource.
     */
    public static function pipelineJobName($project, $location, $pipelineJob)
    {
        return self::getPipelineJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'pipeline_job' => $pipelineJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_endpoint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted project_location_endpoint resource.
     */
    public static function projectLocationEndpointName(
        $project,
        $location,
        $endpoint
    ) {
        return self::getProjectLocationEndpointNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_publisher_model resource.
     *
     * @param string $project
     * @param string $location
     * @param string $publisher
     * @param string $model
     *
     * @return string The formatted project_location_publisher_model resource.
     */
    public static function projectLocationPublisherModelName(
        $project,
        $location,
        $publisher,
        $model
    ) {
        return self::getProjectLocationPublisherModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'publisher' => $publisher,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * training_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trainingPipeline
     *
     * @return string The formatted training_pipeline resource.
     */
    public static function trainingPipelineName(
        $project,
        $location,
        $trainingPipeline
    ) {
        return self::getTrainingPipelineNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'training_pipeline' => $trainingPipeline,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - endpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - location: projects/{project}/locations/{location}
     * - model: projects/{project}/locations/{location}/models/{model}
     * - modelEvaluation: projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
     * - modelEvaluationSlice: projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}
     * - pipelineJob: projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}
     * - projectLocationEndpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - projectLocationPublisherModel: projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * - trainingPipeline: projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Imports a list of externally generated EvaluatedAnnotations.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->modelEvaluationSliceName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]', '[SLICE]');
     *     $evaluatedAnnotations = [];
     *     $response = $modelServiceClient->batchImportEvaluatedAnnotations($formattedParent, $evaluatedAnnotations);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string                $parent               Required. The name of the parent ModelEvaluationSlice resource.
     *                                                    Format:
     *                                                    `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
     * @param EvaluatedAnnotation[] $evaluatedAnnotations Required. Evaluated annotations resource to be imported.
     * @param array                 $optionalArgs         {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\BatchImportEvaluatedAnnotationsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchImportEvaluatedAnnotations(
        $parent,
        $evaluatedAnnotations,
        array $optionalArgs = []
    ) {
        $request = new BatchImportEvaluatedAnnotationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEvaluatedAnnotations($evaluatedAnnotations);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchImportEvaluatedAnnotations',
            BatchImportEvaluatedAnnotationsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Imports a list of externally generated ModelEvaluationSlice.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->modelEvaluationName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]');
     *     $modelEvaluationSlices = [];
     *     $response = $modelServiceClient->batchImportModelEvaluationSlices($formattedParent, $modelEvaluationSlices);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string                 $parent                Required. The name of the parent ModelEvaluation resource.
     *                                                      Format:
     *                                                      `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
     * @param ModelEvaluationSlice[] $modelEvaluationSlices Required. Model evaluation slice resource to be imported.
     * @param array                  $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\BatchImportModelEvaluationSlicesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchImportModelEvaluationSlices(
        $parent,
        $modelEvaluationSlices,
        array $optionalArgs = []
    ) {
        $request = new BatchImportModelEvaluationSlicesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setModelEvaluationSlices($modelEvaluationSlices);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchImportModelEvaluationSlices',
            BatchImportModelEvaluationSlicesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Copies an already existing Vertex AI Model into the specified Location.
     * The source Model must exist in the same Project.
     * When copying custom Models, the users themselves are responsible for
     * [Model.metadata][google.cloud.aiplatform.v1.Model.metadata] content to be
     * region-agnostic, as well as making sure that any resources (e.g. files) it
     * depends on remain accessible.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $formattedSourceModel = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $operationResponse = $modelServiceClient->copyModel($formattedParent, $formattedSourceModel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->copyModel($formattedParent, $formattedSourceModel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'copyModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location into which to copy the Model.
     *                             Format: `projects/{project}/locations/{location}`
     * @param string $sourceModel  Required. The resource name of the Model to copy. That Model must be in the
     *                             same Project. Format:
     *                             `projects/{project}/locations/{location}/models/{model}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $modelId
     *           Optional. Copy source_model into a new Model with this ID. The ID will
     *           become the final component of the model resource name.
     *
     *           This value may be up to 63 characters, and valid characters are
     *           `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     *     @type string $parentModel
     *           Optional. Specify this field to copy source_model into this existing
     *           Model as a new version. Format:
     *           `projects/{project}/locations/{location}/models/{model}`
     *     @type EncryptionSpec $encryptionSpec
     *           Customer-managed encryption key options. If this is set,
     *           then the Model copy will be encrypted with the provided encryption key.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function copyModel($parent, $sourceModel, array $optionalArgs = [])
    {
        $request = new CopyModelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSourceModel($sourceModel);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['modelId'])) {
            $request->setModelId($optionalArgs['modelId']);
        }

        if (isset($optionalArgs['parentModel'])) {
            $request->setParentModel($optionalArgs['parentModel']);
        }

        if (isset($optionalArgs['encryptionSpec'])) {
            $request->setEncryptionSpec($optionalArgs['encryptionSpec']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CopyModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a Model.
     *
     * A model cannot be deleted if any
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] resource has a
     * [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] based on the
     * model in its
     * [deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * field.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $operationResponse = $modelServiceClient->deleteModel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->deleteModel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'deleteModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Model resource to be deleted.
     *                             Format: `projects/{project}/locations/{location}/models/{model}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteModel($name, array $optionalArgs = [])
    {
        $request = new DeleteModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a Model version.
     *
     * Model version can only be deleted if there are no
     * [DeployedModels][google.cloud.aiplatform.v1.DeployedModel] created from it.
     * Deleting the only version in the Model is not allowed. Use
     * [DeleteModel][google.cloud.aiplatform.v1.ModelService.DeleteModel] for
     * deleting the Model instead.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $operationResponse = $modelServiceClient->deleteModelVersion($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->deleteModelVersion($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'deleteModelVersion');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the model version to be deleted, with a version ID
     *                             explicitly included.
     *
     *                             Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteModelVersion($name, array $optionalArgs = [])
    {
        $request = new DeleteModelVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteModelVersion',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Exports a trained, exportable Model to a location specified by the
     * user. A Model is considered to be exportable if it has at least one
     * [supported export
     * format][google.cloud.aiplatform.v1.Model.supported_export_formats].
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $outputConfig = new OutputConfig();
     *     $operationResponse = $modelServiceClient->exportModel($formattedName, $outputConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->exportModel($formattedName, $outputConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'exportModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string       $name         Required. The resource name of the Model to export.
     *                                   The resource name may contain version id or version alias to specify the
     *                                   version, if no version is specified, the default version will be exported.
     * @param OutputConfig $outputConfig Required. The desired output location and configuration.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportModel($name, $outputConfig, array $optionalArgs = [])
    {
        $request = new ExportModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setOutputConfig($outputConfig);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ExportModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets a Model.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $response = $modelServiceClient->getModel($formattedName);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Model resource.
     *                             Format: `projects/{project}/locations/{location}/models/{model}`
     *
     *                             In order to retrieve a specific version of the model, also provide
     *                             the version ID or version alias.
     *                             Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *                             or
     *                             `projects/{project}/locations/{location}/models/{model}&#64;golden`
     *                             If no version ID or alias is specified, the "default" version will be
     *                             returned. The "default" version alias is created for the first version of
     *                             the model, and can be moved to other versions later on. There will be
     *                             exactly one default version.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Model
     *
     * @throws ApiException if the remote call fails
     */
    public function getModel($name, array $optionalArgs = [])
    {
        $request = new GetModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetModel',
            Model::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a ModelEvaluation.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelEvaluationName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]');
     *     $response = $modelServiceClient->getModelEvaluation($formattedName);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the ModelEvaluation resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ModelEvaluation
     *
     * @throws ApiException if the remote call fails
     */
    public function getModelEvaluation($name, array $optionalArgs = [])
    {
        $request = new GetModelEvaluationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetModelEvaluation',
            ModelEvaluation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a ModelEvaluationSlice.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelEvaluationSliceName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]', '[SLICE]');
     *     $response = $modelServiceClient->getModelEvaluationSlice($formattedName);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the ModelEvaluationSlice resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ModelEvaluationSlice
     *
     * @throws ApiException if the remote call fails
     */
    public function getModelEvaluationSlice($name, array $optionalArgs = [])
    {
        $request = new GetModelEvaluationSliceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetModelEvaluationSlice',
            ModelEvaluationSlice::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Imports an externally generated ModelEvaluation.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $modelEvaluation = new ModelEvaluation();
     *     $response = $modelServiceClient->importModelEvaluation($formattedParent, $modelEvaluation);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. The name of the parent model resource.
     *                                         Format: `projects/{project}/locations/{location}/models/{model}`
     * @param ModelEvaluation $modelEvaluation Required. Model evaluation resource to be imported.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ModelEvaluation
     *
     * @throws ApiException if the remote call fails
     */
    public function importModelEvaluation(
        $parent,
        $modelEvaluation,
        array $optionalArgs = []
    ) {
        $request = new ImportModelEvaluationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setModelEvaluation($modelEvaluation);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ImportModelEvaluation',
            ModelEvaluation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists ModelEvaluationSlices in a ModelEvaluation.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->modelEvaluationName('[PROJECT]', '[LOCATION]', '[MODEL]', '[EVALUATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $modelServiceClient->listModelEvaluationSlices($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $modelServiceClient->listModelEvaluationSlices($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the ModelEvaluation to list the
     *                             ModelEvaluationSlices from. Format:
     *                             `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The standard list filter.
     *
     *           * `slice.dimension` - for =.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listModelEvaluationSlices($parent, array $optionalArgs = [])
    {
        $request = new ListModelEvaluationSlicesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListModelEvaluationSlices',
            $optionalArgs,
            ListModelEvaluationSlicesResponse::class,
            $request
        );
    }

    /**
     * Lists ModelEvaluations in a Model.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $modelServiceClient->listModelEvaluations($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $modelServiceClient->listModelEvaluations($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Model to list the ModelEvaluations from.
     *                             Format: `projects/{project}/locations/{location}/models/{model}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listModelEvaluations($parent, array $optionalArgs = [])
    {
        $request = new ListModelEvaluationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListModelEvaluations',
            $optionalArgs,
            ListModelEvaluationsResponse::class,
            $request
        );
    }

    /**
     * Lists versions of the specified model.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $modelServiceClient->listModelVersions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $modelServiceClient->listModelVersions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the model to list versions for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression for filtering the results of the request. For field names
     *           both snake_case and camelCase are supported.
     *
     *           * `labels` supports general map functions that is:
     *           * `labels.key=value` - key:value equality
     *           * `labels.key:* or labels:key - key existence
     *           * A key including a space must be quoted. `labels."a key"`.
     *
     *           Some examples:
     *
     *           * `labels.myKey="myValue"`
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported fields:
     *
     *           * `create_time`
     *           * `update_time`
     *
     *           Example: `update_time asc, create_time desc`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listModelVersions($name, array $optionalArgs = [])
    {
        $request = new ListModelVersionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListModelVersions',
            $optionalArgs,
            ListModelVersionsResponse::class,
            $request
        );
    }

    /**
     * Lists Models in a Location.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $modelServiceClient->listModels($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $modelServiceClient->listModels($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list the Models from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           An expression for filtering the results of the request. For field names
     *           both snake_case and camelCase are supported.
     *
     *           * `model` supports = and !=. `model` represents the Model ID,
     *           i.e. the last segment of the Model's [resource
     *           name][google.cloud.aiplatform.v1.Model.name].
     *           * `display_name` supports = and !=
     *           * `labels` supports general map functions that is:
     *           * `labels.key=value` - key:value equality
     *           * `labels.key:* or labels:key - key existence
     *           * A key including a space must be quoted. `labels."a key"`.
     *
     *           Some examples:
     *
     *           * `model=1234`
     *           * `displayName="myDisplayName"`
     *           * `labels.myKey="myValue"`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported fields:
     *
     *           * `display_name`
     *           * `create_time`
     *           * `update_time`
     *
     *           Example: `display_name, create_time desc`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listModels($parent, array $optionalArgs = [])
    {
        $request = new ListModelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListModels',
            $optionalArgs,
            ListModelsResponse::class,
            $request
        );
    }

    /**
     * Merges a set of aliases for a Model version.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedName = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $versionAliases = [];
     *     $response = $modelServiceClient->mergeVersionAliases($formattedName, $versionAliases);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string   $name           Required. The name of the model version to merge aliases, with a version ID
     *                                 explicitly included.
     *
     *                                 Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * @param string[] $versionAliases Required. The set of version aliases to merge.
     *                                 The alias should be at most 128 characters, and match
     *                                 `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     *                                 Add the `-` prefix to an alias means removing that alias from the version.
     *                                 `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     *                                 the `golden` alias from the version.
     *
     *                                 There is NO ordering in aliases, which means
     *                                 1) The aliases returned from GetModel API might not have the exactly same
     *                                 order from this MergeVersionAliases API. 2) Adding and deleting the same
     *                                 alias in the request is not recommended, and the 2 operations will be
     *                                 cancelled out.
     * @param array    $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Model
     *
     * @throws ApiException if the remote call fails
     */
    public function mergeVersionAliases(
        $name,
        $versionAliases,
        array $optionalArgs = []
    ) {
        $request = new MergeVersionAliasesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setVersionAliases($versionAliases);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'MergeVersionAliases',
            Model::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Incrementally update the dataset used for an examples model.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedModel = $modelServiceClient->modelName('[PROJECT]', '[LOCATION]', '[MODEL]');
     *     $operationResponse = $modelServiceClient->updateExplanationDataset($formattedModel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->updateExplanationDataset($formattedModel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'updateExplanationDataset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $model        Required. The resource name of the Model to update.
     *                             Format: `projects/{project}/locations/{location}/models/{model}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Examples $examples
     *           The example config containing the location of the dataset.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExplanationDataset($model, array $optionalArgs = [])
    {
        $request = new UpdateExplanationDatasetRequest();
        $requestParamHeaders = [];
        $request->setModel($model);
        $requestParamHeaders['model'] = $model;
        if (isset($optionalArgs['examples'])) {
            $request->setExamples($optionalArgs['examples']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateExplanationDataset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a Model.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $model = new Model();
     *     $updateMask = new FieldMask();
     *     $response = $modelServiceClient->updateModel($model, $updateMask);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param Model     $model        Required. The Model which replaces the resource on the server.
     *                                When Model Versioning is enabled, the model.name will be used to determine
     *                                whether to update the model or model version.
     *                                1. model.name with the &#64; value, e.g. models/123&#64;1, refers to a version
     *                                specific update.
     *                                2. model.name without the &#64; value, e.g. models/123, refers to a model
     *                                update.
     *                                3. model.name with &#64;-, e.g. models/123&#64;-, refers to a model update.
     *                                4. Supported model fields: display_name, description; supported
     *                                version-specific fields: version_description. Labels are supported in both
     *                                scenarios. Both the model labels and the version labels are merged when a
     *                                model is returned. When updating labels, if the request is for
     *                                model-specific update, model label gets updated. Otherwise, version labels
     *                                get updated.
     *                                5. A model name or model version name fields update mismatch will cause a
     *                                precondition error.
     *                                6. One request cannot update both the model and the version fields. You
     *                                must update them separately.
     * @param FieldMask $updateMask   Required. The update mask applies to the resource.
     *                                For the `FieldMask` definition, see
     *                                [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Model
     *
     * @throws ApiException if the remote call fails
     */
    public function updateModel($model, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateModelRequest();
        $requestParamHeaders = [];
        $request->setModel($model);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['model.name'] = $model->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateModel',
            Model::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Uploads a Model artifact into Vertex AI.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $formattedParent = $modelServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $model = new Model();
     *     $operationResponse = $modelServiceClient->uploadModel($formattedParent, $model);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $modelServiceClient->uploadModel($formattedParent, $model);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $modelServiceClient->resumeOperation($operationName, 'uploadModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location into which to upload the Model.
     *                             Format: `projects/{project}/locations/{location}`
     * @param Model  $model        Required. The Model to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $parentModel
     *           Optional. The resource name of the model into which to upload the version.
     *           Only specify this field when uploading a new version.
     *     @type string $modelId
     *           Optional. The ID to use for the uploaded Model, which will become the final
     *           component of the model resource name.
     *
     *           This value may be up to 63 characters, and valid characters are
     *           `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     *     @type string $serviceAccount
     *           Optional. The user-provided custom service account to use to do the model
     *           upload. If empty, [Vertex AI Service
     *           Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     *           will be used. Users uploading the Model must have the
     *           `iam.serviceAccounts.actAs` permission on this service account. Also, this
     *           account must belong to the project specified in the `parent` field and have
     *           all necessary read permissions.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function uploadModel($parent, $model, array $optionalArgs = [])
    {
        $request = new UploadModelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setModel($model);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['parentModel'])) {
            $request->setParentModel($optionalArgs['parentModel']);
        }

        if (isset($optionalArgs['modelId'])) {
            $request->setModelId($optionalArgs['modelId']);
        }

        if (isset($optionalArgs['serviceAccount'])) {
            $request->setServiceAccount($optionalArgs['serviceAccount']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UploadModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $response = $modelServiceClient->getLocation();
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $modelServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $modelServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $modelServiceClient->getIamPolicy($resource);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $modelServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $modelServiceClient = new ModelServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $modelServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $modelServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
