<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/profile.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A resource that represents the profile for a job candidate (also referred to
 * as a "single-source profile"). A profile belongs to a [Company][google.cloud.talent.v4beta1.Company], which is
 * the company/organization that owns the profile.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.Profile</code>
 */
class Profile extends \Google\Protobuf\Internal\Message
{
    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/api-test-project/tenants/foo/profiles/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Optional.
     * Profile's id in client system if available.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     */
    private $external_id = '';
    /**
     * Optional.
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     */
    private $source = '';
    /**
     * Optional.
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     */
    private $uri = '';
    /**
     * Optional.
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUI is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     */
    private $group_id = '';
    /**
     * Optional.
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     */
    private $is_hirable = null;
    /**
     * Optional.
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private $create_time = null;
    /**
     * Optional.
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     */
    private $update_time = null;
    /**
     * Optional.
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     */
    private $resume = null;
    /**
     * Optional.
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     */
    private $person_names;
    /**
     * Optional.
     * The candidate's postal addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     */
    private $addresses;
    /**
     * Optional.
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     */
    private $email_addresses;
    /**
     * Optional.
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     */
    private $phone_numbers;
    /**
     * Optional.
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     */
    private $personal_uris;
    /**
     * Optional.
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     */
    private $additional_contact_info;
    /**
     * Optional.
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     */
    private $employment_records;
    /**
     * Optional.
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     */
    private $education_records;
    /**
     * Optional.
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     */
    private $skills;
    /**
     * Optional.
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     */
    private $activities;
    /**
     * Optional.
     * The publications published by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     */
    private $publications;
    /**
     * Optional.
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     */
    private $patents;
    /**
     * Optional.
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     */
    private $certifications;
    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47;</code>
     */
    private $applications;
    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48;</code>
     */
    private $assignments;
    /**
     * Optional.
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     */
    private $custom_attributes;
    /**
     * Output only. Indicates if the profile is fully processed and searchable.
     *
     * Generated from protobuf field <code>bool processed = 27;</code>
     */
    private $processed = false;
    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28;</code>
     */
    private $keyword_snippet = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required during profile update.
     *           Resource name assigned to a profile by the API.
     *           The format is
     *           "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     *           for example, "projects/api-test-project/tenants/foo/profiles/bar".
     *     @type string $external_id
     *           Optional.
     *           Profile's id in client system if available.
     *           The maximum number of bytes allowed is 100.
     *     @type string $source
     *           Optional.
     *           The source description indicating where the profile is acquired.
     *           For example, if a candidate profile is acquired from a resume, the user can
     *           input "resume" here to indicate the source.
     *           The maximum number of bytes allowed is 100.
     *     @type string $uri
     *           Optional.
     *           The URI set by clients that links to this profile's client-side copy.
     *           The maximum number of bytes allowed is 4000.
     *     @type string $group_id
     *           Optional.
     *           The cluster id of the profile to associate with other profile(s) for the
     *           same candidate.
     *           This field should be generated by the customer. If a value is not provided,
     *           a random UUI is assigned to this field of the profile.
     *           This is used to link multiple profiles to the same candidate. For example,
     *           a client has a candidate with two profiles, where one was created recently
     *           and the other one was created 5 years ago. These two profiles may be very
     *           different. The clients can create the first profile and get a generated
     *           [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     *           indicating these two profiles are referring to the same candidate.
     *     @type \Google\Protobuf\BoolValue $is_hirable
     *           Optional.
     *           Indicates the hirable status of the candidate.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Optional.
     *           The timestamp when the profile was first created at this source.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Optional.
     *           The timestamp when the profile was last updated at this source.
     *     @type \Google\Cloud\Talent\V4beta1\Resume $resume
     *           Optional.
     *           The resume representing this profile.
     *     @type \Google\Cloud\Talent\V4beta1\PersonName[]|\Google\Protobuf\Internal\RepeatedField $person_names
     *           Optional.
     *           The names of the candidate this profile references.
     *           Currently only one person name is supported.
     *     @type \Google\Cloud\Talent\V4beta1\Address[]|\Google\Protobuf\Internal\RepeatedField $addresses
     *           Optional.
     *           The candidate's postal addresses.
     *     @type \Google\Cloud\Talent\V4beta1\Email[]|\Google\Protobuf\Internal\RepeatedField $email_addresses
     *           Optional.
     *           The candidate's email addresses.
     *     @type \Google\Cloud\Talent\V4beta1\Phone[]|\Google\Protobuf\Internal\RepeatedField $phone_numbers
     *           Optional.
     *           The candidate's phone number(s).
     *     @type \Google\Cloud\Talent\V4beta1\PersonalUri[]|\Google\Protobuf\Internal\RepeatedField $personal_uris
     *           Optional.
     *           The candidate's personal URIs.
     *     @type \Google\Cloud\Talent\V4beta1\AdditionalContactInfo[]|\Google\Protobuf\Internal\RepeatedField $additional_contact_info
     *           Optional.
     *           Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     *           [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *     @type \Google\Cloud\Talent\V4beta1\EmploymentRecord[]|\Google\Protobuf\Internal\RepeatedField $employment_records
     *           Optional.
     *           The employment history records of the candidate. It's highly recommended
     *           to input this information as accurately as possible to help improve search
     *           quality. Here are some recommendations:
     *           * Specify the start and end dates of the employment records.
     *           * List different employment types separately, no matter how minor the
     *           change is.
     *           For example, only job title is changed from "software engineer" to "senior
     *           software engineer".
     *           * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     *           possible. If not, it's inferred from user inputs.
     *     @type \Google\Cloud\Talent\V4beta1\EducationRecord[]|\Google\Protobuf\Internal\RepeatedField $education_records
     *           Optional.
     *           The education history record of the candidate. It's highly recommended to
     *           input this information as accurately as possible to help improve search
     *           quality. Here are some recommendations:
     *           * Specify the start and end dates of the education records.
     *           * List each education type separately, no matter how minor the change is.
     *           For example, the profile contains the education experience from the same
     *           school but different degrees.
     *           * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     *           possible. If not, it's inferred from user inputs.
     *     @type \Google\Cloud\Talent\V4beta1\Skill[]|\Google\Protobuf\Internal\RepeatedField $skills
     *           Optional.
     *           The skill set of the candidate. It's highly recommended to provide as
     *           much information as possible to help improve the search quality.
     *     @type \Google\Cloud\Talent\V4beta1\Activity[]|\Google\Protobuf\Internal\RepeatedField $activities
     *           Optional.
     *           The individual or collaborative activities which the candidate has
     *           participated in, for example, open-source projects, class assignments that
     *           aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     *     @type \Google\Cloud\Talent\V4beta1\Publication[]|\Google\Protobuf\Internal\RepeatedField $publications
     *           Optional.
     *           The publications published by the candidate.
     *     @type \Google\Cloud\Talent\V4beta1\Patent[]|\Google\Protobuf\Internal\RepeatedField $patents
     *           Optional.
     *           The patents acquired by the candidate.
     *     @type \Google\Cloud\Talent\V4beta1\Certification[]|\Google\Protobuf\Internal\RepeatedField $certifications
     *           Optional.
     *           The certifications acquired by the candidate.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $applications
     *           Output only. The resource names of the candidate's applications.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $assignments
     *           Output only. The resource names of the candidate's assignments.
     *     @type array|\Google\Protobuf\Internal\MapField $custom_attributes
     *           Optional.
     *           A map of fields to hold both filterable and non-filterable custom profile
     *           attributes that aren't covered by the provided structured fields. See
     *           [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     *           At most 100 filterable and at most 100 unfilterable keys are supported. If
     *           limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     *           by default. These are filterable when the `filterable` flag is set to
     *           `true`.
     *           Numeric custom attributes: each key can only map to one numeric value,
     *           otherwise an error is thrown. Client can also filter on numeric custom
     *           attributes using '>', '<' or '=' operators.
     *           String custom attributes: each key can map up to 50 string values. For
     *           filterable string value, each value has a byte size of no more than 256B.
     *           For unfilterable string values, the maximum byte size of a single key is
     *           64B. An error is thrown for any request exceeding the limit.
     *           The maximum total byte size is 10KB.
     *     @type bool $processed
     *           Output only. Indicates if the profile is fully processed and searchable.
     *     @type string $keyword_snippet
     *           Output only. Keyword snippet shows how the search result is related to a
     *           search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\Profile::initOnce();
        parent::__construct($data);
    }

    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/api-test-project/tenants/foo/profiles/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/api-test-project/tenants/foo/profiles/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional.
     * Profile's id in client system if available.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     * @return string
     */
    public function getExternalId()
    {
        return $this->external_id;
    }

    /**
     * Optional.
     * Profile's id in client system if available.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_id = $var;

        return $this;
    }

    /**
     * Optional.
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * Optional.
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->source = $var;

        return $this;
    }

    /**
     * Optional.
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Optional.
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Optional.
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUI is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     * @return string
     */
    public function getGroupId()
    {
        return $this->group_id;
    }

    /**
     * Optional.
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUI is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->group_id = $var;

        return $this;
    }

    /**
     * Optional.
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @return \Google\Protobuf\BoolValue
     */
    public function getIsHirable()
    {
        return $this->is_hirable;
    }

    /**
     * Returns the unboxed value from <code>getIsHirable()</code>

     * Optional.
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @return bool|null
     */
    public function getIsHirableValue()
    {
        $wrapper = $this->getIsHirable();
        return is_null($wrapper) ? null : $wrapper->getValue();
    }

    /**
     * Optional.
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setIsHirable($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->is_hirable = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Optional.
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setIsHirableValue($var)
    {
        $wrappedVar = is_null($var) ? null : new \Google\Protobuf\BoolValue(['value' => $var]);
        return $this->setIsHirable($wrappedVar);
    }

    /**
     * Optional.
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * Optional.
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Optional.
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    /**
     * Optional.
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional.
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     * @return \Google\Cloud\Talent\V4beta1\Resume
     */
    public function getResume()
    {
        return $this->resume;
    }

    /**
     * Optional.
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     * @param \Google\Cloud\Talent\V4beta1\Resume $var
     * @return $this
     */
    public function setResume($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\Resume::class);
        $this->resume = $var;

        return $this;
    }

    /**
     * Optional.
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonNames()
    {
        return $this->person_names;
    }

    /**
     * Optional.
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     * @param \Google\Cloud\Talent\V4beta1\PersonName[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\PersonName::class);
        $this->person_names = $arr;

        return $this;
    }

    /**
     * Optional.
     * The candidate's postal addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * Optional.
     * The candidate's postal addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     * @param \Google\Cloud\Talent\V4beta1\Address[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Address::class);
        $this->addresses = $arr;

        return $this;
    }

    /**
     * Optional.
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmailAddresses()
    {
        return $this->email_addresses;
    }

    /**
     * Optional.
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     * @param \Google\Cloud\Talent\V4beta1\Email[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmailAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Email::class);
        $this->email_addresses = $arr;

        return $this;
    }

    /**
     * Optional.
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPhoneNumbers()
    {
        return $this->phone_numbers;
    }

    /**
     * Optional.
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     * @param \Google\Cloud\Talent\V4beta1\Phone[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPhoneNumbers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Phone::class);
        $this->phone_numbers = $arr;

        return $this;
    }

    /**
     * Optional.
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonalUris()
    {
        return $this->personal_uris;
    }

    /**
     * Optional.
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     * @param \Google\Cloud\Talent\V4beta1\PersonalUri[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonalUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\PersonalUri::class);
        $this->personal_uris = $arr;

        return $this;
    }

    /**
     * Optional.
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalContactInfo()
    {
        return $this->additional_contact_info;
    }

    /**
     * Optional.
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     * @param \Google\Cloud\Talent\V4beta1\AdditionalContactInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalContactInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\AdditionalContactInfo::class);
        $this->additional_contact_info = $arr;

        return $this;
    }

    /**
     * Optional.
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmploymentRecords()
    {
        return $this->employment_records;
    }

    /**
     * Optional.
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     * @param \Google\Cloud\Talent\V4beta1\EmploymentRecord[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmploymentRecords($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EmploymentRecord::class);
        $this->employment_records = $arr;

        return $this;
    }

    /**
     * Optional.
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEducationRecords()
    {
        return $this->education_records;
    }

    /**
     * Optional.
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     * @param \Google\Cloud\Talent\V4beta1\EducationRecord[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEducationRecords($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EducationRecord::class);
        $this->education_records = $arr;

        return $this;
    }

    /**
     * Optional.
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSkills()
    {
        return $this->skills;
    }

    /**
     * Optional.
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     * @param \Google\Cloud\Talent\V4beta1\Skill[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSkills($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Skill::class);
        $this->skills = $arr;

        return $this;
    }

    /**
     * Optional.
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActivities()
    {
        return $this->activities;
    }

    /**
     * Optional.
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     * @param \Google\Cloud\Talent\V4beta1\Activity[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActivities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Activity::class);
        $this->activities = $arr;

        return $this;
    }

    /**
     * Optional.
     * The publications published by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPublications()
    {
        return $this->publications;
    }

    /**
     * Optional.
     * The publications published by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     * @param \Google\Cloud\Talent\V4beta1\Publication[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPublications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Publication::class);
        $this->publications = $arr;

        return $this;
    }

    /**
     * Optional.
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPatents()
    {
        return $this->patents;
    }

    /**
     * Optional.
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     * @param \Google\Cloud\Talent\V4beta1\Patent[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPatents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Patent::class);
        $this->patents = $arr;

        return $this;
    }

    /**
     * Optional.
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertifications()
    {
        return $this->certifications;
    }

    /**
     * Optional.
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     * @param \Google\Cloud\Talent\V4beta1\Certification[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertifications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Certification::class);
        $this->certifications = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplications()
    {
        return $this->applications;
    }

    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applications = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAssignments()
    {
        return $this->assignments;
    }

    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAssignments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->assignments = $arr;

        return $this;
    }

    /**
     * Optional.
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * Optional.
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

    /**
     * Output only. Indicates if the profile is fully processed and searchable.
     *
     * Generated from protobuf field <code>bool processed = 27;</code>
     * @return bool
     */
    public function getProcessed()
    {
        return $this->processed;
    }

    /**
     * Output only. Indicates if the profile is fully processed and searchable.
     *
     * Generated from protobuf field <code>bool processed = 27;</code>
     * @param bool $var
     * @return $this
     */
    public function setProcessed($var)
    {
        GPBUtil::checkBool($var);
        $this->processed = $var;

        return $this;
    }

    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28;</code>
     * @return string
     */
    public function getKeywordSnippet()
    {
        return $this->keyword_snippet;
    }

    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setKeywordSnippet($var)
    {
        GPBUtil::checkString($var, True);
        $this->keyword_snippet = $var;

        return $this;
    }

}

